/*! \file  common.h
 *  \brief FFlibpwb_t@C
 *  \note  \[X͂̃wb_CN[hA\n
 *         ̃t@CŊe(SH,H8,M16C,M32R)p̃wb_t@CCN[h
 */

#ifndef _FFLIB_H_
#define _FFLIB_H_


/*
**--------------------------------------------------
** CũrhIvV
** OPT_TYPE_SIZELFTCYœKiΉFLF[vj
** OPT_TYPE_SPEEDFXs[hœKiΉFLFʃW[̃CCWJj
**--------------------------------------------------
*/
#define OPT_TYPE_SIZE
#define OPT_TYPE_SPEED

/*
**--------------------------------------------------
** W[ʒ萔`
**--------------------------------------------------
*/
/*! Œ菬_ϊp萔(Q32ϊ) */
#define S32			(65536.0f*65536.0f)

/*! Œ菬_ϊp萔(Q31ϊ) */
#define S31			(65536.0f*32768.0f)

/*! Œ菬_ϊp萔(Q30ϊ) */
#define S30			(32768.0f*32768.0f)



/*
**--------------------------------------------------
**}CRʐݒ
**--------------------------------------------------
*/
/* }CRʃCN[ht@C			*/
/* yсARpCʃCCWJ̎w	*/
/* ꂼ̃}N̓RpC̈Öِ錾	*/
#ifdef _SH
	/* SHp(SHC) */
	#define INLINE static
	#pragma inline(integer, fraction, frexp_m, frexp_e)
	#pragma inline(in_sqrtf)
	#pragma inline(get_n, myfmod)
	#include "fflb_sh.h"
#else
#ifdef __H8__
	/* H8p(H8C) */
	#define INLINE __inline static
	#include "fflb_h8.h"
#else
#ifdef __M32R__
	/* M32Rp(CC32R) */
	#define INLINE inline static
	#include "fflb_m32r.h"
	/* ACC32RŃCCWJLɂɂ
	** œKxSȏɂKv[-O4]
	*/
#else
#ifdef M16C
	/* M16Cp(NC30) */
	#define INLINE inline
	#include "fflb_m16c.h"
#endif
#endif
#endif
#endif

/*
**--------------------------------------------------
** FFlib֐iOJ֐j
**--------------------------------------------------
*/
unsigned long sinf( unsigned long );	/* FFLIB B-012 B-016	*/
unsigned long cosf( unsigned long );	/* FFLIB B-012 B-016	*/
unsigned long expf( unsigned long );	/* FFLIB B-012 B-016	*/
unsigned long logf( unsigned long );	/* FFLIB B-012 B-016	*/
unsigned long sqrtf( unsigned long );	/* FFLIB B-012 B-016	*/
unsigned long tanf( unsigned long );	/* FFLIB B-012 B-016	*/
unsigned long atanf( unsigned long );	/* FFLIB B-012 B-016	*/

/*
**--------------------------------------------------
** ֐ivg^Cvj
**--------------------------------------------------
*/
/* sin/cosC */
long __insinL(unsigned long phase, unsigned long m, long e, unsigned long d0);					/* FFLIB B-011	*/
/* sinW vZ */
long __poly_sinL(long d0, long d3, long e, long sign);											/* FFLIB B-011	*/
/* cosW vZ */
long __poly_cosL(long d1, long e, long sign);													/* FFLIB B-011	*/

/* ------ normalize and round ------------------------ */
long __myround(unsigned long m2, long e4, long sign); 		/* mant, exp, sign				*/	/* FFLIB B-011	*/
long __rtn_inf(unsigned long r5);							/* sign							*/	/* FFLIB B-011	*/
long __normalize(unsigned long m, long e, long sign);		/* mant, exp, sign				*/	/* FFLIB B-011	*/
long __normalize1(unsigned long r2, long r4, long r5);		/* mant, exp, sign				*/	/* FFLIB B-011	*/
long __denorm(unsigned long r2, long r4, long r5);			/* construct denormalized num.	*/	/* FFLIB B-011	*/

#ifdef OPT_TYPE_SPEED
/*
**--------------------------------------------------
** ֐iCCWJ or staticj
**--------------------------------------------------
*/
/* OuINLINE͊ɂinlinestaticɒu */
/*!
 *  \brief  [doublel̐擾֐
 *  \param  u  Q32Œ菬_
 *  \param  e  w
 *  \return    l
 *  \note  u*2^eƂāÂ̐߂Ė߂lƂ\n
 *  0̏ꍇ0Ԃ  e33ȏ̏ꍇ͕s\n
 */
INLINE unsigned long integer(unsigned long u, long e)
{
	if(e <= 0){
		return (0);
	}else{
		return (u >> (32 - e));
	}
}
/*!
 *  \brief  [doublel̏擾֐
 *  \param  u  Q32Œ菬_
 *  \param  e  w
 *  \return    Q32Œ菬_
 *
 *  u*2^nƂāÂ̏߂\n
 *  Œ菬_ƂĖ߂lƂ\n
 *  e32ȏ̏ꍇ͕s\n
 *  e-32ȏ̏ꍇ͕s\n
 */
INLINE unsigned long fraction(unsigned long u, long e)
{
	if(e < 0){
		return (u >> (-e));
	}else{
		return (u << e);
	}
}
/*!
 *  \brief  float^̃f[^牼؂o
 *  \param  f  ̃f[^iI/Funsigned longgfloatj
 *  \return  ؂o
 *  \note   MSB͕KP\n
 *  - (return)\n
 *  MSB  .  .  ... b8  b7  b6  ...  .  LSB\n
 *   1   m  m  ...  m   0   0  ...  0   0
 */
INLINE unsigned long frexp_m(unsigned long f)
{
	return (0x80000000 | (f << 8));
}
/*!
 *  \brief  float^̃f[^w؂o
 *  \param  f  ̃f[^iI/Funsigned longgfloatj
 *  \return  ؂ow
 *  \note   ߂l̒l-126`129\n
 *  - w\n
 *  MSB  ...  b1 LSB\n
 *   s   ...  n   n
 */
INLINE long frexp_e(unsigned long f)
{
	return ((long)((f << 1) >> 24) - 126);
}

#ifdef __H8__
/*!
 *  \brief  32b.+.32b+.32b
 *  \param  *i     Q0
 *  \param  *fpart Q32Œ菬_
 *  \param  adder  Q32Œ菬_
 *  \note   Z̏fpartɓ
 */
INLINE void __addc3( long *i, unsigned long *fpart, unsigned long adder)
{
/*   input  &iiii.       */
/*   input       .&fpart */
/* + input       .adder  */
/* --------------------- */
/*             +c        */
/*   output &iiii.       */
/*   return      .&fpart */

	if( *fpart + adder < *fpart ){
		*i = *i + 1;
	}
	*fpart = *fpart + adder;
}

/*!
 *  \brief  Œ菬_pK֐
 *  \param  m  񐳋KŒ菬_|C^
 *  \param  e  wli[|C^
 *
 * mMSB1ƂȂ悤ɐK\n
 * eɂ͐Kۂ̎wZbg
 */
INLINE void __fixed_normalize( unsigned long *m, short *e )
{
	while( (long)*m > 0 ){		/* MSB = 0ȂJԂ		*/
		*e = *e - 1;			/* w-1				*/
		*m = *m << 1;			/* Œ菬_Vtg	*/
	}
}

/*!
 *  \brief  64b(32b.32b)̘_PrbgVtg
 *  \param  *i     Q0
 *  \param  *fpart Q32Œ菬_
 *  \note   fpartMSBiLSBɓ
 */
INLINE void __shll64( long *i, unsigned long *fpart)
{
/*   input  &iiii.       */
/*   input       .&fpart */
/* <<1                   */
/* --------------------- */
/*                       */
/*  output &iiiic.       */
/*  output       .&fpart */

	*i = (*i << 1) | (*fpart >> 31);
	*fpart <<= 1;
}

#else
/* 32b.+.32b+.32b */
void __addc3( long *i, unsigned long *fpart, unsigned long adder);

/* Œ菬_pK֐ */
void __fixed_normalize( unsigned long *m, short *e );

/* 64b(32b.32b)̘_PrbgVtg */
void __shll64( long *i, unsigned long *fpart);

unsigned long __integer(short e, unsigned long u);
unsigned long __fraction(short e, unsigned long u);
unsigned long __frexp_m(unsigned long f);
short __frexp_e(unsigned long f);
#endif

/* no inline */
/* 64b-96b */
unsigned long __sub96( unsigned long *dw_1i, unsigned long *dw_1f, unsigned long dw_2i, unsigned long dw_2f, unsigned long dw_2ff);
#endif		/* __H8__ */

#endif		/* _FFLIB_H_ */
