typedef struct {                          /* inner format float  definition */
    unsigned long s_e;                     /*  sign bit(MSB)|exp(lower2bite) */
    unsigned long m_h;                    /*  mantisa(highter 32bit)        */
    unsigned long m_l;                    /*  mantisa(lower   32bit)        */
} IN_DOUBLE;				
#ifndef _REENTRANT								/* A 3V611-34 */
extern volatile int _errno;
#else											/* A 3V611-34 */
extern  int *errno_addr(void);					/* A 3V611-34 */
#define _errno (*errno_addr())					/* A 3V611-34 */
#endif											/* A 3V611-34 */
extern const    double _HUGE_VAL;

#ifdef __FLT__                                           /* A P3SB068 */
#define double long double                               /* A P3SB068 */
#endif                                                   /* A P3SB068 */
                                                         /*   P3SB068 */
/* for exception error number */
#define ERANGE    1100
#define EDOM      1101
#define HUGE_VAL _HUGEVAL 

/* function '_istype' return value */ 
#define NEG  8
#define ZERO 4
#define INF  2
#define NAN  1 

#define EXMASKD   0x7ff00000
#define MHMASKD   0x000fffff
#define MLMASKD   0xffffffff

#define isEMAXd(p) (((*(long*)&p)&EXMASKD)==EXMASKD)

#define isMANTd(p)  (((*(long*)&p)&MHMASKD) || \
                    ((*((long*)&p+1))&MLMASKD))

/* exp const define (outer format) */
#define SBIAS 127
#define DBIAS 1023

/* exp const define (inner format) */
#define EMAX 32767
#define EMIN (-32767)
#define SIGNMASK 0x80000000
#define ABSMASK  0x7fffffff
#define EXPMASK  0x0000ffff

