typedef struct {                          /* inner format float  definition */
    unsigned long s_e;                    /*  sign bit(MSB)|exp(lower2bite) */
    unsigned long m;                      /*  mantisa(highter 32bit)        */
} IN_SINGLE;				
#ifndef _REENTRANT								/* A 3V611-34 */
extern volatile int _errno;
#else											/* A 3V611-34 */
extern  int *errno_addr(void);					/* A 3V611-34 */
#define _errno (*errno_addr())					/* A 3V611-34 */
#endif											/* A 3V611-34 */
extern const    double _HUGE_VAL;

/* for exception error number */
#define ERANGE    1100
#define EDOM      1101
#define HUGE_VAL _HUGEVAL 

/* function '_istype' return value */ 
#define NEG  8
#define ZERO 4
#define INF  2
#define NAN  1 

#define EXMASKF   0x7f800000
#define MMASKF    0x007fffff

#define isEMAXf(p) (((*(long*)&p)&EXMASKF)==EXMASKF)

#define isMANTf(p)  ((*(long*)&p)&MMASKF)

/* exp const define (outer format) */
#define SBIAS 127
#define DBIAS 1023

/* exp const define (inner format) */
#define EMAX 32767
#define EMIN (-32767)
#define SIGNMASK 0x80000000
#define ABSMASK  0x7fffffff
#define EXPMASK  0x0000ffff

#define _stois     _ftoif
#define _istos     _iftof
#define _in_adds   _in_addf
#define _in_subs   _in_subf
#define _in_cmps   _in_cmpf
#define _in_divs   _in_divf
#define _in_eqs    _in_eqf
#define _in_fmods  _in_fmodf
#define _in_gts    _in_gtf
#define _in_muls   _in_mulf
#define _in_nes    _in_nef
#define _in_sqrts  _in_sqrtf
#define _in_ldexps _in_ldexpf
#define _in_truncs _in_truncf
#define _istypes   _istypef
#define _itois     _itoif
#define _polinos   _polinof

#define _app_atans _app_atanf
#define _app_coss  _app_cosf
#define _app_sins  _app_sinf
#define _in_acoss  _in_acosf
#define _in_asins  _in_asinf
#define _in_atan2s _in_atan2f
#define _in_atans  _in_atanf
#define _in_ceils  _in_ceilf
#define _in_coshs  _in_coshf
#define _in_coss   _in_cosf
#define _in_exps   _in_expf
#define _in_floors _in_floorf
#define _in_log10s _in_log10f
#define _in_logs   _in_logf
#define _in_modfs  _in_modff
#define _in_pows   _in_powf
#define _in_sinhs  _in_sinhf
#define _in_sins   _in_sinf
#define _in_tanhs  _in_tanhf
#define _in_tans   _in_tanf
