/*! \file  fflib_h8.h
 *  \brief FFlib H8pwb_t@C
 *  \note  gݍ݊֐AH8p̒萔`
 */
#ifndef CMN_H8
#define CMN_H8

/* gݍ݊֐wb_t@CCN[h  */
#include <machine.h>

/*
**------------------------
** FFlibIvV}N
**------------------------
*/
/* ^[Qbg */
/* H8S/2600, H8S/2000TARGET_H8S` */
#if defined(__2600N__) | defined(__2600A__) | defined(__2000N__) | defined(__2000A__) | defined(__300HA__) | defined(__300HN__)
	#define TARGET_H8S
#endif

/* H8SXŏZ킪gꍇTARGET_H8SX` */
/* muluxgݍ݊֐g */
#if defined(__H8SXN__) | defined(__H8SXM__) | defined(__H8SXA__) | defined(__H8SXX__)
	#ifdef __HAS_MULTIPLIER__
		#define TARGET_H8SX
	#endif
#endif

/* H8/300, H8/300LTARGET_H8300` */			/* FFLIB B-011 */
#if defined(__300__) | defined(__300L__)			/* FFLIB B-011 */
	#define TARGET_H8300							/* FFLIB B-011 */
#endif												/* FFLIB B-011 */

/* denormalizeT|[gpXCb` */
#define SUPPORT_DENORMALIZE

/*
**------------------------
** 萔E}N`
**------------------------
*/
/* _l` */
#define PLS_NAN		0x7F800001
#define MNS_NAN		0xFF800001
#define PLS_INF		0x7F800000
#define MNS_INF		0xFF800000
#define MNS_ZERO	0x80000000

/* ֐pl` */
#define SINF_NAN	PLS_NAN
#define LOGF_NAN	PLS_NAN
#define SQRTF_NAN	PLS_NAN
#define TANF_NAN	PLS_NAN

/* denormalizeT|[gȂꍇsqrtf߂l`*/
#define SQRTF_RTN_DENORM	(0)		/* FFLIB B-016 */

/*
**------------------------
** errnop̒`
**------------------------
*/
#define ERANGE 1100					/* FFLIB B-015		 */
#define EDOM   1101					/* FFLIB B-015		 */

#ifndef _REENTRANT					/* FFLIB B-015		 */
extern volatile int _errno;			/* FFLIB B-015		 */
#else								/* FFLIB B-015		 */
extern int *errno_addr(void);		/* FFLIB B-015		 */
#define _errno (*errno_addr())		/* FFLIB B-015		 */
#endif								/* FFLIB B-015		 */


/* 32b*32b=H32b, 16b*16b=32b */
#ifdef TARGET_H8S
	/* H8Spgݍ݊֐gp */
	unsigned long __regparam3 dmulu_h(unsigned long c, unsigned long i);		/* FFLIB B-010 */
	         long __regparam3 dmuls_h(long c, long i);							/* FFLIB B-010 */
	unsigned long __regparam3 dmulu_n(unsigned long c, unsigned long i);		/* FFLIB B-004, B-010 */
	         long __regparam3 dmuls_n(long c, long i);							/* FFLIB B-004, B-010 */
#else
#ifdef TARGET_H8SX
	/* H8SXpgݍ݊֐gp */
	#define  dmulu_h(c, i) muluu(c, i)
	#define  dmuls_h(c, i) mulsu(c, i)
	#define  dmulu_n(c, i) muluu(c, i)											/* FFLIB B-004 */
	#define  dmuls_n(c, i) mulsu(c, i)											/* FFLIB B-004 */
#else
#ifdef TARGET_H8300																/* FFLIB B-011 */
	/*H8300pgݍ݊֐gp */
	unsigned long __regparam3 dmulu_h(unsigned long c, unsigned long i);		/* FFLIB B-011 */
	         long __regparam3 dmuls_h(long c, long i);							/* FFLIB B-011 */
	#define  dmulu_n(c, i) dmulu_h(c, i)										/* FFLIB B-011 */
	#define  dmuls_n(c, i) dmuls_h(c, i)										/* FFLIB B-011 */
#else
	/* ̑H8pgݍ݊֐gp */
	unsigned long __regparam3 dmulu_h(unsigned long c, unsigned long i);		/* FFLIB B-010 */
	         long __regparam3 dmuls_h(long c, long i);							/* FFLIB B-010 */
	unsigned long __regparam3 dmulu_n(unsigned long c, unsigned long i);		/* FFLIB B-004, B-010 */
	         long __regparam3 dmuls_n(long c, long i);							/* FFLIB B-004, B-010 */
#endif
#endif
#endif


#endif /* CMN_H8 */
