/*--------------------------------------------------------------------*/
/* H8S,H8/300 SERIES C Compiler Ver. 1.0                              */
/* Copyright (C) 1994 Hitachi, Ltd.                                   */
/* Licensed Material of Hitachi,Ltd.                                  */
/*--------------------------------------------------------------------*/
/**********************************************************************/
/* SPEC;                                                              */
/*  NAME = stdio : header file for standard I/O function ;            */
/*                                                                    */
/*  FUNC = this header file do the following functions;               */
/*         (1) file entry table define;                               */
/*         (2) I/O macro define;                                      */
/*         (3) symbol define;                                         */
/*  CLAS = UNIT;                                                      */
/*                                                                    */
/* END;                                                               */
/**********************************************************************/

#include "lstddef.h"

/*** #ifndef _NFILE                                    ***   P3V252-1 */
/*** #define _NFILE 20                                 ***   P3V252-1 */
/*** #define SYS_OPEN 20                               *** D P3V252-1 */
extern const int _nfiles;                               /* A P3V252-1 */
#pragma pack 2
extern struct _iobuf {
       unsigned char *_bufptr;          /* buffer pointer             */
                long  _bufcnt;          /* buffer count               */
       unsigned char *_bufbase;         /* buffer base pointer        */
                long  _buflen;          /* buffer length              */
                char  _ioflag1;         /* I/O control flag 1         */
                char  _ioflag2;         /* I/O control flag 2         */
                char  _iofd;
                char  reserve;
} ;
#pragma unpack

typedef struct _iobuf FILE;   /* V3.0 C P3V054L **FILE of file-stream */

#define _IOFBF 1                   /* define _IOFBF of full buffering */
#define _IOLBF 2         /* P3V178 ** define _IOLBF of line buffering */
#define _IONBF 3                   /* define _IONBF of non buffering  */

#define SEEK_SET 0                      /* allocate top position */
#define SEEK_CUR 1                      /* allocate current position */
#define SEEK_END 2                      /* allocate bottom position */

#define BUFSIZ 512                      /* default buffer size */

                                        /* error number define */
#define EBADF  1302                     /* I/O operation error */
#define PTRERR 1106                     /* fp null */
#define ECSPEC 1304                     /* format err */
#define NOTOPN 1300                     /* file not open */

                                        /* I/O flags for _ioflag1     */
#define _IOREAD    1                    /* only read or update read   */
#define _IOWRITE   2                    /* only write or update write */
#define _IORW      4                    /* update file                */
#define _IOUNBUF   8                    /* unbffering I/O             */
#define _IOBGBUF  16                    /* automatic buffer allocate  */
#define _IOEOF    32                    /* end of file                */
#define _IOERR    64                    /* I/O error                  */
#define _IOBIN   128                    /* binaly file                */
#define _UNGTC     1                    /* ungetc issued (_ioflag2)   */
#define _IOLINBUF  2                    /* line buffering    A P3V178 */

#define EOF     (-1)
#define _EOL    (0x0A)                  /* end of line       A P3V178 */

#define stdin       (&_iob[0])          /* standard input file */
#define stdout      (&_iob[1])          /* standard output file */
#define stderr      (&_iob[2])          /* standard error output file */

#define getchar()   getc(stdin)
#define putchar(x)  putc(x,stdout)
#define feof(fp)    ((fp)->_ioflag1&_IOEOF)
#define ferror(fp)  ((fp)->_ioflag1&_IOERR)
#define clearerr(fp) ((void)((fp)->_ioflag1&=~(_IOEOF|_IOERR)))
/*** #endif                                            *** D P3V252-1 */
