/* xxcpow.h -- common cpow[fl] functionality */
#include <complex.h>
#include "xmath.h"
_STD_BEGIN

FCTYPE (FFUN(cpow))(FCTYPE x, FCTYPE y)
	{	/* find complex x^y */
	if (!(FFUN(cimag)(x) == FLIT(0.0)))
		return (FFUN(cexp)(FNAME(Cmulcc)(y, FFUN(clog)(x))));
	else if (!(FFUN(cimag)(y) == FLIT(0.0)))
#if defined(_BUILD_FOR_RENESAS) && defined(_R_M16C)	/* V10000K103 */
	{
		FTYPE tmp;
		tmp = FFUN(creal)(x);
		return (FFUN(cexp)(FNAME(Cmulcr)(y, FFUN(log)(tmp))));
	}
#else
		return (FFUN(cexp)(FNAME(Cmulcr)(y, FFUN(log)(FFUN(creal)(x)))));
#endif												/* V10000K103 */
	else
		return (FNAME(Cbuild)(FFUN(pow)(FFUN(creal)(x), FFUN(creal)(y)),
			FLIT(0.0)));
	}
_STD_END

/*
 * Copyright (c) 1992-2007 by P.J. Plauger.  ALL RIGHTS RESERVED.
 * Consult your license regarding permissions and restrictions.
V5.03:0216 */
