/* xxerf.h -- common erf[fl] functionality */
#include "xmath.h"
_STD_BEGIN

FTYPE (FNAME(Erfc))(FTYPE x);
extern FTYPE FNAME(Erf_one);
extern FTYPE FNAME(Erf_small);

#if defined(_BUILD_FOR_RENESAS) && defined(_R_FLT)		/* V10000K102 */

	/* coefficients */
 #if   FBITS <= 26
  #define DPOLY(x)	(((c[0] * x + c[1]) * x + c[2]) * x + c[3])
  #define NPOLY(x)	(((s[0] * x + s[1]) * x + s[2]) * x + s[3])

static const FTYPE s[] = {	/* 3/3, |x| < 1.523 */
	FLIT(0.2614094187e-3),
	FLIT(0.3605236771e-1),
	FLIT(0.1313206918),
	FLIT(1.1283791672),
	};

static const FTYPE c[] = {
	FLIT(0.6362810352e-2),
	FLIT(0.8185214294e-1),
	FLIT(0.4497136338),
	FLIT(1.0),
	};

 #elif FBITS <= 56
  #define DPOLY(x)	((((((c[0] * x + c[1]) * x + c[2]) * x + c[3]) * x \
		+ c[4]) * x + c[5]) * x + c[6])
  #define NPOLY(x)	((((((s[0] * x + s[1]) * x + s[2]) * x + s[3]) * x \
		+ s[4]) * x + s[5]) * x + s[6])

static const FTYPE s[] = {	/* 6/6, |x| < 1.523 */
	FLIT( 1.2040999373658753e-07),
	FLIT( 8.8784405615357056e-06),
	FLIT( 3.2806639713878541e-04),
	FLIT( 3.4814902101731196e-03),
	FLIT( 5.1728385731987528e-02),
	FLIT( 1.7644011324127379e-01),
	FLIT( 1.1283791670955126e+00),
  	};

  static const FTYPE c[] = {
	FLIT( 1.4060567875468972e-06),
	FLIT( 5.8411032889811751e-05),
	FLIT( 1.1742377551152094e-03),
	FLIT( 1.4283713727543943e-02),
	FLIT( 1.0907619238514397e-01),
	FLIT( 4.8969931241768294e-01),
	FLIT( 1.0000000000000000e+00),
	};

 #elif FBITS <= 67
  #define DPOLY(x)	FNAME(Poly)(x, c, sizeof (c) / sizeof (c[0]) - 1)
  #define NPOLY(x)	FNAME(Poly)(x, s, sizeof (s) / sizeof (s[0]) - 1)

static const FTYPE s[] = {	/* 7/7, |x| < 1.523 */
	FLIT( 1.1733351770402246e-09),
	FLIT( 5.2160792495723454e-07),
	FLIT( 1.1251818669814473e-05),
	FLIT( 3.9775588824368457e-04),
	FLIT( 3.3609136187093347e-03),
	FLIT( 5.2537642857531049e-02),
	FLIT( 1.6651049985832042e-01),
	FLIT( 1.1283791670955126e+00),
	};

static const FTYPE c[] = {
	FLIT( 4.7334555604363805e-08),
	FLIT( 2.6679979411122452e-06),
	FLIT( 7.3489466796318722e-05),
	FLIT( 1.2595640728092874e-03),
	FLIT( 1.4318140760137463e-02),
	FLIT( 1.0686008092628962e-01),
	FLIT( 4.8089942167837457e-01),
	FLIT( 1.0000000000000000e+00),
	};

 #elif FBITS <= 115
  #define DPOLY(x)	FNAME(Poly)(x, c, sizeof (c) / sizeof (c[0]) - 1)
  #define NPOLY(x)	FNAME(Poly)(x, s, sizeof (s) / sizeof (s[0]) - 1)

static const FTYPE s[] = {	/* 11/11, |x| < 1.523 */
	FLIT( 5.1630403730106179e-16),
	FLIT( 4.9216883710822229e-13),
	FLIT( 2.6749838834244420e-11),
	FLIT( 2.0936153135649591e-09),
	FLIT( 5.0837799055863544e-08),
	FLIT( 1.9519247483816615e-06),
	FLIT( 2.6215824696504770e-05),
	FLIT( 5.9391183411995597e-04),
	FLIT( 4.3202969131006311e-03),
	FLIT( 5.7391809147983662e-02),
	FLIT( 1.7522105028249452e-01),
	FLIT( 1.1283791670955126e+00),
	};

static const FTYPE c[] = {
	FLIT( 2.9885656240135626e-14),
	FLIT( 3.9378594485318393e-12),
	FLIT( 2.5732367455719520e-10),
	FLIT( 1.0920248597362729e-08),
	FLIT( 3.3223884538399408e-07),
	FLIT( 7.5676892543413964e-06),
	FLIT( 1.3108087039350296e-04),
	FLIT( 1.7196835506108129e-03),
	FLIT( 1.6688108848991384e-02),
	FLIT( 1.1373514856731955e-01),
	FLIT( 4.8861894599979155e-01),
	FLIT( 1.0000000000000000e+00),
	};

 #else /* FBITS */
  #error erf has insufficient precision
 #endif /* FBITS */

#else
	/* coefficients */
 #if   FBITS <= 26
  #define DPOLY(x)	(((c[0] * x + c[1]) * x + c[2]) * x + c[3])
  #define NPOLY(x)	(((s[0] * x + s[1]) * x + s[2]) * x + s[3])

static const FTYPE s[] = {	/* 3/3, |x| < 1.523 */
	FLIT(0.2614094187e-3),
	FLIT(0.3605236771e-1),
	FLIT(0.1313206918),
	FLIT(1.1283791672),
	};

static const FTYPE c[] = {
	FLIT(0.6362810352e-2),
	FLIT(0.8185214294e-1),
	FLIT(0.4497136338),
	FLIT(1.0),
	};

 #elif FBITS <= 56
  #define DPOLY(x)	((((((c[0] * x + c[1]) * x + c[2]) * x + c[3]) * x \
		+ c[4]) * x + c[5]) * x + c[6])
  #define NPOLY(x)	((((((s[0] * x + s[1]) * x + s[2]) * x + s[3]) * x \
		+ s[4]) * x + s[5]) * x + s[6])

static const FTYPE s[] = {	/* 6/6, |x| < 1.523 */
	FLIT(0.12040999373658753679e-6),
	FLIT(0.88784405615357064309e-5),
	FLIT(0.32806639713878541747e-3),
	FLIT(0.34814902101731196859e-2),
	FLIT(0.51728385731987527358e-1),
	FLIT(0.17644011324127378370),
	FLIT(1.12837916709551257390),
	};

static const FTYPE c[] = {
	FLIT(0.14060567875468972603e-5),
	FLIT(0.58411032889811748820e-4),
	FLIT(0.11742377551152094336e-2),
	FLIT(0.14283713727543944095e-1),
	FLIT(0.10907619238514398035),
	FLIT(0.48969931241768294256),
	FLIT(1.0),
	};

 #elif FBITS <= 67
  #define DPOLY(x)	FNAME(Poly)(x, c, sizeof (c) / sizeof (c[0]) - 1)
  #define NPOLY(x)	FNAME(Poly)(x, s, sizeof (s) / sizeof (s[0]) - 1)

static const FTYPE s[] = {	/* 7/7, |x| < 1.523 */
	FLIT(0.1173335177040224550671508e-8),
	FLIT(0.5216079249572345180419514e-6),
	FLIT(0.1125181866981447313660203e-4),
	FLIT(0.3977558882436845809440133e-3),
	FLIT(0.3360913618709334889923423e-2),
	FLIT(0.5253764285753105067039696e-1),
	FLIT(0.1665104998583204282304198),
	FLIT(1.1283791670955125738961589),
	};

static const FTYPE c[] = {
	FLIT(0.4733455560436380663773544e-7),
	FLIT(0.2667997941112245291838663e-5),
	FLIT(0.7348946679631872029680150e-4),
	FLIT(0.1259564072809287409160560e-2),
	FLIT(0.1431814076013746416379793e-1),
	FLIT(0.1068600809262896309878225),
	FLIT(0.4808994216783745456626571),
	FLIT(1.0),
	};

 #elif FBITS <= 115
  #define DPOLY(x)	FNAME(Poly)(x, c, sizeof (c) / sizeof (c[0]) - 1)
  #define NPOLY(x)	FNAME(Poly)(x, s, sizeof (s) / sizeof (s[0]) - 1)

static const FTYPE s[] = {	/* 11/11, |x| < 1.523 */
	FLIT(0.51630403730106176957896163066178846e-15),
	FLIT(0.49216883710822226957326066712120517e-12),
	FLIT(0.26749838834244420657493483239069858e-10),
	FLIT(0.20936153135649591032720013480984730e-8),
	FLIT(0.50837799055863542101951484001252012e-7),
	FLIT(0.19519247483816617346350109590577561e-5),
	FLIT(0.26215824696504770787393598555592600e-4),
	FLIT(0.59391183411995598350191003079143702e-3),
	FLIT(0.43202969131006314964069654757878308e-2),
	FLIT(0.57391809147983659218080008306136341e-1),
	FLIT(0.17522105028249451845826062362718280),
	FLIT(1.12837916709551257389615890312154518),
	};

static const FTYPE c[] = {
	FLIT(0.29885656240135625646372883056909688e-13),
	FLIT(0.39378594485318396123578294822005288e-11),
	FLIT(0.25732367455719518970474635679830478e-9),
	FLIT(0.10920248597362729336822861661274367e-7),
	FLIT(0.33223884538399406499612543947598922e-6),
	FLIT(0.75676892543413966092564352074666446e-5),
	FLIT(0.13108087039350296028951919419989479e-3),
	FLIT(0.17196835506108127612957305505535337e-2),
	FLIT(0.16688108848991384100189484950384267e-1),
	FLIT(0.11373514856731955191244262104412449),
	FLIT(0.48861894599979156643136182845639956),
	FLIT(1.0),
	};

 #else /* FBITS */
  #error erf has insufficient precision
 #endif /* FBITS */

 #endif														/* V10000K102 */

FTYPE (FFUN(erf))(FTYPE x)
	{	/* compute erf(x) */
	FTYPE y;

	switch (FNAME(Dtest)(&x))
		{	/* test for special codes */
	case _NANCODE:
	case 0:
		return (x);
	case _INFCODE:
		return (FISNEG(x) ? FLIT(-1.0) : FLIT(1.0));
	default:	/* finite */
		y = x < FLIT(0.0) ? -x : x;
		if (y < FNAME(Erf_small))
			{	/* compute rational approximation */
			y = x * x;

			return ((NPOLY(y) / DPOLY(y)) * x);
			}
		else if (y < FNAME(Erf_one))
			y = FLIT(1.0) - FNAME(Erfc)(y);
		else
			y = FLIT(1.0);
		return (x < FLIT(0.0) ? -y : y);
		}
	}
_STD_END

/*
 * Copyright (c) 1992-2007 by P.J. Plauger.  ALL RIGHTS RESERVED.
 * Consult your license regarding permissions and restrictions.
V5.03:0216 */
