/* xxexp2.h -- common exp2[fl] functionality */
#include <limits.h>
#include "xmath.h"
_STD_BEGIN

#if defined(_BUILD_FOR_RENESAS) && defined(_R_FLT)		/* V10000K102 */
static const FTYPE ln2 = FLIT(6.9314718055994529e-01);
#else
static const FTYPE ln2 = FLIT(0.69314718055994530941723212145817658);
#endif														/* V10000K102 */

FTYPE (FFUN(exp2))(FTYPE x)
	{	/* compute 2^x */
	long xexp;

	switch (FNAME(Dtest)(&x))
		{	/* test for special codes */
	case _NANCODE:
		return (x);
	case _INFCODE:
		return (FISNEG(x) ? FLIT(0.0) : x);
	case 0:
		return (FLIT(1.0));
	default:	/* finite */
		if (x <= LONG_MIN || LONG_MAX <= x)
			xexp = 0;
		else
			{	/* pick off binary exponent to improve precision */
			FTYPE y = x;

			FNAME(Dint)(&y, 0);
			xexp = (short)y;
			x -= y;
			if (FLIT(0.5) < x)
				{	/* exponentiate smaller positive fraction */
				x -= FLIT(1.0);
				++xexp;
				}
			else if (x < -FLIT(0.5))
				{	/* exponentiate smaller negative fraction */
				x += FLIT(1.0);
				--xexp;
				}				
				}
		x *= ln2;
		FNAME(Exp)(&x, FLIT(1.0), xexp);
		return (x);
			}
		}
_STD_END

/*
 * Copyright (c) 1992-2007 by P.J. Plauger.  ALL RIGHTS RESERVED.
 * Consult your license regarding permissions and restrictions.
V5.03:0216 */
