/* xxpow.hx -- pow[fl] supplement */

 #if 113 <= FBITS
  #define MAX_Y		FLIT(40.0)
  #define MAX_YLOGX	FLIT(30.0)
  #define FRAC_BITS	72057594037927936.0L		/* 2^56 */

static const FTYPE log2e[] = {
	(FTYPE)(FLIT(51978566788454384.0) / FRAC_BITS * 2),	/* 1/ln(2) */
	(FTYPE)(FLIT(52845311949826333.0) / FRAC_BITS_2 * 2),
	(FTYPE)(FLIT(17601992922409181.0) / FRAC_BITS_2 / FRAC_BITS * 2),
	(FTYPE)(FLIT(29654208892704364.0) / FRAC_BITS_4 * 2),
	};

  #define KMAX		11	/* enable ln(x+a) expansion */

static FTYPE scale = (FTYPE)(1 << KMAX);

static FTYPE lnbias[][ACSIZE] = {	/* binary logs for centers */
	{/* -log[2](1024 / 2048) */
	FLIT(-36028797018963968.0) * 2 / FRAC_BITS,
	FLIT(-0.0) * 2 / FRAC_BITS_2,
	FLIT(-0.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-0.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1025 / 2048) */
	FLIT(-35978061469022231.0) * 2 / FRAC_BITS,
	FLIT(-24700168166759225.0) * 2 / FRAC_BITS_2,
	FLIT(-2892035726345613.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-444223756811825.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1026 / 2048) */
	FLIT(-35927375393052202.0) * 2 / FRAC_BITS,
	FLIT(-30653378292445503.0) * 2 / FRAC_BITS_2,
	FLIT(-19514113524182967.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-58670945148169981.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1027 / 2048) */
	FLIT(-35876738694660343.0) * 2 / FRAC_BITS,
	FLIT(-6792972227074913.0) * 2 / FRAC_BITS_2,
	FLIT(-57202989714535342.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-41214366079599857.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1028 / 2048) */
	FLIT(-35826151277734556.0) * 2 / FRAC_BITS,
	FLIT(-19607805989972029.0) * 2 / FRAC_BITS_2,
	FLIT(-63772755401508487.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-23655647217562988.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1029 / 2048) */
	FLIT(-35775613046443091.0) * 2 / FRAC_BITS,
	FLIT(-27988948710383329.0) * 2 / FRAC_BITS_2,
	FLIT(-48603466374103596.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-47582669890649773.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1030 / 2048) */
	FLIT(-35725123905233455.0) * 2 / FRAC_BITS,
	FLIT(-9078929781305117.0) * 2 / FRAC_BITS_2,
	FLIT(-62922112906550529.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-64218482284528045.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1031 / 2048) */
	FLIT(-35674683758831327.0) * 2 / FRAC_BITS,
	FLIT(-32605227190966735.0) * 2 / FRAC_BITS_2,
	FLIT(-3016843226105900.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-41439022684835653.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1032 / 2048) */
	FLIT(-35624292512239482.0) * 2 / FRAC_BITS,
	FLIT(-65310013668714603.0) * 2 / FRAC_BITS_2,
	FLIT(-3302809215285005.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-43448171160447421.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1033 / 2048) */
	FLIT(-35573950070736717.0) * 2 / FRAC_BITS,
	FLIT(-7679135984301560.0) * 2 / FRAC_BITS_2,
	FLIT(-2503220609475505.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-1573563477180800.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1034 / 2048) */
	FLIT(-35523656339876778.0) * 2 / FRAC_BITS,
	FLIT(-32842640582778682.0) * 2 / FRAC_BITS_2,
	FLIT(-5680538293947119.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-270609911819970.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1035 / 2048) */
	FLIT(-35473411225487305.0) * 2 / FRAC_BITS,
	FLIT(-497252884403357.0) * 2 / FRAC_BITS_2,
	FLIT(-6263954774454584.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-21968501259033532.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1036 / 2048) */
	FLIT(-35423214633668766.0) * 2 / FRAC_BITS,
	FLIT(-33365215914352086.0) * 2 / FRAC_BITS_2,
	FLIT(-69567488398881259.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-2316267123820191.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1037 / 2048) */
	FLIT(-35373066470793411.0) * 2 / FRAC_BITS,
	FLIT(-20262810994758001.0) * 2 / FRAC_BITS_2,
	FLIT(-15989402920098153.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-5518962061619245.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1038 / 2048) */
	FLIT(-35322966643504218.0) * 2 / FRAC_BITS,
	FLIT(-61264378547853793.0) * 2 / FRAC_BITS_2,
	FLIT(-60739544910516990.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-24495842500340863.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1039 / 2048) */
	FLIT(-35272915058713856.0) * 2 / FRAC_BITS,
	FLIT(-51409508835364674.0) * 2 / FRAC_BITS_2,
	FLIT(-55265461444186421.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-59127693219907734.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1040 / 2048) */
	FLIT(-35222911623603642.0) * 2 / FRAC_BITS,
	FLIT(-58179811737980894.0) * 2 / FRAC_BITS_2,
	FLIT(-45272660465293896.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-42056315751093414.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1041 / 2048) */
	FLIT(-35172956245622512.0) * 2 / FRAC_BITS,
	FLIT(-49509247131888685.0) * 2 / FRAC_BITS_2,
	FLIT(-17215992271082190.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-10593778530113134.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1042 / 2048) */
	FLIT(-35123048832485991.0) * 2 / FRAC_BITS,
	FLIT(-51121796401917362.0) * 2 / FRAC_BITS_2,
	FLIT(-43510846013348642.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-67454030845453223.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1043 / 2048) */
	FLIT(-35073189292175172.0) * 2 / FRAC_BITS,
	FLIT(-10564304844891677.0) * 2 / FRAC_BITS_2,
	FLIT(-65440331358244442.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-10263833599022934.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1044 / 2048) */
	FLIT(-35023377532935695.0) * 2 / FRAC_BITS,
	FLIT(-14410405033875032.0) * 2 / FRAC_BITS_2,
	FLIT(-44648247162250566.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-22324741588497714.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1045 / 2048) */
	FLIT(-34973613463276737.0) * 2 / FRAC_BITS,
	FLIT(-63973238404363526.0) * 2 / FRAC_BITS_2,
	FLIT(-47310202803801371.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-29372352507715457.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1046 / 2048) */
	FLIT(-34923896991970004.0) * 2 / FRAC_BITS,
	FLIT(-56030156292898537.0) * 2 / FRAC_BITS_2,
	FLIT(-58196279211575045.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-64641067649732200.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1047 / 2048) */
	FLIT(-34874228028048724.0) * 2 / FRAC_BITS,
	FLIT(-38615308728665207.0) * 2 / FRAC_BITS_2,
	FLIT(-71102051621423263.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-64338858473458355.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1048 / 2048) */
	FLIT(-34824606480806651.0) * 2 / FRAC_BITS,
	FLIT(-19315871289793326.0) * 2 / FRAC_BITS_2,
	FLIT(-12177251265719988.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-6326810448456518.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1049 / 2048) */
	FLIT(-34775032259797070.0) * 2 / FRAC_BITS,
	FLIT(-44672815461475645.0) * 2 / FRAC_BITS_2,
	FLIT(-53364927929009474.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-11177033850262775.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1050 / 2048) */
	FLIT(-34725505274831810.0) * 2 / FRAC_BITS,
	FLIT(-44321202468797447.0) * 2 / FRAC_BITS_2,
	FLIT(-65232287316447567.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-21320355587519176.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1051 / 2048) */
	FLIT(-34676025435980257.0) * 2 / FRAC_BITS,
	FLIT(-14381963987256619.0) * 2 / FRAC_BITS_2,
	FLIT(-41231941392889351.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-30703207876719334.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1052 / 2048) */
	FLIT(-34626592653568374.0) * 2 / FRAC_BITS,
	FLIT(-33766195965468085.0) * 2 / FRAC_BITS_2,
	FLIT(-54806148833053454.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-60254105754741485.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1053 / 2048) */
	FLIT(-34577206838177729.0) * 2 / FRAC_BITS,
	FLIT(-39411430812311078.0) * 2 / FRAC_BITS_2,
	FLIT(-70877438459039603.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-20657741442452749.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1054 / 2048) */
	FLIT(-34527867900644522.0) * 2 / FRAC_BITS,
	FLIT(-7058070602440688.0) * 2 / FRAC_BITS_2,
	FLIT(-56422639468058992.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-62553391889366384.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1055 / 2048) */
	FLIT(-34478575752058618.0) * 2 / FRAC_BITS,
	FLIT(-31265339436242646.0) * 2 / FRAC_BITS_2,
	FLIT(-43397272590547264.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-17197344406007020.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1056 / 2048) */
	FLIT(-34429330303762590.0) * 2 / FRAC_BITS,
	FLIT(-14551479186248207.0) * 2 / FRAC_BITS_2,
	FLIT(-53400867273364110.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-21360427088832746.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1057 / 2048) */
	FLIT(-34380131467350757.0) * 2 / FRAC_BITS,
	FLIT(-44649688276665929.0) * 2 / FRAC_BITS_2,
	FLIT(-47263507803020670.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-61814254261622241.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1058 / 2048) */
	FLIT(-34330979154668237.0) * 2 / FRAC_BITS,
	FLIT(-16867906032037136.0) * 2 / FRAC_BITS_2,
	FLIT(-69057855056388756.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-8495049406646805.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1059 / 2048) */
	FLIT(-34281873277809994.0) * 2 / FRAC_BITS,
	FLIT(-12914201229015683.0) * 2 / FRAC_BITS_2,
	FLIT(-21445492550021390.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-15094415054567938.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1060 / 2048) */
	FLIT(-34232813749119898.0) * 2 / FRAC_BITS,
	FLIT(-65257969632944507.0) * 2 / FRAC_BITS_2,
	FLIT(-59796311206400026.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-43037931513864586.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1061 / 2048) */
	FLIT(-34183800481189788.0) * 2 / FRAC_BITS,
	FLIT(-25779487975658768.0) * 2 / FRAC_BITS_2,
	FLIT(-71540654975428560.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-23040598444470595.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1062 / 2048) */
	FLIT(-34134833386858531.0) * 2 / FRAC_BITS,
	FLIT(-41299613982857907.0) * 2 / FRAC_BITS_2,
	FLIT(-41010282433165626.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-21181435563997754.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1063 / 2048) */
	FLIT(-34085912379211099.0) * 2 / FRAC_BITS,
	FLIT(-48923128689467252.0) * 2 / FRAC_BITS_2,
	FLIT(-10285416353452200.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-54114928001299181.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1064 / 2048) */
	FLIT(-34037037371577640.0) * 2 / FRAC_BITS,
	FLIT(-18790386986545437.0) * 2 / FRAC_BITS_2,
	FLIT(-69218752310182186.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-44549347624268898.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1065 / 2048) */
	FLIT(-33988208277532556.0) * 2 / FRAC_BITS,
	FLIT(-5712717889845774.0) * 2 / FRAC_BITS_2,
	FLIT(-57473832571497720.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-35249825036130910.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1066 / 2048) */
	FLIT(-33939425010893588.0) * 2 / FRAC_BITS,
	FLIT(-7927405204372790.0) * 2 / FRAC_BITS_2,
	FLIT(-58241825654936867.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-57717606125772251.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1067 / 2048) */
	FLIT(-33890687485720902.0) * 2 / FRAC_BITS,
	FLIT(-63565222664096981.0) * 2 / FRAC_BITS_2,
	FLIT(-4507367649178623.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-51959085441206990.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1068 / 2048) */
	FLIT(-33841995616316184.0) * 2 / FRAC_BITS,
	FLIT(-6628673496160915.0) * 2 / FRAC_BITS_2,
	FLIT(-54720668274350726.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-11078858896315584.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1069 / 2048) */
	FLIT(-33793349317221728.0) * 2 / FRAC_BITS,
	FLIT(-33672747625166158.0) * 2 / FRAC_BITS_2,
	FLIT(-31400716611428143.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-57854945276534603.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1070 / 2048) */
	FLIT(-33744748503219545.0) * 2 / FRAC_BITS,
	FLIT(-61857193099195045.0) * 2 / FRAC_BITS_2,
	FLIT(-2454750659500165.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-45540183238922642.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1071 / 2048) */
	FLIT(-33696193089330463.0) * 2 / FRAC_BITS,
	FLIT(-38390988950162773.0) * 2 / FRAC_BITS_2,
	FLIT(-58732997029411588.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-1227115133220991.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1072 / 2048) */
	FLIT(-33647682990813234.0) * 2 / FRAC_BITS,
	FLIT(-46751533494383471.0) * 2 / FRAC_BITS_2,
	FLIT(-20209725769015745.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-4907006378953279.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1073 / 2048) */
	FLIT(-33599218123163650.0) * 2 / FRAC_BITS,
	FLIT(-63878447959049390.0) * 2 / FRAC_BITS_2,
	FLIT(-6679930710187732.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-29817672024006445.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1074 / 2048) */
	FLIT(-33550798402113659.0) * 2 / FRAC_BITS,
	FLIT(-15186416594646165.0) * 2 / FRAC_BITS_2,
	FLIT(-46472538669321922.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-39692351882581282.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1075 / 2048) */
	FLIT(-33502423743630482.0) * 2 / FRAC_BITS,
	FLIT(-53676449110406385.0) * 2 / FRAC_BITS_2,
	FLIT(-33056885718716415.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-69945190059655138.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1076 / 2048) */
	FLIT(-33454094063915745.0) * 2 / FRAC_BITS,
	FLIT(-52687052716967122.0) * 2 / FRAC_BITS_2,
	FLIT(-70449159310744273.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-58853118263034160.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1077 / 2048) */
	FLIT(-33405809279404602.0) * 2 / FRAC_BITS,
	FLIT(-40026118003719950.0) * 2 / FRAC_BITS_2,
	FLIT(-48700337171806606.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-25976847216491795.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1078 / 2048) */
	FLIT(-33357569306764870.0) * 2 / FRAC_BITS,
	FLIT(-58643254907453807.0) * 2 / FRAC_BITS_2,
	FLIT(-66526122834451550.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-2062166253243123.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1079 / 2048) */
	FLIT(-33309374062896168.0) * 2 / FRAC_BITS,
	FLIT(-28683126764121160.0) * 2 / FRAC_BITS_2,
	FLIT(-55826490324831635.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-11351382072685023.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1080 / 2048) */
	FLIT(-33261223464929054.0) * 2 / FRAC_BITS,
	FLIT(-41655648553949902.0) * 2 / FRAC_BITS_2,
	FLIT(-55358854497177117.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-5098444590567051.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1081 / 2048) */
	FLIT(-33213117430224175.0) * 2 / FRAC_BITS,
	FLIT(-4259869060186220.0) * 2 / FRAC_BITS_2,
	FLIT(-70432425799694297.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-42592769599095483.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1082 / 2048) */
	FLIT(-33165055876371410.0) * 2 / FRAC_BITS,
	FLIT(-71424499255414601.0) * 2 / FRAC_BITS_2,
	FLIT(-48360979918026006.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-32871973721831324.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1083 / 2048) */
	FLIT(-33117038721189031.0) * 2 / FRAC_BITS,
	FLIT(-65546592289813211.0) * 2 / FRAC_BITS_2,
	FLIT(-53254655021348997.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-36339362046199483.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1084 / 2048) */
	FLIT(-33069065882722852.0) * 2 / FRAC_BITS,
	FLIT(-42087751445327509.0) * 2 / FRAC_BITS_2,
	FLIT(-62681629792055417.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-69492471860444217.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1085 / 2048) */
	FLIT(-33021137279245393.0) * 2 / FRAC_BITS,
	FLIT(-54414505927433417.0) * 2 / FRAC_BITS_2,
	FLIT(-66173752496911961.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-47126460511122822.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1086 / 2048) */
	FLIT(-32973252829255046.0) * 2 / FRAC_BITS,
	FLIT(-53083304942626221.0) * 2 / FRAC_BITS_2,
	FLIT(-64048284001116578.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-21602488458575879.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1087 / 2048) */
	FLIT(-32925412451475241.0) * 2 / FRAC_BITS,
	FLIT(-62147021159710789.0) * 2 / FRAC_BITS_2,
	FLIT(-69346168544356712.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-53512500822055104.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1088 / 2048) */
	FLIT(-32877616064853620.0) * 2 / FRAC_BITS,
	FLIT(-54493815960985044.0) * 2 / FRAC_BITS_2,
	FLIT(-23254786216395431.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-6403778444909531.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1089 / 2048) */
	FLIT(-32829863588561212.0) * 2 / FRAC_BITS,
	FLIT(-29102958372496415.0) * 2 / FRAC_BITS_2,
	FLIT(-34744140508800284.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-42720854177665493.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1090 / 2048) */
	FLIT(-32782154941991613.0) * 2 / FRAC_BITS,
	FLIT(-478411887540719.0) * 2 / FRAC_BITS_2,
	FLIT(-11234728893883607.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-14289753170873307.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1091 / 2048) */
	FLIT(-32734490044760169.0) * 2 / FRAC_BITS,
	FLIT(-42876252791008326.0) * 2 / FRAC_BITS_2,
	FLIT(-22725834539810295.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-41661281516340020.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1092 / 2048) */
	FLIT(-32686868816703167.0) * 2 / FRAC_BITS,
	FLIT(-27548439506411013.0) * 2 / FRAC_BITS_2,
	FLIT(-48524483207110886.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-6536143918551666.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1093 / 2048) */
	FLIT(-32639291177877020.0) * 2 / FRAC_BITS,
	FLIT(-60329282986417276.0) * 2 / FRAC_BITS_2,
	FLIT(-3186159067032615.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-41140534180384315.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1094 / 2048) */
	FLIT(-32591757048557468.0) * 2 / FRAC_BITS,
	FLIT(-32827056758756808.0) * 2 / FRAC_BITS_2,
	FLIT(-55417000235237299.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-67480569552293475.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1095 / 2048) */
	FLIT(-32544266349238771.0) * 2 / FRAC_BITS,
	FLIT(-15141915692694961.0) * 2 / FRAC_BITS_2,
	FLIT(-7721033727829697.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-48396582590727360.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1096 / 2048) */
	FLIT(-32496819000632914.0) * 2 / FRAC_BITS,
	FLIT(-47506490912220718.0) * 2 / FRAC_BITS_2,
	FLIT(-13070690594375920.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-36951923569204524.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1097 / 2048) */
	FLIT(-32449414923668814.0) * 2 / FRAC_BITS,
	FLIT(-49982617334530848.0) * 2 / FRAC_BITS_2,
	FLIT(-59427642448039860.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-58183982421938784.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1098 / 2048) */
	FLIT(-32402054039491526.0) * 2 / FRAC_BITS,
	FLIT(-64953692404903185.0) * 2 / FRAC_BITS_2,
	FLIT(-15867083129680671.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-45927713724351493.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1099 / 2048) */
	FLIT(-32354736269461459.0) * 2 / FRAC_BITS,
	FLIT(-38354981422962579.0) * 2 / FRAC_BITS_2,
	FLIT(-32350015413068609.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-681191687028957.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1100 / 2048) */
	FLIT(-32307461535153590.0) * 2 / FRAC_BITS,
	FLIT(-2917914627939990.0) * 2 / FRAC_BITS_2,
	FLIT(-11097349738867584.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-47857445988040463.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1101 / 2048) */
	FLIT(-32260229758356685.0) * 2 / FRAC_BITS,
	FLIT(-13503947403118757.0) * 2 / FRAC_BITS_2,
	FLIT(-33291786551345060.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-32460327636504999.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1102 / 2048) */
	FLIT(-32213040861072524.0) * 2 / FRAC_BITS,
	FLIT(-49303619031242741.0) * 2 / FRAC_BITS_2,
	FLIT(-6331194621488659.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-72050752524455153.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1103 / 2048) */
	FLIT(-32165894765515128.0) * 2 / FRAC_BITS,
	FLIT(-25627722172198098.0) * 2 / FRAC_BITS_2,
	FLIT(-57757949063306217.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-16671183923447261.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1104 / 2048) */
	FLIT(-32118791394109986.0) * 2 / FRAC_BITS,
	FLIT(-58026301701583682.0) * 2 / FRAC_BITS_2,
	FLIT(-46095160741183352.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-63682586776108260.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1105 / 2048) */
	FLIT(-32071730669493295.0) * 2 / FRAC_BITS,
	FLIT(-40616033661038002.0) * 2 / FRAC_BITS_2,
	FLIT(-68527446681689327.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-48460094196002945.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1106 / 2048) */
	FLIT(-32024712514511192.0) * 2 / FRAC_BITS,
	FLIT(-50463411775071792.0) * 2 / FRAC_BITS_2,
	FLIT(-44936228494489845.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-62192491433100347.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1107 / 2048) */
	FLIT(-31977736852218999.0) * 2 / FRAC_BITS,
	FLIT(-63460836058269734.0) * 2 / FRAC_BITS_2,
	FLIT(-68328019686820088.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-20759734965245888.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1108 / 2048) */
	FLIT(-31930803605880466.0) * 2 / FRAC_BITS,
	FLIT(-61214637821925901.0) * 2 / FRAC_BITS_2,
	FLIT(-16474646244207901.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-9495885206472769.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1109 / 2048) */
	FLIT(-31883912698967019.0) * 2 / FRAC_BITS,
	FLIT(-23205499237616069.0) * 2 / FRAC_BITS_2,
	FLIT(-8715119565234706.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-67575042443687236.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1110 / 2048) */
	FLIT(-31837064055157010.0) * 2 / FRAC_BITS,
	FLIT(-19066097441196324.0) * 2 / FRAC_BITS_2,
	FLIT(-17390538045114283.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-12591375026075782.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1111 / 2048) */
	FLIT(-31790257598334974.0) * 2 / FRAC_BITS,
	FLIT(-39368421564140465.0) * 2 / FRAC_BITS_2,
	FLIT(-7878797532616495.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-28751919148237671.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1112 / 2048) */
	FLIT(-31743493252590886.0) * 2 / FRAC_BITS,
	FLIT(-68012649993071366.0) * 2 / FRAC_BITS_2,
	FLIT(-71365820335934587.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-20674876836246266.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1113 / 2048) */
	FLIT(-31696770942219423.0) * 2 / FRAC_BITS,
	FLIT(-34626597401374626.0) * 2 / FRAC_BITS_2,
	FLIT(-63048133948217016.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-7517759681322838.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1114 / 2048) */
	FLIT(-31650090591719226.0) * 2 / FRAC_BITS,
	FLIT(-5968872896614568.0) * 2 / FRAC_BITS_2,
	FLIT(-59707200958826392.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-6001420415986891.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1115 / 2048) */
	FLIT(-31603452125792170.0) * 2 / FRAC_BITS,
	FLIT(-38588300756034927.0) * 2 / FRAC_BITS_2,
	FLIT(-60320724304418140.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-28854385688565362.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1116 / 2048) */
	FLIT(-31556855469342637.0) * 2 / FRAC_BITS,
	FLIT(-51748952012585872.0) * 2 / FRAC_BITS_2,
	FLIT(-56300319677641511.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-30904549514170696.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1117 / 2048) */
	FLIT(-31510300547476788.0) * 2 / FRAC_BITS,
	FLIT(-7580557558706817.0) * 2 / FRAC_BITS_2,
	FLIT(-42838042155393782.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-52837859518911678.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1118 / 2048) */
	FLIT(-31463787285501839.0) * 2 / FRAC_BITS,
	FLIT(-36903686148019951.0) * 2 / FRAC_BITS_2,
	FLIT(-16349081609379734.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-55160978390687628.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1119 / 2048) */
	FLIT(-31417315608925348.0) * 2 / FRAC_BITS,
	FLIT(-5071784726847487.0) * 2 / FRAC_BITS_2,
	FLIT(-46738066432449970.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-40841931127923972.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1120 / 2048) */
	FLIT(-31370885443454492.0) * 2 / FRAC_BITS,
	FLIT(-29792657248049837.0) * 2 / FRAC_BITS_2,
	FLIT(-33005899245248399.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-63034441104593904.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1121 / 2048) */
	FLIT(-31324496714995361.0) * 2 / FRAC_BITS,
	FLIT(-4135233942297680.0) * 2 / FRAC_BITS_2,
	FLIT(-2693229892403719.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-70907446499955193.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1122 / 2048) */
	FLIT(-31278149349652242.0) * 2 / FRAC_BITS,
	FLIT(-69045295147233252.0) * 2 / FRAC_BITS_2,
	FLIT(-4598059451831605.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-27764205533742277.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1123 / 2048) */
	FLIT(-31231843273726921.0) * 2 / FRAC_BITS,
	FLIT(-16533820665768286.0) * 2 / FRAC_BITS_2,
	FLIT(-28772529566847470.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-10382447949491531.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1124 / 2048) */
	FLIT(-31185578413717970.0) * 2 / FRAC_BITS,
	FLIT(-222496216345805.0) * 2 / FRAC_BITS_2,
	FLIT(-11301614869000276.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-70445094500854509.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1125 / 2048) */
	FLIT(-31139354696320054.0) * 2 / FRAC_BITS,
	FLIT(-30022083995641685.0) * 2 / FRAC_BITS_2,
	FLIT(-13055336962680591.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-31595463489774767.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1126 / 2048) */
	FLIT(-31093172048423233.0) * 2 / FRAC_BITS,
	FLIT(-51182522879116458.0) * 2 / FRAC_BITS_2,
	FLIT(-17142542809507549.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-19693304695206000.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1127 / 2048) */
	FLIT(-31047030397112267.0) * 2 / FRAC_BITS,
	FLIT(-30060483384861346.0) * 2 / FRAC_BITS_2,
	FLIT(-59220416302270792.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-44384325940518637.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1128 / 2048) */
	FLIT(-31000929669665924.0) * 2 / FRAC_BITS,
	FLIT(-45418264729732766.0) * 2 / FRAC_BITS_2,
	FLIT(-47469731484488894.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-25722712930629002.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1129 / 2048) */
	FLIT(-30954869793556296.0) * 2 / FRAC_BITS,
	FLIT(-23787308488026594.0) * 2 / FRAC_BITS_2,
	FLIT(-23004927727578235.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-11531726522067385.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1130 / 2048) */
	FLIT(-30908850696448110.0) * 2 / FRAC_BITS,
	FLIT(-54473601305872974.0) * 2 / FRAC_BITS_2,
	FLIT(-67863710440458446.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-66723616608183780.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1131 / 2048) */
	FLIT(-30862872306198051.0) * 2 / FRAC_BITS,
	FLIT(-58061671551108316.0) * 2 / FRAC_BITS_2,
	FLIT(-57694519556345295.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-34037548818737921.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1132 / 2048) */
	FLIT(-30816934550854080.0) * 2 / FRAC_BITS,
	FLIT(-32239284347723219.0) * 2 / FRAC_BITS_2,
	FLIT(-57765741284114955.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-21862937842074252.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1133 / 2048) */
	FLIT(-30771037358654759.0) * 2 / FRAC_BITS,
	FLIT(-9101863746805715.0) * 2 / FRAC_BITS_2,
	FLIT(-12038998070787536.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-55235400852507584.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1134 / 2048) */
	FLIT(-30725180658028579.0) * 2 / FRAC_BITS,
	FLIT(-11024276322380021.0) * 2 / FRAC_BITS_2,
	FLIT(-58610677238994106.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-41635866795953238.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1135 / 2048) */
	FLIT(-30679364377593291.0) * 2 / FRAC_BITS,
	FLIT(-3964285185770061.0) * 2 / FRAC_BITS_2,
	FLIT(-1168204599932880.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-43881874374818881.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1136 / 2048) */
	FLIT(-30633588446155237.0) * 2 / FRAC_BITS,
	FLIT(-63241766707026100.0) * 2 / FRAC_BITS_2,
	FLIT(-25247444500298553.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-4906316515277701.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1137 / 2048) */
	FLIT(-30587852792708691.0) * 2 / FRAC_BITS,
	FLIT(-30096011637585099.0) * 2 / FRAC_BITS_2,
	FLIT(-43535019850530799.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-7468149252406885.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1138 / 2048) */
	FLIT(-30542157346435191.0) * 2 / FRAC_BITS,
	FLIT(-27000562434438063.0) * 2 / FRAC_BITS_2,
	FLIT(-59437874032737924.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-43723750487223360.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1139 / 2048) */
	FLIT(-30496502036702887.0) * 2 / FRAC_BITS,
	FLIT(-29187755417440579.0) * 2 / FRAC_BITS_2,
	FLIT(-43464511985411176.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-11310784823862810.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1140 / 2048) */
	FLIT(-30450886793065884.0) * 2 / FRAC_BITS,
	FLIT(-4491268513389675.0) * 2 / FRAC_BITS_2,
	FLIT(-17041801956415210.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-54824455526524489.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1141 / 2048) */
	FLIT(-30405311545263588.0) * 2 / FRAC_BITS,
	FLIT(-43951506874743004.0) * 2 / FRAC_BITS_2,
	FLIT(-8239566918153675.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-25386327536677127.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1142 / 2048) */
	FLIT(-30359776223220061.0) * 2 / FRAC_BITS,
	FLIT(-49750558004160783.0) * 2 / FRAC_BITS_2,
	FLIT(-63789550616852422.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-8886889775880891.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1143 / 2048) */
	FLIT(-30314280757043370.0) * 2 / FRAC_BITS,
	FLIT(-60259587086401418.0) * 2 / FRAC_BITS_2,
	FLIT(-2596701572366989.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-44146834733622269.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1144 / 2048) */
	FLIT(-30268825077024946.0) * 2 / FRAC_BITS,
	FLIT(-58202745703481491.0) * 2 / FRAC_BITS_2,
	FLIT(-66447139667458839.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-33073234319072953.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1145 / 2048) */
	FLIT(-30223409113638942.0) * 2 / FRAC_BITS,
	FLIT(-53503277526127808.0) * 2 / FRAC_BITS_2,
	FLIT(-32863942078639628.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-61472649613765136.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1146 / 2048) */
	FLIT(-30178032797541596.0) * 2 / FRAC_BITS,
	FLIT(-7404931429188157.0) * 2 / FRAC_BITS_2,
	FLIT(-17291406679902956.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-31512184849217380.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1147 / 2048) */
	FLIT(-30132696059570593.0) * 2 / FRAC_BITS,
	FLIT(-29159400899832294.0) * 2 / FRAC_BITS_2,
	FLIT(-18332003225578677.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-38397479949679427.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1148 / 2048) */
	FLIT(-30087398830744437.0) * 2 / FRAC_BITS,
	FLIT(-51597844752369669.0) * 2 / FRAC_BITS_2,
	FLIT(-45975064434891371.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-6638137441344805.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1149 / 2048) */
	FLIT(-30042141042261818.0) * 2 / FRAC_BITS,
	FLIT(-65408379117162489.0) * 2 / FRAC_BITS_2,
	FLIT(-57652245023945170.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-62727322236260524.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1150 / 2048) */
	FLIT(-29996922625500986.0) * 2 / FRAC_BITS,
	FLIT(-46392737143275465.0) * 2 / FRAC_BITS_2,
	FLIT(-3791643206686827.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-18122011637388040.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1151 / 2048) */
	FLIT(-29951743512019126.0) * 2 / FRAC_BITS,
	FLIT(-7018286910000097.0) * 2 / FRAC_BITS_2,
	FLIT(-28510850342540155.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-36873491263920521.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1152 / 2048) */
	FLIT(-29906603633551736.0) * 2 / FRAC_BITS,
	FLIT(-27127103333202292.0) * 2 / FRAC_BITS_2,
	FLIT(-23132466425977949.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-46812530107641778.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1153 / 2048) */
	FLIT(-29861502922012011.0) * 2 / FRAC_BITS,
	FLIT(-46612409972061149.0) * 2 / FRAC_BITS_2,
	FLIT(-8560837903913342.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-9426321765326244.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1154 / 2048) */
	FLIT(-29816441309490224.0) * 2 / FRAC_BITS,
	FLIT(-67570006156669659.0) * 2 / FRAC_BITS_2,
	FLIT(-30251419848548494.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-20625541104644448.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1155 / 2048) */
	FLIT(-29771418728253114.0) * 2 / FRAC_BITS,
	FLIT(-44344136434298045.0) * 2 / FRAC_BITS_2,
	FLIT(-14349172480684574.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-12337274155498715.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1156 / 2048) */
	FLIT(-29726435110743273.0) * 2 / FRAC_BITS,
	FLIT(-36930037884042152.0) * 2 / FRAC_BITS_2,
	FLIT(-46509572432790862.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-12807556889819062.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1157 / 2048) */
	FLIT(-29681490389578540.0) * 2 / FRAC_BITS,
	FLIT(-50279940013394199.0) * 2 / FRAC_BITS_2,
	FLIT(-67766940668445455.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-22791666126555791.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1158 / 2048) */
	FLIT(-29636584497551395.0) * 2 / FRAC_BITS,
	FLIT(-62929204518629491.0) * 2 / FRAC_BITS_2,
	FLIT(-70507746022398285.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-19966847845354622.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1159 / 2048) */
	FLIT(-29591717367628356.0) * 2 / FRAC_BITS,
	FLIT(-27789312364342957.0) * 2 / FRAC_BITS_2,
	FLIT(-49607624626846701.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-23596130622380995.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1160 / 2048) */
	FLIT(-29546888932949376.0) * 2 / FRAC_BITS,
	FLIT(-60305889292747140.0) * 2 / FRAC_BITS_2,
	FLIT(-42175935594482809.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-18478251966852223.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1161 / 2048) */
	FLIT(-29502099126827251.0) * 2 / FRAC_BITS,
	FLIT(-20379522963988959.0) * 2 / FRAC_BITS_2,
	FLIT(-26435275641262955.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-18203107230161264.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1162 / 2048) */
	FLIT(-29457347882747018.0) * 2 / FRAC_BITS,
	FLIT(-295972274190103.0) * 2 / FRAC_BITS_2,
	FLIT(-43559729104786138.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-32329507426185513.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1163 / 2048) */
	FLIT(-29412635134365366.0) * 2 / FRAC_BITS,
	FLIT(-60384029684427405.0) * 2 / FRAC_BITS_2,
	FLIT(-24840821340716030.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-59087170934687603.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1164 / 2048) */
	FLIT(-29367960815510049.0) * 2 / FRAC_BITS,
	FLIT(-4083252773123129.0) * 2 / FRAC_BITS_2,
	FLIT(-46296560839720399.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-5353594422088086.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1165 / 2048) */
	FLIT(-29323324860179289.0) * 2 / FRAC_BITS,
	FLIT(-56167093794417261.0) * 2 / FRAC_BITS_2,
	FLIT(-55798101765861125.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-71005922085838605.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1166 / 2048) */
	FLIT(-29278727202541202.0) * 2 / FRAC_BITS,
	FLIT(-65280903598445105.0) * 2 / FRAC_BITS_2,
	FLIT(-8913196370637033.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-34054850081844125.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1167 / 2048) */
	FLIT(-29234167776933208.0) * 2 / FRAC_BITS,
	FLIT(-40106697331142510.0) * 2 / FRAC_BITS_2,
	FLIT(-1791395561120560.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-62632664164592097.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1168 / 2048) */
	FLIT(-29189646517861453.0) * 2 / FRAC_BITS,
	FLIT(-613370471947350.0) * 2 / FRAC_BITS_2,
	FLIT(-47552239694558466.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-18053074069874152.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1169 / 2048) */
	FLIT(-29145163360000231.0) * 2 / FRAC_BITS,
	FLIT(-8160378615513301.0) * 2 / FRAC_BITS_2,
	FLIT(-60159148985097317.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-56603283049940729.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1170 / 2048) */
	FLIT(-29100718238191411.0) * 2 / FRAC_BITS,
	FLIT(-13249321033255250.0) * 2 / FRAC_BITS_2,
	FLIT(-68405126891271846.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-16811251820807257.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1171 / 2048) */
	FLIT(-29056311087443862.0) * 2 / FRAC_BITS,
	FLIT(-24414484016622067.0) * 2 / FRAC_BITS_2,
	FLIT(-46252872448127063.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-42870417502759381.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1172 / 2048) */
	FLIT(-29011941842932884.0) * 2 / FRAC_BITS,
	FLIT(-20884939472594507.0) * 2 / FRAC_BITS_2,
	FLIT(-9378905988104661.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-56902465776286389.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1173 / 2048) */
	FLIT(-28967610439999639.0) * 2 / FRAC_BITS,
	FLIT(-40462523624640790.0) * 2 / FRAC_BITS_2,
	FLIT(-69349946957578783.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-70086365221017791.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1174 / 2048) */
	FLIT(-28923316814150588.0) * 2 / FRAC_BITS,
	FLIT(-9374268168384889.0) * 2 / FRAC_BITS_2,
	FLIT(-28155202566084184.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-56322113661656879.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1175 / 2048) */
	FLIT(-28879060901056924.0) * 2 / FRAC_BITS,
	FLIT(-33784700171424549.0) * 2 / FRAC_BITS_2,
	FLIT(-5166213949992368.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-52219731829836718.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1176 / 2048) */
	FLIT(-28834842636554016.0) * 2 / FRAC_BITS,
	FLIT(-71218879054407892.0) * 2 / FRAC_BITS_2,
	FLIT(-36257721987065389.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-27514269272052155.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1177 / 2048) */
	FLIT(-28790661956640849.0) * 2 / FRAC_BITS,
	FLIT(-61880127064695642.0) * 2 / FRAC_BITS_2,
	FLIT(-23629229861665108.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-36557101806902181.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1178 / 2048) */
	FLIT(-28746518797479467.0) * 2 / FRAC_BITS,
	FLIT(-14584571972025645.0) * 2 / FRAC_BITS_2,
	FLIT(-17983267136879605.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-8572966412200199.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1179 / 2048) */
	FLIT(-28702413095394419.0) * 2 / FRAC_BITS,
	FLIT(-46442974622995618.0) * 2 / FRAC_BITS_2,
	FLIT(-35309717691697937.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-53139340556098297.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1180 / 2048) */
	FLIT(-28658344786872213.0) * 2 / FRAC_BITS,
	FLIT(-15137504203802079.0) * 2 / FRAC_BITS_2,
	FLIT(-38537970865397869.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-17334945942352262.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1181 / 2048) */
	FLIT(-28614313808560760.0) * 2 / FRAC_BITS,
	FLIT(-39970912364298938.0) * 2 / FRAC_BITS_2,
	FLIT(-49492066516484825.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-1359553742814432.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1182 / 2048) */
	FLIT(-28570320097268834.0) * 2 / FRAC_BITS,
	FLIT(-37336510414303646.0) * 2 / FRAC_BITS_2,
	FLIT(-61831455049561919.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-27253793117609498.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1183 / 2048) */
	FLIT(-28526363589965523.0) * 2 / FRAC_BITS,
	FLIT(-71199706023644297.0) * 2 / FRAC_BITS_2,
	FLIT(-61570755601205615.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-18248951148791872.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1184 / 2048) */
	FLIT(-28482444223779692.0) * 2 / FRAC_BITS,
	FLIT(-4537552220448713.0) * 2 / FRAC_BITS_2,
	FLIT(-57221744011843051.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-54305460543150509.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1185 / 2048) */
	FLIT(-28438561935999436.0) * 2 / FRAC_BITS,
	FLIT(-36164293301916029.0) * 2 / FRAC_BITS_2,
	FLIT(-64816872178650806.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-410005297428002.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1186 / 2048) */
	FLIT(-28394716664071552.0) * 2 / FRAC_BITS,
	FLIT(-32438550864973407.0) * 2 / FRAC_BITS_2,
	FLIT(-52253728326877853.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-34201890905623880.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1187 / 2048) */
	FLIT(-28350908345600997.0) * 2 / FRAC_BITS,
	FLIT(-30923544637220775.0) * 2 / FRAC_BITS_2,
	FLIT(-9726909898314759.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-67219145327461853.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1188 / 2048) */
	FLIT(-28307136918350358.0) * 2 / FRAC_BITS,
	FLIT(-41678582519450500.0) * 2 / FRAC_BITS_2,
	FLIT(-4475739661414123.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-68172957196474525.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1189 / 2048) */
	FLIT(-28263402320239322.0) * 2 / FRAC_BITS,
	FLIT(-10053482759139036.0) * 2 / FRAC_BITS_2,
	FLIT(-55145100784125780.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-34139542341531060.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1190 / 2048) */
	FLIT(-28219704489344145.0) * 2 / FRAC_BITS,
	FLIT(-12228879171106945.0) * 2 / FRAC_BITS_2,
	FLIT(-56260685461643830.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-69438219549503435.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1191 / 2048) */
	FLIT(-28176043363897129.0) * 2 / FRAC_BITS,
	FLIT(-34174209950279775.0) * 2 / FRAC_BITS_2,
	FLIT(-39057678593543438.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-56124168870906467.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1192 / 2048) */
	FLIT(-28132418882286097.0) * 2 / FRAC_BITS,
	FLIT(-53794235188916240.0) * 2 / FRAC_BITS_2,
	FLIT(-53094586971206234.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-62253027018353253.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1193 / 2048) */
	FLIT(-28088830983053871.0) * 2 / FRAC_BITS,
	FLIT(-65175743570068245.0) * 2 / FRAC_BITS_2,
	FLIT(-8158392944703646.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-20131546080432604.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1194 / 2048) */
	FLIT(-28045279604897753.0) * 2 / FRAC_BITS,
	FLIT(-44138773149200655.0) * 2 / FRAC_BITS_2,
	FLIT(-38337439227950572.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-55648224603000506.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1195 / 2048) */
	FLIT(-28001764686669006.0) * 2 / FRAC_BITS,
	FLIT(-70474116061090276.0) * 2 / FRAC_BITS_2,
	FLIT(-43579343513427074.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-33594724461939843.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1196 / 2048) */
	FLIT(-27958286167372343.0) * 2 / FRAC_BITS,
	FLIT(-29619974180889030.0) * 2 / FRAC_BITS_2,
	FLIT(-59141433135278082.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-3337799968420530.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1197 / 2048) */
	FLIT(-27914843986165408.0) * 2 / FRAC_BITS,
	FLIT(-45917490319747730.0) * 2 / FRAC_BITS_2,
	FLIT(-20293624698232200.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-19304283693982741.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1198 / 2048) */
	FLIT(-27871438082358271.0) * 2 / FRAC_BITS,
	FLIT(-61400876000387247.0) * 2 / FRAC_BITS_2,
	FLIT(-19854672957644144.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-13893490884668533.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1199 / 2048) */
	FLIT(-27828068395412917.0) * 2 / FRAC_BITS,
	FLIT(-501345853041316.0) * 2 / FRAC_BITS_2,
	FLIT(-32409208096048550.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-5306671738852846.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1200 / 2048) */
	FLIT(-27784734864942736.0) * 2 / FRAC_BITS,
	FLIT(-15493538774894074.0) * 2 / FRAC_BITS_2,
	FLIT(-52886542929409360.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-1251954968921559.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1201 / 2048) */
	FLIT(-27741437430712025.0) * 2 / FRAC_BITS,
	FLIT(-19287208922836271.0) * 2 / FRAC_BITS_2,
	FLIT(-34257171605895055.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-17079912804924864.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1202 / 2048) */
	FLIT(-27698176032635481.0) * 2 / FRAC_BITS,
	FLIT(-18014428078211361.0) * 2 / FRAC_BITS_2,
	FLIT(-50821090546087362.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-19661193630847663.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1203 / 2048) */
	FLIT(-27654950610777702.0) * 2 / FRAC_BITS,
	FLIT(-17678387136064767.0) * 2 / FRAC_BITS_2,
	FLIT(-61669173058376651.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-49896001897198943.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1204 / 2048) */
	FLIT(-27611761105352689.0) * 2 / FRAC_BITS,
	FLIT(-8516531658088894.0) * 2 / FRAC_BITS_2,
	FLIT(-4082320389334238.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-4081509706260181.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1205 / 2048) */
	FLIT(-27568607456723349.0) * 2 / FRAC_BITS,
	FLIT(-26331969280192103.0) * 2 / FRAC_BITS_2,
	FLIT(-8581691454433201.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-57397236165579516.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1206 / 2048) */
	FLIT(-27525489605401003.0) * 2 / FRAC_BITS,
	FLIT(-1821042789657827.0) * 2 / FRAC_BITS_2,
	FLIT(-43342192194993694.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-51719536486595058.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1207 / 2048) */
	FLIT(-27482407492044890.0) * 2 / FRAC_BITS,
	FLIT(-45677988630083208.0) * 2 / FRAC_BITS_2,
	FLIT(-48502230716693984.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-11310094960187232.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1208 / 2048) */
	FLIT(-27439361057461683.0) * 2 / FRAC_BITS,
	FLIT(-15822024582762556.0) * 2 / FRAC_BITS_2,
	FLIT(-34917763415982463.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-41745853643024623.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1209 / 2048) */
	FLIT(-27396350242604994.0) * 2 / FRAC_BITS,
	FLIT(-23342624491891220.0) * 2 / FRAC_BITS_2,
	FLIT(-69346592071736240.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-42617356744410903.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1210 / 2048) */
	FLIT(-27353374988574894.0) * 2 / FRAC_BITS,
	FLIT(-2940848593440587.0) * 2 / FRAC_BITS_2,
	FLIT(-32271828941032527.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-38874364556020001.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1211 / 2048) */
	FLIT(-27310435236617425.0) * 2 / FRAC_BITS,
	FLIT(-4470896537228084.0) * 2 / FRAC_BITS_2,
	FLIT(-61519056084566222.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-57186775084081559.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1212 / 2048) */
	FLIT(-27267530928124120.0) * 2 / FRAC_BITS,
	FLIT(-51944045711094549.0) * 2 / FRAC_BITS_2,
	FLIT(-49667990723158270.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-54204022167046703.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1213 / 2048) */
	FLIT(-27224662004631525.0) * 2 / FRAC_BITS,
	FLIT(-1628341841872669.0) * 2 / FRAC_BITS_2,
	FLIT(-60549568359971091.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-41542209313456288.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1214 / 2048) */
	FLIT(-27181828407820714.0) * 2 / FRAC_BITS,
	FLIT(-47054299229462167.0) * 2 / FRAC_BITS_2,
	FLIT(-31578456839598283.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-48383545961935527.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1215 / 2048) */
	FLIT(-27139030079516822.0) * 2 / FRAC_BITS,
	FLIT(-68782751887152195.0) * 2 / FRAC_BITS_2,
	FLIT(-6433726885227130.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-51910974698208830.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1216 / 2048) */
	FLIT(-27096266961688565.0) * 2 / FRAC_BITS,
	FLIT(-62020317330570000.0) * 2 / FRAC_BITS_2,
	FLIT(-56873007923143979.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-24480947005671281.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1217 / 2048) */
	FLIT(-27053538996447769.0) * 2 / FRAC_BITS,
	FLIT(-56119478430353886.0) * 2 / FRAC_BITS_2,
	FLIT(-36250992013146332.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-25444926029788798.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1218 / 2048) */
	FLIT(-27010846126048901.0) * 2 / FRAC_BITS,
	FLIT(-29674517061177259.0) * 2 / FRAC_BITS_2,
	FLIT(-45427758336299798.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-55015674172238410.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1219 / 2048) */
	FLIT(-26968188292888599.0) * 2 / FRAC_BITS,
	FLIT(-36698132075852644.0) * 2 / FRAC_BITS_2,
	FLIT(-1607489838456276.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-4319415731191702.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1220 / 2048) */
	FLIT(-26925565439505208.0) * 2 / FRAC_BITS,
	FLIT(-38791582625847357.0) * 2 / FRAC_BITS_2,
	FLIT(-13394771561912914.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-42081224102706001.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1221 / 2048) */
	FLIT(-26882977508578314.0) * 2 / FRAC_BITS,
	FLIT(-19089031406696921.0) * 2 / FRAC_BITS_2,
	FLIT(-38565017247279226.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-3608293594055320.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1222 / 2048) */
	FLIT(-26840424442928281.0) * 2 / FRAC_BITS,
	FLIT(-17011937209038114.0) * 2 / FRAC_BITS_2,
	FLIT(-60516003878583623.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-37435520160869208.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1223 / 2048) */
	FLIT(-26797906185515792.0) * 2 / FRAC_BITS,
	FLIT(-11103594099208555.0) * 2 / FRAC_BITS_2,
	FLIT(-47660735651851701.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-2558812120183019.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1224 / 2048) */
	FLIT(-26755422679441389.0) * 2 / FRAC_BITS,
	FLIT(-9563325256259400.0) * 2 / FRAC_BITS_2,
	FLIT(-46387252642373380.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-53216308552551309.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1225 / 2048) */
	FLIT(-26712973867945016.0) * 2 / FRAC_BITS,
	FLIT(-59585314496099674.0) * 2 / FRAC_BITS_2,
	FLIT(-66011798490496799.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-54011288171259872.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1226 / 2048) */
	FLIT(-26670559694405567.0) * 2 / FRAC_BITS,
	FLIT(-30726042989015445.0) * 2 / FRAC_BITS_2,
	FLIT(-14320994949276883.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-54873003494406833.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1227 / 2048) */
	FLIT(-26628180102340427.0) * 2 / FRAC_BITS,
	FLIT(-36334386844961835.0) * 2 / FRAC_BITS_2,
	FLIT(-16669348918950671.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-1833703234092158.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1228 / 2048) */
	FLIT(-26585835035405026.0) * 2 / FRAC_BITS,
	FLIT(-51239169083548670.0) * 2 / FRAC_BITS_2,
	FLIT(-6139330249200359.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-1662374671254967.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1229 / 2048) */
	FLIT(-26543524437392388.0) * 2 / FRAC_BITS,
	FLIT(-22081255602252192.0) * 2 / FRAC_BITS_2,
	FLIT(-70877720603987704.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-11888717934598918.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1230 / 2048) */
	FLIT(-26501248252232681.0) * 2 / FRAC_BITS,
	FLIT(-37298726279213906.0) * 2 / FRAC_BITS_2,
	FLIT(-65855708119052331.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-16913245343600396.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1231 / 2048) */
	FLIT(-26459006423992775.0) * 2 / FRAC_BITS,
	FLIT(-51719732697071776.0) * 2 / FRAC_BITS_2,
	FLIT(-44053722661985784.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-64323544175015206.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1232 / 2048) */
	FLIT(-26416798896875796.0) * 2 / FRAC_BITS,
	FLIT(-29815591213550434.0) * 2 / FRAC_BITS_2,
	FLIT(-54180378447413342.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-54051359672573442.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1233 / 2048) */
	FLIT(-26374625615220683.0) * 2 / FRAC_BITS,
	FLIT(-2576000207495074.0) * 2 / FRAC_BITS_2,
	FLIT(-36203157020353870.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-11706859638918367.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1234 / 2048) */
	FLIT(-26332486523501748.0) * 2 / FRAC_BITS,
	FLIT(-37375031895942925.0) * 2 / FRAC_BITS_2,
	FLIT(-27303169566491929.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-14530548962512399.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1235 / 2048) */
	FLIT(-26290381566328240.0) * 2 / FRAC_BITS,
	FLIT(-48142535030622959.0) * 2 / FRAC_BITS_2,
	FLIT(-30088074350509939.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-66537262756764696.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1236 / 2048) */
	FLIT(-26248310688443905.0) * 2 / FRAC_BITS,
	FLIT(-21677487893759799.0) * 2 / FRAC_BITS_2,
	FLIT(-53828191261329312.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-8629909833388680.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1237 / 2048) */
	FLIT(-26206273834726551.0) * 2 / FRAC_BITS,
	FLIT(-10964276126548556.0) * 2 / FRAC_BITS_2,
	FLIT(-17182868101736283.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-70581088220021264.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1238 / 2048) */
	FLIT(-26164270950187616.0) * 2 / FRAC_BITS,
	FLIT(-38989915254631170.0) * 2 / FRAC_BITS_2,
	FLIT(-9119063427057433.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-34411589283607459.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1239 / 2048) */
	FLIT(-26122301979971737.0) * 2 / FRAC_BITS,
	FLIT(-56563726010160134.0) * 2 / FRAC_BITS_2,
	FLIT(-41789793607214858.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-53872368147738450.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1240 / 2048) */
	FLIT(-26080366869356319.0) * 2 / FRAC_BITS,
	FLIT(-25586842233530044.0) * 2 / FRAC_BITS_2,
	FLIT(-53828008109873754.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-27058059892525204.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1241 / 2048) */
	FLIT(-26038465563751105.0) * 2 / FRAC_BITS,
	FLIT(-55107186432932394.0) * 2 / FRAC_BITS_2,
	FLIT(-70807025910953897.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-24456852514783683.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1242 / 2048) */
	FLIT(-25996598008697755.0) * 2 / FRAC_BITS,
	FLIT(-13095810996858038.0) * 2 / FRAC_BITS_2,
	FLIT(-69227627167161302.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-38437522845822102.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1243 / 2048) */
	FLIT(-25954764149869414.0) * 2 / FRAC_BITS,
	FLIT(-54496535271373572.0) * 2 / FRAC_BITS_2,
	FLIT(-16980595604695453.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-57740535176163318.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1244 / 2048) */
	FLIT(-25912963933070297.0) * 2 / FRAC_BITS,
	FLIT(-47339672179860569.0) * 2 / FRAC_BITS_2,
	FLIT(-62996613295442175.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-46783195019924523.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1245 / 2048) */
	FLIT(-25871197304235261.0) * 2 / FRAC_BITS,
	FLIT(-58054447838962276.0) * 2 / FRAC_BITS_2,
	FLIT(-63440372788947098.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-42604615328441104.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1246 / 2048) */
	FLIT(-25829464209429390.0) * 2 / FRAC_BITS,
	FLIT(-21892785523463142.0) * 2 / FRAC_BITS_2,
	FLIT(-55500179448399958.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-43769791480056280.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1247 / 2048) */
	FLIT(-25787764594847573.0) * 2 / FRAC_BITS,
	FLIT(-39029763702786197.0) * 2 / FRAC_BITS_2,
	FLIT(-13252356738568647.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-31582914606446436.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1248 / 2048) */
	FLIT(-25746098406814092.0) * 2 / FRAC_BITS,
	FLIT(-70778369850435576.0) * 2 / FRAC_BITS_2,
	FLIT(-36178738820072678.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-58525337337881985.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1249 / 2048) */
	FLIT(-25704465591782206.0) * 2 / FRAC_BITS,
	FLIT(-44144857195290462.0) * 2 / FRAC_BITS_2,
	FLIT(-57641557798903240.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-64444104909401098.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1250 / 2048) */
	FLIT(-25662866096333736.0) * 2 / FRAC_BITS,
	FLIT(-3859974216585857.0) * 2 / FRAC_BITS_2,
	FLIT(-10583025394912834.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-27748973868129275.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1251 / 2048) */
	FLIT(-25621299867178655.0) * 2 / FRAC_BITS,
	FLIT(-23082159288345723.0) * 2 / FRAC_BITS_2,
	FLIT(-22440692723984600.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-67487406943888045.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1252 / 2048) */
	FLIT(-25579766851154681.0) * 2 / FRAC_BITS,
	FLIT(-16317565034537171.0) * 2 / FRAC_BITS_2,
	FLIT(-63204851933060533.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-59100078702343328.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1253 / 2048) */
	FLIT(-25538266995226865.0) * 2 / FRAC_BITS,
	FLIT(-30450528621948392.0) * 2 / FRAC_BITS_2,
	FLIT(-47252049843371155.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-325690428394042.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1254 / 2048) */
	FLIT(-25496800246487188.0) * 2 / FRAC_BITS,
	FLIT(-4514202478890272.0) * 2 / FRAC_BITS_2,
	FLIT(-38216281158580153.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-45841374094504028.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1255 / 2048) */
	FLIT(-25455366552154153.0) * 2 / FRAC_BITS,
	FLIT(-6446839888602864.0) * 2 / FRAC_BITS_2,
	FLIT(-68492396947336276.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-10260270345315737.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1256 / 2048) */
	FLIT(-25413965859572385.0) * 2 / FRAC_BITS,
	FLIT(-9527317729059206.0) * 2 / FRAC_BITS_2,
	FLIT(-20004271026030401.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-52670385106359276.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1257 / 2048) */
	FLIT(-25372598116212228.0) * 2 / FRAC_BITS,
	FLIT(-568842479688755.0) * 2 / FRAC_BITS_2,
	FLIT(-2766148506229890.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-5633324599120611.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1258 / 2048) */
	FLIT(-25331263269669344.0) * 2 / FRAC_BITS,
	FLIT(-59031368181433758.0) * 2 / FRAC_BITS_2,
	FLIT(-8418936190310546.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-60709238988060040.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1259 / 2048) */
	FLIT(-25289961267664319.0) * 2 / FRAC_BITS,
	FLIT(-46216322584821328.0) * 2 / FRAC_BITS_2,
	FLIT(-45374903115423409.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-29549485021321955.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1260 / 2048) */
	FLIT(-25248692058042260.0) * 2 / FRAC_BITS,
	FLIT(-56919760581252129.0) * 2 / FRAC_BITS_2,
	FLIT(-56138365671226349.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-37789377174307747.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1261 / 2048) */
	FLIT(-25207455588772405.0) * 2 / FRAC_BITS,
	FLIT(-47734519290356413.0) * 2 / FRAC_BITS_2,
	FLIT(-59342833233815128.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-17066401652328292.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1262 / 2048) */
	FLIT(-25166251807947727.0) * 2 / FRAC_BITS,
	FLIT(-10556314243120131.0) * 2 / FRAC_BITS_2,
	FLIT(-4261525828726673.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-43303638237065227.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1263 / 2048) */
	FLIT(-25125080663784541.0) * 2 / FRAC_BITS,
	FLIT(-42239073480125379.0) * 2 / FRAC_BITS_2,
	FLIT(-46046746363458146.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-55788163316122422.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1264 / 2048) */
	FLIT(-25083942104622118.0) * 2 / FRAC_BITS,
	FLIT(-21635748081168419.0) * 2 / FRAC_BITS_2,
	FLIT(-32590484107451638.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-42124090814502729.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1265 / 2048) */
	FLIT(-25042836078922290.0) * 2 / FRAC_BITS,
	FLIT(-46415671108776062.0) * 2 / FRAC_BITS_2,
	FLIT(-24966122408851770.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-9138930205367579.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1266 / 2048) */
	FLIT(-25001762535269068.0) * 2 / FRAC_BITS,
	FLIT(-43863897548697328.0) * 2 / FRAC_BITS_2,
	FLIT(-34303350945326046.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-33666365992795590.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1267 / 2048) */
	FLIT(-24960721422368252.0) * 2 / FRAC_BITS,
	FLIT(-68347416969928448.0) * 2 / FRAC_BITS_2,
	FLIT(-64827795175165810.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-54293421042316575.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1268 / 2048) */
	FLIT(-24919712689047050.0) * 2 / FRAC_BITS,
	FLIT(-59947454292506988.0) * 2 / FRAC_BITS_2,
	FLIT(-24746658746629824.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-10018976168304159.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1269 / 2048) */
	FLIT(-24878736284253693.0) * 2 / FRAC_BITS,
	FLIT(-487774025007122.0) * 2 / FRAC_BITS_2,
	FLIT(-70602197910466844.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-477649000342845.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1270 / 2048) */
	FLIT(-24837792157057052.0) * 2 / FRAC_BITS,
	FLIT(-34097477307345590.0) * 2 / FRAC_BITS_2,
	FLIT(-124390004599232.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-40300345111976777.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1271 / 2048) */
	FLIT(-24796880256646264.0) * 2 / FRAC_BITS,
	FLIT(-47392029737849876.0) * 2 / FRAC_BITS_2,
	FLIT(-66797173299516725.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-42719350267204041.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1272 / 2048) */
	FLIT(-24756000532330349.0) * 2 / FRAC_BITS,
	FLIT(-5798933707471253.0) * 2 / FRAC_BITS_2,
	FLIT(-50702389561178808.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-59506953100653157.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1273 / 2048) */
	FLIT(-24715152933537832.0) * 2 / FRAC_BITS,
	FLIT(-36714256787025536.0) * 2 / FRAC_BITS_2,
	FLIT(-5025139654231788.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-29387953384624560.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1274 / 2048) */
	FLIT(-24674337409816373.0) * 2 / FRAC_BITS,
	FLIT(-42812551533713240.0) * 2 / FRAC_BITS_2,
	FLIT(-49303994381160118.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-39227076502292362.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1275 / 2048) */
	FLIT(-24633553910832388.0) * 2 / FRAC_BITS,
	FLIT(-69987354735879119.0) * 2 / FRAC_BITS_2,
	FLIT(-4083735107876855.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-7655733413831090.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1276 / 2048) */
	FLIT(-24592802386370680.0) * 2 / FRAC_BITS,
	FLIT(-60328823258247737.0) * 2 / FRAC_BITS_2,
	FLIT(-63350414796647752.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-9495170534831761.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1277 / 2048) */
	FLIT(-24552082786334065.0) * 2 / FRAC_BITS,
	FLIT(-70505998185213544.0) * 2 / FRAC_BITS_2,
	FLIT(-9972770158557713.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-329772220263286.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1278 / 2048) */
	FLIT(-24511395060743006.0) * 2 / FRAC_BITS,
	FLIT(-18311276002300456.0) * 2 / FRAC_BITS_2,
	FLIT(-48379910926276502.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-51718846622919480.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1279 / 2048) */
	FLIT(-24470739159735240.0) * 2 / FRAC_BITS,
	FLIT(-37740001701799953.0) * 2 / FRAC_BITS_2,
	FLIT(-39042822348788067.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-71695990891784778.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1280 / 2048) */
	FLIT(-24430115033565418.0) * 2 / FRAC_BITS,
	FLIT(-964993554146464.0) * 2 / FRAC_BITS_2,
	FLIT(-20660154858210192.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-42966040485996286.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1281 / 2048) */
	FLIT(-24389522632604733.0) * 2 / FRAC_BITS,
	FLIT(-8160210394277476.0) * 2 / FRAC_BITS_2,
	FLIT(-16646594303729904.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-6561052270164253.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1282 / 2048) */
	FLIT(-24348961907340561.0) * 2 / FRAC_BITS,
	FLIT(-43250723112525379.0) * 2 / FRAC_BITS_2,
	FLIT(-49970069867131647.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-24139570457513635.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1283 / 2048) */
	FLIT(-24308432808376098.0) * 2 / FRAC_BITS,
	FLIT(-20087737821964799.0) * 2 / FRAC_BITS_2,
	FLIT(-66521584450309054.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-57207416995740727.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1284 / 2048) */
	FLIT(-24267935286429996.0) * 2 / FRAC_BITS,
	FLIT(-2398157173721790.0) * 2 / FRAC_BITS_2,
	FLIT(-65418423052206883.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-62009204825711213.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1285 / 2048) */
	FLIT(-24227469292336006.0) * 2 / FRAC_BITS,
	FLIT(-20572799544118494.0) * 2 / FRAC_BITS_2,
	FLIT(-12375316221790743.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-66621687703559275.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1286 / 2048) */
	FLIT(-24187034777042620.0) * 2 / FRAC_BITS,
	FLIT(-61281487664478347.0) * 2 / FRAC_BITS_2,
	FLIT(-63268419866935316.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-53755532160641302.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1287 / 2048) */
	FLIT(-24146631691612715.0) * 2 / FRAC_BITS,
	FLIT(-13272254998755848.0) * 2 / FRAC_BITS_2,
	FLIT(-17522012055508853.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-7828170388786796.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1288 / 2048) */
	FLIT(-24106259987223193.0) * 2 / FRAC_BITS,
	FLIT(-1232819690957973.0) * 2 / FRAC_BITS_2,
	FLIT(-46874671915232585.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-24315925321921019.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1289 / 2048) */
	FLIT(-24065919615164632.0) * 2 / FRAC_BITS,
	FLIT(-26385540418785819.0) * 2 / FRAC_BITS_2,
	FLIT(-42145235506744689.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-22346826364436645.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1290 / 2048) */
	FLIT(-24025610526840932.0) * 2 / FRAC_BITS,
	FLIT(-66275007222861067.0) * 2 / FRAC_BITS_2,
	FLIT(-23962964073495198.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-14356617608515772.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1291 / 2048) */
	FLIT(-23985332673768964.0) * 2 / FRAC_BITS,
	FLIT(-56827671383891019.0) * 2 / FRAC_BITS_2,
	FLIT(-34976581037097494.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-26020446010187362.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1292 / 2048) */
	FLIT(-23945086007578218.0) * 2 / FRAC_BITS,
	FLIT(-44456539253627109.0) * 2 / FRAC_BITS_2,
	FLIT(-8070200101611474.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-30884725450580812.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1293 / 2048) */
	FLIT(-23904870480010457.0) * 2 / FRAC_BITS,
	FLIT(-3352897479910197.0) * 2 / FRAC_BITS_2,
	FLIT(-53020734691703643.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-48005295830300018.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1294 / 2048) */
	FLIT(-23864686042919367.0) * 2 / FRAC_BITS,
	FLIT(-38088597343133465.0) * 2 / FRAC_BITS_2,
	FLIT(-57212493989805126.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-67725384325550145.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1295 / 2048) */
	FLIT(-23824532648270216.0) * 2 / FRAC_BITS,
	FLIT(-34330209468498551.0) * 2 / FRAC_BITS_2,
	FLIT(-18170049219163515.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-45282307609816478.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1296 / 2048) */
	FLIT(-23784410248139504.0) * 2 / FRAC_BITS,
	FLIT(-54254206666404584.0) * 2 / FRAC_BITS_2,
	FLIT(-46264932851955899.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-21567466177355621.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1297 / 2048) */
	FLIT(-23744318794714624.0) * 2 / FRAC_BITS,
	FLIT(-35066175521927404.0) * 2 / FRAC_BITS_2,
	FLIT(-24301930303296239.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-52182624176699367.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1298 / 2048) */
	FLIT(-23704258240293517.0) * 2 / FRAC_BITS,
	FLIT(-15160438169302676.0) * 2 / FRAC_BITS_2,
	FLIT(-59712450067562812.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-8351864510331801.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1299 / 2048) */
	FLIT(-23664228537284333.0) * 2 / FRAC_BITS,
	FLIT(-22788625204043890.0) * 2 / FRAC_BITS_2,
	FLIT(-41402204069281525.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-7472234234264524.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1300 / 2048) */
	FLIT(-23624229638205092.0) * 2 / FRAC_BITS,
	FLIT(-59144805292127358.0) * 2 / FRAC_BITS_2,
	FLIT(-65932815323504089.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-12964762199161765.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1301 / 2048) */
	FLIT(-23584261495683347.0) * 2 / FRAC_BITS,
	FLIT(-31316382065500581.0) * 2 / FRAC_BITS_2,
	FLIT(-49764446295399640.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-49278528582695047.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1302 / 2048) */
	FLIT(-23544324062455843.0) * 2 / FRAC_BITS,
	FLIT(-67013064039888099.0) * 2 / FRAC_BITS_2,
	FLIT(-57079830851690743.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-63595482097911392.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1303 / 2048) */
	FLIT(-23504417291368188.0) * 2 / FRAC_BITS,
	FLIT(-57721472909917843.0) * 2 / FRAC_BITS_2,
	FLIT(-70218248249670723.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-8327410467838899.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1304 / 2048) */
	FLIT(-23464541135374514.0) * 2 / FRAC_BITS,
	FLIT(-15123843180839630.0) * 2 / FRAC_BITS_2,
	FLIT(-67951416569043404.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-5317926918079510.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1305 / 2048) */
	FLIT(-23424695547537145.0) * 2 / FRAC_BITS,
	FLIT(-15375398588021496.0) * 2 / FRAC_BITS_2,
	FLIT(-65308402020460758.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-65290782074494001.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1306 / 2048) */
	FLIT(-23384880481026268.0) * 2 / FRAC_BITS,
	FLIT(-19046751428953834.0) * 2 / FRAC_BITS_2,
	FLIT(-53772396753783489.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-56060641489428161.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1307 / 2048) */
	FLIT(-23345095889119600.0) * 2 / FRAC_BITS,
	FLIT(-70712724926375575.0) * 2 / FRAC_BITS_2,
	FLIT(-51431515569375967.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-50846611939771674.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1308 / 2048) */
	FLIT(-23305341725202063.0) * 2 / FRAC_BITS,
	FLIT(-13076969999995401.0) * 2 / FRAC_BITS_2,
	FLIT(-2140807248662389.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-30758774757661878.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1309 / 2048) */
	FLIT(-23265617942765449.0) * 2 / FRAC_BITS,
	FLIT(-12251813136607543.0) * 2 / FRAC_BITS_2,
	FLIT(-5377570625880837.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-60455138117482973.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1310 / 2048) */
	FLIT(-23225924495408101.0) * 2 / FRAC_BITS,
	FLIT(-20280864843939790.0) * 2 / FRAC_BITS_2,
	FLIT(-32837406123930180.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-49292850934452805.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1311 / 2048) */
	FLIT(-23186261336834584.0) * 2 / FRAC_BITS,
	FLIT(-47989024994225747.0) * 2 / FRAC_BITS_2,
	FLIT(-30910574626399396.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-16105939743851605.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1312 / 2048) */
	FLIT(-23146628420855363.0) * 2 / FRAC_BITS,
	FLIT(-22770181058466296.0) * 2 / FRAC_BITS_2,
	FLIT(-33629320047853163.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-58627330860675124.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1313 / 2048) */
	FLIT(-23107025701386477.0) * 2 / FRAC_BITS,
	FLIT(-23537718190399897.0) * 2 / FRAC_BITS_2,
	FLIT(-62714263117252999.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-65916829397286909.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1314 / 2048) */
	FLIT(-23067453132449221.0) * 2 / FRAC_BITS,
	FLIT(-27740473805149642.0) * 2 / FRAC_BITS_2,
	FLIT(-70684706120536415.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-64865604177515930.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1315 / 2048) */
	FLIT(-23027910668169824.0) * 2 / FRAC_BITS,
	FLIT(-34731189519614550.0) * 2 / FRAC_BITS_2,
	FLIT(-3408709653335711.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-31162552202809836.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1316 / 2048) */
	FLIT(-22988398262779130.0) * 2 / FRAC_BITS,
	FLIT(-60682376757034993.0) * 2 / FRAC_BITS_2,
	FLIT(-48249242658538126.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-58413645514369698.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1317 / 2048) */
	FLIT(-22948915870612282.0) * 2 / FRAC_BITS,
	FLIT(-4649807673752368.0) * 2 / FRAC_BITS_2,
	FLIT(-63286571737900908.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-57250368585447016.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1318 / 2048) */
	FLIT(-22909463446108400.0) * 2 / FRAC_BITS,
	FLIT(-33904313520985403.0) * 2 / FRAC_BITS_2,
	FLIT(-9323757333874415.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-5253744602488465.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1319 / 2048) */
	FLIT(-22870040943810273.0) * 2 / FRAC_BITS,
	FLIT(-46984456679920319.0) * 2 / FRAC_BITS_2,
	FLIT(-41727915967643513.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-50391659153245781.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1320 / 2048) */
	FLIT(-22830648318364040.0) * 2 / FRAC_BITS,
	FLIT(-15516472740394672.0) * 2 / FRAC_BITS_2,
	FLIT(-2003428093646366.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-64326467574829033.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1321 / 2048) */
	FLIT(-22791285524518876.0) * 2 / FRAC_BITS,
	FLIT(-51488609150716166.0) * 2 / FRAC_BITS_2,
	FLIT(-23861670764912638.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-36008732049775969.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1322 / 2048) */
	FLIT(-22751952517126685.0) * 2 / FRAC_BITS,
	FLIT(-55475376583117775.0) * 2 / FRAC_BITS_2,
	FLIT(-65101895745533547.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-48578028611304796.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1323 / 2048) */
	FLIT(-22712649251141785.0) * 2 / FRAC_BITS,
	FLIT(-26288388349682248.0) * 2 / FRAC_BITS_2,
	FLIT(-59390188413043339.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-2269205341765998.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1324 / 2048) */
	FLIT(-22673375681620599.0) * 2 / FRAC_BITS,
	FLIT(-22862284194080564.0) * 2 / FRAC_BITS_2,
	FLIT(-30077844405824658.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-40257573983970361.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1325 / 2048) */
	FLIT(-22634131763721348.0) * 2 / FRAC_BITS,
	FLIT(-66222963187090972.0) * 2 / FRAC_BITS_2,
	FLIT(-8398872026682283.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-13946377961932937.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1326 / 2048) */
	FLIT(-22594917452703745.0) * 2 / FRAC_BITS,
	FLIT(-53214591773492684.0) * 2 / FRAC_BITS_2,
	FLIT(-59433525036468109.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-64929115782791516.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1327 / 2048) */
	FLIT(-22555732703928685.0) * 2 / FRAC_BITS,
	FLIT(-41894240399904505.0) * 2 / FRAC_BITS_2,
	FLIT(-16582257952569568.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-65374647296278728.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1328 / 2048) */
	FLIT(-22516577472857943.0) * 2 / FRAC_BITS,
	FLIT(-43525902618214666.0) * 2 / FRAC_BITS_2,
	FLIT(-31213984717747931.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-12261106807587896.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1329 / 2048) */
	FLIT(-22477451715053870.0) * 2 / FRAC_BITS,
	FLIT(-41374706465210608.0) * 2 / FRAC_BITS_2,
	FLIT(-35509806811829641.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-39369971657121484.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1330 / 2048) */
	FLIT(-22438355386179090.0) * 2 / FRAC_BITS,
	FLIT(-19755380540691902.0) * 2 / FRAC_BITS_2,
	FLIT(-17821313130464443.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-15457794072337249.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1331 / 2048) */
	FLIT(-22399288441996198.0) * 2 / FRAC_BITS,
	FLIT(-2963782558941184.0) * 2 / FRAC_BITS_2,
	FLIT(-53446308143197470.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-29891283123999540.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1332 / 2048) */
	FLIT(-22360250838367460.0) * 2 / FRAC_BITS,
	FLIT(-31664655553651006.0) * 2 / FRAC_BITS_2,
	FLIT(-8296616399893065.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-29060396612864352.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1333 / 2048) */
	FLIT(-22321242531254516.0) * 2 / FRAC_BITS,
	FLIT(-4310716643569101.0) * 2 / FRAC_BITS_2,
	FLIT(-24904429253959592.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-40162722532119418.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1334 / 2048) */
	FLIT(-22282263476718077.0) * 2 / FRAC_BITS,
	FLIT(-31746051735655276.0) * 2 / FRAC_BITS_2,
	FLIT(-56044708264466994.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-51817330222107274.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1335 / 2048) */
	FLIT(-22243313630917634.0) * 2 / FRAC_BITS,
	FLIT(-7593667050307380.0) * 2 / FRAC_BITS_2,
	FLIT(-3323229094632982.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-54044899382311871.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1336 / 2048) */
	FLIT(-22204392950111156.0) * 2 / FRAC_BITS,
	FLIT(-51390308959537864.0) * 2 / FRAC_BITS_2,
	FLIT(-47813404598059110.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-36534882431343112.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1337 / 2048) */
	FLIT(-22165501390654802.0) * 2 / FRAC_BITS,
	FLIT(-22669043456490384.0) * 2 / FRAC_BITS_2,
	FLIT(-18070917853952188.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-64203117432958076.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1338 / 2048) */
	FLIT(-22126638909002620.0) * 2 / FRAC_BITS,
	FLIT(-51186858868489609.0) * 2 / FRAC_BITS_2,
	FLIT(-51226802659196922.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-45323407275353932.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1339 / 2048) */
	FLIT(-22087805461706261.0) * 2 / FRAC_BITS,
	FLIT(-65328754410993083.0) * 2 / FRAC_BITS_2,
	FLIT(-66874463655424041.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-20342717063628886.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1340 / 2048) */
	FLIT(-22049001005414684.0) * 2 / FRAC_BITS,
	FLIT(-47716527048529935.0) * 2 / FRAC_BITS_2,
	FLIT(-40869880627225937.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-47873046864949566.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1341 / 2048) */
	FLIT(-22010225496873866.0) * 2 / FRAC_BITS,
	FLIT(-8863744484190597.0) * 2 / FRAC_BITS_2,
	FLIT(-4169459359256248.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-37007963088067096.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1342 / 2048) */
	FLIT(-21971478892926512.0) * 2 / FRAC_BITS,
	FLIT(-38814516591347954.0) * 2 / FRAC_BITS_2,
	FLIT(-34569250764077857.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-33098142670685539.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1343 / 2048) */
	FLIT(-21932761150511771.0) * 2 / FRAC_BITS,
	FLIT(-4071970004225527.0) * 2 / FRAC_BITS_2,
	FLIT(-55845270323847069.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-48527869259412260.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1344 / 2048) */
	FLIT(-21894072226664942.0) * 2 / FRAC_BITS,
	FLIT(-42391215360504519.0) * 2 / FRAC_BITS_2,
	FLIT(-23911977600027182.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-7445868653454538.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1345 / 2048) */
	FLIT(-21855412078517195.0) * 2 / FRAC_BITS,
	FLIT(-53652046271113587.0) * 2 / FRAC_BITS_2,
	FLIT(-19051720131026530.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-29761564711102511.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1346 / 2048) */
	FLIT(-21816780663295281.0) * 2 / FRAC_BITS,
	FLIT(-59965699430778456.0) * 2 / FRAC_BITS_2,
	FLIT(-15640934594394524.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-10251578192069294.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1347 / 2048) */
	FLIT(-21778177938321250.0) * 2 / FRAC_BITS,
	FLIT(-65580057319109619.0) * 2 / FRAC_BITS_2,
	FLIT(-52924659909390440.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-70732679412410587.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1348 / 2048) */
	FLIT(-21739603861012168.0) * 2 / FRAC_BITS,
	FLIT(-64762081157002829.0) * 2 / FRAC_BITS_2,
	FLIT(-24827878615344383.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-18013382612510157.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1349 / 2048) */
	FLIT(-21701058388879835.0) * 2 / FRAC_BITS,
	FLIT(-53204489999668165.0) * 2 / FRAC_BITS_2,
	FLIT(-10062858385514596.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-29387263520948983.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1350 / 2048) */
	FLIT(-21662541479530504.0) * 2 / FRAC_BITS,
	FLIT(-42620642108096367.0) * 2 / FRAC_BITS_2,
	FLIT(-3961415317459373.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-48064485076563338.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1351 / 2048) */
	FLIT(-21624053090664602.0) * 2 / FRAC_BITS,
	FLIT(-6135722508003782.0) * 2 / FRAC_BITS_2,
	FLIT(-71287257196447517.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-52657780429095317.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1352 / 2048) */
	FLIT(-21585593180076449.0) * 2 / FRAC_BITS,
	FLIT(-42372042329740924.0) * 2 / FRAC_BITS_2,
	FLIT(-49225011214167407.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-70238144568122191.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1353 / 2048) */
	FLIT(-21547161705653985.0) * 2 / FRAC_BITS,
	FLIT(-37321660244714504.0) * 2 / FRAC_BITS_2,
	FLIT(-14972593283289338.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-7930163911579934.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1354 / 2048) */
	FLIT(-21508758625378488.0) * 2 / FRAC_BITS,
	FLIT(-48656286417336903.0) * 2 / FRAC_BITS_2,
	FLIT(-56368891611098019.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-3713671302371583.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1355 / 2048) */
	FLIT(-21470383897324302.0) * 2 / FRAC_BITS,
	FLIT(-43052744999473974.0) * 2 / FRAC_BITS_2,
	FLIT(-11284190612337674.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-40400918308512568.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1356 / 2048) */
	FLIT(-21432037479658560.0) * 2 / FRAC_BITS,
	FLIT(-67072159418327656.0) * 2 / FRAC_BITS_2,
	FLIT(-58769788795237229.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-11135044157044414.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1357 / 2048) */
	FLIT(-21393719330640913.0) * 2 / FRAC_BITS,
	FLIT(-58635260684638151.0) * 2 / FRAC_BITS_2,
	FLIT(-52406743535382054.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-50674024197607314.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1358 / 2048) */
	FLIT(-21355429408623255.0) * 2 / FRAC_BITS,
	FLIT(-19347364800425356.0) * 2 / FRAC_BITS_2,
	FLIT(-47076072013769631.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-38044527005828782.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1359 / 2048) */
	FLIT(-21317167672049451.0) * 2 / FRAC_BITS,
	FLIT(-42949127915964848.0) * 2 / FRAC_BITS_2,
	FLIT(-58050229841960413.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-16500789712738466.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1360 / 2048) */
	FLIT(-21278934079455070.0) * 2 / FRAC_BITS,
	FLIT(-55458809515131508.0) * 2 / FRAC_BITS_2,
	FLIT(-43914941074605623.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-49369818930905817.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1361 / 2048) */
	FLIT(-21240728589467112.0) * 2 / FRAC_BITS,
	FLIT(-59322138130319642.0) * 2 / FRAC_BITS_2,
	FLIT(-29718316619237377.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-58606613563741638.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1362 / 2048) */
	FLIT(-21202551160803741.0) * 2 / FRAC_BITS,
	FLIT(-16562843298224742.0) * 2 / FRAC_BITS_2,
	FLIT(-64131876992639598.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-60350895961607451.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1363 / 2048) */
	FLIT(-21164401752274015.0) * 2 / FRAC_BITS,
	FLIT(-19138014763804360.0) * 2 / FRAC_BITS_2,
	FLIT(-57419279007772536.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-13857456376628016.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1364 / 2048) */
	FLIT(-21126280322777623.0) * 2 / FRAC_BITS,
	FLIT(-25609776199030642.0) * 2 / FRAC_BITS_2,
	FLIT(-2944893274110761.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-18074978460504743.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1365 / 2048) */
	FLIT(-21088186831304617.0) * 2 / FRAC_BITS,
	FLIT(-28513433060557477.0) * 2 / FRAC_BITS_2,
	FLIT(-69184638065321078.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-49502184404547953.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1366 / 2048) */
	FLIT(-21050121236935148.0) * 2 / FRAC_BITS,
	FLIT(-3594373542534222.0) * 2 / FRAC_BITS_2,
	FLIT(-24098120766533841.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-61444021004211047.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1367 / 2048) */
	FLIT(-21012083498839201.0) * 2 / FRAC_BITS,
	FLIT(-893902907758347.0) * 2 / FRAC_BITS_2,
	FLIT(-56497003490578023.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-58582805208855062.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1368 / 2048) */
	FLIT(-20974073576276334.0) * 2 / FRAC_BITS,
	FLIT(-17089826625844357.0) * 2 / FRAC_BITS_2,
	FLIT(-7947880311193992.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-71293477113313060.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1369 / 2048) */
	FLIT(-20936091428595416.0) * 2 / FRAC_BITS,
	FLIT(-9075104440897427.0) * 2 / FRAC_BITS_2,
	FLIT(-42385893985758167.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-36553327048373083.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1370 / 2048) */
	FLIT(-20898137015234364.0) * 2 / FRAC_BITS,
	FLIT(-48471484466367182.0) * 2 / FRAC_BITS_2,
	FLIT(-33730845452586113.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-7860370017272875.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1371 / 2048) */
	FLIT(-20860210295719887.0) * 2 / FRAC_BITS,
	FLIT(-40315822176540536.0) * 2 / FRAC_BITS_2,
	FLIT(-8223285296435779.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-10733464235854343.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1372 / 2048) */
	FLIT(-20822311229667223.0) * 2 / FRAC_BITS,
	FLIT(-14425397043782183.0) * 2 / FRAC_BITS_2,
	FLIT(-37037233161114621.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-60205201855792851.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1373 / 2048) */
	FLIT(-20784439776779882.0) * 2 / FRAC_BITS,
	FLIT(-52395030621053014.0) * 2 / FRAC_BITS_2,
	FLIT(-58540967416713167.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-11068170188508777.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1374 / 2048) */
	FLIT(-20746595896849392.0) * 2 / FRAC_BITS,
	FLIT(-66101835638582490.0) * 2 / FRAC_BITS_2,
	FLIT(-23770020433418411.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-5884077162625771.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1375 / 2048) */
	FLIT(-20708779549755040.0) * 2 / FRAC_BITS,
	FLIT(-3882908182086454.0) * 2 / FRAC_BITS_2,
	FLIT(-31757504597077777.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-18765892436108814.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1376 / 2048) */
	FLIT(-20670990695463614.0) * 2 / FRAC_BITS,
	FLIT(-51746462002113456.0) * 2 / FRAC_BITS_2,
	FLIT(-63794170040223966.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-56070703125590500.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1377 / 2048) */
	FLIT(-20633229294029157.0) * 2 / FRAC_BITS,
	FLIT(-36690428589461692.0) * 2 / FRAC_BITS_2,
	FLIT(-69519719068351330.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-27971244622265152.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1378 / 2048) */
	FLIT(-20595495305592705.0) * 2 / FRAC_BITS,
	FLIT(-49450200224704537.0) * 2 / FRAC_BITS_2,
	FLIT(-63748661955273537.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-71219760330893363.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1379 / 2048) */
	FLIT(-20557788690382040.0) * 2 / FRAC_BITS,
	FLIT(-52600622441605873.0) * 2 / FRAC_BITS_2,
	FLIT(-62610966223611151.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-59944725701350194.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1380 / 2048) */
	FLIT(-20520109408711436.0) * 2 / FRAC_BITS,
	FLIT(-58991295255730146.0) * 2 / FRAC_BITS_2,
	FLIT(-66755315599393545.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-34591033224176611.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1381 / 2048) */
	FLIT(-20482457420981410.0) * 2 / FRAC_BITS,
	FLIT(-15537505609056093.0) * 2 / FRAC_BITS_2,
	FLIT(-15829351191648371.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-11711365102279515.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1382 / 2048) */
	FLIT(-20444832687678469.0) * 2 / FRAC_BITS,
	FLIT(-40600040210108932.0) * 2 / FRAC_BITS_2,
	FLIT(-42115338148096651.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-1041205635143434.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1383 / 2048) */
	FLIT(-20407235169374867.0) * 2 / FRAC_BITS,
	FLIT(-5863908607221433.0) * 2 / FRAC_BITS_2,
	FLIT(-43569914860610665.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-34962401448880783.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1384 / 2048) */
	FLIT(-20369664826728350.0) * 2 / FRAC_BITS,
	FLIT(-47700826881252647.0) * 2 / FRAC_BITS_2,
	FLIT(-49173311697528015.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-37118374465483942.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1385 / 2048) */
	FLIT(-20332121620481916.0) * 2 / FRAC_BITS,
	FLIT(-62179631376072365.0) * 2 / FRAC_BITS_2,
	FLIT(-37134801102418093.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-52461925692469056.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1386 / 2048) */
	FLIT(-20294605511463564.0) * 2 / FRAC_BITS,
	FLIT(-56942694546752727.0) * 2 / FRAC_BITS_2,
	FLIT(-5255250835463356.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-28806295742287285.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1387 / 2048) */
	FLIT(-20257116460586050.0) * 2 / FRAC_BITS,
	FLIT(-62633687802517351.0) * 2 / FRAC_BITS_2,
	FLIT(-32367653579774509.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-42534021075545433.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1388 / 2048) */
	FLIT(-20219654428846644.0) * 2 / FRAC_BITS,
	FLIT(-35945695465287539.0) * 2 / FRAC_BITS_2,
	FLIT(-5649759058093215.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-23216310495256213.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1389 / 2048) */
	FLIT(-20182219377326884.0) * 2 / FRAC_BITS,
	FLIT(-42244890142621411.0) * 2 / FRAC_BITS_2,
	FLIT(-63668130488211550.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-36554200824452191.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1390 / 2048) */
	FLIT(-20144811267192336.0) * 2 / FRAC_BITS,
	FLIT(-68977643547217831.0) * 2 / FRAC_BITS_2,
	FLIT(-19968381156216843.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-63640917322242553.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1391 / 2048) */
	FLIT(-20107430059692352.0) * 2 / FRAC_BITS,
	FLIT(-46049423690955075.0) * 2 / FRAC_BITS_2,
	FLIT(-6407101408373677.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-1664418018023483.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1392 / 2048) */
	FLIT(-20070075716159827.0) * 2 / FRAC_BITS,
	FLIT(-846853367273886.0) * 2 / FRAC_BITS_2,
	FLIT(-33082013949261591.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-34947273553640793.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1393 / 2048) */
	FLIT(-20032748198010959.0) * 2 / FRAC_BITS,
	FLIT(-59402885176502882.0) * 2 / FRAC_BITS_2,
	FLIT(-39116950401999805.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-16281563148813265.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1394 / 2048) */
	FLIT(-19995447466745016.0) * 2 / FRAC_BITS,
	FLIT(-5206402981523404.0) * 2 / FRAC_BITS_2,
	FLIT(-56884106264248594.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-65031109305584655.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1395 / 2048) */
	FLIT(-19958173483944087.0) * 2 / FRAC_BITS,
	FLIT(-52713945566732337.0) * 2 / FRAC_BITS_2,
	FLIT(-4902880497923768.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-1812995962239047.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1396 / 2048) */
	FLIT(-19920926211272856.0) * 2 / FRAC_BITS,
	FLIT(-25051757062064061.0) * 2 / FRAC_BITS_2,
	FLIT(-59535818408434289.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-4903796400673497.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1397 / 2048) */
	FLIT(-19883705610478356.0) * 2 / FRAC_BITS,
	FLIT(-34120411272846187.0) * 2 / FRAC_BITS_2,
	FLIT(-21298869206764175.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-31317263679956315.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1398 / 2048) */
	FLIT(-19846511643389739.0) * 2 / FRAC_BITS,
	FLIT(-68765651906871943.0) * 2 / FRAC_BITS_2,
	FLIT(-46704180120639908.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-15417349634699240.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1399 / 2048) */
	FLIT(-19809344271918041.0) * 2 / FRAC_BITS,
	FLIT(-3963267125923400.0) * 2 / FRAC_BITS_2,
	FLIT(-29228128099869470.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-1017452087246205.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1400 / 2048) */
	FLIT(-19772203458055942.0) * 2 / FRAC_BITS,
	FLIT(-30757650802196301.0) * 2 / FRAC_BITS_2,
	FLIT(-53666054103458592.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-33942887552662255.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1401 / 2048) */
	FLIT(-19735089163877541.0) * 2 / FRAC_BITS,
	FLIT(-65543123375319260.0) * 2 / FRAC_BITS_2,
	FLIT(-65636120657448837.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-3275425026867359.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1402 / 2048) */
	FLIT(-19698001351538120.0) * 2 / FRAC_BITS,
	FLIT(-11927704796251097.0) * 2 / FRAC_BITS_2,
	FLIT(-13834522027109239.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-48622389381699724.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1403 / 2048) */
	FLIT(-19660939983273909.0) * 2 / FRAC_BITS,
	FLIT(-10231745068755493.0) * 2 / FRAC_BITS_2,
	FLIT(-27263544231897100.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-3362708320033117.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1404 / 2048) */
	FLIT(-19623905021401861.0) * 2 / FRAC_BITS,
	FLIT(-25847879145709932.0) * 2 / FRAC_BITS_2,
	FLIT(-59311205246050628.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-33280273407595828.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1405 / 2048) */
	FLIT(-19586896428319420.0) * 2 / FRAC_BITS,
	FLIT(-1187489770492269.0) * 2 / FRAC_BITS_2,
	FLIT(-31961769727210469.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-41353540948922860.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1406 / 2048) */
	FLIT(-19549914166504289.0) * 2 / FRAC_BITS,
	FLIT(-66557869551018714.0) * 2 / FRAC_BITS_2,
	FLIT(-42037157897059095.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-6728813510893855.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1407 / 2048) */
	FLIT(-19512958198514209.0) * 2 / FRAC_BITS,
	FLIT(-17085154816960054.0) * 2 / FRAC_BITS_2,
	FLIT(-44121703369042927.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-12352875032407818.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1408 / 2048) */
	FLIT(-19476028486986722.0) * 2 / FRAC_BITS,
	FLIT(-987927519647061.0) * 2 / FRAC_BITS_2,
	FLIT(-41834634060375135.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-33982959053975825.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1409 / 2048) */
	FLIT(-19439124994638951.0) * 2 / FRAC_BITS,
	FLIT(-41051982324947667.0) * 2 / FRAC_BITS_2,
	FLIT(-48498831376827324.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-30432779281181381.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1410 / 2048) */
	FLIT(-19402247684267374.0) * 2 / FRAC_BITS,
	FLIT(-46383258283879230.0) * 2 / FRAC_BITS_2,
	FLIT(-68129886342699086.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-68688753416625289.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1411 / 2048) */
	FLIT(-19365396518747596.0) * 2 / FRAC_BITS,
	FLIT(-25962124541271774.0) * 2 / FRAC_BITS_2,
	FLIT(-54468770934143362.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-18664885252497427.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1412 / 2048) */
	FLIT(-19328571461034125.0) * 2 / FRAC_BITS,
	FLIT(-71408243600342473.0) * 2 / FRAC_BITS_2,
	FLIT(-9879259337032415.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-27716947019711016.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1413 / 2048) */
	FLIT(-19291772474160153.0) * 2 / FRAC_BITS,
	FLIT(-36654421062261498.0) * 2 / FRAC_BITS_2,
	FLIT(-43136737452008351.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-27425321176073119.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1414 / 2048) */
	FLIT(-19254999521237326.0) * 2 / FRAC_BITS,
	FLIT(-67208157738396776.0) * 2 / FRAC_BITS_2,
	FLIT(-50447501897207503.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-14837360712859463.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1415 / 2048) */
	FLIT(-19218252565455530.0) * 2 / FRAC_BITS,
	FLIT(-33204277901869684.0) * 2 / FRAC_BITS_2,
	FLIT(-6368302104397211.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-64828978328070539.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1416 / 2048) */
	FLIT(-19181531570082663.0) * 2 / FRAC_BITS,
	FLIT(-27736062316256761.0) * 2 / FRAC_BITS_2,
	FLIT(-29444049220176651.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-33803967529140833.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1417 / 2048) */
	FLIT(-19144836498464419.0) * 2 / FRAC_BITS,
	FLIT(-56728236517228685.0) * 2 / FRAC_BITS_2,
	FLIT(-15187079642757118.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-42471581987902084.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1418 / 2048) */
	FLIT(-19108167314024069.0) * 2 / FRAC_BITS,
	FLIT(-977701635334203.0) * 2 / FRAC_BITS_2,
	FLIT(-38324962637133803.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-69406519633060059.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1419 / 2048) */
	FLIT(-19071523980262236.0) * 2 / FRAC_BITS,
	FLIT(-66297941188361664.0) * 2 / FRAC_BITS_2,
	FLIT(-45137443275660141.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-5373536176495311.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1420 / 2048) */
	FLIT(-19034906460756687.0) * 2 / FRAC_BITS,
	FLIT(-64206760261172564.0) * 2 / FRAC_BITS_2,
	FLIT(-45907599358508745.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-47872357001273988.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1421 / 2048) */
	FLIT(-18998314719162107.0) * 2 / FRAC_BITS,
	FLIT(-44938629088479486.0) * 2 / FRAC_BITS_2,
	FLIT(-46207269510349031.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-15649012718051170.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1422 / 2048) */
	FLIT(-18961748719209886.0) * 2 / FRAC_BITS,
	FLIT(-48762851414370711.0) * 2 / FRAC_BITS_2,
	FLIT(-55722950533429588.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-16879026884216572.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1423 / 2048) */
	FLIT(-18925208424707904.0) * 2 / FRAC_BITS,
	FLIT(-56239252113812278.0) * 2 / FRAC_BITS_2,
	FLIT(-29727112683425344.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-59780982329745758.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1424 / 2048) */
	FLIT(-18888693799540315.0) * 2 / FRAC_BITS,
	FLIT(-65122715867487705.0) * 2 / FRAC_BITS_2,
	FLIT(-43154435061361751.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-23701390861458663.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1425 / 2048) */
	FLIT(-18852204807667334.0) * 2 / FRAC_BITS,
	FLIT(-5456262067536139.0) * 2 / FRAC_BITS_2,
	FLIT(-37701956814625403.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-25732901974592840.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1426 / 2048) */
	FLIT(-18815741413125019.0) * 2 / FRAC_BITS,
	FLIT(-69084598714366116.0) * 2 / FRAC_BITS_2,
	FLIT(-67696780779857939.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-60397138147780256.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1427 / 2048) */
	FLIT(-18779303580025068.0) * 2 / FRAC_BITS,
	FLIT(-12208587797923070.0) * 2 / FRAC_BITS_2,
	FLIT(-25831987185360510.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-21193545950263434.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1428 / 2048) */
	FLIT(-18742891272554595.0) * 2 / FRAC_BITS,
	FLIT(-24827437283561627.0) * 2 / FRAC_BITS_2,
	FLIT(-47166763816422613.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-13849647098364069.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1429 / 2048) */
	FLIT(-18706504454975928.0) * 2 / FRAC_BITS,
	FLIT(-68366616076444657.0) * 2 / FRAC_BITS_2,
	FLIT(-60185690684248377.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-7627555125347883.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1430 / 2048) */
	FLIT(-18670143091626396.0) * 2 / FRAC_BITS,
	FLIT(-59167739257627956.0) * 2 / FRAC_BITS_2,
	FLIT(-15049700487741096.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-3981680767141304.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1431 / 2048) */
	FLIT(-18633807146918117.0) * 2 / FRAC_BITS,
	FLIT(-32926037040673546.0) * 2 / FRAC_BITS_2,
	FLIT(-1777261949228822.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-34261889170366999.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1432 / 2048) */
	FLIT(-18597496585337791.0) * 2 / FRAC_BITS,
	FLIT(-1622864928045019.0) * 2 / FRAC_BITS_2,
	FLIT(-34906305456332947.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-52314883847724360.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1433 / 2048) */
	FLIT(-18561211371446491.0) * 2 / FRAC_BITS,
	FLIT(-7135332593825721.0) * 2 / FRAC_BITS_2,
	FLIT(-4072097599821944.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-17611189690115594.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1434 / 2048) */
	FLIT(-18524951469879457.0) * 2 / FRAC_BITS,
	FLIT(-11015080135617022.0) * 2 / FRAC_BITS_2,
	FLIT(-34485421868205856.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-50063746048728413.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1435 / 2048) */
	FLIT(-18488716845345887.0) * 2 / FRAC_BITS,
	FLIT(-52562838306516133.0) * 2 / FRAC_BITS_2,
	FLIT(-66635219293101563.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-49604177927341092.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1436 / 2048) */
	FLIT(-18452507462628734.0) * 2 / FRAC_BITS,
	FLIT(-26462566337118804.0) * 2 / FRAC_BITS_2,
	FLIT(-37134103958817631.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-38599379181634873.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1437 / 2048) */
	FLIT(-18416323286584496.0) * 2 / FRAC_BITS,
	FLIT(-16507091414485915.0) * 2 / FRAC_BITS_2,
	FLIT(-6332780072371774.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-8366393230024296.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1438 / 2048) */
	FLIT(-18380164282143015.0) * 2 / FRAC_BITS,
	FLIT(-32278002499519289.0) * 2 / FRAC_BITS_2,
	FLIT(-40671403541128324.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-26137488006659065.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1439 / 2048) */
	FLIT(-18344030414307273.0) * 2 / FRAC_BITS,
	FLIT(-13256234069392672.0) * 2 / FRAC_BITS_2,
	FLIT(-12517218288485902.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-47264226289784870.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1440 / 2048) */
	FLIT(-18307921648153186.0) * 2 / FRAC_BITS,
	FLIT(-28092096887348756.0) * 2 / FRAC_BITS_2,
	FLIT(-43792621284188142.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-17720976555710129.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1441 / 2048) */
	FLIT(-18271837948829405.0) * 2 / FRAC_BITS,
	FLIT(-20303798809440387.0) * 2 / FRAC_BITS_2,
	FLIT(-54011885326095123.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-40309769502432344.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1442 / 2048) */
	FLIT(-18235779281557111.0) * 2 / FRAC_BITS,
	FLIT(-36941599921062026.0) * 2 / FRAC_BITS_2,
	FLIT(-54607702435378544.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-41320842417129376.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1443 / 2048) */
	FLIT(-18199745611629817.0) * 2 / FRAC_BITS,
	FLIT(-3258328032956354.0) * 2 / FRAC_BITS_2,
	FLIT(-21342888793987794.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-40773203843104559.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1444 / 2048) */
	FLIT(-18163736904413163.0) * 2 / FRAC_BITS,
	FLIT(-51983040623212065.0) * 2 / FRAC_BITS_2,
	FLIT(-41688421808360022.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-48961894011342562.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1445 / 2048) */
	FLIT(-18127753125344723.0) * 2 / FRAC_BITS,
	FLIT(-37895031438188616.0) * 2 / FRAC_BITS_2,
	FLIT(-67169727291001054.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-55773597375815348.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1446 / 2048) */
	FLIT(-18091794239933799.0) * 2 / FRAC_BITS,
	FLIT(-38930527392646784.0) * 2 / FRAC_BITS_2,
	FLIT(-71545363847139920.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-1808663714440150.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1447 / 2048) */
	FLIT(-18055860213761227.0) * 2 / FRAC_BITS,
	FLIT(-42175723686917577.0) * 2 / FRAC_BITS_2,
	FLIT(-55398395314985266.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-44091107057458607.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1448 / 2048) */
	FLIT(-18019951012479178.0) * 2 / FRAC_BITS,
	FLIT(-39519753276025075.0) * 2 / FRAC_BITS_2,
	FLIT(-52482050788127603.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-34225020423718957.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1449 / 2048) */
	FLIT(-17984066601810961.0) * 2 / FRAC_BITS,
	FLIT(-28359923024160265.0) * 2 / FRAC_BITS_2,
	FLIT(-70007138341210534.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-71128455429562798.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1450 / 2048) */
	FLIT(-17948206947550826.0) * 2 / FRAC_BITS,
	FLIT(-61270882846893604.0) * 2 / FRAC_BITS_2,
	FLIT(-62836090452693001.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-61444292452848509.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1451 / 2048) */
	FLIT(-17912372015563771.0) * 2 / FRAC_BITS,
	FLIT(-56204812096481962.0) * 2 / FRAC_BITS_2,
	FLIT(-9474602132582655.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-28846991909333139.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1452 / 2048) */
	FLIT(-17876561771785344.0) * 2 / FRAC_BITS,
	FLIT(-15539406705895269.0) * 2 / FRAC_BITS_2,
	FLIT(-23177907295811309.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-55343386142808572.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1453 / 2048) */
	FLIT(-17840776182221449.0) * 2 / FRAC_BITS,
	FLIT(-5254729311904974.0) * 2 / FRAC_BITS_2,
	FLIT(-521257839793156.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-35514513149959502.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1454 / 2048) */
	FLIT(-17805015212948154.0) * 2 / FRAC_BITS,
	FLIT(-38154485035727833.0) * 2 / FRAC_BITS_2,
	FLIT(-34278596741131037.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-23982506370397176.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1455 / 2048) */
	FLIT(-17769278830111499.0) * 2 / FRAC_BITS,
	FLIT(-5048246327269593.0) * 2 / FRAC_BITS_2,
	FLIT(-66956715697930591.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-48319634908084373.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1456 / 2048) */
	FLIT(-17733566999927299.0) * 2 / FRAC_BITS,
	FLIT(-13984887839809867.0) * 2 / FRAC_BITS_2,
	FLIT(-36958249994121911.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-19158675883694744.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1457 / 2048) */
	FLIT(-17697879688680957.0) * 2 / FRAC_BITS,
	FLIT(-56476561742515200.0) * 2 / FRAC_BITS_2,
	FLIT(-69071351523163481.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-22437264302300998.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1458 / 2048) */
	FLIT(-17662216862727273.0) * 2 / FRAC_BITS,
	FLIT(-9323715961678940.0) * 2 / FRAC_BITS_2,
	FLIT(-69397399277933848.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-68379996284997400.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1459 / 2048) */
	FLIT(-17626578488490248.0) * 2 / FRAC_BITS,
	FLIT(-43903875148805305.0) * 2 / FRAC_BITS_2,
	FLIT(-4525346533365647.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-53425339939579068.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1460 / 2048) */
	FLIT(-17590964532462903.0) * 2 / FRAC_BITS,
	FLIT(-1578364026093814.0) * 2 / FRAC_BITS_2,
	FLIT(-68212394552768658.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-61019114555870439.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1461 / 2048) */
	FLIT(-17555374961207081.0) * 2 / FRAC_BITS,
	FLIT(-40866972261445836.0) * 2 / FRAC_BITS_2,
	FLIT(-57869171094231273.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-57718875163124607.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1462 / 2048) */
	FLIT(-17519809741353267.0) * 2 / FRAC_BITS,
	FLIT(-34182683925170565.0) * 2 / FRAC_BITS_2,
	FLIT(-14991362218691461.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-62474481570500031.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1463 / 2048) */
	FLIT(-17484268839600394.0) * 2 / FRAC_BITS,
	FLIT(-19778314506192499.0) * 2 / FRAC_BITS_2,
	FLIT(-38995792332629386.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-6474712640316787.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1464 / 2048) */
	FLIT(-17448752222715658.0) * 2 / FRAC_BITS,
	FLIT(-51390140738302039.0) * 2 / FRAC_BITS_2,
	FLIT(-4300849916691696.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-58550245689494571.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1465 / 2048) */
	FLIT(-17413259857534334.0) * 2 / FRAC_BITS,
	FLIT(-21849933026740971.0) * 2 / FRAC_BITS_2,
	FLIT(-30039060846314854.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-27810912224354740.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1466 / 2048) */
	FLIT(-17377791710959585.0) * 2 / FRAC_BITS,
	FLIT(-36937704665281109.0) * 2 / FRAC_BITS_2,
	FLIT(-3252902432071054.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-39949929394123197.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1467 / 2048) */
	FLIT(-17342347749962282.0) * 2 / FRAC_BITS,
	FLIT(-42250946514041923.0) * 2 / FRAC_BITS_2,
	FLIT(-19026288957093417.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-52130457025721289.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1468 / 2048) */
	FLIT(-17306927941580816.0) * 2 / FRAC_BITS,
	FLIT(-71997989774445547.0) * 2 / FRAC_BITS_2,
	FLIT(-21725553338356085.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-45082859601648078.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1469 / 2048) */
	FLIT(-17271532252920917.0) * 2 / FRAC_BITS,
	FLIT(-38665831897633004.0) * 2 / FRAC_BITS_2,
	FLIT(-71816061189331958.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-22847851387284620.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1470 / 2048) */
	FLIT(-17236160651155467.0) * 2 / FRAC_BITS,
	FLIT(-126278570626420.0) * 2 / FRAC_BITS_2,
	FLIT(-56917876845275581.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-70480309758048442.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1471 / 2048) */
	FLIT(-17200813103524319.0) * 2 / FRAC_BITS,
	FLIT(-39305283808449628.0) * 2 / FRAC_BITS_2,
	FLIT(-7550131856356305.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-2481555051053354.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1472 / 2048) */
	FLIT(-17165489577334118.0) * 2 / FRAC_BITS,
	FLIT(-44462750034982536.0) * 2 / FRAC_BITS_2,
	FLIT(-34528927528194378.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-4247524703323402.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1473 / 2048) */
	FLIT(-17130190039958115.0) * 2 / FRAC_BITS,
	FLIT(-38418890717512756.0) * 2 / FRAC_BITS_2,
	FLIT(-37076709738478438.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-49430106567372918.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1474 / 2048) */
	FLIT(-17094914458835988.0) * 2 / FRAC_BITS,
	FLIT(-47739461014030532.0) * 2 / FRAC_BITS_2,
	FLIT(-62044359829390880.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-38889965432929105.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1475 / 2048) */
	FLIT(-17059662801473663.0) * 2 / FRAC_BITS,
	FLIT(-16102497757948543.0) * 2 / FRAC_BITS_2,
	FLIT(-59198125723608061.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-60300986428348549.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1476 / 2048) */
	FLIT(-17024435035443131.0) * 2 / FRAC_BITS,
	FLIT(-49897284391668588.0) * 2 / FRAC_BITS_2,
	FLIT(-56761786473831113.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-33382266930388966.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1477 / 2048) */
	FLIT(-16989231128382274.0) * 2 / FRAC_BITS,
	FLIT(-59128009575999555.0) * 2 / FRAC_BITS_2,
	FLIT(-35082862119375278.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-66357298576536286.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1478 / 2048) */
	FLIT(-16954051047994683.0) * 2 / FRAC_BITS,
	FLIT(-18423256488724421.0) * 2 / FRAC_BITS_2,
	FLIT(-22719722052216234.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-36531464075830649.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1479 / 2048) */
	FLIT(-16918894762049479.0) * 2 / FRAC_BITS,
	FLIT(-55340669328258930.0) * 2 / FRAC_BITS_2,
	FLIT(-56336800165657022.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-41351051998550324.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1480 / 2048) */
	FLIT(-16883762238381142.0) * 2 / FRAC_BITS,
	FLIT(-5502545774595178.0) * 2 / FRAC_BITS_2,
	FLIT(-5824304832125308.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-25213906991218860.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1481 / 2048) */
	FLIT(-16848653444889326.0) * 2 / FRAC_BITS,
	FLIT(-19653976664212161.0) * 2 / FRAC_BITS_2,
	FLIT(-42299397825473738.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-647302030520433.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1482 / 2048) */
	FLIT(-16813568349538690.0) * 2 / FRAC_BITS,
	FLIT(-60741093143077641.0) * 2 / FRAC_BITS_2,
	FLIT(-20994152705288722.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-10948690305625330.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1483 / 2048) */
	FLIT(-16778506920358721.0) * 2 / FRAC_BITS,
	FLIT(-20217884116252699.0) * 2 / FRAC_BITS_2,
	FLIT(-58656963717777768.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-37075705466347959.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1484 / 2048) */
	FLIT(-16743469125443555.0) * 2 / FRAC_BITS,
	FLIT(-21063045734773480.0) * 2 / FRAC_BITS_2,
	FLIT(-51481900735228041.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-20140291646465916.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1485 / 2048) */
	FLIT(-16708454932951808.0) * 2 / FRAC_BITS,
	FLIT(-42643576073596964.0) * 2 / FRAC_BITS_2,
	FLIT(-25135894519624316.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-39081403644542876.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1486 / 2048) */
	FLIT(-16673464311106401.0) * 2 / FRAC_BITS,
	FLIT(-20175272464513461.0) * 2 / FRAC_BITS_2,
	FLIT(-9261438034788185.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-68644834434603232.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1487 / 2048) */
	FLIT(-16638497228194384.0) * 2 / FRAC_BITS,
	FLIT(-58321621033623706.0) * 2 / FRAC_BITS_2,
	FLIT(-56317537471981960.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-1482861049001556.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1488 / 2048) */
	FLIT(-16603553652566769.0) * 2 / FRAC_BITS,
	FLIT(-38185400345984726.0) * 2 / FRAC_BITS_2,
	FLIT(-44734086464652536.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-43527081479313775.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1489 / 2048) */
	FLIT(-16568633552638352.0) * 2 / FRAC_BITS,
	FLIT(-58675940427215166.0) * 2 / FRAC_BITS_2,
	FLIT(-3569067260655235.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-57947718133876536.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1490 / 2048) */
	FLIT(-16533736896887547.0) * 2 / FRAC_BITS,
	FLIT(-54759228743062705.0) * 2 / FRAC_BITS_2,
	FLIT(-1697147791488491.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-33161473466421604.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1491 / 2048) */
	FLIT(-16498863653856212.0) * 2 / FRAC_BITS,
	FLIT(-33575388029602683.0) * 2 / FRAC_BITS_2,
	FLIT(-49159422100325735.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-12352185168732240.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1492 / 2048) */
	FLIT(-16464013792149479.0) * 2 / FRAC_BITS,
	FLIT(-63565827098174277.0) * 2 / FRAC_BITS_2,
	FLIT(-35171833219460995.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-53464463093067051.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1493 / 2048) */
	FLIT(-16429187280435588.0) * 2 / FRAC_BITS,
	FLIT(-16444275429334378.0) * 2 / FRAC_BITS_2,
	FLIT(-51402789964049653.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-14515042485873136.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1494 / 2048) */
	FLIT(-16394384087445711.0) * 2 / FRAC_BITS,
	FLIT(-70653005951416958.0) * 2 / FRAC_BITS_2,
	FLIT(-54346451143725880.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-59073636915229675.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1495 / 2048) */
	FLIT(-16359604181973793.0) * 2 / FRAC_BITS,
	FLIT(-30584967735035495.0) * 2 / FRAC_BITS_2,
	FLIT(-7743993955560338.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-46303840454416817.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1496 / 2048) */
	FLIT(-16324847532876374.0) * 2 / FRAC_BITS,
	FLIT(-55481743480632105.0) * 2 / FRAC_BITS_2,
	FLIT(-65089420276770566.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-40386737498885356.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1497 / 2048) */
	FLIT(-16290114109072430.0) * 2 / FRAC_BITS,
	FLIT(-59656052516191729.0) * 2 / FRAC_BITS_2,
	FLIT(-52319519337679850.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-71659548252547209.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1498 / 2048) */
	FLIT(-16255403879543202.0) * 2 / FRAC_BITS,
	FLIT(-17662269201024017.0) * 2 / FRAC_BITS_2,
	FLIT(-66197934226256116.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-22642543371523973.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1499 / 2048) */
	FLIT(-16220716813332029.0) * 2 / FRAC_BITS,
	FLIT(-21332263350268241.0) * 2 / FRAC_BITS_2,
	FLIT(-10998247142611044.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-43065671599821368.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1500 / 2048) */
	FLIT(-16186052879544186.0) * 2 / FRAC_BITS,
	FLIT(-16458532329040539.0) * 2 / FRAC_BITS_2,
	FLIT(-1489103749691616.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-44217995454917846.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1501 / 2048) */
	FLIT(-16151412047346716.0) * 2 / FRAC_BITS,
	FLIT(-11598471373810484.0) * 2 / FRAC_BITS_2,
	FLIT(-17405897992667681.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-66605037820174011.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1502 / 2048) */
	FLIT(-16116794285968266.0) * 2 / FRAC_BITS,
	FLIT(-38264898367873949.0) * 2 / FRAC_BITS_2,
	FLIT(-21888538482229759.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-20069680960451775.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1503 / 2048) */
	FLIT(-16082199564698925.0) * 2 / FRAC_BITS,
	FLIT(-6459818254812220.0) * 2 / FRAC_BITS_2,
	FLIT(-70945871024037060.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-11289818501056954.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1504 / 2048) */
	FLIT(-16047627852890056.0) * 2 / FRAC_BITS,
	FLIT(-31854713063131620.0) * 2 / FRAC_BITS_2,
	FLIT(-35903498271499919.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-38345244895772080.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1505 / 2048) */
	FLIT(-16013079119954139.0) * 2 / FRAC_BITS,
	FLIT(-9481525212235358.0) * 2 / FRAC_BITS_2,
	FLIT(-24742475247544430.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-47047550192256468.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1506 / 2048) */
	FLIT(-15978553335364603.0) * 2 / FRAC_BITS,
	FLIT(-19045398001057546.0) * 2 / FRAC_BITS_2,
	FLIT(-59398475302115058.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-26729291932104308.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1507 / 2048) */
	FLIT(-15944050468655668.0) * 2 / FRAC_BITS,
	FLIT(-48494418431867779.0) * 2 / FRAC_BITS_2,
	FLIT(-54905324654751055.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-70934882623180349.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1508 / 2048) */
	FLIT(-15909570489422183.0) * 2 / FRAC_BITS,
	FLIT(-44498119884507170.0) * 2 / FRAC_BITS_2,
	FLIT(-46128286343356320.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-46660080783880999.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1509 / 2048) */
	FLIT(-15875113367319464.0) * 2 / FRAC_BITS,
	FLIT(-1450526685034385.0) * 2 / FRAC_BITS_2,
	FLIT(-34040592621930692.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-11367099327057745.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1510 / 2048) */
	FLIT(-15840679072063133.0) * 2 / FRAC_BITS,
	FLIT(-16787018136909020.0) * 2 / FRAC_BITS_2,
	FLIT(-55577918274192656.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-12654300091092974.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1511 / 2048) */
	FLIT(-15806267573428962.0) * 2 / FRAC_BITS,
	FLIT(-24232217101013194.0) * 2 / FRAC_BITS_2,
	FLIT(-57166340691683938.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-38273344232608738.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1512 / 2048) */
	FLIT(-15771878841252710.0) * 2 / FRAC_BITS,
	FLIT(-69518318693706811.0) * 2 / FRAC_BITS_2,
	FLIT(-47044444026005131.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-54258398761096317.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1513 / 2048) */
	FLIT(-15737512845429968.0) * 2 / FRAC_BITS,
	FLIT(-47558937790544813.0) * 2 / FRAC_BITS_2,
	FLIT(-66409221277757182.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-30105169306368194.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1514 / 2048) */
	FLIT(-15703169555915996.0) * 2 / FRAC_BITS,
	FLIT(-53849667630178953.0) * 2 / FRAC_BITS_2,
	FLIT(-2882385772766814.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-29620042730674838.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1515 / 2048) */
	FLIT(-15668848942725570.0) * 2 / FRAC_BITS,
	FLIT(-52909039265241013.0) * 2 / FRAC_BITS_2,
	FLIT(-70328145581368463.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-25112468615115054.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1516 / 2048) */
	FLIT(-15634550975932823.0) * 2 / FRAC_BITS,
	FLIT(-16532459970983953.0) * 2 / FRAC_BITS_2,
	FLIT(-31968786637541824.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-20090681217549963.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1517 / 2048) */
	FLIT(-15600275625671087.0) * 2 / FRAC_BITS,
	FLIT(-27307733278915010.0) * 2 / FRAC_BITS_2,
	FLIT(-18793470021768279.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-40875197365897697.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1518 / 2048) */
	FLIT(-15566022862132740.0) * 2 / FRAC_BITS,
	FLIT(-59014229221230744.0) * 2 / FRAC_BITS_2,
	FLIT(-15872200763630552.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-25607951792156149.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1519 / 2048) */
	FLIT(-15531792655569050.0) * 2 / FRAC_BITS,
	FLIT(-10219582029262390.0) * 2 / FRAC_BITS_2,
	FLIT(-57859342025739976.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-24228820643724152.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1520 / 2048) */
	FLIT(-15497584976290015.0) * 2 / FRAC_BITS,
	FLIT(-62985310884716465.0) * 2 / FRAC_BITS_2,
	FLIT(-5475568743426235.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-67446987491667568.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1521 / 2048) */
	FLIT(-15463399794664217.0) * 2 / FRAC_BITS,
	FLIT(-69499145662943217.0) * 2 / FRAC_BITS_2,
	FLIT(-299883602217421.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-44993080637836034.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1522 / 2048) */
	FLIT(-15429237081118661.0) * 2 / FRAC_BITS,
	FLIT(-56159428912221476.0) * 2 / FRAC_BITS_2,
	FLIT(-32862789713841722.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-61799358413000933.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1523 / 2048) */
	FLIT(-15395096806138624.0) * 2 / FRAC_BITS,
	FLIT(-43527553269067140.0) * 2 / FRAC_BITS_2,
	FLIT(-55074288826903923.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-21892340953622437.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1524 / 2048) */
	FLIT(-15360978940267502.0) * 2 / FRAC_BITS,
	FLIT(-46696035419800271.0) * 2 / FRAC_BITS_2,
	FLIT(-63088062397305950.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-56769366698765347.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1525 / 2048) */
	FLIT(-15326883454106658.0) * 2 / FRAC_BITS,
	FLIT(-39756576179993821.0) * 2 / FRAC_BITS_2,
	FLIT(-34054926420123107.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-12989670550774352.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1526 / 2048) */
	FLIT(-15292810318315269.0) * 2 / FRAC_BITS,
	FLIT(-28341082027297628.0) * 2 / FRAC_BITS_2,
	FLIT(-2920318422711621.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-63449707341402574.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1527 / 2048) */
	FLIT(-15258759503610175.0) * 2 / FRAC_BITS,
	FLIT(-13921305372022929.0) * 2 / FRAC_BITS_2,
	FLIT(-36908905170660470.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-51758211348819630.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1528 / 2048) */
	FLIT(-15224730980765727.0) * 2 / FRAC_BITS,
	FLIT(-65898973800514947.0) * 2 / FRAC_BITS_2,
	FLIT(-5725173466913981.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-44134716814360458.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1529 / 2048) */
	FLIT(-15190724720613640.0) * 2 / FRAC_BITS,
	FLIT(-69000577512718428.0) * 2 / FRAC_BITS_2,
	FLIT(-41142860358381786.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-54657835890222091.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1530 / 2048) */
	FLIT(-15156740694042839.0) * 2 / FRAC_BITS,
	FLIT(-10528318810405864.0) * 2 / FRAC_BITS_2,
	FLIT(-67047407500583573.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-24124755000619660.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1531 / 2048) */
	FLIT(-15122778871999309.0) * 2 / FRAC_BITS,
	FLIT(-14694703217039382.0) * 2 / FRAC_BITS_2,
	FLIT(-5956746189860974.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-24774977628111512.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1532 / 2048) */
	FLIT(-15088839225485950.0) * 2 / FRAC_BITS,
	FLIT(-51844827450561343.0) * 2 / FRAC_BITS_2,
	FLIT(-46086011810956196.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-3292260163475666.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1533 / 2048) */
	FLIT(-15054921725562427.0) * 2 / FRAC_BITS,
	FLIT(-43004585832451869.0) * 2 / FRAC_BITS_2,
	FLIT(-71464217294585648.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-25498942723328690.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1534 / 2048) */
	FLIT(-15021026343345019.0) * 2 / FRAC_BITS,
	FLIT(-71387328833490045.0) * 2 / FRAC_BITS_2,
	FLIT(-42490321614271380.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-45516774759381039.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1535 / 2048) */
	FLIT(-14987153050006476.0) * 2 / FRAC_BITS,
	FLIT(-52204162637695134.0) * 2 / FRAC_BITS_2,
	FLIT(-26799485107410551.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-44628415157251254.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1536 / 2048) */
	FLIT(-14953301816775868.0) * 2 / FRAC_BITS,
	FLIT(-13563551666601146.0) * 2 / FRAC_BITS_2,
	FLIT(-11566233212988974.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-59435062072784857.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1537 / 2048) */
	FLIT(-14919472614938439.0) * 2 / FRAC_BITS,
	FLIT(-51576277779470783.0) * 2 / FRAC_BITS_2,
	FLIT(-60651937084462450.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-47641696546652171.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1538 / 2048) */
	FLIT(-14885665415835465.0) * 2 / FRAC_BITS,
	FLIT(-31588742049253628.0) * 2 / FRAC_BITS_2,
	FLIT(-57408342728332234.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-8515974856253704.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1539 / 2048) */
	FLIT(-14851880190864102.0) * 2 / FRAC_BITS,
	FLIT(-44216929959046649.0) * 2 / FRAC_BITS_2,
	FLIT(-31080346737171942.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-46048413183026902.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1540 / 2048) */
	FLIT(-14818116911477246.0) * 2 / FRAC_BITS,
	FLIT(-30780584767696899.0) * 2 / FRAC_BITS_2,
	FLIT(-2782939267695599.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-24959806120641793.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1541 / 2048) */
	FLIT(-14784375549183385.0) * 2 / FRAC_BITS,
	FLIT(-19156689491438071.0) * 2 / FRAC_BITS_2,
	FLIT(-54738653297210123.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-9154531082276682.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1542 / 2048) */
	FLIT(-14750656075546456.0) * 2 / FRAC_BITS,
	FLIT(-33171357656573176.0) * 2 / FRAC_BITS_2,
	FLIT(-3281394576569526.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-11033115252419909.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1543 / 2048) */
	FLIT(-14716958462185702.0) * 2 / FRAC_BITS,
	FLIT(-35686525493478114.0) * 2 / FRAC_BITS_2,
	FLIT(-51163436988107999.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-5360619665941221.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1544 / 2048) */
	FLIT(-14683282680775527.0) * 2 / FRAC_BITS,
	FLIT(-49365652852028345.0) * 2 / FRAC_BITS_2,
	FLIT(-58941512809409310.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-32589379810497700.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1545 / 2048) */
	FLIT(-14649628703045355.0) * 2 / FRAC_BITS,
	FLIT(-22642481447906264.0) * 2 / FRAC_BITS_2,
	FLIT(-2430752081611568.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-51595950319384967.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1546 / 2048) */
	FLIT(-14615996500779485.0) * 2 / FRAC_BITS,
	FLIT(-17223806140183789.0) * 2 / FRAC_BITS_2,
	FLIT(-1842043240007719.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-13451130677032367.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1547 / 2048) */
	FLIT(-14582386045816951.0) * 2 / FRAC_BITS,
	FLIT(-68478703800794911.0) * 2 / FRAC_BITS_2,
	FLIT(-60213036210517342.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-25562454328604275.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1548 / 2048) */
	FLIT(-14548797310051383.0) * 2 / FRAC_BITS,
	FLIT(-6815971297387813.0) * 2 / FRAC_BITS_2,
	FLIT(-14869042428273980.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-30825639195304343.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1549 / 2048) */
	FLIT(-14515230265430858.0) * 2 / FRAC_BITS,
	FLIT(-32555263824822281.0) * 2 / FRAC_BITS_2,
	FLIT(-49691820819074137.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-33960229896143969.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1550 / 2048) */
	FLIT(-14481684883957769.0) * 2 / FRAC_BITS,
	FLIT(-26551835787676509.0) * 2 / FRAC_BITS_2,
	FLIT(-2430568930156010.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-70024100378521491.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1551 / 2048) */
	FLIT(-14448161137688678.0) * 2 / FRAC_BITS,
	FLIT(-46406192249379828.0) * 2 / FRAC_BITS_2,
	FLIT(-17246771506936093.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-59705671984604827.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1552 / 2048) */
	FLIT(-14414658998734180.0) * 2 / FRAC_BITS,
	FLIT(-62577295144449919.0) * 2 / FRAC_BITS_2,
	FLIT(-34730327626731424.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-17976126387231164.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1553 / 2048) */
	FLIT(-14381178439258763.0) * 2 / FRAC_BITS,
	FLIT(-15137487587699457.0) * 2 / FRAC_BITS_2,
	FLIT(-40671869895628457.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-48170089529418838.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1554 / 2048) */
	FLIT(-14347719431480666.0) * 2 / FRAC_BITS,
	FLIT(-46928767580953233.0) * 2 / FRAC_BITS_2,
	FLIT(-9076127573942297.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-61751329196605048.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1555 / 2048) */
	FLIT(-14314281947671747.0) * 2 / FRAC_BITS,
	FLIT(-48304665734007034.0) * 2 / FRAC_BITS_2,
	FLIT(-11599174115724432.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-17691641467992874.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1556 / 2048) */
	FLIT(-14280865960157340.0) * 2 / FRAC_BITS,
	FLIT(-26543145664541363.0) * 2 / FRAC_BITS_2,
	FLIT(-62282756386059522.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-3197602091807240.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1557 / 2048) */
	FLIT(-14247471441316119.0) * 2 / FRAC_BITS,
	FLIT(-2770336176527004.0) * 2 / FRAC_BITS_2,
	FLIT(-248184085578029.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-11873310535197785.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1558 / 2048) */
	FLIT(-14214098363579961.0) * 2 / FRAC_BITS,
	FLIT(-12732904351108361.0) * 2 / FRAC_BITS_2,
	FLIT(-18444733933069207.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-11050683828418469.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1559 / 2048) */
	FLIT(-14180746699433810.0) * 2 / FRAC_BITS,
	FLIT(-67181490503851670.0) * 2 / FRAC_BITS_2,
	FLIT(-71519537633764330.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-58045342479114642.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1560 / 2048) */
	FLIT(-14147416421415542.0) * 2 / FRAC_BITS,
	FLIT(-71743363404582040.0) * 2 / FRAC_BITS_2,
	FLIT(-56838893678282871.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-29433783785950336.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1561 / 2048) */
	FLIT(-14114107502115826.0) * 2 / FRAC_BITS,
	FLIT(-66450970895791836.0) * 2 / FRAC_BITS_2,
	FLIT(-52006313833246155.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-5956745821166692.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1562 / 2048) */
	FLIT(-14080819914177991.0) * 2 / FRAC_BITS,
	FLIT(-64229694226673161.0) * 2 / FRAC_BITS_2,
	FLIT(-67082078560673688.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-38889275569253527.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1563 / 2048) */
	FLIT(-14047553630297891.0) * 2 / FRAC_BITS,
	FLIT(-64685348068518508.0) * 2 / FRAC_BITS_2,
	FLIT(-55077079226337617.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-54831498880310145.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1564 / 2048) */
	FLIT(-14014308623223771.0) * 2 / FRAC_BITS,
	FLIT(-26898971958039644.0) * 2 / FRAC_BITS_2,
	FLIT(-57783713744589809.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-10651303148232933.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1565 / 2048) */
	FLIT(-13981084865756131.0) * 2 / FRAC_BITS,
	FLIT(-17282558588683636.0) * 2 / FRAC_BITS_2,
	FLIT(-11807412753342790.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-30008525150411679.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1566 / 2048) */
	FLIT(-13947882330747595.0) * 2 / FRAC_BITS,
	FLIT(-27973956700476178.0) * 2 / FRAC_BITS_2,
	FLIT(-56214480375239541.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-9702209623354636.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1567 / 2048) */
	FLIT(-13914700991102777.0) * 2 / FRAC_BITS,
	FLIT(-42113626877061925.0) * 2 / FRAC_BITS_2,
	FLIT(-11111754290638.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-42554962071857211.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1568 / 2048) */
	FLIT(-13881540819778148.0) * 2 / FRAC_BITS,
	FLIT(-57655327387806746.0) * 2 / FRAC_BITS_2,
	FLIT(-24691488774076414.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-40136801237195234.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1569 / 2048) */
	FLIT(-13848401789781904.0) * 2 / FRAC_BITS,
	FLIT(-69593707959499683.0) * 2 / FRAC_BITS_2,
	FLIT(-69762512424564020.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-52018535684589122.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1570 / 2048) */
	FLIT(-13815283874173835.0) * 2 / FRAC_BITS,
	FLIT(-10492311283205670.0) * 2 / FRAC_BITS_2,
	FLIT(-40664425884240594.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-23578831554427627.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1571 / 2048) */
	FLIT(-13782187046065190.0) * 2 / FRAC_BITS,
	FLIT(-9483971513848872.0) * 2 / FRAC_BITS_2,
	FLIT(-49010540247595756.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-38400747220860592.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1572 / 2048) */
	FLIT(-13749111278618551.0) * 2 / FRAC_BITS,
	FLIT(-32879422956394472.0) * 2 / FRAC_BITS_2,
	FLIT(-23743484478708962.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-65761872521241376.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1573 / 2048) */
	FLIT(-13716056545047700.0) * 2 / FRAC_BITS,
	FLIT(-59190673223128553.0) * 2 / FRAC_BITS_2,
	FLIT(-36224179689906038.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-67056193373048778.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1574 / 2048) */
	FLIT(-13683022818617489.0) * 2 / FRAC_BITS,
	FLIT(-67878761537895013.0) * 2 / FRAC_BITS_2,
	FLIT(-68027917319205631.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-48084624340978052.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1575 / 2048) */
	FLIT(-13650010072643710.0) * 2 / FRAC_BITS,
	FLIT(-57884754135398594.0) * 2 / FRAC_BITS_2,
	FLIT(-4740926491508606.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-8697823622376097.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1576 / 2048) */
	FLIT(-13617018280492966.0) * 2 / FRAC_BITS,
	FLIT(-23772958747702500.0) * 2 / FRAC_BITS_2,
	FLIT(-50265221836572944.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-39876325082752577.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1577 / 2048) */
	FLIT(-13584047415582541.0) * 2 / FRAC_BITS,
	FLIT(-33488625910856731.0) * 2 / FRAC_BITS_2,
	FLIT(-16029398602963974.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-36742053813259177.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1578 / 2048) */
	FLIT(-13551097451380274.0) * 2 / FRAC_BITS,
	FLIT(-47329747632069231.0) * 2 / FRAC_BITS_2,
	FLIT(-66372382046042429.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-47631573789598406.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1579 / 2048) */
	FLIT(-13518168361404429.0) * 2 / FRAC_BITS,
	FLIT(-54481784984376761.0) * 2 / FRAC_BITS_2,
	FLIT(-47022464353658125.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-47525873924622570.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1580 / 2048) */
	FLIT(-13485260119223568.0) * 2 / FRAC_BITS,
	FLIT(-22600741635314883.0) * 2 / FRAC_BITS_2,
	FLIT(-53250638965661831.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-13032537262571080.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1581 / 2048) */
	FLIT(-13452372698456422.0) * 2 / FRAC_BITS,
	FLIT(-20621622269041834.0) * 2 / FRAC_BITS_2,
	FLIT(-67988872681047967.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-49930859924223306.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1582 / 2048) */
	FLIT(-13419506072771767.0) * 2 / FRAC_BITS,
	FLIT(-10278677407701947.0) * 2 / FRAC_BITS_2,
	FLIT(-59549299969286461.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-43825976740785110.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1583 / 2048) */
	FLIT(-13386660215888295.0) * 2 / FRAC_BITS,
	FLIT(-26803423301898717.0) * 2 / FRAC_BITS_2,
	FLIT(-60091787710608599.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-65194348082906059.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1584 / 2048) */
	FLIT(-13353835101574490.0) * 2 / FRAC_BITS,
	FLIT(-28115030852849353.0) * 2 / FRAC_BITS_2,
	FLIT(-64967100486353085.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-8737895123689668.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1585 / 2048) */
	FLIT(-13321030703648500.0) * 2 / FRAC_BITS,
	FLIT(-60912447846653452.0) * 2 / FRAC_BITS_2,
	FLIT(-45406813604840016.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-52985016654300446.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1586 / 2048) */
	FLIT(-13288246995978015.0) * 2 / FRAC_BITS,
	FLIT(-22983813217607387.0) * 2 / FRAC_BITS_2,
	FLIT(-17347122310786425.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-70263052919734778.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1587 / 2048) */
	FLIT(-13255483952480137.0) * 2 / FRAC_BITS,
	FLIT(-30431457698638283.0) * 2 / FRAC_BITS_2,
	FLIT(-8566494231449794.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-67930111479431662.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1588 / 2048) */
	FLIT(-13222741547121261.0) * 2 / FRAC_BITS,
	FLIT(-20610658283678629.0) * 2 / FRAC_BITS_2,
	FLIT(-27491445380554463.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-68746700836049546.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1589 / 2048) */
	FLIT(-13190019753916947.0) * 2 / FRAC_BITS,
	FLIT(-31826955325526969.0) * 2 / FRAC_BITS_2,
	FLIT(-64911388166688831.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-20984234507420211.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1590 / 2048) */
	FLIT(-13157318546931799.0) * 2 / FRAC_BITS,
	FLIT(-6763927261617717.0) * 2 / FRAC_BITS_2,
	FLIT(-71362544419389001.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-30415399548721507.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1591 / 2048) */
	FLIT(-13124637900279338.0) * 2 / FRAC_BITS,
	FLIT(-56284014222562170.0) * 2 / FRAC_BITS_2,
	FLIT(-48958320014139082.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-38318569630813074.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1592 / 2048) */
	FLIT(-13091977788121885.0) * 2 / FRAC_BITS,
	FLIT(-30575221482599509.0) * 2 / FRAC_BITS_2,
	FLIT(-26771206014961597.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-68270756568143584.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1593 / 2048) */
	FLIT(-13059338184670431.0) * 2 / FRAC_BITS,
	FLIT(-54863165649459053.0) * 2 / FRAC_BITS_2,
	FLIT(-52576515646154601.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-8558903598854676.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1594 / 2048) */
	FLIT(-13026719064184522.0) * 2 / FRAC_BITS,
	FLIT(-11971092684213910.0) * 2 / FRAC_BITS_2,
	FLIT(-7328447613751724.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-42822565567111813.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1595 / 2048) */
	FLIT(-12994120400972130.0) * 2 / FRAC_BITS,
	FLIT(-61293816812394202.0) * 2 / FRAC_BITS_2,
	FLIT(-11952975616930008.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-52461211020828048.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1596 / 2048) */
	FLIT(-12961542169389540.0) * 2 / FRAC_BITS,
	FLIT(-32353938653146584.0) * 2 / FRAC_BITS_2,
	FLIT(-8727391485243225.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-31926815659125819.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1597 / 2048) */
	FLIT(-12928984343841220.0) * 2 / FRAC_BITS,
	FLIT(-70737580493421519.0) * 2 / FRAC_BITS_2,
	FLIT(-23419198547382891.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-16474305743739055.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1598 / 2048) */
	FLIT(-12896446898779709.0) * 2 / FRAC_BITS,
	FLIT(-14290934986188728.0) * 2 / FRAC_BITS_2,
	FLIT(-59158284487895350.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-44749023340681611.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1599 / 2048) */
	FLIT(-12863929808705488.0) * 2 / FRAC_BITS,
	FLIT(-21490956870973936.0) * 2 / FRAC_BITS_2,
	FLIT(-69808058867925842.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-45095074160629173.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1600 / 2048) */
	FLIT(-12831433048166868.0) * 2 / FRAC_BITS,
	FLIT(-1929987108292928.0) * 2 / FRAC_BITS_2,
	FLIT(-41320309716420385.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-13874486934064637.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1601 / 2048) */
	FLIT(-12798956591759865.0) * 2 / FRAC_BITS,
	FLIT(-10540563415905519.0) * 2 / FRAC_BITS_2,
	FLIT(-5786688170442281.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-13769656766786052.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1602 / 2048) */
	FLIT(-12766500414128084.0) * 2 / FRAC_BITS,
	FLIT(-20192225162762061.0) * 2 / FRAC_BITS_2,
	FLIT(-66286901487339700.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-70513920969100442.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1603 / 2048) */
	FLIT(-12734064489962599.0) * 2 / FRAC_BITS,
	FLIT(-9308353627956781.0) * 2 / FRAC_BITS_2,
	FLIT(-24549531607467643.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-38575009746366466.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1604 / 2048) */
	FLIT(-12701648794001834.0) * 2 / FRAC_BITS,
	FLIT(-4114835469463621.0) * 2 / FRAC_BITS_2,
	FLIT(-50102939845387676.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-62518533862342021.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1605 / 2048) */
	FLIT(-12669253301031446.0) * 2 / FRAC_BITS,
	FLIT(-3363150727868255.0) * 2 / FRAC_BITS_2,
	FLIT(-14020983872489140.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-32917651273779564.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1606 / 2048) */
	FLIT(-12636877985884207.0) * 2 / FRAC_BITS,
	FLIT(-1601297991594412.0) * 2 / FRAC_BITS_2,
	FLIT(-17329279717005665.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-52036033123849977.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1607 / 2048) */
	FLIT(-12604522823439886.0) * 2 / FRAC_BITS,
	FLIT(-38836026181038450.0) * 2 / FRAC_BITS_2,
	FLIT(-698754896926433.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-9397233178943216.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1608 / 2048) */
	FLIT(-12572187788625134.0) * 2 / FRAC_BITS,
	FLIT(-60315085160984617.0) * 2 / FRAC_BITS_2,
	FLIT(-31775958982004719.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-64342068451738136.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1609 / 2048) */
	FLIT(-12539872856413366.0) * 2 / FRAC_BITS,
	FLIT(-18676982417083008.0) * 2 / FRAC_BITS_2,
	FLIT(-4395717445453984.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-20870322721846700.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1610 / 2048) */
	FLIT(-12507578001824643.0) * 2 / FRAC_BITS,
	FLIT(-2197813245104437.0) * 2 / FRAC_BITS_2,
	FLIT(-67534826773442777.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-67281965807917306.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1611 / 2048) */
	FLIT(-12475303199925559.0) * 2 / FRAC_BITS,
	FLIT(-28749968261247311.0) * 2 / FRAC_BITS_2,
	FLIT(-58038771882310897.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-27069819917438203.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1612 / 2048) */
	FLIT(-12443048425829126.0) * 2 / FRAC_BITS,
	FLIT(-9779072825290074.0) * 2 / FRAC_BITS_2,
	FLIT(-57780358858747265.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-55239888709553981.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1613 / 2048) */
	FLIT(-12410813654694655.0) * 2 / FRAC_BITS,
	FLIT(-28317963011853264.0) * 2 / FRAC_BITS_2,
	FLIT(-29491758821638578.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-17439969452258240.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1614 / 2048) */
	FLIT(-12378598861727645.0) * 2 / FRAC_BITS,
	FLIT(-66250604383568269.0) * 2 / FRAC_BITS_2,
	FLIT(-9957798485805312.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-46230586297891081.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1615 / 2048) */
	FLIT(-12346404022179668.0) * 2 / FRAC_BITS,
	FLIT(-45421532807773573.0) * 2 / FRAC_BITS_2,
	FLIT(-28730354959821667.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-1793171898649163.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1616 / 2048) */
	FLIT(-12314229111348252.0) * 2 / FRAC_BITS,
	FLIT(-38380494044493403.0) * 2 / FRAC_BITS_2,
	FLIT(-38101757510169295.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-66826554132189781.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1617 / 2048) */
	FLIT(-12282074104576771.0) * 2 / FRAC_BITS,
	FLIT(-149212536127018.0) * 2 / FRAC_BITS_2,
	FLIT(-6034762009512588.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-61497228326027981.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1618 / 2048) */
	FLIT(-12249938977254328.0) * 2 / FRAC_BITS,
	FLIT(-29722292632232622.0) * 2 / FRAC_BITS_2,
	FLIT(-31619075769960101.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-15543322320807841.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1619 / 2048) */
	FLIT(-12217823704815647.0) * 2 / FRAC_BITS,
	FLIT(-8286842249339593.0) * 2 / FRAC_BITS_2,
	FLIT(-58907553174881150.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-4387073817984091.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1620 / 2048) */
	FLIT(-12185728262740954.0) * 2 / FRAC_BITS,
	FLIT(-55219200220551048.0) * 2 / FRAC_BITS_2,
	FLIT(-66925087710166091.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-64533506663351908.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1621 / 2048) */
	FLIT(-12153652626555872.0) * 2 / FRAC_BITS,
	FLIT(-325820768589980.0) * 2 / FRAC_BITS_2,
	FLIT(-60117612880528593.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-13542316625871676.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1622 / 2048) */
	FLIT(-12121596771831300.0) * 2 / FRAC_BITS,
	FLIT(-33963442514974435.0) * 2 / FRAC_BITS_2,
	FLIT(-51380221079994949.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-19009484159430001.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1623 / 2048) */
	FLIT(-12089560674183311.0) * 2 / FRAC_BITS,
	FLIT(-12930456884087811.0) * 2 / FRAC_BITS_2,
	FLIT(-59927213131014981.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-20249441756688245.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1624 / 2048) */
	FLIT(-12057544309273033.0) * 2 / FRAC_BITS,
	FLIT(-16110965394576113.0) * 2 / FRAC_BITS_2,
	FLIT(-33861525123310823.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-67638206137381489.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1625 / 2048) */
	FLIT(-12025547652806542.0) * 2 / FRAC_BITS,
	FLIT(-60109798846273823.0) * 2 / FRAC_BITS_2,
	FLIT(-14535376143786345.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-55930802685158052.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1626 / 2048) */
	FLIT(-11993570680534752.0) * 2 / FRAC_BITS,
	FLIT(-55651303111928656.0) * 2 / FRAC_BITS_2,
	FLIT(-2190268967116456.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-56869939895301138.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1627 / 2048) */
	FLIT(-11961613368253302.0) * 2 / FRAC_BITS,
	FLIT(-4651177768253239.0) * 2 / FRAC_BITS_2,
	FLIT(-51181515097988715.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-64307433736512587.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1628 / 2048) */
	FLIT(-11929675691802446.0) * 2 / FRAC_BITS,
	FLIT(-5525479740095775.0) * 2 / FRAC_BITS_2,
	FLIT(-26998784034290251.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-16230825559198399.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1629 / 2048) */
	FLIT(-11897757627066946.0) * 2 / FRAC_BITS,
	FLIT(-66646856609227368.0) * 2 / FRAC_BITS_2,
	FLIT(-3556923176177617.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-8979956493432800.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1630 / 2048) */
	FLIT(-11865859149975964.0) * 2 / FRAC_BITS,
	FLIT(-16088836734986095.0) * 2 / FRAC_BITS_2,
	FLIT(-16553977389325660.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-48283967404075797.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1631 / 2048) */
	FLIT(-11833980236502946.0) * 2 / FRAC_BITS,
	FLIT(-11972169896246234.0) * 2 / FRAC_BITS_2,
	FLIT(-47483691294689140.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-48108282218439935.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1632 / 2048) */
	FLIT(-11802120862665520.0) * 2 / FRAC_BITS,
	FLIT(-68057367627586190.0) * 2 / FRAC_BITS_2,
	FLIT(-34821019429384405.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-65838840517694388.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1633 / 2048) */
	FLIT(-11770281004525388.0) * 2 / FRAC_BITS,
	FLIT(-35646922704080700.0) * 2 / FRAC_BITS_2,
	FLIT(-59776372028492931.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-9153841218601104.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1634 / 2048) */
	FLIT(-11738460638188212.0) * 2 / FRAC_BITS,
	FLIT(-41709185294755521.0) * 2 / FRAC_BITS_2,
	FLIT(-48609583925440010.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-8494056093333845.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1635 / 2048) */
	FLIT(-11706659739803513.0) * 2 / FRAC_BITS,
	FLIT(-14041963554141865.0) * 2 / FRAC_BITS_2,
	FLIT(-22800962106872582.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-1667221205730229.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1636 / 2048) */
	FLIT(-11674878285564559.0) * 2 / FRAC_BITS,
	FLIT(-22770835178360689.0) * 2 / FRAC_BITS_2,
	FLIT(-5103115705961696.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-14456235199235236.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1637 / 2048) */
	FLIT(-11643116251708261.0) * 2 / FRAC_BITS,
	FLIT(-69000986113559771.0) * 2 / FRAC_BITS_2,
	FLIT(-52143930868771887.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-22710053763164398.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1638 / 2048) */
	FLIT(-11611373614515067.0) * 2 / FRAC_BITS,
	FLIT(-41111991173012159.0) * 2 / FRAC_BITS_2,
	FLIT(-60090716420099860.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-65971205991336523.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1639 / 2048) */
	FLIT(-11579650350308851.0) * 2 / FRAC_BITS,
	FLIT(-54782162708563302.0) * 2 / FRAC_BITS_2,
	FLIT(-22871626993653434.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-24178392034401143.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1640 / 2048) */
	FLIT(-11547946435456813.0) * 2 / FRAC_BITS,
	FLIT(-23735174612612760.0) * 2 / FRAC_BITS_2,
	FLIT(-54289474906063356.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-29535777308743475.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1641 / 2048) */
	FLIT(-11516261846369368.0) * 2 / FRAC_BITS,
	FLIT(-46390608425357954.0) * 2 / FRAC_BITS_2,
	FLIT(-66983233448226274.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-54858037587150397.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1642 / 2048) */
	FLIT(-11484596559500046.0) * 2 / FRAC_BITS,
	FLIT(-23066294926464176.0) * 2 / FRAC_BITS_2,
	FLIT(-59517948949671862.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-62582105880001283.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1643 / 2048) */
	FLIT(-11452950551345382.0) * 2 / FRAC_BITS,
	FLIT(-16857230720253688.0) * 2 / FRAC_BITS_2,
	FLIT(-246415561925459.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-56221504472325153.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1644 / 2048) */
	FLIT(-11421323798444814.0) * 2 / FRAC_BITS,
	FLIT(-61070042578821864.0) * 2 / FRAC_BITS_2,
	FLIT(-24636923807364895.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-24329391604061445.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1645 / 2048) */
	FLIT(-11389716277380580.0) * 2 / FRAC_BITS,
	FLIT(-61647370311181457.0) * 2 / FRAC_BITS_2,
	FLIT(-68909397516748319.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-29322091962438049.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1646 / 2048) */
	FLIT(-11358127964777611.0) * 2 / FRAC_BITS,
	FLIT(-10671331933339620.0) * 2 / FRAC_BITS_2,
	FLIT(-4956361533748673.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-25514174417711266.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1647 / 2048) */
	FLIT(-11326558837303427.0) * 2 / FRAC_BITS,
	FLIT(-6459650033576395.0) * 2 / FRAC_BITS_2,
	FLIT(-27433316342669646.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-33305181759208414.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1648 / 2048) */
	FLIT(-11295008871668037.0) * 2 / FRAC_BITS,
	FLIT(-8113936227158653.0) * 2 / FRAC_BITS_2,
	FLIT(-42261958048340337.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-21252441798531758.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1649 / 2048) */
	FLIT(-11263478044623833.0) * 2 / FRAC_BITS,
	FLIT(-45013517067507027.0) * 2 / FRAC_BITS_2,
	FLIT(-57985113843126855.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-24379904832140695.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1650 / 2048) */
	FLIT(-11231966332965490.0) * 2 / FRAC_BITS,
	FLIT(-16481466294541136.0) * 2 / FRAC_BITS_2,
	FLIT(-22663582951856559.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-35234914022897384.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1651 / 2048) */
	FLIT(-11200473713529859.0) * 2 / FRAC_BITS,
	FLIT(-18289707899105620.0) * 2 / FRAC_BITS_2,
	FLIT(-4076740753472743.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-68482173929005554.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1652 / 2048) */
	FLIT(-11169000163195869.0) * 2 / FRAC_BITS,
	FLIT(-43000174343558988.0) * 2 / FRAC_BITS_2,
	FLIT(-30223560394225883.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-66494900112881528.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1653 / 2048) */
	FLIT(-11137545658884424.0) * 2 / FRAC_BITS,
	FLIT(-62867170697843887.0) * 2 / FRAC_BITS_2,
	FLIT(-17897427834477634.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-59428220559312074.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1654 / 2048) */
	FLIT(-11106110177558301.0) * 2 / FRAC_BITS,
	FLIT(-62874558302648722.0) * 2 / FRAC_BITS_2,
	FLIT(-37546050090276019.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-44516099140434526.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1655 / 2048) */
	FLIT(-11074693696222049.0) * 2 / FRAC_BITS,
	FLIT(-23827277748227028.0) * 2 / FRAC_BITS_2,
	FLIT(-50737999264034851.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-11166020432038712.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1656 / 2048) */
	FLIT(-11043296191921886.0) * 2 / FRAC_BITS,
	FLIT(-71589853368184828.0) * 2 / FRAC_BITS_2,
	FLIT(-57661393954172327.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-51060054810965181.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1657 / 2048) */
	FLIT(-11011917641745604.0) * 2 / FRAC_BITS,
	FLIT(-71816137607992208.0) * 2 / FRAC_BITS_2,
	FLIT(-56545265035963642.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-7985409187015153.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1658 / 2048) */
	FLIT(-10980558022822463.0) * 2 / FRAC_BITS,
	FLIT(-39185117746867428.0) * 2 / FRAC_BITS_2,
	FLIT(-40335399454329793.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-59104919986127616.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1659 / 2048) */
	FLIT(-10949217312323092.0) * 2 / FRAC_BITS,
	FLIT(-64026963441672938.0) * 2 / FRAC_BITS_2,
	FLIT(-56502461707478820.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-49569959467957268.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1660 / 2048) */
	FLIT(-10917895487459393.0) * 2 / FRAC_BITS,
	FLIT(-44490896172361130.0) * 2 / FRAC_BITS_2,
	FLIT(-51874139575958123.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-55227147293584183.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1661 / 2048) */
	FLIT(-10886592525484437.0) * 2 / FRAC_BITS,
	FLIT(-16809952102409618.0) * 2 / FRAC_BITS_2,
	FLIT(-4694803438429663.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-3671218659072513.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1662 / 2048) */
	FLIT(-10855308403692367.0) * 2 / FRAC_BITS,
	FLIT(-2720595450599111.0) * 2 / FRAC_BITS_2,
	FLIT(-28040879457196875.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-68930947279257627.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1663 / 2048) */
	FLIT(-10824043099418299.0) * 2 / FRAC_BITS,
	FLIT(-22477725359088414.0) * 2 / FRAC_BITS_2,
	FLIT(-19786573803960825.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-41992125564297508.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1664 / 2048) */
	FLIT(-10792796590038224.0) * 2 / FRAC_BITS,
	FLIT(-57214818183834430.0) * 2 / FRAC_BITS_2,
	FLIT(-24612505607083703.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-71147869303025063.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1665 / 2048) */
	FLIT(-10761568852968910.0) * 2 / FRAC_BITS,
	FLIT(-32629649107797470.0) * 2 / FRAC_BITS_2,
	FLIT(-28956771258103257.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-72026437098860639.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1666 / 2048) */
	FLIT(-10730359865667801.0) * 2 / FRAC_BITS,
	FLIT(-40091549310863854.0) * 2 / FRAC_BITS_2,
	FLIT(-47946274990471845.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-46540579682104765.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1667 / 2048) */
	FLIT(-10699169605632924.0) * 2 / FRAC_BITS,
	FLIT(-2460161100469801.0) * 2 / FRAC_BITS_2,
	FLIT(-70885499603239541.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-57278045264336443.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1668 / 2048) */
	FLIT(-10667998050402787.0) * 2 / FRAC_BITS,
	FLIT(-9518607621744577.0) * 2 / FRAC_BITS_2,
	FLIT(-10874459510995626.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-8052344871103187.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1669 / 2048) */
	FLIT(-10636845177556286.0) * 2 / FRAC_BITS,
	FLIT(-25908522051524597.0) * 2 / FRAC_BITS_2,
	FLIT(-59486776936300256.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-14783291240593559.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1670 / 2048) */
	FLIT(-10605710964712606.0) * 2 / FRAC_BITS,
	FLIT(-52355302513684328.0) * 2 / FRAC_BITS_2,
	FLIT(-68473559456269303.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-7443328879411463.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1671 / 2048) */
	FLIT(-10574595389531126.0) * 2 / FRAC_BITS,
	FLIT(-19532424563215714.0) * 2 / FRAC_BITS_2,
	FLIT(-71273434171815366.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-65436482488771748.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1672 / 2048) */
	FLIT(-10543498429711319.0) * 2 / FRAC_BITS,
	FLIT(-63008244850217062.0) * 2 / FRAC_BITS_2,
	FLIT(-26650047945591178.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-58463906059647106.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1673 / 2048) */
	FLIT(-10512420062992663.0) * 2 / FRAC_BITS,
	FLIT(-26279192162919249.0) * 2 / FRAC_BITS_2,
	FLIT(-35264933042255089.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-10697084594541173.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1674 / 2048) */
	FLIT(-10481360267154537.0) * 2 / FRAC_BITS,
	FLIT(-65312503679187018.0) * 2 / FRAC_BITS_2,
	FLIT(-67866552890630486.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-18282017549027618.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1675 / 2048) */
	FLIT(-10450319020016134.0) * 2 / FRAC_BITS,
	FLIT(-48681520602676399.0) * 2 / FRAC_BITS_2,
	FLIT(-61530035485436130.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-18781493313017917.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1676 / 2048) */
	FLIT(-10419296299436359.0) * 2 / FRAC_BITS,
	FLIT(-59062884851015544.0) * 2 / FRAC_BITS_2,
	FLIT(-63257509331168851.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-18255856564263689.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1677 / 2048) */
	FLIT(-10388292083313739.0) * 2 / FRAC_BITS,
	FLIT(-50467237814621097.0) * 2 / FRAC_BITS_2,
	FLIT(-27915314822368709.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-42538446425544549.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1678 / 2048) */
	FLIT(-10357306349586326.0) * 2 / FRAC_BITS,
	FLIT(-30224654071547557.0) * 2 / FRAC_BITS_2,
	FLIT(-17128329057710487.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-57832493840348669.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1679 / 2048) */
	FLIT(-10326339076231603.0) * 2 / FRAC_BITS,
	FLIT(-45076120506929887.0) * 2 / FRAC_BITS_2,
	FLIT(-10023573184824908.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-22300598773197554.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1680 / 2048) */
	FLIT(-10295390241266392.0) * 2 / FRAC_BITS,
	FLIT(-43356208914650983.0) * 2 / FRAC_BITS_2,
	FLIT(-44572132458237374.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-50411909139450825.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1681 / 2048) */
	FLIT(-10264459822746758.0) * 2 / FRAC_BITS,
	FLIT(-45540362116932592.0) * 2 / FRAC_BITS_2,
	FLIT(-67258640095706327.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-45197067683422312.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1682 / 2048) */
	FLIT(-10233547798767917.0) * 2 / FRAC_BITS,
	FLIT(-46624197439273416.0) * 2 / FRAC_BITS_2,
	FLIT(-43031561472545233.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-23082016999639808.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1683 / 2048) */
	FLIT(-10202654147464143.0) * 2 / FRAC_BITS,
	FLIT(-10551252775906462.0) * 2 / FRAC_BITS_2,
	FLIT(-16164292664820580.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-15141673568599199.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1684 / 2048) */
	FLIT(-10171778847008673.0) * 2 / FRAC_BITS,
	FLIT(-28675521813524233.0) * 2 / FRAC_BITS_2,
	FLIT(-34480513150469171.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-68410695281265501.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1685 / 2048) */
	FLIT(-10140921875613618.0) * 2 / FRAC_BITS,
	FLIT(-65727074711149293.0) * 2 / FRAC_BITS_2,
	FLIT(-45488033473554575.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-60979423098506444.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1686 / 2048) */
	FLIT(-10110083211529870.0) * 2 / FRAC_BITS,
	FLIT(-13786047882946951.0) * 2 / FRAC_BITS_2,
	FLIT(-22867848081989251.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-57822562535711430.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1687 / 2048) */
	FLIT(-10079262833047005.0) * 2 / FRAC_BITS,
	FLIT(-54194639419949012.0) * 2 / FRAC_BITS_2,
	FLIT(-267280983261216.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-34499596298180846.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1688 / 2048) */
	FLIT(-10048460718493200.0) * 2 / FRAC_BITS,
	FLIT(-30300345882096182.0) * 2 / FRAC_BITS_2,
	FLIT(-22737117732337071.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-46288897957938669.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1689 / 2048) */
	FLIT(-10017676846235133.0) * 2 / FRAC_BITS,
	FLIT(-64746074545717604.0) * 2 / FRAC_BITS_2,
	FLIT(-28708776022496524.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-7070772730062922.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1690 / 2048) */
	FLIT(-9986911194677899.0) * 2 / FRAC_BITS,
	FLIT(-43337035883887388.0) * 2 / FRAC_BITS_2,
	FLIT(-69885166072377600.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-41146591016190542.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1691 / 2048) */
	FLIT(-9956163742264913.0) * 2 / FRAC_BITS,
	FLIT(-55085439160129770.0) * 2 / FRAC_BITS_2,
	FLIT(-27969848946577794.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-48182337867129944.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1692 / 2048) */
	FLIT(-9925434467477824.0) * 2 / FRAC_BITS,
	FLIT(-58981816396333912.0) * 2 / FRAC_BITS_2,
	FLIT(-59035964697477869.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-13100180965485923.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1693 / 2048) */
	FLIT(-9894723348836423.0) * 2 / FRAC_BITS,
	FLIT(-2403440567661928.0) * 2 / FRAC_BITS_2,
	FLIT(-56914237723706005.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-16144813212089151.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1694 / 2048) */
	FLIT(-9864030364898550.0) * 2 / FRAC_BITS,
	FLIT(-30803518733197496.0) * 2 / FRAC_BITS_2,
	FLIT(-23957418469860542.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-15976724688621332.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1695 / 2048) */
	FLIT(-9833355494260010.0) * 2 / FRAC_BITS,
	FLIT(-68037152972474121.0) * 2 / FRAC_BITS_2,
	FLIT(-7372349615519485.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-54101084643040701.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1696 / 2048) */
	FLIT(-9802698715554480.0) * 2 / FRAC_BITS,
	FLIT(-64292976078798043.0) * 2 / FRAC_BITS_2,
	FLIT(-39136156348189834.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-71891027868299.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1697 / 2048) */
	FLIT(-9772060007453419.0) * 2 / FRAC_BITS,
	FLIT(-46871827516066437.0) * 2 / FRAC_BITS_2,
	FLIT(-65345782407806055.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-25536625770211536.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1698 / 2048) */
	FLIT(-9741439348665980.0) * 2 / FRAC_BITS,
	FLIT(-45802836014324365.0) * 2 / FRAC_BITS_2,
	FLIT(-69331974497103930.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-9240405876931173.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1699 / 2048) */
	FLIT(-9710836717938922.0) * 2 / FRAC_BITS,
	FLIT(-38345146281552028.0) * 2 / FRAC_BITS_2,
	FLIT(-19919336223651013.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-43327374147704553.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1700 / 2048) */
	FLIT(-9680252094056520.0) * 2 / FRAC_BITS,
	FLIT(-56423803069277972.0) * 2 / FRAC_BITS_2,
	FLIT(-64575095932815816.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-20278265378974168.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1701 / 2048) */
	FLIT(-9649685455840479.0) * 2 / FRAC_BITS,
	FLIT(-24587827988981167.0) * 2 / FRAC_BITS_2,
	FLIT(-70176910451983081.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-29013334830810160.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1702 / 2048) */
	FLIT(-9619136782149842.0) * 2 / FRAC_BITS,
	FLIT(-49000302255431250.0) * 2 / FRAC_BITS_2,
	FLIT(-19693077502109493.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-58552985246473912.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1703 / 2048) */
	FLIT(-9588606051880908.0) * 2 / FRAC_BITS,
	FLIT(-4473095435699820.0) * 2 / FRAC_BITS_2,
	FLIT(-36789756872803692.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-5417085713553646.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1704 / 2048) */
	FLIT(-9558093243967138.0) * 2 / FRAC_BITS,
	FLIT(-4747724335699310.0) * 2 / FRAC_BITS_2,
	FLIT(-36813677713287527.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-64341378588062559.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1705 / 2048) */
	FLIT(-9527598337379073.0) * 2 / FRAC_BITS,
	FLIT(-26574769753177106.0) * 2 / FRAC_BITS_2,
	FLIT(-23605048132320953.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-61041018946501030.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1706 / 2048) */
	FLIT(-9497121311124245.0) * 2 / FRAC_BITS,
	FLIT(-56621090535346611.0) * 2 / FRAC_BITS_2,
	FLIT(-26390616531713746.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-43069826486023253.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1707 / 2048) */
	FLIT(-9466662144247091.0) * 2 / FRAC_BITS,
	FLIT(-40564114101039209.0) * 2 / FRAC_BITS_2,
	FLIT(-71004107245726899.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-31101218522080281.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1708 / 2048) */
	FLIT(-9436220815828864.0) * 2 / FRAC_BITS,
	FLIT(-66654252765604266.0) * 2 / FRAC_BITS_2,
	FLIT(-5080361090740929.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-19183584235307331.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1709 / 2048) */
	FLIT(-9405797304987551.0) * 2 / FRAC_BITS,
	FLIT(-63105254927902628.0) * 2 / FRAC_BITS_2,
	FLIT(-18882948171703853.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-48778855991512093.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1710 / 2048) */
	FLIT(-9375391590877784.0) * 2 / FRAC_BITS,
	FLIT(-18054820179990821.0) * 2 / FRAC_BITS_2,
	FLIT(-28608035169404185.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-42201923561381411.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1711 / 2048) */
	FLIT(-9345003652690754.0) * 2 / FRAC_BITS,
	FLIT(-1455812350328355.0) * 2 / FRAC_BITS_2,
	FLIT(-39393596743460293.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-21938710975139847.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1712 / 2048) */
	FLIT(-9314633469654127.0) * 2 / FRAC_BITS,
	FLIT(-60892199545048580.0) * 2 / FRAC_BITS_2,
	FLIT(-53852189839217909.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-2574142752926355.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1713 / 2048) */
	FLIT(-9284281021031961.0) * 2 / FRAC_BITS,
	FLIT(-63314109670761930.0) * 2 / FRAC_BITS_2,
	FLIT(-3298189791913460.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-68321951848665748.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1714 / 2048) */
	FLIT(-9253946286124616.0) * 2 / FRAC_BITS,
	FLIT(-59089806395607261.0) * 2 / FRAC_BITS_2,
	FLIT(-19272901395913748.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-32964978081160553.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1715 / 2048) */
	FLIT(-9223629244268673.0) * 2 / FRAC_BITS,
	FLIT(-15390390597928647.0) * 2 / FRAC_BITS_2,
	FLIT(-57697388019324814.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-31113648303861202.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1716 / 2048) */
	FLIT(-9193329874836846.0) * 2 / FRAC_BITS,
	FLIT(-71766297370082638.0) * 2 / FRAC_BITS_2,
	FLIT(-5955778842519878.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-20450702353929874.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1717 / 2048) */
	FLIT(-9163048157237905.0) * 2 / FRAC_BITS,
	FLIT(-20816715967550511.0) * 2 / FRAC_BITS_2,
	FLIT(-61356543726564727.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-1172738539171376.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1718 / 2048) */
	FLIT(-9132784070916582.0) * 2 / FRAC_BITS,
	FLIT(-31502639264467477.0) * 2 / FRAC_BITS_2,
	FLIT(-71070532773831506.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-60908741155974021.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1719 / 2048) */
	FLIT(-9102537595353496.0) * 2 / FRAC_BITS,
	FLIT(-20968483095789303.0) * 2 / FRAC_BITS_2,
	FLIT(-28857639892891931.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-18889652884074301.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1720 / 2048) */
	FLIT(-9072308710065064.0) * 2 / FRAC_BITS,
	FLIT(-52711455556259921.0) * 2 / FRAC_BITS_2,
	FLIT(-12396730860506223.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-26979149573658851.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1721 / 2048) */
	FLIT(-9042097394603422.0) * 2 / FRAC_BITS,
	FLIT(-31655246069924762.0) * 2 / FRAC_BITS_2,
	FLIT(-49524122947014618.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-30018455447632690.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1722 / 2048) */
	FLIT(-9011903628556337.0) * 2 / FRAC_BITS,
	FLIT(-65161396418970815.0) * 2 / FRAC_BITS_2,
	FLIT(-57541297647880345.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-66073199514129662.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1723 / 2048) */
	FLIT(-8981727391547130.0) * 2 / FRAC_BITS,
	FLIT(-48765796030349330.0) * 2 / FRAC_BITS_2,
	FLIT(-20866904119825327.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-63368997014518860.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1724 / 2048) */
	FLIT(-8951568663234588.0) * 2 / FRAC_BITS,
	FLIT(-61846939851236987.0) * 2 / FRAC_BITS_2,
	FLIT(-41454501478714668.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-60627827795443096.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1725 / 2048) */
	FLIT(-8921427423312886.0) * 2 / FRAC_BITS,
	FLIT(-59956288809876611.0) * 2 / FRAC_BITS_2,
	FLIT(-15357876419675802.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-5499479672244962.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1726 / 2048) */
	FLIT(-8891303651511503.0) * 2 / FRAC_BITS,
	FLIT(-16672296420781562.0) * 2 / FRAC_BITS_2,
	FLIT(-41127551070443202.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-45479966555894030.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1727 / 2048) */
	FLIT(-8861197327595139.0) * 2 / FRAC_BITS,
	FLIT(-10515245248706267.0) * 2 / FRAC_BITS_2,
	FLIT(-61838905086405537.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-14595750122407165.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1728 / 2048) */
	FLIT(-8831108431363636.0) * 2 / FRAC_BITS,
	FLIT(-40690654999803438.0) * 2 / FRAC_BITS_2,
	FLIT(-34698699638966924.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-34189998142498700.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1729 / 2048) */
	FLIT(-8801036942651897.0) * 2 / FRAC_BITS,
	FLIT(-3947611132451932.0) * 2 / FRAC_BITS_2,
	FLIT(-21773663879337954.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-43639622889366026.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1730 / 2048) */
	FLIT(-8770982841329800.0) * 2 / FRAC_BITS,
	FLIT(-48665820435399111.0) * 2 / FRAC_BITS_2,
	FLIT(-69833466555738208.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-8026820913552293.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1731 / 2048) */
	FLIT(-8740946107302125.0) * 2 / FRAC_BITS,
	FLIT(-9075963785342869.0) * 2 / FRAC_BITS_2,
	FLIT(-41817653061537469.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-8003009139501370.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1732 / 2048) */
	FLIT(-8710926720508465.0) * 2 / FRAC_BITS,
	FLIT(-9225073537442744.0) * 2 / FRAC_BITS_2,
	FLIT(-29835970856292550.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-20094766199407603.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1733 / 2048) */
	FLIT(-8680924660923152.0) * 2 / FRAC_BITS,
	FLIT(-2843257088833765.0) * 2 / FRAC_BITS_2,
	FLIT(-707463989541462.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-69891330343469744.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1734 / 2048) */
	FLIT(-8650939908555173.0) * 2 / FRAC_BITS,
	FLIT(-50493589550643298.0) * 2 / FRAC_BITS_2,
	FLIT(-58075805645779837.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-185024924675983.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1735 / 2048) */
	FLIT(-8620972443448094.0) * 2 / FRAC_BITS,
	FLIT(-36910689019434003.0) * 2 / FRAC_BITS_2,
	FLIT(-26309913916303407.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-66182350981252500.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1736 / 2048) */
	FLIT(-8591022245679975.0) * 2 / FRAC_BITS,
	FLIT(-53449512373286953.0) * 2 / FRAC_BITS_2,
	FLIT(-45513597638701769.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-4160420025126535.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1737 / 2048) */
	FLIT(-8561089295363296.0) * 2 / FRAC_BITS,
	FLIT(-4435162147302702.0) * 2 / FRAC_BITS_2,
	FLIT(-10016385197459324.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-7344315880211543.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1738 / 2048) */
	FLIT(-8531173572644872.0) * 2 / FRAC_BITS,
	FLIT(-22623675600815481.0) * 2 / FRAC_BITS_2,
	FLIT(-2367524129898838.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-4049455830550619.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1739 / 2048) */
	FLIT(-8501275057705780.0) * 2 / FRAC_BITS,
	FLIT(-36392265283580334.0) * 2 / FRAC_BITS_2,
	FLIT(-21067648245415035.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-20593111400994654.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1740 / 2048) */
	FLIT(-8471393730761277.0) * 2 / FRAC_BITS,
	FLIT(-1811846921420350.0) * 2 / FRAC_BITS_2,
	FLIT(-53742168807471784.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-5855720001709144.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1741 / 2048) */
	FLIT(-8441529572060720.0) * 2 / FRAC_BITS,
	FLIT(-6911909020669258.0) * 2 / FRAC_BITS_2,
	FLIT(-34269802388428395.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-38597242874544970.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1742 / 2048) */
	FLIT(-8411682561887491.0) * 2 / FRAC_BITS,
	FLIT(-31908757640289965.0) * 2 / FRAC_BITS_2,
	FLIT(-44822231376099449.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-3997281644050407.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1743 / 2048) */
	FLIT(-8381852680558918.0) * 2 / FRAC_BITS,
	FLIT(-13859523940791249.0) * 2 / FRAC_BITS_2,
	FLIT(-55125962317775113.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-19706975461042434.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1744 / 2048) */
	FLIT(-8352039908426194.0) * 2 / FRAC_BITS,
	FLIT(-71571012371322190.0) * 2 / FRAC_BITS_2,
	FLIT(-62632168073601350.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-43381306722804956.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1745 / 2048) */
	FLIT(-8322244225874306.0) * 2 / FRAC_BITS,
	FLIT(-26016750616210526.0) * 2 / FRAC_BITS_2,
	FLIT(-8138379228716545.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-47869836886669784.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1746 / 2048) */
	FLIT(-8292465613321949.0) * 2 / FRAC_BITS,
	FLIT(-17646804439724275.0) * 2 / FRAC_BITS_2,
	FLIT(-57862794052709373.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-64788656494872943.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1747 / 2048) */
	FLIT(-8262704051221455.0) * 2 / FRAC_BITS,
	FLIT(-58807470076274567.0) * 2 / FRAC_BITS_2,
	FLIT(-68386150608092872.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-31876146190165927.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1748 / 2048) */
	FLIT(-8232959520058716.0) * 2 / FRAC_BITS,
	FLIT(-34425473327624601.0) * 2 / FRAC_BITS_2,
	FLIT(-19344341413410421.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-28728471708994683.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1749 / 2048) */
	FLIT(-8203232000353103.0) * 2 / FRAC_BITS,
	FLIT(-6786861227118315.0) * 2 / FRAC_BITS_2,
	FLIT(-20479429583626008.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-21432318116701046.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1750 / 2048) */
	FLIT(-8173521472657392.0) * 2 / FRAC_BITS,
	FLIT(-31722644356342766.0) * 2 / FRAC_BITS_2,
	FLIT(-2268614923740849.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-4851334000730606.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1751 / 2048) */
	FLIT(-8143827917557689.0) * 2 / FRAC_BITS,
	FLIT(-62607752188143697.0) * 2 / FRAC_BITS_2,
	FLIT(-65516744264735768.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-27656220243441289.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1752 / 2048) */
	FLIT(-8114151315673353.0) * 2 / FRAC_BITS,
	FLIT(-14176922138548496.0) * 2 / FRAC_BITS_2,
	FLIT(-59118472907547441.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-5430542104731073.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1753 / 2048) */
	FLIT(-8084491647656916.0) * 2 / FRAC_BITS,
	FLIT(-58161358595639891.0) * 2 / FRAC_BITS_2,
	FLIT(-40691609484889986.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-2348142604252969.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1754 / 2048) */
	FLIT(-8054848894194015.0) * 2 / FRAC_BITS,
	FLIT(-69828708188499204.0) * 2 / FRAC_BITS_2,
	FLIT(-2673148390591927.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-64064381252899940.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1755 / 2048) */
	FLIT(-8025223036003311.0) * 2 / FRAC_BITS,
	FLIT(-26812872699856397.0) * 2 / FRAC_BITS_2,
	FLIT(-7913766066332885.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-4188719855664179.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1756 / 2048) */
	FLIT(-7995614053836413.0) * 2 / FRAC_BITS,
	FLIT(-63143850045079158.0) * 2 / FRAC_BITS_2,
	FLIT(-51720338524911933.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-69872900550590095.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1757 / 2048) */
	FLIT(-7966021928477809.0) * 2 / FRAC_BITS,
	FLIT(-34309510028359773.0) * 2 / FRAC_BITS_2,
	FLIT(-60177986476164290.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-59420224515845003.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1758 / 2048) */
	FLIT(-7936446640744784.0) * 2 / FRAC_BITS,
	FLIT(-34448491139195653.0) * 2 / FRAC_BITS_2,
	FLIT(-20945139201093636.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-44279933811143310.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1759 / 2048) */
	FLIT(-7906888171487350.0) * 2 / FRAC_BITS,
	FLIT(-64181882704699266.0) * 2 / FRAC_BITS_2,
	FLIT(-14144096537678197.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-18612547815586373.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1760 / 2048) */
	FLIT(-7877346501588172.0) * 2 / FRAC_BITS,
	FLIT(-1952921073793525.0) * 2 / FRAC_BITS_2,
	FLIT(-62494788918585328.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-4891405502044176.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1761 / 2048) */
	FLIT(-7847821611962488.0) * 2 / FRAC_BITS,
	FLIT(-22937819834986035.0) * 2 / FRAC_BITS_2,
	FLIT(-39721435779073159.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-43699581696513800.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1762 / 2048) */
	FLIT(-7818313483558043.0) * 2 / FRAC_BITS,
	FLIT(-24323992147630927.0) * 2 / FRAC_BITS_2,
	FLIT(-29240137172432629.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-49539523282660584.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1763 / 2048) */
	FLIT(-7788822097355010.0) * 2 / FRAC_BITS,
	FLIT(-2459049022651817.0) * 2 / FRAC_BITS_2,
	FLIT(-25365896050149194.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-42640439948337688.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1764 / 2048) */
	FLIT(-7759347434365917.0) * 2 / FRAC_BITS,
	FLIT(-12724836683081102.0) * 2 / FRAC_BITS_2,
	FLIT(-47823955200054364.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-14891737306909077.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1765 / 2048) */
	FLIT(-7729889475635576.0) * 2 / FRAC_BITS,
	FLIT(-315643116561001.0) * 2 / FRAC_BITS_2,
	FLIT(-30539414195242607.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-70682987505707303.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1766 / 2048) */
	FLIT(-7700448202241007.0) * 2 / FRAC_BITS,
	FLIT(-6272689230302995.0) * 2 / FRAC_BITS_2,
	FLIT(-38605319663122069.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-45964806103267850.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1767 / 2048) */
	FLIT(-7671023595291367.0) * 2 / FRAC_BITS,
	FLIT(-28148123638626791.0) * 2 / FRAC_BITS_2,
	FLIT(-29549500349868579.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-68008028484985056.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1768 / 2048) */
	FLIT(-7641615635927877.0) * 2 / FRAC_BITS,
	FLIT(-39651040106891538.0) * 2 / FRAC_BITS_2,
	FLIT(-47867291823479135.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-5494053710006658.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1769 / 2048) */
	FLIT(-7612224305323749.0) * 2 / FRAC_BITS,
	FLIT(-25109890772373633.0) * 2 / FRAC_BITS_2,
	FLIT(-14250397439975338.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-46684989135493586.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1770 / 2048) */
	FLIT(-7582849584684113.0) * 2 / FRAC_BITS,
	FLIT(-28701055870403225.0) * 2 / FRAC_BITS_2,
	FLIT(-50104204078386844.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-4712413977209184.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1771 / 2048) */
	FLIT(-7553491455245947.0) * 2 / FRAC_BITS,
	FLIT(-2220747210605035.0) * 2 / FRAC_BITS_2,
	FLIT(-16651711937679784.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-58298884375896845.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1772 / 2048) */
	FLIT(-7524149898278002.0) * 2 / FRAC_BITS,
	FLIT(-27811154798609462.0) * 2 / FRAC_BITS_2,
	FLIT(-23943573598840666.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-51992503622264562.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1773 / 2048) */
	FLIT(-7494824895080734.0) * 2 / FRAC_BITS,
	FLIT(-50900062080904793.0) * 2 / FRAC_BITS_2,
	FLIT(-1340094224622958.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-14631261152466420.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1774 / 2048) */
	FLIT(-7465516426986230.0) * 2 / FRAC_BITS,
	FLIT(-60053202191642545.0) * 2 / FRAC_BITS_2,
	FLIT(-63848328048474224.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-19732499105848783.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1775 / 2048) */
	FLIT(-7436224475358137.0) * 2 / FRAC_BITS,
	FLIT(-65171753815319028.0) * 2 / FRAC_BITS_2,
	FLIT(-66567754216718938.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-18780803449342339.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1776 / 2048) */
	FLIT(-7406949021591592.0) * 2 / FRAC_BITS,
	FLIT(-18101103887049859.0) * 2 / FRAC_BITS_2,
	FLIT(-68787977224832026.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-41682928578007431.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1777 / 2048) */
	FLIT(-7377690047113148.0) * 2 / FRAC_BITS,
	FLIT(-35889979782038019.0) * 2 / FRAC_BITS_2,
	FLIT(-58159066567753642.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-45292362966176954.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1778 / 2048) */
	FLIT(-7348447533380708.0) * 2 / FRAC_BITS,
	FLIT(-61960147447102498.0) * 2 / FRAC_BITS_2,
	FLIT(-63867573571355183.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-17402705244578107.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1779 / 2048) */
	FLIT(-7319221461883452.0) * 2 / FRAC_BITS,
	FLIT(-46002102531574553.0) * 2 / FRAC_BITS_2,
	FLIT(-63819961539866828.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-21579358940480801.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1780 / 2048) */
	FLIT(-7290011814141765.0) * 2 / FRAC_BITS,
	FLIT(-66087709421634169.0) * 2 / FRAC_BITS_2,
	FLIT(-63814589919571943.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-66667431347454950.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1781 / 2048) */
	FLIT(-7260818571707171.0) * 2 / FRAC_BITS,
	FLIT(-32663715058127212.0) * 2 / FRAC_BITS_2,
	FLIT(-37683196201459624.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-36042198834301652.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1782 / 2048) */
	FLIT(-7231641716162258.0) * 2 / FRAC_BITS,
	FLIT(-55242134186051646.0) * 2 / FRAC_BITS_2,
	FLIT(-16041972874403098.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-55550425231331447.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1783 / 2048) */
	FLIT(-7202481229120614.0) * 2 / FRAC_BITS,
	FLIT(-30587899517722523.0) * 2 / FRAC_BITS_2,
	FLIT(-59732110908901821.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-60455646609292427.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1784 / 2048) */
	FLIT(-7173337092226752.0) * 2 / FRAC_BITS,
	FLIT(-37623307201888463.0) * 2 / FRAC_BITS_2,
	FLIT(-39660569446207947.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-57945939240497011.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1785 / 2048) */
	FLIT(-7144209287156045.0) * 2 / FRAC_BITS,
	FLIT(-25792430837708091.0) * 2 / FRAC_BITS_2,
	FLIT(-67826918674632805.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-56815687584360356.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1786 / 2048) */
	FLIT(-7115097795614654.0) * 2 / FRAC_BITS,
	FLIT(-21817436355773685.0) * 2 / FRAC_BITS_2,
	FLIT(-20718912156715962.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-62826191901443362.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1787 / 2048) */
	FLIT(-7086002599339460.0) * 2 / FRAC_BITS,
	FLIT(-62166281837093563.0) * 2 / FRAC_BITS_2,
	FLIT(-16339710345604406.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-41278261276560654.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1788 / 2048) */
	FLIT(-7056923680097997.0) * 2 / FRAC_BITS,
	FLIT(-67357786855517386.0) * 2 / FRAC_BITS_2,
	FLIT(-64660820184195209.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-49630495053210175.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1789 / 2048) */
	FLIT(-7027861019688381.0) * 2 / FRAC_BITS,
	FLIT(-18345427165563063.0) * 2 / FRAC_BITS_2,
	FLIT(-41917189906377495.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-71518474866277427.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1790 / 2048) */
	FLIT(-6998814599939241.0) * 2 / FRAC_BITS,
	FLIT(-2587858482191483.0) * 2 / FRAC_BITS_2,
	FLIT(-55566460314543140.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-23223330295792711.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1791 / 2048) */
	FLIT(-6969784402709653.0) * 2 / FRAC_BITS,
	FLIT(-57702324815801801.0) * 2 / FRAC_BITS_2,
	FLIT(-49903672440939547.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-43025692637857427.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1792 / 2048) */
	FLIT(-6940770409889074.0) * 2 / FRAC_BITS,
	FLIT(-28827663693903373.0) * 2 / FRAC_BITS_2,
	FLIT(-12345744387038207.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-20068400618597617.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1793 / 2048) */
	FLIT(-6911772603397268.0) * 2 / FRAC_BITS,
	FLIT(-16111770700486692.0) * 2 / FRAC_BITS_2,
	FLIT(-37728456591490603.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-39300885972055335.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1794 / 2048) */
	FLIT(-6882790965184243.0) * 2 / FRAC_BITS,
	FLIT(-43183525847490176.0) * 2 / FRAC_BITS_2,
	FLIT(-70707666348267056.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-62772862041205387.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1795 / 2048) */
	FLIT(-6853825477230184.0) * 2 / FRAC_BITS,
	FLIT(-27427559891265268.0) * 2 / FRAC_BITS_2,
	FLIT(-57794258817027824.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-9507825629703224.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1796 / 2048) */
	FLIT(-6824876121545382.0) * 2 / FRAC_BITS,
	FLIT(-52016505652508473.0) * 2 / FRAC_BITS_2,
	FLIT(-41358426696401466.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-11297617339625730.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1797 / 2048) */
	FLIT(-6795942880170172.0) * 2 / FRAC_BITS,
	FLIT(-2906833629060457.0) * 2 / FRAC_BITS_2,
	FLIT(-31420906170633119.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-1270958919525454.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1798 / 2048) */
	FLIT(-6767025735174860.0) * 2 / FRAC_BITS,
	FLIT(-11905150380056320.0) * 2 / FRAC_BITS_2,
	FLIT(-54683633987936178.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-31661824925312789.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1799 / 2048) */
	FLIT(-6738124668659662.0) * 2 / FRAC_BITS,
	FLIT(-48435469683875403.0) * 2 / FRAC_BITS_2,
	FLIT(-4060905750618758.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-43724047836160605.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1800 / 2048) */
	FLIT(-6709239662754636.0) * 2 / FRAC_BITS,
	FLIT(-29057090441495220.0) * 2 / FRAC_BITS_2,
	FLIT(-64452776142398334.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-60687017041706416.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1801 / 2048) */
	FLIT(-6680370699619613.0) * 2 / FRAC_BITS,
	FLIT(-12343037950048457.0) * 2 / FRAC_BITS_2,
	FLIT(-62926393444871957.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-5019744195945929.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1802 / 2048) */
	FLIT(-6651517761444133.0) * 2 / FRAC_BITS,
	FLIT(-46729198001855151.0) * 2 / FRAC_BITS_2,
	FLIT(-62390942564585265.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-6475669472777830.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1803 / 2048) */
	FLIT(-6622680830447381.0) * 2 / FRAC_BITS,
	FLIT(-31577979744812507.0) * 2 / FRAC_BITS_2,
	FLIT(-62387323759076337.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-7038661665704584.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1804 / 2048) */
	FLIT(-6593859888878117.0) * 2 / FRAC_BITS,
	FLIT(-23758108578113358.0) * 2 / FRAC_BITS_2,
	FLIT(-3406360070300363.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-20552695876723013.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1805 / 2048) */
	FLIT(-6565054919014613.0) * 2 / FRAC_BITS,
	FLIT(-52948034177358529.0) * 2 / FRAC_BITS_2,
	FLIT(-62348576666570215.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-19870340459410913.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1806 / 2048) */
	FLIT(-6536265903164589.0) * 2 / FRAC_BITS,
	FLIT(-22080083324690040.0) * 2 / FRAC_BITS_2,
	FLIT(-15648553602323212.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-63516571779045039.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1807 / 2048) */
	FLIT(-6507492823665143.0) * 2 / FRAC_BITS,
	FLIT(-53169874138977861.0) * 2 / FRAC_BITS_2,
	FLIT(-23920731905090355.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-19765152101343393.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1808 / 2048) */
	FLIT(-6478735662882692.0) * 2 / FRAC_BITS,
	FLIT(-53508607751726510.0) * 2 / FRAC_BITS_2,
	FLIT(-47203555582248254.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-23757576122187493.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1809 / 2048) */
	FLIT(-6449994403212903.0) * 2 / FRAC_BITS,
	FLIT(-15384594456258973.0) * 2 / FRAC_BITS_2,
	FLIT(-54908425407982669.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-39097004521451979.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1810 / 2048) */
	FLIT(-6421269027080628.0) * 2 / FRAC_BITS,
	FLIT(-40484746830171540.0) * 2 / FRAC_BITS_2,
	FLIT(-1084611608409860.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-5133466871787308.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1811 / 2048) */
	FLIT(-6392559516939844.0) * 2 / FRAC_BITS,
	FLIT(-16875660886996372.0) * 2 / FRAC_BITS_2,
	FLIT(-42181143356773794.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-7050387584515755.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1812 / 2048) */
	FLIT(-6363865855273583.0) * 2 / FRAC_BITS,
	FLIT(-29385576249363702.0) * 2 / FRAC_BITS_2,
	FLIT(-46483996628971438.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-29123321677881545.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1813 / 2048) */
	FLIT(-6335188024593872.0) * 2 / FRAC_BITS,
	FLIT(-62192879608255460.0) * 2 / FRAC_BITS_2,
	FLIT(-9855638747991530.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-22384667742417808.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1814 / 2048) */
	FLIT(-6306526007441669.0) * 2 / FRAC_BITS,
	FLIT(-2385176896160742.0) * 2 / FRAC_BITS_2,
	FLIT(-24304675992837019.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-69485051866041459.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1815 / 2048) */
	FLIT(-6277879786386794.0) * 2 / FRAC_BITS,
	FLIT(-16504400260041733.0) * 2 / FRAC_BITS_2,
	FLIT(-43838062154021502.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-26251832590876923.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1816 / 2048) */
	FLIT(-6249249344027873.0) * 2 / FRAC_BITS,
	FLIT(-2999291631623596.0) * 2 / FRAC_BITS_2,
	FLIT(-52565643779650624.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-915833888822594.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1817 / 2048) */
	FLIT(-6220634662992268.0) * 2 / FRAC_BITS,
	FLIT(-66098498116150955.0) * 2 / FRAC_BITS_2,
	FLIT(-67119411635646016.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-46371615517826132.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1818 / 2048) */
	FLIT(-6192035725936020.0) * 2 / FRAC_BITS,
	FLIT(-65507597377695695.0) * 2 / FRAC_BITS_2,
	FLIT(-61234223936147245.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-41581490201903624.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1819 / 2048) */
	FLIT(-6163452515543780.0) * 2 / FRAC_BITS,
	FLIT(-43328421468105689.0) * 2 / FRAC_BITS_2,
	FLIT(-5049382017685404.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-8977921197835886.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1820 / 2048) */
	FLIT(-6134885014528749.0) * 2 / FRAC_BITS,
	FLIT(-14949881393956331.0) * 2 / FRAC_BITS_2,
	FLIT(-57618404852332103.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-62124716369691031.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1821 / 2048) */
	FLIT(-6106333205632614.0) * 2 / FRAC_BITS,
	FLIT(-60617850896063313.0) * 2 / FRAC_BITS_2,
	FLIT(-43144690052587258.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-35761013996792449.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1822 / 2048) */
	FLIT(-6077797071625489.0) * 2 / FRAC_BITS,
	FLIT(-69124757274501741.0) * 2 / FRAC_BITS_2,
	FLIT(-33406998027273681.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-16332269388853695.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1823 / 2048) */
	FLIT(-6049276595305848.0) * 2 / FRAC_BITS,
	FLIT(-70326753424893332.0) * 2 / FRAC_BITS_2,
	FLIT(-2699110158811130.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-57795195486605797.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1824 / 2048) */
	FLIT(-6020771759500466.0) * 2 / FRAC_BITS,
	FLIT(-3526274959243210.0) * 2 / FRAC_BITS_2,
	FLIT(-68439241136132954.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-11858415040528202.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1825 / 2048) */
	FLIT(-5992282547064353.0) * 2 / FRAC_BITS,
	FLIT(-2543357580240279.0) * 2 / FRAC_BITS_2,
	FLIT(-16814955373050915.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-31927561003938790.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1826 / 2048) */
	FLIT(-5963808940880697.0) * 2 / FRAC_BITS,
	FLIT(-44513830137861728.0) * 2 / FRAC_BITS_2,
	FLIT(-991024740195130.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-46244065861563721.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1827 / 2048) */
	FLIT(-5935350923860801.0) * 2 / FRAC_BITS,
	FLIT(-43238068727778405.0) * 2 / FRAC_BITS_2,
	FLIT(-56993991549288773.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-42393142207095332.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1828 / 2048) */
	FLIT(-5906908478944019.0) * 2 / FRAC_BITS,
	FLIT(-26752270509939389.0) * 2 / FRAC_BITS_2,
	FLIT(-68714646121374740.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-23355996200997422.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1829 / 2048) */
	FLIT(-5878481589097696.0) * 2 / FRAC_BITS,
	FLIT(-38794359329039195.0) * 2 / FRAC_BITS_2,
	FLIT(-51045669258851238.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-30518518900812829.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1830 / 2048) */
	FLIT(-5850070237317108.0) * 2 / FRAC_BITS,
	FLIT(-52355134292448503.0) * 2 / FRAC_BITS_2,
	FLIT(-24961004774901889.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-29458692137562922.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1831 / 2048) */
	FLIT(-5821674406625400.0) * 2 / FRAC_BITS,
	FLIT(-39390236450358490.0) * 2 / FRAC_BITS_2,
	FLIT(-11926333511054815.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-1852218719008832.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1832 / 2048) */
	FLIT(-5793294080073524.0) * 2 / FRAC_BITS,
	FLIT(-52538283971981344.0) * 2 / FRAC_BITS_2,
	FLIT(-12203787220429436.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-18506609127768849.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1833 / 2048) */
	FLIT(-5764929240740181.0) * 2 / FRAC_BITS,
	FLIT(-30575488875639261.0) * 2 / FRAC_BITS_2,
	FLIT(-24643053644662.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-24812988195726130.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1834 / 2048) */
	FLIT(-5736579871731757.0) * 2 / FRAC_BITS,
	FLIT(-48143534983696699.0) * 2 / FRAC_BITS_2,
	FLIT(-24522995652758195.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-26395211067054135.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1835 / 2048) */
	FLIT(-5708245956182267.0) * 2 / FRAC_BITS,
	FLIT(-905389290664075.0) * 2 / FRAC_BITS_2,
	FLIT(-42385708196566278.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-15991306049716429.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1836 / 2048) */
	FLIT(-5679927477253289.0) * 2 / FRAC_BITS,
	FLIT(-23126876922860546.0) * 2 / FRAC_BITS_2,
	FLIT(-57953485855362355.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-40593776587408231.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1837 / 2048) */
	FLIT(-5651624418133910.0) * 2 / FRAC_BITS,
	FLIT(-52378236479184926.0) * 2 / FRAC_BITS_2,
	FLIT(-17590444620506309.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-70517841485318937.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1838 / 2048) */
	FLIT(-5623336762040663.0) * 2 / FRAC_BITS,
	FLIT(-54526563656811481.0) * 2 / FRAC_BITS_2,
	FLIT(-13461611481802359.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-16343376397063609.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1839 / 2048) */
	FLIT(-5595064492217467.0) * 2 / FRAC_BITS,
	FLIT(-44289594655616591.0) * 2 / FRAC_BITS_2,
	FLIT(-25887228162265858.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-42250471529263755.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1840 / 2048) */
	FLIT(-5566807591935568.0) * 2 / FRAC_BITS,
	FLIT(-45427743589129000.0) * 2 / FRAC_BITS_2,
	FLIT(-55189082386404570.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-47213565189319689.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1841 / 2048) */
	FLIT(-5538566044493480.0) * 2 / FRAC_BITS,
	FLIT(-62593859659371458.0) * 2 / FRAC_BITS_2,
	FLIT(-67151893220091662.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-8264912335411166.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1842 / 2048) */
	FLIT(-5510339833216926.0) * 2 / FRAC_BITS,
	FLIT(-64802720750149816.0) * 2 / FRAC_BITS_2,
	FLIT(-17705563462189333.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-61097436744039825.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1843 / 2048) */
	FLIT(-5482128941458778.0) * 2 / FRAC_BITS,
	FLIT(-52540018437091984.0) * 2 / FRAC_BITS_2,
	FLIT(-19545741511947467.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-42457073392902446.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1844 / 2048) */
	FLIT(-5453933352598998.0) * 2 / FRAC_BITS,
	FLIT(-64357950978548223.0) * 2 / FRAC_BITS_2,
	FLIT(-32003681647621690.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-47584933414023862.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1845 / 2048) */
	FLIT(-5425753050044581.0) * 2 / FRAC_BITS,
	FLIT(-50862277945815053.0) * 2 / FRAC_BITS_2,
	FLIT(-5364347294113370.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-4290713378457317.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1846 / 2048) */
	FLIT(-5397588017229494.0) * 2 / FRAC_BITS,
	FLIT(-48398990852932594.0) * 2 / FRAC_BITS_2,
	FLIT(-49859950107382257.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-3996591780374829.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1847 / 2048) */
	FLIT(-5369438237614620.0) * 2 / FRAC_BITS,
	FLIT(-3884985396569723.0) * 2 / FRAC_BITS_2,
	FLIT(-56909982578102129.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-11503918762194054.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1848 / 2048) */
	FLIT(-5341303694687696.0) * 2 / FRAC_BITS,
	FLIT(-43379142880151580.0) * 2 / FRAC_BITS_2,
	FLIT(-65746611660402317.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-41428827707430364.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1849 / 2048) */
	FLIT(-5313184371963261.0) * 2 / FRAC_BITS,
	FLIT(-31435329966298977.0) * 2 / FRAC_BITS_2,
	FLIT(-55530746042519997.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-40083812213253064.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1850 / 2048) */
	FLIT(-5285080252982592.0) * 2 / FRAC_BITS,
	FLIT(-6467539328741642.0) * 2 / FRAC_BITS_2,
	FLIT(-26484459690335500.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-68179947477215147.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1851 / 2048) */
	FLIT(-5256991321313648.0) * 2 / FRAC_BITS,
	FLIT(-50938583562544071.0) * 2 / FRAC_BITS_2,
	FLIT(-38869402779480904.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-1908016997369321.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1852 / 2048) */
	FLIT(-5228917560551016.0) * 2 / FRAC_BITS,
	FLIT(-28681338476020265.0) * 2 / FRAC_BITS_2,
	FLIT(-52101897275222575.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-49176732789595270.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1853 / 2048) */
	FLIT(-5200858954315847.0) * 2 / FRAC_BITS,
	FLIT(-54007234294379299.0) * 2 / FRAC_BITS_2,
	FLIT(-13829360252068845.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-49785085167714487.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1854 / 2048) */
	FLIT(-5172815486255805.0) * 2 / FRAC_BITS,
	FLIT(-35241039560360945.0) * 2 / FRAC_BITS_2,
	FLIT(-65394424474318286.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-68064971906173537.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1855 / 2048) */
	FLIT(-5144787140045005.0) * 2 / FRAC_BITS,
	FLIT(-22028039288919945.0) * 2 / FRAC_BITS_2,
	FLIT(-84461555510297.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-63106332132462203.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1856 / 2048) */
	FLIT(-5116773899383958.0) * 2 / FRAC_BITS,
	FLIT(-59340895738600676.0) * 2 / FRAC_BITS_2,
	FLIT(-21515780736272616.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-47569805518783872.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1857 / 2048) */
	FLIT(-5088775747999516.0) * 2 / FRAC_BITS,
	FLIT(-52553466921232316.0) * 2 / FRAC_BITS_2,
	FLIT(-20685296640046408.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-21789057318464380.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1858 / 2048) */
	FLIT(-5060792669644812.0) * 2 / FRAC_BITS,
	FLIT(-3833805121589834.0) * 2 / FRAC_BITS_2,
	FLIT(-63829276487675144.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-26584030728353398.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1859 / 2048) */
	FLIT(-5032824648099203.0) * 2 / FRAC_BITS,
	FLIT(-43359969849387986.0) * 2 / FRAC_BITS_2,
	FLIT(-19002051236614607.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-32163509584170081.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1860 / 2048) */
	FLIT(-5004871667168219.0) * 2 / FRAC_BITS,
	FLIT(-39150393900131190.0) * 2 / FRAC_BITS_2,
	FLIT(-65394241322862729.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-14435527927382126.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1861 / 2048) */
	FLIT(-4976933710683501.0) * 2 / FRAC_BITS,
	FLIT(-10452555447950254.0) * 2 / FRAC_BITS_2,
	FLIT(-43487264861338847.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-70123821264186932.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1862 / 2048) */
	FLIT(-4949010762502746.0) * 2 / FRAC_BITS,
	FLIT(-47618050680448811.0) * 2 / FRAC_BITS_2,
	FLIT(-9506902659292457.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-64617748242866515.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1863 / 2048) */
	FLIT(-4921102806509655.0) * 2 / FRAC_BITS,
	FLIT(-26659362663459185.0) * 2 / FRAC_BITS_2,
	FLIT(-8736266342222341.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-25814990880679024.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1864 / 2048) */
	FLIT(-4893209826613871.0) * 2 / FRAC_BITS,
	FLIT(-55202100240270797.0) * 2 / FRAC_BITS_2,
	FLIT(-35137946907650933.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-28039881599842318.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1865 / 2048) */
	FLIT(-4865331806750929.0) * 2 / FRAC_BITS,
	FLIT(-64530820652320741.0) * 2 / FRAC_BITS_2,
	FLIT(-55831988077671188.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-24372909541135402.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1866 / 2048) */
	FLIT(-4837468730882197.0) * 2 / FRAC_BITS,
	FLIT(-60903223846461716.0) * 2 / FRAC_BITS_2,
	FLIT(-2505252470503214.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-34160663054781444.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1867 / 2048) */
	FLIT(-4809620582994822.0) * 2 / FRAC_BITS,
	FLIT(-27291845193702249.0) * 2 / FRAC_BITS_2,
	FLIT(-55950393594656888.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-7451935874512509.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1868 / 2048) */
	FLIT(-4781787347101673.0) * 2 / FRAC_BITS,
	FLIT(-51979571708718114.0) * 2 / FRAC_BITS_2,
	FLIT(-54069887444459862.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-15897956992010438.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1869 / 2048) */
	FLIT(-4753969007241290.0) * 2 / FRAC_BITS,
	FLIT(-35456337190064288.0) * 2 / FRAC_BITS_2,
	FLIT(-67066412661388933.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-31147259514913201.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1870 / 2048) */
	FLIT(-4726165547477824.0) * 2 / FRAC_BITS,
	FLIT(-56446737034778570.0) * 2 / FRAC_BITS_2,
	FLIT(-13691981097052823.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-11295183946953707.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1871 / 2048) */
	FLIT(-4698376951900987.0) * 2 / FRAC_BITS,
	FLIT(-27940234065750807.0) * 2 / FRAC_BITS_2,
	FLIT(-45420447908010849.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-33256384899618458.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1872 / 2048) */
	FLIT(-4670603204625993.0) * 2 / FRAC_BITS,
	FLIT(-12284327479108786.0) * 2 / FRAC_BITS_2,
	FLIT(-47744972033061653.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-45902805372738906.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1873 / 2048) */
	FLIT(-4642844289793506.0) * 2 / FRAC_BITS,
	FLIT(-42385392475019614.0) * 2 / FRAC_BITS_2,
	FLIT(-63996999521850062.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-66218236798526231.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1874 / 2048) */
	FLIT(-4615100191569587.0) * 2 / FRAC_BITS,
	FLIT(-25444281287824804.0) * 2 / FRAC_BITS_2,
	FLIT(-37236727813469783.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-59643919554220798.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1875 / 2048) */
	FLIT(-4587370894145636.0) * 2 / FRAC_BITS,
	FLIT(-17423525883187003.0) * 2 / FRAC_BITS_2,
	FLIT(-22149258607901809.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-15126441902986197.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1876 / 2048) */
	FLIT(-4559656381738341.0) * 2 / FRAC_BITS,
	FLIT(-3521603150358908.0) * 2 / FRAC_BITS_2,
	FLIT(-32555470156053952.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-24975406997550896.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1877 / 2048) */
	FLIT(-4531956638589622.0) * 2 / FRAC_BITS,
	FLIT(-49312104961614643.0) * 2 / FRAC_BITS_2,
	FLIT(-2711146951446660.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-65031379700980820.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1878 / 2048) */
	FLIT(-4504271648966581.0) * 2 / FRAC_BITS,
	FLIT(-29881116701138318.0) * 2 / FRAC_BITS_2,
	FLIT(-2713491108121572.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-46477546737200250.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1879 / 2048) */
	FLIT(-4476601397161443.0) * 2 / FRAC_BITS,
	FLIT(-17793676425869850.0) * 2 / FRAC_BITS_2,
	FLIT(-30073806090893508.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-14687557396763260.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1880 / 2048) */
	FLIT(-4448945867491506.0) * 2 / FRAC_BITS,
	FLIT(-32819706617278084.0) * 2 / FRAC_BITS_2,
	FLIT(-56563653129710112.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-9253691343840431.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1881 / 2048) */
	FLIT(-4421305044299088.0) * 2 / FRAC_BITS,
	FLIT(-18077754145491418.0) * 2 / FRAC_BITS_2,
	FLIT(-49782514371569128.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-33218842129360949.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1882 / 2048) */
	FLIT(-4393678911951471.0) * 2 / FRAC_BITS,
	FLIT(-42563867615737155.0) * 2 / FRAC_BITS_2,
	FLIT(-26075598406126077.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-70622766503593945.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1883 / 2048) */
	FLIT(-4366067454840852.0) * 2 / FRAC_BITS,
	FLIT(-9457122372942560.0) * 2 / FRAC_BITS_2,
	FLIT(-10737309659854545.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-6863924843703841.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1884 / 2048) */
	FLIT(-4338470657384285.0) * 2 / FRAC_BITS,
	FLIT(-23090869395660352.0) * 2 / FRAC_BITS_2,
	FLIT(-31570504239019376.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-40047853141216197.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1885 / 2048) */
	FLIT(-4310888504023633.0) * 2 / FRAC_BITS,
	FLIT(-45463113438653634.0) * 2 / FRAC_BITS_2,
	FLIT(-66788441201566513.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-17568527231949350.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1886 / 2048) */
	FLIT(-4283320979225513.0) * 2 / FRAC_BITS,
	FLIT(-67232931093448832.0) * 2 / FRAC_BITS_2,
	FLIT(-68158247576047541.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-62874855563998526.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1887 / 2048) */
	FLIT(-4255768067481245.0) * 2 / FRAC_BITS,
	FLIT(-537325810106968.0) * 2 / FRAC_BITS_2,
	FLIT(-19985169403299521.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-48086707022916962.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1888 / 2048) */
	FLIT(-4228229753306795.0) * 2 / FRAC_BITS,
	FLIT(-14172510649655615.0) * 2 / FRAC_BITS_2,
	FLIT(-17877816007187676.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-46426499494283911.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1889 / 2048) */
	FLIT(-4200706021242730.0) * 2 / FRAC_BITS,
	FLIT(-14071094900540933.0) * 2 / FRAC_BITS_2,
	FLIT(-50728204292144237.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-62239226529307673.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1890 / 2048) */
	FLIT(-4173196855854160.0) * 2 / FRAC_BITS,
	FLIT(-70483312247853275.0) * 2 / FRAC_BITS_2,
	FLIT(-67704598884215324.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-25166845209164668.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1891 / 2048) */
	FLIT(-4145702241730691.0) * 2 / FRAC_BITS,
	FLIT(-62448437751084473.0) * 2 / FRAC_BITS_2,
	FLIT(-25902469955366283.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-55264797061166568.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1892 / 2048) */
	FLIT(-4118222163486368.0) * 2 / FRAC_BITS,
	FLIT(-52734389521760518.0) * 2 / FRAC_BITS_2,
	FLIT(-33571210062671166.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-17996068141638389.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1893 / 2048) */
	FLIT(-4090756605759627.0) * 2 / FRAC_BITS,
	FLIT(-24119865909721277.0) * 2 / FRAC_BITS_2,
	FLIT(-15827759041715648.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-30681106271922149.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1894 / 2048) */
	FLIT(-4063305553213241.0) * 2 / FRAC_BITS,
	FLIT(-57851682238980298.0) * 2 / FRAC_BITS_2,
	FLIT(-68091914197375199.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-44166252819607889.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1895 / 2048) */
	FLIT(-4035868990534273.0) * 2 / FRAC_BITS,
	FLIT(-17497453525130417.0) * 2 / FRAC_BITS_2,
	FLIT(-52628941495752016.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-63056721703546250.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1896 / 2048) */
	FLIT(-4008446902434018.0) * 2 / FRAC_BITS,
	FLIT(-35199299747769565.0) * 2 / FRAC_BITS_2,
	FLIT(-44156717320440613.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-29501558849359651.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1897 / 2048) */
	FLIT(-3981039273647958.0) * 2 / FRAC_BITS,
	FLIT(-70915415139230883.0) * 2 / FRAC_BITS_2,
	FLIT(-2969780141165689.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-17503278441113898.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1898 / 2048) */
	FLIT(-3953646088935709.0) * 2 / FRAC_BITS,
	FLIT(-57828188655781781.0) * 2 / FRAC_BITS_2,
	FLIT(-107151263714234.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-17143349334971279.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1899 / 2048) */
	FLIT(-3926267333080968.0) * 2 / FRAC_BITS,
	FLIT(-57427449215298474.0) * 2 / FRAC_BITS_2,
	FLIT(-45869584158315021.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-21043834027652511.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1900 / 2048) */
	FLIT(-3898902990891465.0) * 2 / FRAC_BITS,
	FLIT(-63950304438862929.0) * 2 / FRAC_BITS_2,
	FLIT(-26135723601636428.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-38355433939735919.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1901 / 2048) */
	FLIT(-3871553047198912.0) * 2 / FRAC_BITS,
	FLIT(-34607876690617612.0) * 2 / FRAC_BITS_2,
	FLIT(-34767614186037546.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-32836736922672770.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1902 / 2048) */
	FLIT(-3844217486858951.0) * 2 / FRAC_BITS,
	FLIT(-1453411921180198.0) * 2 / FRAC_BITS_2,
	FLIT(-36312891959618798.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-69454038241089017.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1903 / 2048) */
	FLIT(-3816896294751104.0) * 2 / FRAC_BITS,
	FLIT(-48688754400899709.0) * 2 / FRAC_BITS_2,
	FLIT(-18950351719975214.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-71101333519459767.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1904 / 2048) */
	FLIT(-3789589455778727.0) * 2 / FRAC_BITS,
	FLIT(-11263885616960481.0) * 2 / FRAC_BITS_2,
	FLIT(-35600530603433638.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-26472179063507148.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1905 / 2048) */
	FLIT(-3762296954868952.0) * 2 / FRAC_BITS,
	FLIT(-47661028973946736.0) * 2 / FRAC_BITS_2,
	FLIT(-11690623217588207.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-27677813146833698.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1906 / 2048) */
	FLIT(-3735018776972645.0) * 2 / FRAC_BITS,
	FLIT(-69220794486866649.0) * 2 / FRAC_BITS_2,
	FLIT(-11596753183339099.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-42415876710089552.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1907 / 2048) */
	FLIT(-3707754907064352.0) * 2 / FRAC_BITS,
	FLIT(-43593213535319974.0) * 2 / FRAC_BITS_2,
	FLIT(-39493904349004863.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-44239323634967303.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1908 / 2048) */
	FLIT(-3680505330142249.0) * 2 / FRAC_BITS,
	FLIT(-19362485374072399.0) * 2 / FRAC_BITS_2,
	FLIT(-62268622774167783.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-46884421135510078.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1909 / 2048) */
	FLIT(-3653270031228094.0) * 2 / FRAC_BITS,
	FLIT(-15931058615269266.0) * 2 / FRAC_BITS_2,
	FLIT(-65742912245942309.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-16508631510911298.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1910 / 2048) */
	FLIT(-3626048995367177.0) * 2 / FRAC_BITS,
	FLIT(-66863967354661411.0) * 2 / FRAC_BITS_2,
	FLIT(-26385328325124174.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-15043163262428809.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1911 / 2048) */
	FLIT(-3598842207628273.0) * 2 / FRAC_BITS,
	FLIT(-56376103200314386.0) * 2 / FRAC_BITS_2,
	FLIT(-60870227594149093.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-26604544537149283.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1912 / 2048) */
	FLIT(-3571649653103588.0) * 2 / FRAC_BITS,
	FLIT(-69509122506943812.0) * 2 / FRAC_BITS_2,
	FLIT(-22919188655216881.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-62686278013871492.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1913 / 2048) */
	FLIT(-3544471316908715.0) * 2 / FRAC_BITS,
	FLIT(-30989756121145875.0) * 2 / FRAC_BITS_2,
	FLIT(-47656893958286236.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-54938270315309328.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1914 / 2048) */
	FLIT(-3517307184182581.0) * 2 / FRAC_BITS,
	FLIT(-1834780886920948.0) * 2 / FRAC_BITS_2,
	FLIT(-2859053971708790.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-68930232607616618.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1915 / 2048) */
	FLIT(-3490157240087400.0) * 2 / FRAC_BITS,
	FLIT(-52809821004707807.0) * 2 / FRAC_BITS_2,
	FLIT(-66746166669166388.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-46258300649471953.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1916 / 2048) */
	FLIT(-3463021469808628.0) * 2 / FRAC_BITS,
	FLIT(-2943539747884768.0) * 2 / FRAC_BITS_2,
	FLIT(-66824140897310735.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-20988925195167374.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1917 / 2048) */
	FLIT(-3435899858554906.0) * 2 / FRAC_BITS,
	FLIT(-31874827668901602.0) * 2 / FRAC_BITS_2,
	FLIT(-59946144139265477.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-39096314657776402.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1918 / 2048) */
	FLIT(-3408792391558021.0) * 2 / FRAC_BITS,
	FLIT(-4276560568196155.0) * 2 / FRAC_BITS_2,
	FLIT(-25416434981414127.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-57020324187802141.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1919 / 2048) */
	FLIT(-3381699054072850.0) * 2 / FRAC_BITS,
	FLIT(-28343217337135468.0) * 2 / FRAC_BITS_2,
	FLIT(-22917171395385339.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-19249907099933127.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1920 / 2048) */
	FLIT(-3354619831377318.0) * 2 / FRAC_BITS,
	FLIT(-14528545220747610.0) * 2 / FRAC_BITS_2,
	FLIT(-32226388071199167.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-30343508520853208.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1921 / 2048) */
	FLIT(-3327554708772345.0) * 2 / FRAC_BITS,
	FLIT(-35944829674783618.0) * 2 / FRAC_BITS_2,
	FLIT(-70458341798643685.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-30161354567097024.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1922 / 2048) */
	FLIT(-3300503671581802.0) * 2 / FRAC_BITS,
	FLIT(-49243697358767160.0) * 2 / FRAC_BITS_2,
	FLIT(-66335706503327123.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-40241632850985771.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1923 / 2048) */
	FLIT(-3273466705152461.0) * 2 / FRAC_BITS,
	FLIT(-56814274779126525.0) * 2 / FRAC_BITS_2,
	FLIT(-61536303080120622.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-11517038492370557.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1924 / 2048) */
	FLIT(-3246443794853948.0) * 2 / FRAC_BITS,
	FLIT(-61752370404283144.0) * 2 / FRAC_BITS_2,
	FLIT(-9776655580998819.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-53395735808247637.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1925 / 2048) */
	FLIT(-3219434926078696.0) * 2 / FRAC_BITS,
	FLIT(-31745578321843363.0) * 2 / FRAC_BITS_2,
	FLIT(-23443094125905791.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-67925846606638080.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1926 / 2048) */
	FLIT(-3192440084241896.0) * 2 / FRAC_BITS,
	FLIT(-15961708840322937.0) * 2 / FRAC_BITS_2,
	FLIT(-4927062227267922.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-49386672860568134.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1927 / 2048) */
	FLIT(-3165459254781451.0) * 2 / FRAC_BITS,
	FLIT(-54624894121597916.0) * 2 / FRAC_BITS_2,
	FLIT(-69532818319353083.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-24914981718519268.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1928 / 2048) */
	FLIT(-3138492423157931.0) * 2 / FRAC_BITS,
	FLIT(-25366975726045638.0) * 2 / FRAC_BITS_2,
	FLIT(-59979130634150945.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-14431195679583229.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1929 / 2048) */
	FLIT(-3111539574854521.0) * 2 / FRAC_BITS,
	FLIT(-2787445293151558.0) * 2 / FRAC_BITS_2,
	FLIT(-2777059041996355.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-41133000195498223.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1930 / 2048) */
	FLIT(-3084600695376977.0) * 2 / FRAC_BITS,
	FLIT(-50330646406174810.0) * 2 / FRAC_BITS_2,
	FLIT(-7544073629691567.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-3497826258566051.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1931 / 2048) */
	FLIT(-3057675770253582.0) * 2 / FRAC_BITS,
	FLIT(-20913707846817880.0) * 2 / FRAC_BITS_2,
	FLIT(-17434811145912308.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-42336279433848721.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1932 / 2048) */
	FLIT(-3030764785035093.0) * 2 / FRAC_BITS,
	FLIT(-14796371357559119.0) * 2 / FRAC_BITS_2,
	FLIT(-58440905128221560.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-11693393356777941.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1933 / 2048) */
	FLIT(-3003867725294699.0) * 2 / FRAC_BITS,
	FLIT(-53513748393872708.0) * 2 / FRAC_BITS_2,
	FLIT(-2370681432763429.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-20432007916935196.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1934 / 2048) */
	FLIT(-2976984576627975.0) * 2 / FRAC_BITS,
	FLIT(-50708929733110249.0) * 2 / FRAC_BITS_2,
	FLIT(-50704148454377978.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-22828530033561840.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1935 / 2048) */
	FLIT(-2950115324652833.0) * 2 / FRAC_BITS,
	FLIT(-7780964851534277.0) * 2 / FRAC_BITS_2,
	FLIT(-35529197286484173.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-1734085643372694.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1936 / 2048) */
	FLIT(-2923259955009476.0) * 2 / FRAC_BITS,
	FLIT(-1975855039294123.0) * 2 / FRAC_BITS_2,
	FLIT(-11611674082822334.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-67965918107951651.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1937 / 2048) */
	FLIT(-2896418453360354.0) * 2 / FRAC_BITS,
	FLIT(-38951459334822735.0) * 2 / FRAC_BITS_2,
	FLIT(-5649498540362002.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-61343302283450381.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1938 / 2048) */
	FLIT(-2869590805390118.0) * 2 / FRAC_BITS,
	FLIT(-58020090920228255.0) * 2 / FRAC_BITS_2,
	FLIT(-19636433314600449.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-18262193485437733.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1939 / 2048) */
	FLIT(-2842776996805573.0) * 2 / FRAC_BITS,
	FLIT(-17984707477901338.0) * 2 / FRAC_BITS_2,
	FLIT(-28820390631246108.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-29564285825070386.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1940 / 2048) */
	FLIT(-2815977013335630.0) * 2 / FRAC_BITS,
	FLIT(-63542288698596383.0) * 2 / FRAC_BITS_2,
	FLIT(-55390482484941616.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-60942166873227451.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1941 / 2048) */
	FLIT(-2789190840731267.0) * 2 / FRAC_BITS,
	FLIT(-51652149009734611.0) * 2 / FRAC_BITS_2,
	FLIT(-68778727202794101.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-55102852360407066.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1942 / 2048) */
	FLIT(-2762418464765477.0) * 2 / FRAC_BITS,
	FLIT(-23110037671627857.0) * 2 / FRAC_BITS_2,
	FLIT(-46738619749299527.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-29893780361257630.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1943 / 2048) */
	FLIT(-2735659871233225.0) * 2 / FRAC_BITS,
	FLIT(-34034835195056211.0) * 2 / FRAC_BITS_2,
	FLIT(-41725506505288361.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-52476811897737151.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1944 / 2048) */
	FLIT(-2708915045951404.0) * 2 / FRAC_BITS,
	FLIT(-67817758333005730.0) * 2 / FRAC_BITS_2,
	FLIT(-57831166064944874.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-8944934212212543.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1945 / 2048) */
	FLIT(-2682183974758790.0) * 2 / FRAC_BITS,
	FLIT(-27508139218687828.0) * 2 / FRAC_BITS_2,
	FLIT(-10885317206341778.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-46163642577803527.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1946 / 2048) */
	FLIT(-2655466643515993.0) * 2 / FRAC_BITS,
	FLIT(-24782719649046804.0) * 2 / FRAC_BITS_2,
	FLIT(-11653970685044858.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-40743277454843883.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1947 / 2048) */
	FLIT(-2628763038105417.0) * 2 / FRAC_BITS,
	FLIT(-28723989835903822.0) * 2 / FRAC_BITS_2,
	FLIT(-71278683280551786.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-67786926583116658.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1948 / 2048) */
	FLIT(-2602073144431213.0) * 2 / FRAC_BITS,
	FLIT(-27303420594844690.0) * 2 / FRAC_BITS_2,
	FLIT(-46302937881242298.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-70341407128267686.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1949 / 2048) */
	FLIT(-2575396948419234.0) * 2 / FRAC_BITS,
	FLIT(-53025679161832638.0) * 2 / FRAC_BITS_2,
	FLIT(-43256868969901319.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-68604916419143950.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1950 / 2048) */
	FLIT(-2548734436016993.0) * 2 / FRAC_BITS,
	FLIT(-650762920800569.0) * 2 / FRAC_BITS_2,
	FLIT(-5441454498565128.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-342230234018687.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1951 / 2048) */
	FLIT(-2522085593193613.0) * 2 / FRAC_BITS,
	FLIT(-29602205193984931.0) * 2 / FRAC_BITS_2,
	FLIT(-3366837628129138.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-40310565963954539.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1952 / 2048) */
	FLIT(-2495450405939790.0) * 2 / FRAC_BITS,
	FLIT(-37826589071700892.0) * 2 / FRAC_BITS_2,
	FLIT(-64792210741630657.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-71172777654637650.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1953 / 2048) */
	FLIT(-2468828860267744.0) * 2 / FRAC_BITS,
	FLIT(-8519021668561309.0) * 2 / FRAC_BITS_2,
	FLIT(-68646064064679718.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-50972950132768313.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1954 / 2048) */
	FLIT(-2442220942211175.0) * 2 / FRAC_BITS,
	FLIT(-4710361894491294.0) * 2 / FRAC_BITS_2,
	FLIT(-50732858546236151.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-57461289812748340.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1955 / 2048) */
	FLIT(-2415626637825221.0) * 2 / FRAC_BITS,
	FLIT(-27863965512186109.0) * 2 / FRAC_BITS_2,
	FLIT(-6386274564872065.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-53617343634229220.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1956 / 2048) */
	FLIT(-2389045933186414.0) * 2 / FRAC_BITS,
	FLIT(-28687394847440777.0) * 2 / FRAC_BITS_2,
	FLIT(-7460055744104442.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-64752988990864367.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1957 / 2048) */
	FLIT(-2362478814392634.0) * 2 / FRAC_BITS,
	FLIT(-70134253557728654.0) * 2 / FRAC_BITS_2,
	FLIT(-27077371933556380.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-45733388804203040.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1958 / 2048) */
	FLIT(-2335925267563069.0) * 2 / FRAC_BITS,
	FLIT(-66110643387134767.0) * 2 / FRAC_BITS_2,
	FLIT(-12931475083808950.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-57684349915434488.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1959 / 2048) */
	FLIT(-2309385278838168.0) * 2 / FRAC_BITS,
	FLIT(-32610303095554980.0) * 2 / FRAC_BITS_2,
	FLIT(-65338629966772464.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-43438109524285082.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1960 / 2048) */
	FLIT(-2282858834379598.0) * 2 / FRAC_BITS,
	FLIT(-58620320941953210.0) * 2 / FRAC_BITS_2,
	FLIT(-45351643632286607.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-11045247685263585.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1961 / 2048) */
	FLIT(-2256345920370204.0) * 2 / FRAC_BITS,
	FLIT(-68830528299246757.0) * 2 / FRAC_BITS_2,
	FLIT(-24300306322104949.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-54377351571018809.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1962 / 2048) */
	FLIT(-2229846523013963.0) * 2 / FRAC_BITS,
	FLIT(-26640521666596547.0) * 2 / FRAC_BITS_2,
	FLIT(-13707040461651364.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-18136242792518799.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1963 / 2048) */
	FLIT(-2203360628535940.0) * 2 / FRAC_BITS,
	FLIT(-979248728669050.0) * 2 / FRAC_BITS_2,
	FLIT(-59530269023066167.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-40836128908121751.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1964 / 2048) */
	FLIT(-2176888223182247.0) * 2 / FRAC_BITS,
	FLIT(-24855339050911610.0) * 2 / FRAC_BITS_2,
	FLIT(-25510476525489463.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-62052638532515996.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1965 / 2048) */
	FLIT(-2150429293220001.0) * 2 / FRAC_BITS,
	FLIT(-33844416510540936.0) * 2 / FRAC_BITS_2,
	FLIT(-44403639336919155.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-36670318969309727.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1966 / 2048) */
	FLIT(-2123983824937279.0) * 2 / FRAC_BITS,
	FLIT(-28604528456762183.0) * 2 / FRAC_BITS_2,
	FLIT(-13890170980586506.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-8089331261874781.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1967 / 2048) */
	FLIT(-2097551804643076.0) * 2 / FRAC_BITS,
	FLIT(-29050159910249178.0) * 2 / FRAC_BITS_2,
	FLIT(-23647359256038484.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-18455901081524190.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1968 / 2048) */
	FLIT(-2071133218667263.0) * 2 / FRAC_BITS,
	FLIT(-36333732725067442.0) * 2 / FRAC_BITS_2,
	FLIT(-45195553260842138.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-46004798895532045.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1969 / 2048) */
	FLIT(-2044728053360545.0) * 2 / FRAC_BITS,
	FLIT(-2610792447692081.0) * 2 / FRAC_BITS_2,
	FLIT(-4683345478780147.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-14240248863772250.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1970 / 2048) */
	FLIT(-2018336295094416.0) * 2 / FRAC_BITS,
	FLIT(-24737952301848964.0) * 2 / FRAC_BITS_2,
	FLIT(-70925376694783137.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-10784771530820928.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1971 / 2048) */
	FLIT(-1991957930261121.0) * 2 / FRAC_BITS,
	FLIT(-41304025471750789.0) * 2 / FRAC_BITS_2,
	FLIT(-10193345295597454.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-52243072212372852.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1972 / 2048) */
	FLIT(-1965592945273611.0) * 2 / FRAC_BITS,
	FLIT(-41777117661657784.0) * 2 / FRAC_BITS_2,
	FLIT(-44770566952668047.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-53973583963693403.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1973 / 2048) */
	FLIT(-1939241326565501.0) * 2 / FRAC_BITS,
	FLIT(-67168278554251159.0) * 2 / FRAC_BITS_2,
	FLIT(-37772836530947655.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-20281412679824833.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1974 / 2048) */
	FLIT(-1912903060591031.0) * 2 / FRAC_BITS,
	FLIT(-2188334385708203.0) * 2 / FRAC_BITS_2,
	FLIT(-59815475871527101.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-45791113549226619.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1975 / 2048) */
	FLIT(-1886578133825018.0) * 2 / FRAC_BITS,
	FLIT(-23565735189461348.0) * 2 / FRAC_BITS_2,
	FLIT(-1853199785944087.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-55998577748567367.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1976 / 2048) */
	FLIT(-1860266532762822.0) * 2 / FRAC_BITS,
	FLIT(-47177541476476495.0) * 2 / FRAC_BITS_2,
	FLIT(-9427919492299747.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-23571222270768409.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1977 / 2048) */
	FLIT(-1833968243920300.0) * 2 / FRAC_BITS,
	FLIT(-47467865187586549.0) * 2 / FRAC_BITS_2,
	FLIT(-20889990546863389.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-64688806675273322.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1978 / 2048) */
	FLIT(-1807683253833765.0) * 2 / FRAC_BITS,
	FLIT(-24151617999168057.0) * 2 / FRAC_BITS_2,
	FLIT(-26265503530490408.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-60318227828913903.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1979 / 2048) */
	FLIT(-1781411549059944.0) * 2 / FRAC_BITS,
	FLIT(-48526164481379017.0) * 2 / FRAC_BITS_2,
	FLIT(-61518459037613912.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-35628518561969298.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1980 / 2048) */
	FLIT(-1755153116175940.0) * 2 / FRAC_BITS,
	FLIT(-29080024406995818.0) * 2 / FRAC_BITS_2,
	FLIT(-13569661306635341.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-51703935609685955.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1981 / 2048) */
	FLIT(-1728907941779186.0) * 2 / FRAC_BITS,
	FLIT(-61066948041626592.0) * 2 / FRAC_BITS_2,
	FLIT(-70111485671153162.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-41931338460671869.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1982 / 2048) */
	FLIT(-1702676012487409.0) * 2 / FRAC_BITS,
	FLIT(-62985947669631918.0) * 2 / FRAC_BITS_2,
	FLIT(-2806138936119996.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-64697747235302050.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1983 / 2048) */
	FLIT(-1676457314938585.0) * 2 / FRAC_BITS,
	FLIT(-69038928249718922.0) * 2 / FRAC_BITS_2,
	FLIT(-4610534920594586.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-35955496646161718.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1984 / 2048) */
	FLIT(-1650251835790901.0) * 2 / FRAC_BITS,
	FLIT(-24621848679383580.0) * 2 / FRAC_BITS_2,
	FLIT(-33167853251663561.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-56149613444456853.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1985 / 2048) */
	FLIT(-1624059561722711.0) * 2 / FRAC_BITS,
	FLIT(-21575651837825093.0) * 2 / FRAC_BITS_2,
	FLIT(-48151600238764656.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-39655147284117897.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1986 / 2048) */
	FLIT(-1597880479432499.0) * 2 / FRAC_BITS,
	FLIT(-36425835860681710.0) * 2 / FRAC_BITS_2,
	FLIT(-41644077618813633.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-27635042018827282.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1987 / 2048) */
	FLIT(-1571714575638837.0) * 2 / FRAC_BITS,
	FLIT(-36279468998753253.0) * 2 / FRAC_BITS_2,
	FLIT(-21718204853699620.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-38363665685575712.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1988 / 2048) */
	FLIT(-1545561837080344.0) * 2 / FRAC_BITS,
	FLIT(-20011836363001537.0) * 2 / FRAC_BITS_2,
	FLIT(-37593188887336760.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-24974717133875318.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1989 / 2048) */
	FLIT(-1519422250515645.0) * 2 / FRAC_BITS,
	FLIT(-66778143440093830.0) * 2 / FRAC_BITS_2,
	FLIT(-70999758249457084.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-52306583817648437.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1990 / 2048) */
	FLIT(-1493295802723335.0) * 2 / FRAC_BITS,
	FLIT(-31540215036745973.0) * 2 / FRAC_BITS_2,
	FLIT(-47431360873171790.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-39179203016211935.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1991 / 2048) */
	FLIT(-1467182480501932.0) * 2 / FRAC_BITS,
	FLIT(-40507680795672137.0) * 2 / FRAC_BITS_2,
	FLIT(-22259090810574802.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-68207979477694783.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1992 / 2048) */
	FLIT(-1441082270669843.0) * 2 / FRAC_BITS,
	FLIT(-57089454284815812.0) * 2 / FRAC_BITS_2,
	FLIT(-42780217930736905.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-71696168880372753.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1993 / 2048) */
	FLIT(-1414995160065322.0) * 2 / FRAC_BITS,
	FLIT(-31543121433609774.0) * 2 / FRAC_BITS_2,
	FLIT(-33655493715499269.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-4050813728141804.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1994 / 2048) */
	FLIT(-1388921135546428.0) * 2 / FRAC_BITS,
	FLIT(-57839703746152237.0) * 2 / FRAC_BITS_2,
	FLIT(-6830345730319060.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-51605333917162364.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1995 / 2048) */
	FLIT(-1362860183990990.0) * 2 / FRAC_BITS,
	FLIT(-33318932207293048.0) * 2 / FRAC_BITS_2,
	FLIT(-29387546343453418.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-2835262107194170.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1996 / 2048) */
	FLIT(-1336812292296562.0) * 2 / FRAC_BITS,
	FLIT(-46092500849590583.0) * 2 / FRAC_BITS_2,
	FLIT(-40753286124690876.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-12224486179762352.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1997 / 2048) */
	FLIT(-1310777447380388.0) * 2 / FRAC_BITS,
	FLIT(-49021865382361940.0) * 2 / FRAC_BITS_2,
	FLIT(-41790965954113442.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-27519621048106397.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1998 / 2048) */
	FLIT(-1284755636179360.0) * 2 / FRAC_BITS,
	FLIT(-45228207220252152.0) * 2 / FRAC_BITS_2,
	FLIT(-19862849612882040.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-16437864647721274.0) * 2 / FRAC_BITS_4},

	{/* -log[2](1999 / 2048) */
	FLIT(-1258746845649979.0) * 2 / FRAC_BITS,
	FLIT(-64537219455205032.0) * 2 / FRAC_BITS_2,
	FLIT(-13825246751819071.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-14940349194126809.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2000 / 2048) */
	FLIT(-1232751062768318.0) * 2 / FRAC_BITS,
	FLIT(-2894980662439392.0) * 2 / FRAC_BITS_2,
	FLIT(-61980464574630577.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-56840527420060924.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2001 / 2048) */
	FLIT(-1206768274529977.0) * 2 / FRAC_BITS,
	FLIT(-45309603402256422.0) * 2 / FRAC_BITS_2,
	FLIT(-67610941477455969.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-39194798256964196.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2002 / 2048) */
	FLIT(-1180798467950053.0) * 2 / FRAC_BITS,
	FLIT(-14972815359456929.0) * 2 / FRAC_BITS_2,
	FLIT(-6735290016569110.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-53141634937670570.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2003 / 2048) */
	FLIT(-1154841630063092.0) * 2 / FRAC_BITS,
	FLIT(-26440971220731210.0) * 2 / FRAC_BITS_2,
	FLIT(-67807067819542359.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-1841187336588400.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2004 / 2048) */
	FLIT(-1128897747923056.0) * 2 / FRAC_BITS,
	FLIT(-64953860626139010.0) * 2 / FRAC_BITS_2,
	FLIT(-59379637811048085.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-23912350466200033.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2005 / 2048) */
	FLIT(-1102966808603284.0) * 2 / FRAC_BITS,
	FLIT(-5079829023610085.0) * 2 / FRAC_BITS_2,
	FLIT(-70763094703597869.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-33426980310410372.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2006 / 2048) */
	FLIT(-1077048799196447.0) * 2 / FRAC_BITS,
	FLIT(-68666326610640659.0) * 2 / FRAC_BITS_2,
	FLIT(-41132602223583107.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-52830277939193442.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2007 / 2048) */
	FLIT(-1051143706814520.0) * 2 / FRAC_BITS,
	FLIT(-64750410535090755.0) * 2 / FRAC_BITS_2,
	FLIT(-62793035872185897.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-32700875310210854.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2008 / 2048) */
	FLIT(-1025251518588735.0) * 2 / FRAC_BITS,
	FLIT(-5481846334456400.0) * 2 / FRAC_BITS_2,
	FLIT(-47832242089126083.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-39351823897247386.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2009 / 2048) */
	FLIT(-999372221669544.0) * 2 / FRAC_BITS,
	FLIT(-8367914408345106.0) * 2 / FRAC_BITS_2,
	FLIT(-58320808821929578.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-26706538059942422.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2010 / 2048) */
	FLIT(-973505803226584.0) * 2 / FRAC_BITS,
	FLIT(-61280078715131081.0) * 2 / FRAC_BITS_2,
	FLIT(-52436113840214912.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-35250514899806487.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2011 / 2048) */
	FLIT(-947652250448639.0) * 2 / FRAC_BITS,
	FLIT(-10489964476429414.0) * 2 / FRAC_BITS_2,
	FLIT(-52903888249784006.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-13111020351430498.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2012 / 2048) */
	FLIT(-921811550543595.0) * 2 / FRAC_BITS,
	FLIT(-59944569056361175.0) * 2 / FRAC_BITS_2,
	FLIT(-22474359408941717.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-23989631292200823.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2013 / 2048) */
	FLIT(-895983690738412.0) * 2 / FRAC_BITS,
	FLIT(-52378068257949100.0) * 2 / FRAC_BITS_2,
	FLIT(-46135483977066832.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-20475610705542461.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2014 / 2048) */
	FLIT(-870168658279078.0) * 2 / FRAC_BITS,
	FLIT(-54255699371440108.0) * 2 / FRAC_BITS_2,
	FLIT(-23951570233405877.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-24552838033539580.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2015 / 2048) */
	FLIT(-844366440430576.0) * 2 / FRAC_BITS,
	FLIT(-10744066379436539.0) * 2 / FRAC_BITS_2,
	FLIT(-6382919679029522.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-26148335157622332.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2016 / 2048) */
	FLIT(-818577024476842.0) * 2 / FRAC_BITS,
	FLIT(-55954767027105665.0) * 2 / FRAC_BITS_2,
	FLIT(-35478210813016156.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-66880930726239396.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2017 / 2048) */
	FLIT(-792800397720734.0) * 2 / FRAC_BITS,
	FLIT(-37289361887098530.0) * 2 / FRAC_BITS_2,
	FLIT(-11448923158042903.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-40077577152432672.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2018 / 2048) */
	FLIT(-767036547483987.0) * 2 / FRAC_BITS,
	FLIT(-55305506992272990.0) * 2 / FRAC_BITS_2,
	FLIT(-45620158446290955.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-14050390526793904.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2019 / 2048) */
	FLIT(-741285461107182.0) * 2 / FRAC_BITS,
	FLIT(-1471657059451666.0) * 2 / FRAC_BITS_2,
	FLIT(-27207167807383498.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-69686640264854152.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2020 / 2048) */
	FLIT(-715547125949702.0) * 2 / FRAC_BITS,
	FLIT(-39345487598639867.0) * 2 / FRAC_BITS_2,
	FLIT(-58761912368379488.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-37735000580258132.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2021 / 2048) */
	FLIT(-689821529389703.0) * 2 / FRAC_BITS,
	FLIT(-11543581027317141.0) * 2 / FRAC_BITS_2,
	FLIT(-27640074273795950.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-22358353983434645.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2022 / 2048) */
	FLIT(-664108658824069.0) * 2 / FRAC_BITS,
	FLIT(-6268038785676039.0) * 2 / FRAC_BITS_2,
	FLIT(-36394111828333358.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-5390850647367078.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2023 / 2048) */
	FLIT(-638408501668379.0) * 2 / FRAC_BITS,
	FLIT(-65757701577945525.0) * 2 / FRAC_BITS_2,
	FLIT(-58855316819829069.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-32875957508416679.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2024 / 2048) */
	FLIT(-612721045356872.0) * 2 / FRAC_BITS,
	FLIT(-45450677554629598.0) * 2 / FRAC_BITS_2,
	FLIT(-4305967550641577.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-38230483757299228.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2025 / 2048) */
	FLIT(-587046277342404.0) * 2 / FRAC_BITS,
	FLIT(-56184193774697513.0) * 2 / FRAC_BITS_2,
	FLIT(-15527648530448348.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-35441953111420259.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2026 / 2048) */
	FLIT(-561384185096417.0) * 2 / FRAC_BITS,
	FLIT(-48260408860370046.0) * 2 / FRAC_BITS_2,
	FLIT(-61115985408493818.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-31473929719831000.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2027 / 2048) */
	FLIT(-535734756108899.0) * 2 / FRAC_BITS,
	FLIT(-50568247605220834.0) * 2 / FRAC_BITS_2,
	FLIT(-11700450433969590.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-29961454022086070.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2028 / 2048) */
	FLIT(-510097977888349.0) * 2 / FRAC_BITS,
	FLIT(-55935593996342070.0) * 2 / FRAC_BITS_2,
	FLIT(-60791244427156382.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-57615612602979112.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2029 / 2048) */
	FLIT(-484473837961740.0) * 2 / FRAC_BITS,
	FLIT(-57095720670975307.0) * 2 / FRAC_BITS_2,
	FLIT(-60772513188135209.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-64219899261318646.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2030 / 2048) */
	FLIT(-458862323874483.0) * 2 / FRAC_BITS,
	FLIT(-17075958948722577.0) * 2 / FRAC_BITS_2,
	FLIT(-54521679981521016.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-38546652585449840.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2031 / 2048) */
	FLIT(-433263423190388.0) * 2 / FRAC_BITS,
	FLIT(-62219838083938049.0) * 2 / FRAC_BITS_2,
	FLIT(-67935124824086993.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-63148733375156441.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2032 / 2048) */
	FLIT(-407677123491634.0) * 2 / FRAC_BITS,
	FLIT(-33132483753199125.0) * 2 / FRAC_BITS_2,
	FLIT(-51521829184316975.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-69391898663908426.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2033 / 2048) */
	FLIT(-382103412378725.0) * 2 / FRAC_BITS,
	FLIT(-50854922837690645.0) * 2 / FRAC_BITS_2,
	FLIT(-38667603724433952.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-27055089758597637.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2034 / 2048) */
	FLIT(-356542277470461.0) * 2 / FRAC_BITS,
	FLIT(-8578117047000866.0) * 2 / FRAC_BITS_2,
	FLIT(-70336022008226203.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-70570106229829271.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2035 / 2048) */
	FLIT(-330993706403896.0) * 2 / FRAC_BITS,
	FLIT(-6490473294242239.0) * 2 / FRAC_BITS_2,
	FLIT(-47658938892500443.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-59196866045194686.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2036 / 2048) */
	FLIT(-305457686834307.0) * 2 / FRAC_BITS,
	FLIT(-357753705421783.0) * 2 / FRAC_BITS_2,
	FLIT(-25342671957671495.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-64380743313962709.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2037 / 2048) */
	FLIT(-279934206435155.0) * 2 / FRAC_BITS,
	FLIT(-32910916467026502.0) * 2 / FRAC_BITS_2,
	FLIT(-58642305226758606.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-25421995040685703.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2038 / 2048) */
	FLIT(-254423252898052.0) * 2 / FRAC_BITS,
	FLIT(-39216879900308625.0) * 2 / FRAC_BITS_2,
	FLIT(-36835287612543975.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-21440302638731758.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2039 / 2048) */
	FLIT(-228924813932723.0) * 2 / FRAC_BITS,
	FLIT(-18647117282218354.0) * 2 / FRAC_BITS_2,
	FLIT(-62512179673206.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-25228944697060656.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2040 / 2048) */
	FLIT(-203438877266970.0) * 2 / FRAC_BITS,
	FLIT(-69022361181732654.0) * 2 / FRAC_BITS_2,
	FLIT(-55481174287594598.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-36747286965762739.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2041 / 2048) */
	FLIT(-177965430646641.0) * 2 / FRAC_BITS,
	FLIT(-66742135912893636.0) * 2 / FRAC_BITS_2,
	FLIT(-44616776633114105.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-51760660371456404.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2042 / 2048) */
	FLIT(-152504461835590.0) * 2 / FRAC_BITS,
	FLIT(-1686998781952878.0) * 2 / FRAC_BITS_2,
	FLIT(-63980201835945978.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-4416450186101363.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2043 / 2048) */
	FLIT(-127055958615641.0) * 2 / FRAC_BITS,
	FLIT(-30126394964825889.0) * 2 / FRAC_BITS_2,
	FLIT(-3640516167700637.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-47728363996464373.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2044 / 2048) */
	FLIT(-101619908786559.0) * 2 / FRAC_BITS,
	FLIT(-29441034165850723.0) * 2 / FRAC_BITS_2,
	FLIT(-59897984081596673.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-38121474688471769.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2045 / 2048) */
	FLIT(-76196300166009.0) * 2 / FRAC_BITS,
	FLIT(-23735828732507153.0) * 2 / FRAC_BITS_2,
	FLIT(-25763270564171888.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-57422275685231523.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2046 / 2048) */
	FLIT(-50785120589523.0) * 2 / FRAC_BITS,
	FLIT(-39173327865631788.0) * 2 / FRAC_BITS_2,
	FLIT(-14511126487099736.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-5452446495361664.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2047 / 2048) */
	FLIT(-25386357910466.0) * 2 / FRAC_BITS,
	FLIT(-37527871864542306.0) * 2 / FRAC_BITS_2,
	FLIT(-5625768551628193.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-27948915564782066.0) * 2 / FRAC_BITS_4},

	{/* -log[2](2048 / 2048) */
	FLIT(-0.0) * 2 / FRAC_BITS,
	FLIT(-0.0) * 2 / FRAC_BITS_2,
	FLIT(-0.0) * 2 / FRAC_BITS_2 / FRAC_BITS,
	FLIT(-0.0) * 2 / FRAC_BITS_4},
	};

 #elif 64 <= FBITS
  #define MAX_Y		FLIT(40.0)
  #define MAX_YLOGX	FLIT(16.0)
  #define FRAC_BITS	4294967296.0L		/* 2^32 */

static const FTYPE log2e[] = {
	(FTYPE)(FLIT(3098164009.0) / FRAC_BITS * 2),	/* 1/ln(2) */
	(FTYPE)(FLIT(1545072827.0) / FRAC_BITS_2 * 2),
	(FTYPE)(FLIT(3196583632.0) / FRAC_BITS_2 / FRAC_BITS * 2),
	(FTYPE)(FLIT(1763524232.0) / FRAC_BITS_4 * 2),
	};

  #define KMAX		9	/* enable ln(x+a) expansion */

static FTYPE scale = (FTYPE)(1 << KMAX);

static FTYPE lnbias[][ACSIZE] = {	/* binary logs for centers */
	{/* log[2](256 / 512) */
	FLIT(-2147483648.0) * 2 / FRAC_BITS,
	FLIT(-0.0) * 2 / FRAC_BITS_2,
	FLIT(-0.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](257 / 512) */
	FLIT(-2135405020.0) * 2 / FRAC_BITS,
	FLIT(-2485820485.0) * 2 / FRAC_BITS_2,
	FLIT(-2838632155.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](258 / 512) */
	FLIT(-2123373300.0) * 2 / FRAC_BITS,
	FLIT(-2433710824.0) * 2 / FRAC_BITS_2,
	FLIT(-119309567.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](259 / 512) */
	FLIT(-2111388125.0) * 2 / FRAC_BITS,
	FLIT(-181444214.0) * 2 / FRAC_BITS_2,
	FLIT(-2306650733.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](260 / 512) */
	FLIT(-2099449135.0) * 2 / FRAC_BITS,
	FLIT(-1202043598.0) * 2 / FRAC_BITS_2,
	FLIT(-2990212029.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](261 / 512) */
	FLIT(-2087555976.0) * 2 / FRAC_BITS,
	FLIT(-2942177075.0) * 2 / FRAC_BITS_2,
	FLIT(-841998621.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](262 / 512) */
	FLIT(-2075708298.0) * 2 / FRAC_BITS,
	FLIT(-3140680516.0) * 2 / FRAC_BITS_2,
	FLIT(-2679029441.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](263 / 512) */
	FLIT(-2063905754.0) * 2 / FRAC_BITS,
	FLIT(-3857282679.0) * 2 / FRAC_BITS_2,
	FLIT(-4130153456.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](264 / 512) */
	FLIT(-2052148002.0) * 2 / FRAC_BITS,
	FLIT(-2621480499.0) * 2 / FRAC_BITS_2,
	FLIT(-2994619354.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](265 / 512) */
	FLIT(-2040434703.0) * 2 / FRAC_BITS,
	FLIT(-766221031.0) * 2 / FRAC_BITS_2,
	FLIT(-3620147900.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](266 / 512) */
	FLIT(-2028765521.0) * 2 / FRAC_BITS,
	FLIT(-3176474690.0) * 2 / FRAC_BITS_2,
	FLIT(-3250709894.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](267 / 512) */
	FLIT(-2017140127.0) * 2 / FRAC_BITS,
	FLIT(-862656535.0) * 2 / FRAC_BITS_2,
	FLIT(-2361282834.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](268 / 512) */
	FLIT(-2005558192.0) * 2 / FRAC_BITS,
	FLIT(-783299238.0) * 2 / FRAC_BITS_2,
	FLIT(-407216803.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](269 / 512) */
	FLIT(-1994019392.0) * 2 / FRAC_BITS,
	FLIT(-4132626875.0) * 2 / FRAC_BITS_2,
	FLIT(-781739381.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](270 / 512) */
	FLIT(-1982523409.0) * 2 / FRAC_BITS,
	FLIT(-1812405907.0) * 2 / FRAC_BITS_2,
	FLIT(-4254562034.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](271 / 512) */
	FLIT(-1971069924.0) * 2 / FRAC_BITS,
	FLIT(-4267844757.0) * 2 / FRAC_BITS_2,
	FLIT(-2257994315.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](272 / 512) */
	FLIT(-1959658626.0) * 2 / FRAC_BITS,
	FLIT(-2608231617.0) * 2 / FRAC_BITS_2,
	FLIT(-2580954831.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](273 / 512) */
	FLIT(-1948289204.0) * 2 / FRAC_BITS,
	FLIT(-2746138465.0) * 2 / FRAC_BITS_2,
	FLIT(-3743999717.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](274 / 512) */
	FLIT(-1936961352.0) * 2 / FRAC_BITS,
	FLIT(-3706081960.0) * 2 / FRAC_BITS_2,
	FLIT(-3337018201.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](275 / 512) */
	FLIT(-1925674768.0) * 2 / FRAC_BITS,
	FLIT(-1706931722.0) * 2 / FRAC_BITS_2,
	FLIT(-1574170850.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](276 / 512) */
	FLIT(-1914429151.0) * 2 / FRAC_BITS,
	FLIT(-2838110926.0) * 2 / FRAC_BITS_2,
	FLIT(-647834765.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](277 / 512) */
	FLIT(-1903224206.0) * 2 / FRAC_BITS,
	FLIT(-1379832537.0) * 2 / FRAC_BITS_2,
	FLIT(-2053342830.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](278 / 512) */
	FLIT(-1892059639.0) * 2 / FRAC_BITS,
	FLIT(-1076700913.0) * 2 / FRAC_BITS_2,
	FLIT(-2703561489.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](279 / 512) */
	FLIT(-1880935160.0) * 2 / FRAC_BITS,
	FLIT(-2055187895.0) * 2 / FRAC_BITS_2,
	FLIT(-3647327797.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](280 / 512) */
	FLIT(-1869850483.0) * 2 / FRAC_BITS,
	FLIT(-629546089.0) * 2 / FRAC_BITS_2,
	FLIT(-3628306479.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](281 / 512) */
	FLIT(-1858805323.0) * 2 / FRAC_BITS,
	FLIT(-1996083712.0) * 2 / FRAC_BITS_2,
	FLIT(-3395022832.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](282 / 512) */
	FLIT(-1847799400.0) * 2 / FRAC_BITS,
	FLIT(-2866054305.0) * 2 / FRAC_BITS_2,
	FLIT(-1537986439.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](283 / 512) */
	FLIT(-1836832436.0) * 2 / FRAC_BITS,
	FLIT(-4166631538.0) * 2 / FRAC_BITS_2,
	FLIT(-2306167643.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](284 / 512) */
	FLIT(-1825904157.0) * 2 / FRAC_BITS,
	FLIT(-2270291424.0) * 2 / FRAC_BITS_2,
	FLIT(-2920103818.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](285 / 512) */
	FLIT(-1815014290.0) * 2 / FRAC_BITS,
	FLIT(-1702206479.0) * 2 / FRAC_BITS_2,
	FLIT(-4106809428.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](286 / 512) */
	FLIT(-1804162566.0) * 2 / FRAC_BITS,
	FLIT(-2080944846.0) * 2 / FRAC_BITS_2,
	FLIT(-3340156571.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](287 / 512) */
	FLIT(-1793348719.0) * 2 / FRAC_BITS,
	FLIT(-2242082231.0) * 2 / FRAC_BITS_2,
	FLIT(-1341613988.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](288 / 512) */
	FLIT(-1782572486.0) * 2 / FRAC_BITS,
	FLIT(-69826656.0) * 2 / FRAC_BITS_2,
	FLIT(-1609887221.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](289 / 512) */
	FLIT(-1771833605.0) * 2 / FRAC_BITS,
	FLIT(-921495939.0) * 2 / FRAC_BITS_2,
	FLIT(-866942366.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](290 / 512) */
	FLIT(-1761131819.0) * 2 / FRAC_BITS,
	FLIT(-285049046.0) * 2 / FRAC_BITS_2,
	FLIT(-1071842600.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](291 / 512) */
	FLIT(-1750466872.0) * 2 / FRAC_BITS,
	FLIT(-799154446.0) * 2 / FRAC_BITS_2,
	FLIT(-2175950609.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](292 / 512) */
	FLIT(-1739838511.0) * 2 / FRAC_BITS,
	FLIT(-3506195714.0) * 2 / FRAC_BITS_2,
	FLIT(-769356056.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](293 / 512) */
	FLIT(-1729246487.0) * 2 / FRAC_BITS,
	FLIT(-3402929226.0) * 2 / FRAC_BITS_2,
	FLIT(-851306091.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](294 / 512) */
	FLIT(-1718690552.0) * 2 / FRAC_BITS,
	FLIT(-2173640957.0) * 2 / FRAC_BITS_2,
	FLIT(-87126870.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](295 / 512) */
	FLIT(-1708170460.0) * 2 / FRAC_BITS,
	FLIT(-3746010421.0) * 2 / FRAC_BITS_2,
	FLIT(-3346716890.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](296 / 512) */
	FLIT(-1697685970.0) * 2 / FRAC_BITS,
	FLIT(-1259564048.0) * 2 / FRAC_BITS_2,
	FLIT(-518075455.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](297 / 512) */
	FLIT(-1687236840.0) * 2 / FRAC_BITS,
	FLIT(-2691307156.0) * 2 / FRAC_BITS_2,
	FLIT(-309539280.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](298 / 512) */
	FLIT(-1676822834.0) * 2 / FRAC_BITS,
	FLIT(-649204159.0) * 2 / FRAC_BITS_2,
	FLIT(-496133990.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](299 / 512) */
	FLIT(-1666443715.0) * 2 / FRAC_BITS,
	FLIT(-2297575273.0) * 2 / FRAC_BITS_2,
	FLIT(-993371982.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](300 / 512) */
	FLIT(-1656099251.0) * 2 / FRAC_BITS,
	FLIT(-3450245175.0) * 2 / FRAC_BITS_2,
	FLIT(-189438717.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](301 / 512) */
	FLIT(-1645789212.0) * 2 / FRAC_BITS,
	FLIT(-1320677662.0) * 2 / FRAC_BITS_2,
	FLIT(-1102941234.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](302 / 512) */
	FLIT(-1635513368.0) * 2 / FRAC_BITS,
	FLIT(-2979377976.0) * 2 / FRAC_BITS_2,
	FLIT(-906767074.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](303 / 512) */
	FLIT(-1625271494.0) * 2 / FRAC_BITS,
	FLIT(-3748714680.0) * 2 / FRAC_BITS_2,
	FLIT(-2329254094.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](304 / 512) */
	FLIT(-1615063366.0) * 2 / FRAC_BITS,
	FLIT(-4254594524.0) * 2 / FRAC_BITS_2,
	FLIT(-1462134616.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](305 / 512) */
	FLIT(-1604888763.0) * 2 / FRAC_BITS,
	FLIT(-1710438537.0) * 2 / FRAC_BITS_2,
	FLIT(-3502057136.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](306 / 512) */
	FLIT(-1594747464.0) * 2 / FRAC_BITS,
	FLIT(-2678058273.0) * 2 / FRAC_BITS_2,
	FLIT(-4190842053.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](307 / 512) */
	FLIT(-1584639253.0) * 2 / FRAC_BITS,
	FLIT(-1470816950.0) * 2 / FRAC_BITS_2,
	FLIT(-163624911.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](308 / 512) */
	FLIT(-1574563914.0) * 2 / FRAC_BITS,
	FLIT(-1508447337.0) * 2 / FRAC_BITS_2,
	FLIT(-3978251021.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](309 / 512) */
	FLIT(-1564521234.0) * 2 / FRAC_BITS,
	FLIT(-2314076493.0) * 2 / FRAC_BITS_2,
	FLIT(-59733383.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](310 / 512) */
	FLIT(-1554511002.0) * 2 / FRAC_BITS,
	FLIT(-3693027162.0) * 2 / FRAC_BITS_2,
	FLIT(-3877171776.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](311 / 512) */
	FLIT(-1544533010.0) * 2 / FRAC_BITS,
	FLIT(-1323555240.0) * 2 / FRAC_BITS_2,
	FLIT(-791566352.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](312 / 512) */
	FLIT(-1534587049.0) * 2 / FRAC_BITS,
	FLIT(-3824258299.0) * 2 / FRAC_BITS_2,
	FLIT(-1955424439.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](313 / 512) */
	FLIT(-1524672916.0) * 2 / FRAC_BITS,
	FLIT(-2578643257.0) * 2 / FRAC_BITS_2,
	FLIT(-4173147003.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](314 / 512) */
	FLIT(-1514790407.0) * 2 / FRAC_BITS,
	FLIT(-1691001121.0) * 2 / FRAC_BITS_2,
	FLIT(-3641410791.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](315 / 512) */
	FLIT(-1504939321.0) * 2 / FRAC_BITS,
	FLIT(-699372746.0) * 2 / FRAC_BITS_2,
	FLIT(-943226405.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](316 / 512) */
	FLIT(-1495119458.0) * 2 / FRAC_BITS,
	FLIT(-3060016716.0) * 2 / FRAC_BITS_2,
	FLIT(-3717801683.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](317 / 512) */
	FLIT(-1485330622.0) * 2 / FRAC_BITS,
	FLIT(-3158706900.0) * 2 / FRAC_BITS_2,
	FLIT(-4192493131.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](318 / 512) */
	FLIT(-1475572617.0) * 2 / FRAC_BITS,
	FLIT(-3388435732.0) * 2 / FRAC_BITS_2,
	FLIT(-2585360309.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](319 / 512) */
	FLIT(-1465845250.0) * 2 / FRAC_BITS,
	FLIT(-1163950294.0) * 2 / FRAC_BITS_2,
	FLIT(-1421787142.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](320 / 512) */
	FLIT(-1456148328.0) * 2 / FRAC_BITS,
	FLIT(-1707665923.0) * 2 / FRAC_BITS_2,
	FLIT(-1839731201.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](321 / 512) */
	FLIT(-1446481662.0) * 2 / FRAC_BITS,
	FLIT(-772353032.0) * 2 / FRAC_BITS_2,
	FLIT(-2233236084.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](322 / 512) */
	FLIT(-1436845063.0) * 2 / FRAC_BITS,
	FLIT(-1725077764.0) * 2 / FRAC_BITS_2,
	FLIT(-1631466432.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](323 / 512) */
	FLIT(-1427238345.0) * 2 / FRAC_BITS,
	FLIT(-2567858845.0) * 2 / FRAC_BITS_2,
	FLIT(-4043089447.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](324 / 512) */
	FLIT(-1417661324.0) * 2 / FRAC_BITS,
	FLIT(-139653312.0) * 2 / FRAC_BITS_2,
	FLIT(-3219774443.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](325 / 512) */
	FLIT(-1408113815.0) * 2 / FRAC_BITS,
	FLIT(-2909709522.0) * 2 / FRAC_BITS_2,
	FLIT(-534975935.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](326 / 512) */
	FLIT(-1398595639.0) * 2 / FRAC_BITS,
	FLIT(-822653493.0) * 2 / FRAC_BITS_2,
	FLIT(-3138266222.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](327 / 512) */
	FLIT(-1389106614.0) * 2 / FRAC_BITS,
	FLIT(-3864432430.0) * 2 / FRAC_BITS_2,
	FLIT(-1970231190.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](328 / 512) */
	FLIT(-1379646564.0) * 2 / FRAC_BITS,
	FLIT(-3320202064.0) * 2 / FRAC_BITS_2,
	FLIT(-3848006006.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](329 / 512) */
	FLIT(-1370215312.0) * 2 / FRAC_BITS,
	FLIT(-1753021143.0) * 2 / FRAC_BITS_2,
	FLIT(-2521618106.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](330 / 512) */
	FLIT(-1360812683.0) * 2 / FRAC_BITS,
	FLIT(-34179127.0) * 2 / FRAC_BITS_2,
	FLIT(-539383259.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](331 / 512) */
	FLIT(-1351438503.0) * 2 / FRAC_BITS,
	FLIT(-1554675537.0) * 2 / FRAC_BITS_2,
	FLIT(-958421028.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](332 / 512) */
	FLIT(-1342092601.0) * 2 / FRAC_BITS,
	FLIT(-3553056666.0) * 2 / FRAC_BITS_2,
	FLIT(-2727603222.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](333 / 512) */
	FLIT(-1332774808.0) * 2 / FRAC_BITS,
	FLIT(-1329390704.0) * 2 / FRAC_BITS_2,
	FLIT(-2127962677.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](334 / 512) */
	FLIT(-1323484954.0) * 2 / FRAC_BITS,
	FLIT(-1050391734.0) * 2 / FRAC_BITS_2,
	FLIT(-2469836398.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](335 / 512) */
	FLIT(-1314222872.0) * 2 / FRAC_BITS,
	FLIT(-2490965161.0) * 2 / FRAC_BITS_2,
	FLIT(-2246948004.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](336 / 512) */
	FLIT(-1304988397.0) * 2 / FRAC_BITS,
	FLIT(-3251760790.0) * 2 / FRAC_BITS_2,
	FLIT(-2593518888.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](337 / 512) */
	FLIT(-1295781365.0) * 2 / FRAC_BITS,
	FLIT(-2977876198.0) * 2 / FRAC_BITS_2,
	FLIT(-348457543.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](338 / 512) */
	FLIT(-1286601613.0) * 2 / FRAC_BITS,
	FLIT(-3283722646.0) * 2 / FRAC_BITS_2,
	FLIT(-2300961656.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](339 / 512) */
	FLIT(-1277448980.0) * 2 / FRAC_BITS,
	FLIT(-3384033518.0) * 2 / FRAC_BITS_2,
	FLIT(-1237716082.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](340 / 512) */
	FLIT(-1268323307.0) * 2 / FRAC_BITS,
	FLIT(-20930245.0) * 2 / FRAC_BITS_2,
	FLIT(-125718736.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](341 / 512) */
	FLIT(-1259224434.0) * 2 / FRAC_BITS,
	FLIT(-276961114.0) * 2 / FRAC_BITS_2,
	FLIT(-4227116318.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](342 / 512) */
	FLIT(-1250152205.0) * 2 / FRAC_BITS,
	FLIT(-29453884.0) * 2 / FRAC_BITS_2,
	FLIT(-3072021838.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](343 / 512) */
	FLIT(-1241106464.0) * 2 / FRAC_BITS,
	FLIT(-1060607795.0) * 2 / FRAC_BITS_2,
	FLIT(-1070758537.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](344 / 512) */
	FLIT(-1232087057.0) * 2 / FRAC_BITS,
	FLIT(-2398797495.0) * 2 / FRAC_BITS_2,
	FLIT(-3609333252.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](345 / 512) */
	FLIT(-1223093832.0) * 2 / FRAC_BITS,
	FLIT(-250809553.0) * 2 / FRAC_BITS_2,
	FLIT(-2487565966.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](346 / 512) */
	FLIT(-1214126636.0) * 2 / FRAC_BITS,
	FLIT(-819961513.0) * 2 / FRAC_BITS_2,
	FLIT(-2007382463.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](347 / 512) */
	FLIT(-1205185319.0) * 2 / FRAC_BITS,
	FLIT(-3060413567.0) * 2 / FRAC_BITS_2,
	FLIT(-3026938217.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](348 / 512) */
	FLIT(-1196269733.0) * 2 / FRAC_BITS,
	FLIT(-2907263747.0) * 2 / FRAC_BITS_2,
	FLIT(-37055010.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](349 / 512) */
	FLIT(-1187379730.0) * 2 / FRAC_BITS,
	FLIT(-1802541145.0) * 2 / FRAC_BITS_2,
	FLIT(-7387311.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](350 / 512) */
	FLIT(-1178515163.0) * 2 / FRAC_BITS,
	FLIT(-2337212013.0) * 2 / FRAC_BITS_2,
	FLIT(-1173070384.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](351 / 512) */
	FLIT(-1169675887.0) * 2 / FRAC_BITS,
	FLIT(-3894084955.0) * 2 / FRAC_BITS_2,
	FLIT(-3565311661.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](352 / 512) */
	FLIT(-1160861759.0) * 2 / FRAC_BITS,
	FLIT(-2586567171.0) * 2 / FRAC_BITS_2,
	FLIT(-2189675743.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](353 / 512) */
	FLIT(-1152072635.0) * 2 / FRAC_BITS,
	FLIT(-4083191293.0) * 2 / FRAC_BITS_2,
	FLIT(-2976600533.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](354 / 512) */
	FLIT(-1143308375.0) * 2 / FRAC_BITS,
	FLIT(-2073257826.0) * 2 / FRAC_BITS_2,
	FLIT(-2311929300.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](355 / 512) */
	FLIT(-1134568837.0) * 2 / FRAC_BITS,
	FLIT(-3977957348.0) * 2 / FRAC_BITS_2,
	FLIT(-464867723.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](356 / 512) */
	FLIT(-1125853884.0) * 2 / FRAC_BITS,
	FLIT(-827743207.0) * 2 / FRAC_BITS_2,
	FLIT(-1556339223.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](357 / 512) */
	FLIT(-1117163376.0) * 2 / FRAC_BITS,
	FLIT(-1565025112.0) * 2 / FRAC_BITS_2,
	FLIT(-879506424.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](358 / 512) */
	FLIT(-1108497177.0) * 2 / FRAC_BITS,
	FLIT(-2923151109.0) * 2 / FRAC_BITS_2,
	FLIT(-3288117133.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](359 / 512) */
	FLIT(-1099855152.0) * 2 / FRAC_BITS,
	FLIT(-2255847006.0) * 2 / FRAC_BITS_2,
	FLIT(-59791966.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](360 / 512) */
	FLIT(-1091237166.0) * 2 / FRAC_BITS,
	FLIT(-1777492579.0) * 2 / FRAC_BITS_2,
	FLIT(-3449618423.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](361 / 512) */
	FLIT(-1082643085.0) * 2 / FRAC_BITS,
	FLIT(-4214221752.0) * 2 / FRAC_BITS_2,
	FLIT(-2924269232.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](362 / 512) */
	FLIT(-1074072778.0) * 2 / FRAC_BITS,
	FLIT(-4160801420.0) * 2 / FRAC_BITS_2,
	FLIT(-1728157600.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](363 / 512) */
	FLIT(-1065526114.0) * 2 / FRAC_BITS,
	FLIT(-913080375.0) * 2 / FRAC_BITS_2,
	FLIT(-889327801.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](364 / 512) */
	FLIT(-1057002961.0) * 2 / FRAC_BITS,
	FLIT(-2711225137.0) * 2 / FRAC_BITS_2,
	FLIT(-2939056106.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](365 / 512) */
	FLIT(-1048503192.0) * 2 / FRAC_BITS,
	FLIT(-918894341.0) * 2 / FRAC_BITS_2,
	FLIT(-2609087258.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](366 / 512) */
	FLIT(-1040026678.0) * 2 / FRAC_BITS,
	FLIT(-37685942.0) * 2 / FRAC_BITS_2,
	FLIT(-2467269545.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](367 / 512) */
	FLIT(-1031573292.0) * 2 / FRAC_BITS,
	FLIT(-477630719.0) * 2 / FRAC_BITS_2,
	FLIT(-3385478412.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](368 / 512) */
	FLIT(-1023142908.0) * 2 / FRAC_BITS,
	FLIT(-2803197597.0) * 2 / FRAC_BITS_2,
	FLIT(-4137858450.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](369 / 512) */
	FLIT(-1014735402.0) * 2 / FRAC_BITS,
	FLIT(-3390028721.0) * 2 / FRAC_BITS_2,
	FLIT(-1162925932.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](370 / 512) */
	FLIT(-1006350650.0) * 2 / FRAC_BITS,
	FLIT(-2967229971.0) * 2 / FRAC_BITS_2,
	FLIT(-2357806657.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](371 / 512) */
	FLIT(-997988529.0) * 2 / FRAC_BITS,
	FLIT(-2275402570.0) * 2 / FRAC_BITS_2,
	FLIT(-3568991976.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](372 / 512) */
	FLIT(-989648917.0) * 2 / FRAC_BITS,
	FLIT(-2020274567.0) * 2 / FRAC_BITS_2,
	FLIT(-2842384186.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](373 / 512) */
	FLIT(-981331693.0) * 2 / FRAC_BITS,
	FLIT(-2826954721.0) * 2 / FRAC_BITS_2,
	FLIT(-3569905674.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](374 / 512) */
	FLIT(-973036738.0) * 2 / FRAC_BITS,
	FLIT(-899831493.0) * 2 / FRAC_BITS_2,
	FLIT(-475663278.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](375 / 512) */
	FLIT(-964763932.0) * 2 / FRAC_BITS,
	FLIT(-862943802.0) * 2 / FRAC_BITS_2,
	FLIT(-2029169919.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](376 / 512) */
	FLIT(-956513157.0) * 2 / FRAC_BITS,
	FLIT(-2831140977.0) * 2 / FRAC_BITS_2,
	FLIT(-733042828.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](377 / 512) */
	FLIT(-948284297.0) * 2 / FRAC_BITS,
	FLIT(-2366728094.0) * 2 / FRAC_BITS_2,
	FLIT(-382592227.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](378 / 512) */
	FLIT(-940077235.0) * 2 / FRAC_BITS,
	FLIT(-3321587446.0) * 2 / FRAC_BITS_2,
	FLIT(-4203406110.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](379 / 512) */
	FLIT(-931891857.0) * 2 / FRAC_BITS,
	FLIT(-615094074.0) * 2 / FRAC_BITS_2,
	FLIT(-3157216213.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](380 / 512) */
	FLIT(-923728047.0) * 2 / FRAC_BITS,
	FLIT(-1667293151.0) * 2 / FRAC_BITS_2,
	FLIT(-3301865817.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](381 / 512) */
	FLIT(-915585693.0) * 2 / FRAC_BITS,
	FLIT(-587984549.0) * 2 / FRAC_BITS_2,
	FLIT(-3855350685.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](382 / 512) */
	FLIT(-907464681.0) * 2 / FRAC_BITS,
	FLIT(-3905953770.0) * 2 / FRAC_BITS_2,
	FLIT(-516193393.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](383 / 512) */
	FLIT(-899364902.0) * 2 / FRAC_BITS,
	FLIT(-464158392.0) * 2 / FRAC_BITS_2,
	FLIT(-815303585.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](384 / 512) */
	FLIT(-891286243.0) * 2 / FRAC_BITS,
	FLIT(-34913328.0) * 2 / FRAC_BITS_2,
	FLIT(-804943610.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](385 / 512) */
	FLIT(-883228594.0) * 2 / FRAC_BITS,
	FLIT(-3216113261.0) * 2 / FRAC_BITS_2,
	FLIT(-1523014926.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](386 / 512) */
	FLIT(-875191848.0) * 2 / FRAC_BITS,
	FLIT(-1392732079.0) * 2 / FRAC_BITS_2,
	FLIT(-1640807001.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](387 / 512) */
	FLIT(-867175895.0) * 2 / FRAC_BITS,
	FLIT(-2468624152.0) * 2 / FRAC_BITS_2,
	FLIT(-924253178.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](388 / 512) */
	FLIT(-859180629.0) * 2 / FRAC_BITS,
	FLIT(-764241118.0) * 2 / FRAC_BITS_2,
	FLIT(-1371006998.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](389 / 512) */
	FLIT(-851205942.0) * 2 / FRAC_BITS,
	FLIT(-2749406302.0) * 2 / FRAC_BITS_2,
	FLIT(-1289334926.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](390 / 512) */
	FLIT(-843251730.0) * 2 / FRAC_BITS,
	FLIT(-1236956926.0) * 2 / FRAC_BITS_2,
	FLIT(-3795155640.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](391 / 512) */
	FLIT(-835317887.0) * 2 / FRAC_BITS,
	FLIT(-1116461919.0) * 2 / FRAC_BITS_2,
	FLIT(-2423845985.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](392 / 512) */
	FLIT(-827404309.0) * 2 / FRAC_BITS,
	FLIT(-2138727628.0) * 2 / FRAC_BITS_2,
	FLIT(-3577150555.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](393 / 512) */
	FLIT(-819510893.0) * 2 / FRAC_BITS,
	FLIT(-3175593844.0) * 2 / FRAC_BITS_2,
	FLIT(-3483973052.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](394 / 512) */
	FLIT(-811637537.0) * 2 / FRAC_BITS,
	FLIT(-2185209428.0) * 2 / FRAC_BITS_2,
	FLIT(-1969310058.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](395 / 512) */
	FLIT(-803784139.0) * 2 / FRAC_BITS,
	FLIT(-472715344.0) * 2 / FRAC_BITS_2,
	FLIT(-1262565589.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](396 / 512) */
	FLIT(-795950597.0) * 2 / FRAC_BITS,
	FLIT(-2656393827.0) * 2 / FRAC_BITS_2,
	FLIT(-3799562965.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](397 / 512) */
	FLIT(-788136812.0) * 2 / FRAC_BITS,
	FLIT(-3749342537.0) * 2 / FRAC_BITS_2,
	FLIT(-961074581.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](398 / 512) */
	FLIT(-780342685.0) * 2 / FRAC_BITS,
	FLIT(-2011372908.0) * 2 / FRAC_BITS_2,
	FLIT(-2684387174.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](399 / 512) */
	FLIT(-772568116.0) * 2 / FRAC_BITS,
	FLIT(-3211388018.0) * 2 / FRAC_BITS_2,
	FLIT(-4055653505.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](400 / 512) */
	FLIT(-764813008.0) * 2 / FRAC_BITS,
	FLIT(-3415331846.0) * 2 / FRAC_BITS_2,
	FLIT(-3679462402.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](401 / 512) */
	FLIT(-757077264.0) * 2 / FRAC_BITS,
	FLIT(-1839311374.0) * 2 / FRAC_BITS_2,
	FLIT(-2657864311.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](402 / 512) */
	FLIT(-749360787.0) * 2 / FRAC_BITS,
	FLIT(-818212566.0) * 2 / FRAC_BITS_2,
	FLIT(-1212160414.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](403 / 512) */
	FLIT(-741663481.0) * 2 / FRAC_BITS,
	FLIT(-1479738914.0) * 2 / FRAC_BITS_2,
	FLIT(-3187921403.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](404 / 512) */
	FLIT(-733985251.0) * 2 / FRAC_BITS,
	FLIT(-3713801352.0) * 2 / FRAC_BITS_2,
	FLIT(-1524310483.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](405 / 512) */
	FLIT(-726326004.0) * 2 / FRAC_BITS,
	FLIT(-1847319236.0) * 2 / FRAC_BITS_2,
	FLIT(-764538349.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](406 / 512) */
	FLIT(-718685645.0) * 2 / FRAC_BITS,
	FLIT(-1794230585.0) * 2 / FRAC_BITS_2,
	FLIT(-1020686677.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](407 / 512) */
	FLIT(-711064081.0) * 2 / FRAC_BITS,
	FLIT(-3846131219.0) * 2 / FRAC_BITS_2,
	FLIT(-2707751199.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](408 / 512) */
	FLIT(-703461221.0) * 2 / FRAC_BITS,
	FLIT(-2643144945.0) * 2 / FRAC_BITS_2,
	FLIT(-3385898442.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](409 / 512) */
	FLIT(-695876973.0) * 2 / FRAC_BITS,
	FLIT(-30052176.0) * 2 / FRAC_BITS_2,
	FLIT(-3857987083.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](410 / 512) */
	FLIT(-688311245.0) * 2 / FRAC_BITS,
	FLIT(-732900692.0) * 2 / FRAC_BITS_2,
	FLIT(-1392769911.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](411 / 512) */
	FLIT(-680763947.0) * 2 / FRAC_BITS,
	FLIT(-3740995288.0) * 2 / FRAC_BITS_2,
	FLIT(-4141961812.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](412 / 512) */
	FLIT(-673234991.0) * 2 / FRAC_BITS,
	FLIT(-2279163164.0) * 2 / FRAC_BITS_2,
	FLIT(-3549757068.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](413 / 512) */
	FLIT(-665724287.0) * 2 / FRAC_BITS,
	FLIT(-960224664.0) * 2 / FRAC_BITS_2,
	FLIT(-3295560967.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](414 / 512) */
	FLIT(-658231746.0) * 2 / FRAC_BITS,
	FLIT(-2873024254.0) * 2 / FRAC_BITS_2,
	FLIT(-1452778376.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](415 / 512) */
	FLIT(-650757282.0) * 2 / FRAC_BITS,
	FLIT(-965755294.0) * 2 / FRAC_BITS_2,
	FLIT(-272367127.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](416 / 512) */
	FLIT(-643300806.0) * 2 / FRAC_BITS,
	FLIT(-3789344971.0) * 2 / FRAC_BITS_2,
	FLIT(-1150480828.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](417 / 512) */
	FLIT(-635862234.0) * 2 / FRAC_BITS,
	FLIT(-1111614241.0) * 2 / FRAC_BITS_2,
	FLIT(-3508505100.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](418 / 512) */
	FLIT(-628441478.0) * 2 / FRAC_BITS,
	FLIT(-2546194399.0) * 2 / FRAC_BITS_2,
	FLIT(-3651810359.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](419 / 512) */
	FLIT(-621038454.0) * 2 / FRAC_BITS,
	FLIT(-3167307729.0) * 2 / FRAC_BITS_2,
	FLIT(-3579936500.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](420 / 512) */
	FLIT(-613653078.0) * 2 / FRAC_BITS,
	FLIT(-664459418.0) * 2 / FRAC_BITS_2,
	FLIT(-138282794.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](421 / 512) */
	FLIT(-606285264.0) * 2 / FRAC_BITS,
	FLIT(-3907494245.0) * 2 / FRAC_BITS_2,
	FLIT(-3762041713.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](422 / 512) */
	FLIT(-598934931.0) * 2 / FRAC_BITS,
	FLIT(-2857242731.0) * 2 / FRAC_BITS_2,
	FLIT(-2785085663.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](423 / 512) */
	FLIT(-591601995.0) * 2 / FRAC_BITS,
	FLIT(-2900967633.0) * 2 / FRAC_BITS_2,
	FLIT(-2342930050.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](424 / 512) */
	FLIT(-584286374.0) * 2 / FRAC_BITS,
	FLIT(-3353522404.0) * 2 / FRAC_BITS_2,
	FLIT(-1780416698.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](425 / 512) */
	FLIT(-576987987.0) * 2 / FRAC_BITS,
	FLIT(-1728596168.0) * 2 / FRAC_BITS_2,
	FLIT(-1965449938.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](426 / 512) */
	FLIT(-569706752.0) * 2 / FRAC_BITS,
	FLIT(-2305204752.0) * 2 / FRAC_BITS_2,
	FLIT(-3725047429.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](427 / 512) */
	FLIT(-562442589.0) * 2 / FRAC_BITS,
	FLIT(-3219620076.0) * 2 / FRAC_BITS_2,
	FLIT(-3450901212.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](428 / 512) */
	FLIT(-555195419.0) * 2 / FRAC_BITS,
	FLIT(-737439704.0) * 2 / FRAC_BITS_2,
	FLIT(-1428292473.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](429 / 512) */
	FLIT(-547965161.0) * 2 / FRAC_BITS,
	FLIT(-2115858174.0) * 2 / FRAC_BITS_2,
	FLIT(-4145100182.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](430 / 512) */
	FLIT(-540751737.0) * 2 / FRAC_BITS,
	FLIT(-4106463419.0) * 2 / FRAC_BITS_2,
	FLIT(-1154097158.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](431 / 512) */
	FLIT(-533555070.0) * 2 / FRAC_BITS,
	FLIT(-1523064027.0) * 2 / FRAC_BITS_2,
	FLIT(-3111571527.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](432 / 512) */
	FLIT(-526375081.0) * 2 / FRAC_BITS,
	FLIT(-104739984.0) * 2 / FRAC_BITS_2,
	FLIT(-2414830832.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](433 / 512) */
	FLIT(-519211692.0) * 2 / FRAC_BITS,
	FLIT(-3609342240.0) * 2 / FRAC_BITS_2,
	FLIT(-3324497721.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](434 / 512) */
	FLIT(-512064829.0) * 2 / FRAC_BITS,
	FLIT(-907241405.0) * 2 / FRAC_BITS_2,
	FLIT(-3826015853.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](435 / 512) */
	FLIT(-504934414.0) * 2 / FRAC_BITS,
	FLIT(-319962374.0) * 2 / FRAC_BITS_2,
	FLIT(-1876786211.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](436 / 512) */
	FLIT(-497820371.0) * 2 / FRAC_BITS,
	FLIT(-3829519102.0) * 2 / FRAC_BITS_2,
	FLIT(-1165287579.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](437 / 512) */
	FLIT(-490722627.0) * 2 / FRAC_BITS,
	FLIT(-2762824826.0) * 2 / FRAC_BITS_2,
	FLIT(-1305025770.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](438 / 512) */
	FLIT(-483641106.0) * 2 / FRAC_BITS,
	FLIT(-3541109042.0) * 2 / FRAC_BITS_2,
	FLIT(-1574299667.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](439 / 512) */
	FLIT(-476575735.0) * 2 / FRAC_BITS,
	FLIT(-1889959392.0) * 2 / FRAC_BITS_2,
	FLIT(-1426014127.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](440 / 512) */
	FLIT(-469526439.0) * 2 / FRAC_BITS,
	FLIT(-4294233094.0) * 2 / FRAC_BITS_2,
	FLIT(-4029406944.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](441 / 512) */
	FLIT(-462493147.0) * 2 / FRAC_BITS,
	FLIT(-2208554285.0) * 2 / FRAC_BITS_2,
	FLIT(-892070481.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](442 / 512) */
	FLIT(-455475785.0) * 2 / FRAC_BITS,
	FLIT(-2102609292.0) * 2 / FRAC_BITS_2,
	FLIT(-3731435659.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](443 / 512) */
	FLIT(-448474281.0) * 2 / FRAC_BITS,
	FLIT(-3967054434.0) * 2 / FRAC_BITS_2,
	FLIT(-3457749648.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](444 / 512) */
	FLIT(-441488565.0) * 2 / FRAC_BITS,
	FLIT(-1294477376.0) * 2 / FRAC_BITS_2,
	FLIT(-1323019066.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](445 / 512) */
	FLIT(-434518564.0) * 2 / FRAC_BITS,
	FLIT(-2535409130.0) * 2 / FRAC_BITS_2,
	FLIT(-3396070424.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](446 / 512) */
	FLIT(-427564209.0) * 2 / FRAC_BITS,
	FLIT(-1014939781.0) * 2 / FRAC_BITS_2,
	FLIT(-2855458059.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](447 / 512) */
	FLIT(-420625429.0) * 2 / FRAC_BITS,
	FLIT(-684117487.0) * 2 / FRAC_BITS_2,
	FLIT(-1301077601.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](448 / 512) */
	FLIT(-413702154.0) * 2 / FRAC_BITS,
	FLIT(-3216847462.0) * 2 / FRAC_BITS_2,
	FLIT(-1788575277.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](449 / 512) */
	FLIT(-406794316.0) * 2 / FRAC_BITS,
	FLIT(-3696928440.0) * 2 / FRAC_BITS_2,
	FLIT(-3434905055.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](450 / 512) */
	FLIT(-399901846.0) * 2 / FRAC_BITS,
	FLIT(-3485158503.0) * 2 / FRAC_BITS_2,
	FLIT(-994382328.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](451 / 512) */
	FLIT(-393024676.0) * 2 / FRAC_BITS,
	FLIT(-1611801940.0) * 2 / FRAC_BITS_2,
	FLIT(-1742714453.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](452 / 512) */
	FLIT(-386162737.0) * 2 / FRAC_BITS,
	FLIT(-3349120190.0) * 2 / FRAC_BITS_2,
	FLIT(-432772471.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](453 / 512) */
	FLIT(-379315963.0) * 2 / FRAC_BITS,
	FLIT(-3014291304.0) * 2 / FRAC_BITS_2,
	FLIT(-1711710685.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](454 / 512) */
	FLIT(-372484287.0) * 2 / FRAC_BITS,
	FLIT(-1132257546.0) * 2 / FRAC_BITS_2,
	FLIT(-2815885383.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](455 / 512) */
	FLIT(-365667642.0) * 2 / FRAC_BITS,
	FLIT(-123923765.0) * 2 / FRAC_BITS_2,
	FLIT(-483820011.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](456 / 512) */
	FLIT(-358865961.0) * 2 / FRAC_BITS,
	FLIT(-4289507852.0) * 2 / FRAC_BITS_2,
	FLIT(-2267078227.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](457 / 512) */
	FLIT(-352079181.0) * 2 / FRAC_BITS,
	FLIT(-2612204383.0) * 2 / FRAC_BITS_2,
	FLIT(-185359534.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](458 / 512) */
	FLIT(-345307235.0) * 2 / FRAC_BITS,
	FLIT(-3101635770.0) * 2 / FRAC_BITS_2,
	FLIT(-2806675778.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](459 / 512) */
	FLIT(-338550059.0) * 2 / FRAC_BITS,
	FLIT(-2712971602.0) * 2 / FRAC_BITS_2,
	FLIT(-700818368.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](460 / 512) */
	FLIT(-331807589.0) * 2 / FRAC_BITS,
	FLIT(-215896225.0) * 2 / FRAC_BITS_2,
	FLIT(-1682622355.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](461 / 512) */
	FLIT(-325079760.0) * 2 / FRAC_BITS,
	FLIT(-473814756.0) * 2 / FRAC_BITS_2,
	FLIT(-2771854988.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](462 / 512) */
	FLIT(-318366509.0) * 2 / FRAC_BITS,
	FLIT(-1543360666.0) * 2 / FRAC_BITS_2,
	FLIT(-488227336.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](463 / 512) */
	FLIT(-311667773.0) * 2 / FRAC_BITS,
	FLIT(-3248908389.0) * 2 / FRAC_BITS_2,
	FLIT(-3850796939.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](464 / 512) */
	FLIT(-304983490.0) * 2 / FRAC_BITS,
	FLIT(-2872350418.0) * 2 / FRAC_BITS_2,
	FLIT(-3527078695.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](465 / 512) */
	FLIT(-298313597.0) * 2 / FRAC_BITS,
	FLIT(-3727940491.0) * 2 / FRAC_BITS_2,
	FLIT(-387148091.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](466 / 512) */
	FLIT(-291658033.0) * 2 / FRAC_BITS,
	FLIT(-2262462404.0) * 2 / FRAC_BITS_2,
	FLIT(-503613357.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](467 / 512) */
	FLIT(-285016736.0) * 2 / FRAC_BITS,
	FLIT(-925362616.0) * 2 / FRAC_BITS_2,
	FLIT(-2871337798.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](468 / 512) */
	FLIT(-278389644.0) * 2 / FRAC_BITS,
	FLIT(-3859171627.0) * 2 / FRAC_BITS_2,
	FLIT(-2760368050.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](469 / 512) */
	FLIT(-271776698.0) * 2 / FRAC_BITS,
	FLIT(-4000146700.0) * 2 / FRAC_BITS_2,
	FLIT(-2195792081.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](470 / 512) */
	FLIT(-265177838.0) * 2 / FRAC_BITS,
	FLIT(-243839604.0) * 2 / FRAC_BITS_2,
	FLIT(-2572774030.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](471 / 512) */
	FLIT(-258593002.0) * 2 / FRAC_BITS,
	FLIT(-1725914450.0) * 2 / FRAC_BITS_2,
	FLIT(-151387106.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](472 / 512) */
	FLIT(-252022132.0) * 2 / FRAC_BITS,
	FLIT(-2038344498.0) * 2 / FRAC_BITS_2,
	FLIT(-1506985689.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](473 / 512) */
	FLIT(-245465169.0) * 2 / FRAC_BITS,
	FLIT(-690397371.0) * 2 / FRAC_BITS_2,
	FLIT(-1504041700.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](474 / 512) */
	FLIT(-238922053.0) * 2 / FRAC_BITS,
	FLIT(-3094930045.0) * 2 / FRAC_BITS_2,
	FLIT(-227777998.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](475 / 512) */
	FLIT(-232392727.0) * 2 / FRAC_BITS,
	FLIT(-3374959075.0) * 2 / FRAC_BITS_2,
	FLIT(-846629723.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](476 / 512) */
	FLIT(-225877133.0) * 2 / FRAC_BITS,
	FLIT(-1530111784.0) * 2 / FRAC_BITS_2,
	FLIT(-74562813.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](477 / 512) */
	FLIT(-219375212.0) * 2 / FRAC_BITS,
	FLIT(-3423349060.0) * 2 / FRAC_BITS_2,
	FLIT(-3390303920.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](478 / 512) */
	FLIT(-212886908.0) * 2 / FRAC_BITS,
	FLIT(-3587958006.0) * 2 / FRAC_BITS_2,
	FLIT(-4063083436.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](479 / 512) */
	FLIT(-206412164.0) * 2 / FRAC_BITS,
	FLIT(-2394420234.0) * 2 / FRAC_BITS_2,
	FLIT(-1965179150.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](480 / 512) */
	FLIT(-199950923.0) * 2 / FRAC_BITS,
	FLIT(-1742579251.0) * 2 / FRAC_BITS_2,
	FLIT(-2644674812.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](481 / 512) */
	FLIT(-193503129.0) * 2 / FRAC_BITS,
	FLIT(-753941723.0) * 2 / FRAC_BITS_2,
	FLIT(-1668556284.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](482 / 512) */
	FLIT(-187068726.0) * 2 / FRAC_BITS,
	FLIT(-54045530.0) * 2 / FRAC_BITS_2,
	FLIT(-522275117.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](483 / 512) */
	FLIT(-180647658.0) * 2 / FRAC_BITS,
	FLIT(-1759991092.0) * 2 / FRAC_BITS_2,
	FLIT(-2436410043.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](484 / 512) */
	FLIT(-174239871.0) * 2 / FRAC_BITS,
	FLIT(-878167047.0) * 2 / FRAC_BITS_2,
	FLIT(-84384190.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](485 / 512) */
	FLIT(-167845309.0) * 2 / FRAC_BITS,
	FLIT(-2471907041.0) * 2 / FRAC_BITS_2,
	FLIT(-3210738200.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](486 / 512) */
	FLIT(-161463919.0) * 2 / FRAC_BITS,
	FLIT(-174566640.0) * 2 / FRAC_BITS_2,
	FLIT(-4024718054.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](487 / 512) */
	FLIT(-155095645.0) * 2 / FRAC_BITS,
	FLIT(-1947364705.0) * 2 / FRAC_BITS_2,
	FLIT(-5307829.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](488 / 512) */
	FLIT(-148740435.0) * 2 / FRAC_BITS,
	FLIT(-2772614.0) * 2 / FRAC_BITS_2,
	FLIT(-1662325934.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](489 / 512) */
	FLIT(-142398234.0) * 2 / FRAC_BITS,
	FLIT(-857566821.0) * 2 / FRAC_BITS_2,
	FLIT(-3943209833.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](490 / 512) */
	FLIT(-136068989.0) * 2 / FRAC_BITS,
	FLIT(-3846393552.0) * 2 / FRAC_BITS_2,
	FLIT(-1121914461.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](491 / 512) */
	FLIT(-129752649.0) * 2 / FRAC_BITS,
	FLIT(-1110288216.0) * 2 / FRAC_BITS_2,
	FLIT(-1305253606.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](492 / 512) */
	FLIT(-123449159.0) * 2 / FRAC_BITS,
	FLIT(-3355115393.0) * 2 / FRAC_BITS_2,
	FLIT(-357982321.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](493 / 512) */
	FLIT(-117158469.0) * 2 / FRAC_BITS,
	FLIT(-1185614740.0) * 2 / FRAC_BITS_2,
	FLIT(-1813066230.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](494 / 512) */
	FLIT(-110880525.0) * 2 / FRAC_BITS,
	FLIT(-3748972199.0) * 2 / FRAC_BITS_2,
	FLIT(-2612615444.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](495 / 512) */
	FLIT(-104615278.0) * 2 / FRAC_BITS,
	FLIT(-69092455.0) * 2 / FRAC_BITS_2,
	FLIT(-1344326870.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](496 / 512) */
	FLIT(-98362674.0) * 2 / FRAC_BITS,
	FLIT(-1985361239.0) * 2 / FRAC_BITS_2,
	FLIT(-2037440575.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](497 / 512) */
	FLIT(-92122664.0) * 2 / FRAC_BITS,
	FLIT(-1192171591.0) * 2 / FRAC_BITS_2,
	FLIT(-413711800.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](498 / 512) */
	FLIT(-85895196.0) * 2 / FRAC_BITS,
	FLIT(-3587969994.0) * 2 / FRAC_BITS_2,
	FLIT(-3532546833.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](499 / 512) */
	FLIT(-79680221.0) * 2 / FRAC_BITS,
	FLIT(-3494867619.0) * 2 / FRAC_BITS_2,
	FLIT(-3236078579.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](500 / 512) */
	FLIT(-73477689.0) * 2 / FRAC_BITS,
	FLIT(-828030474.0) * 2 / FRAC_BITS_2,
	FLIT(-1224226308.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](501 / 512) */
	FLIT(-67287549.0) * 2 / FRAC_BITS,
	FLIT(-1085305062.0) * 2 / FRAC_BITS_2,
	FLIT(-3274780009.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](502 / 512) */
	FLIT(-61109752.0) * 2 / FRAC_BITS,
	FLIT(-2452045587.0) * 2 / FRAC_BITS_2,
	FLIT(-2041958266.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](503 / 512) */
	FLIT(-54944250.0) * 2 / FRAC_BITS,
	FLIT(-85912532.0) * 2 / FRAC_BITS_2,
	FLIT(-4148467921.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](504 / 512) */
	FLIT(-48790992.0) * 2 / FRAC_BITS,
	FLIT(-3286674118.0) * 2 / FRAC_BITS_2,
	FLIT(-3398462499.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](505 / 512) */
	FLIT(-42649932.0) * 2 / FRAC_BITS,
	FLIT(-1126499979.0) * 2 / FRAC_BITS_2,
	FLIT(-3364041684.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](506 / 512) */
	FLIT(-36521020.0) * 2 / FRAC_BITS,
	FLIT(-1094797473.0) * 2 / FRAC_BITS_2,
	FLIT(-2032566897.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](507 / 512) */
	FLIT(-30404208.0) * 2 / FRAC_BITS,
	FLIT(-3318635974.0) * 2 / FRAC_BITS_2,
	FLIT(-3105905267.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](508 / 512) */
	FLIT(-24299450.0) * 2 / FRAC_BITS,
	FLIT(-553071221.0) * 2 / FRAC_BITS_2,
	FLIT(-3050407074.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](509 / 512) */
	FLIT(-18206696.0) * 2 / FRAC_BITS,
	FLIT(-3941368577.0) * 2 / FRAC_BITS_2,
	FLIT(-1163921031.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](510 / 512) */
	FLIT(-12125902.0) * 2 / FRAC_BITS,
	FLIT(-55843573.0) * 2 / FRAC_BITS_2,
	FLIT(-930662347.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](511 / 512) */
	FLIT(-6057018.0) * 2 / FRAC_BITS,
	FLIT(-2428075880.0) * 2 / FRAC_BITS_2,
	FLIT(-2557931334.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](512 / 512) */
	FLIT(-0.0) * 2 / FRAC_BITS,
	FLIT(-0.0) * 2 / FRAC_BITS_2,
	FLIT(-0.0) * 2 / FRAC_BITS_2 / FRAC_BITS},
	};

 #elif 53 <= FBITS
  #define MAX_Y		FLIT(40.0)
  #define MAX_YLOGX	FLIT(15.0)
  #define FRAC_BITS	67108864.0L		/* 2^26 */

static const FTYPE log2e[] = {
	(FTYPE)(FLIT(48408812.0) / FRAC_BITS * 2),	/* 1/ln(2) */
	(FTYPE)(FLIT(43368831.0) / FRAC_BITS / FRAC_BITS * 2),
	(FTYPE)(FLIT(3076001.0) / FRAC_BITS / FRAC_BITS / FRAC_BITS * 2),
	(FTYPE)(FLIT(67031145.0) / FRAC_BITS / FRAC_BITS / FRAC_BITS
		/ FRAC_BITS * 2),
	};

  #define KMAX		6	/* enable ln(x+a) expansion */

static FTYPE scale = (FTYPE)(1 << KMAX);

static FTYPE lnbias[][ACSIZE] = {	/* binary logs for centers */
	{/* log[2](32 / 64) */
	FLIT(-33554432.0) * 2 / FRAC_BITS,
	FLIT(-0.0) * 2 / FRAC_BITS_2,
	FLIT(-0.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](33 / 64) */
	FLIT(-32064812.0) * 2 / FRAC_BITS,
	FLIT(-36291593.0) * 2 / FRAC_BITS_2,
	FLIT(-59567263.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](34 / 64) */
	FLIT(-30619666.0) * 2 / FRAC_BITS,
	FLIT(-2733927.0) * 2 / FRAC_BITS_2,
	FLIT(-19949173.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](35 / 64) */
	FLIT(-29216413.0) * 2 / FRAC_BITS,
	FLIT(-53631073.0) * 2 / FRAC_BITS_2,
	FLIT(-52065808.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](36 / 64) */
	FLIT(-27852695.0) * 2 / FRAC_BITS,
	FLIT(-6308503.0) * 2 / FRAC_BITS_2,
	FLIT(-35133437.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](37 / 64) */
	FLIT(-26526343.0) * 2 / FRAC_BITS,
	FLIT(-19181878.0) * 2 / FRAC_BITS_2,
	FLIT(-50595768.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](38 / 64) */
	FLIT(-25235365.0) * 2 / FRAC_BITS,
	FLIT(-7330175.0) * 2 / FRAC_BITS_2,
	FLIT(-24581577.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](39 / 64) */
	FLIT(-23977922.0) * 2 / FRAC_BITS,
	FLIT(-43925272.0) * 2 / FRAC_BITS_2,
	FLIT(-54451491.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](40 / 64) */
	FLIT(-22752317.0) * 2 / FRAC_BITS,
	FLIT(-42359950.0) * 2 / FRAC_BITS_2,
	FLIT(-41999210.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](41 / 64) */
	FLIT(-21556977.0) * 2 / FRAC_BITS,
	FLIT(-38559332.0) * 2 / FRAC_BITS_2,
	FLIT(-13908310.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](42 / 64) */
	FLIT(-20390443.0) * 2 / FRAC_BITS,
	FLIT(-47979806.0) * 2 / FRAC_BITS_2,
	FLIT(-61187749.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](43 / 64) */
	FLIT(-19251360.0) * 2 / FRAC_BITS,
	FLIT(-18411435.0) * 2 / FRAC_BITS_2,
	FLIT(-61732296.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](44 / 64) */
	FLIT(-18138464.0) * 2 / FRAC_BITS,
	FLIT(-66691774.0) * 2 / FRAC_BITS_2,
	FLIT(-8446112.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](45 / 64) */
	FLIT(-17050580.0) * 2 / FRAC_BITS,
	FLIT(-48668454.0) * 2 / FRAC_BITS_2,
	FLIT(-10023783.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](46 / 64) */
	FLIT(-15986607.0) * 2 / FRAC_BITS,
	FLIT(-63598934.0) * 2 / FRAC_BITS_2,
	FLIT(-27753896.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](47 / 64) */
	FLIT(-14945518.0) * 2 / FRAC_BITS,
	FLIT(-5934076.0) * 2 / FRAC_BITS_2,
	FLIT(-35408620.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](48 / 64) */
	FLIT(-13926347.0) * 2 / FRAC_BITS,
	FLIT(-36708683.0) * 2 / FRAC_BITS_2,
	FLIT(-51121150.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](49 / 64) */
	FLIT(-12928192.0) * 2 / FRAC_BITS,
	FLIT(-22542246.0) * 2 / FRAC_BITS_2,
	FLIT(-20133197.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](50 / 64) */
	FLIT(-11950203.0) * 2 / FRAC_BITS,
	FLIT(-17611037.0) * 2 / FRAC_BITS_2,
	FLIT(-16889556.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](51 / 64) */
	FLIT(-10991581.0) * 2 / FRAC_BITS,
	FLIT(-39442611.0) * 2 / FRAC_BITS_2,
	FLIT(-3961460.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](52 / 64) */
	FLIT(-10051575.0) * 2 / FRAC_BITS,
	FLIT(-7216589.0) * 2 / FRAC_BITS_2,
	FLIT(-3330340.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](53 / 64) */
	FLIT(-9129474.0) * 2 / FRAC_BITS,
	FLIT(-40664619.0) * 2 / FRAC_BITS_2,
	FLIT(-3742343.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](54 / 64) */
	FLIT(-8224610.0) * 2 / FRAC_BITS,
	FLIT(-43017187.0) * 2 / FRAC_BITS_2,
	FLIT(-19145723.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](55 / 64) */
	FLIT(-7336350.0) * 2 / FRAC_BITS,
	FLIT(-41942860.0) * 2 / FRAC_BITS_2,
	FLIT(-50445322.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](56 / 64) */
	FLIT(-6464096.0) * 2 / FRAC_BITS,
	FLIT(-11271123.0) * 2 / FRAC_BITS_2,
	FLIT(-10066598.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](57 / 64) */
	FLIT(-5607280.0) * 2 / FRAC_BITS,
	FLIT(-44038859.0) * 2 / FRAC_BITS_2,
	FLIT(-8593864.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](58 / 64) */
	FLIT(-4765367.0) * 2 / FRAC_BITS,
	FLIT(-2798409.0) * 2 / FRAC_BITS_2,
	FLIT(-28619918.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](59 / 64) */
	FLIT(-3937845.0) * 2 / FRAC_BITS,
	FLIT(-55023594.0) * 2 / FRAC_BITS_2,
	FLIT(-46962292.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](60 / 64) */
	FLIT(-3124233.0) * 2 / FRAC_BITS,
	FLIT(-11959770.0) * 2 / FRAC_BITS_2,
	FLIT(-26011496.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](61 / 64) */
	FLIT(-2324069.0) * 2 / FRAC_BITS,
	FLIT(-19923620.0) * 2 / FRAC_BITS_2,
	FLIT(-60922053.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](62 / 64) */
	FLIT(-1536916.0) * 2 / FRAC_BITS,
	FLIT(-52913507.0) * 2 / FRAC_BITS_2,
	FLIT(-22404700.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](63 / 64) */
	FLIT(-762359.0) * 2 / FRAC_BITS,
	FLIT(-17579626.0) * 2 / FRAC_BITS_2,
	FLIT(-45200036.0) * 2 / FRAC_BITS_2 / FRAC_BITS},

	{/* log[2](64 / 64) */
	FLIT(-0.0) * 2 / FRAC_BITS,
	FLIT(-0.0) * 2 / FRAC_BITS_2,
	FLIT(-0.0) * 2 / FRAC_BITS_2 / FRAC_BITS},
	};

 #elif 24 <= FBITS
  #define MAX_Y		FLIT(40.0)
  #define MAX_YLOGX	FLIT(12.0)
  #define FRAC_BITS	4096.0L		/* 2^12 */

static const FTYPE log2e[] = {
	(FTYPE)(FLIT(2954.0) / FRAC_BITS * 2),	/* 1/ln(2) */
	(FTYPE)(FLIT(2619.0) / FRAC_BITS / FRAC_BITS * 2),
	(FTYPE)(FLIT(661.0) / FRAC_BITS / FRAC_BITS / FRAC_BITS * 2),
	(FTYPE)(FLIT(3095.0) / FRAC_BITS / FRAC_BITS / FRAC_BITS
		/ FRAC_BITS * 2),
	};

  #define KMAX		0	/* disable ln(x+a) expansion */

 #else /* FBITS */
  #error pow has insufficient precision
 #endif /* FBITS */

/*
 * Copyright (c) 1994-2005 by P.J. Plauger.  ALL RIGHTS RESERVED. 
 * Consult your license regarding permissions and restrictions.
V5.00:1521 */
