/* xxxerfc.h -- common _[FL]Erfc functionality */
#include "xmath.h"
_STD_BEGIN

	/* coefficients */
#if defined(_BUILD_FOR_RENESAS) && defined(_R_FLT)		/* V10000K102 */

		 #if   FBITS <= 24
		  #define DPOLY(x)	((c[0] * x + c[1]) * x + c[2])
		  #define NPOLY(x)	(((s[0] * x + s[1]) * x + s[2]) * x + s[3])

		/* extern const */ FTYPE FNAME(Erf_one) = FLIT(3.82);

		static const FTYPE s[] = {	/* 3/2, 1.523 <= x <= 3.82 */
			FLIT(-0.1904329681e-3),
			FLIT( 0.3365143039e-2),
			FLIT( 0.3904994244),
			FLIT( 0.8272613270),
			};

		static const FTYPE c[] = {
			FLIT( 0.7372748054),
			FLIT( 1.2764107769),
			FLIT( 0.8419510227),
			};

		 #elif FBITS <= 53
		  #define DPOLY(x)	FNAME(Poly)(x, c, sizeof (c) / sizeof (c[0]) - 1)
		  #define NPOLY(x)	FNAME(Poly)(x, s, sizeof (s) / sizeof (s[0]) - 1)

		/* extern const */ FTYPE FNAME(Erf_one) = FLIT(5.84);

		static const FTYPE s[] = {	/* 6/6, 1.523 <= x <= 5.84 */
			FLIT( 6.1792832735846071e-10),
			FLIT( 1.1684287172270874e-02),
			FLIT( 9.5637893500953100e-02),
			FLIT( 3.8676415143622900e-01),
			FLIT( 9.1231706220035758e-01),
			FLIT( 1.2525362561495670e+00),
			FLIT( 8.3571382001120953e-01),
			};

		static const FTYPE c[] = {
			FLIT( 2.0709916302643547e-02),
			FLIT( 1.6951239053544545e-01),
			FLIT( 6.9589694980162042e-01),
			FLIT( 1.7015840993444071e+00),
			FLIT( 2.5541015508553357e+00),
			FLIT( 2.1955066259704652e+00),
			FLIT( 8.3571864525686790e-01),
			};

		 #elif FBITS <= 67
		  #define DPOLY(x)	FNAME(Poly)(x, c, sizeof (c) / sizeof (c[0]) - 1)
		  #define NPOLY(x)	FNAME(Poly)(x, s, sizeof (s) / sizeof (s[0]) - 1)

		/* extern const */ FTYPE FNAME(Erf_one) = FLIT(6.45);

		static const FTYPE s[] = {	/* 8/8, 1.523 <= x <= 6.45 */
			FLIT( 3.9823665956705046e-13),
			FLIT( 1.0305751819545013e-03),
			FLIT( 1.3240156780346166e-02),
			FLIT( 8.4684130850007575e-02),
			FLIT( 3.3721428277131882e-01),
			FLIT( 8.9258194194792007e-01),
			FLIT( 1.5680950663872535e+00),
			FLIT( 1.7077875378129037e+00),
			FLIT( 9.1727270872118738e-01),
			};

		static const FTYPE c[] = {
			FLIT( 1.8266470018578099e-03),
			FLIT( 2.3467565054201025e-02),
			FLIT( 1.5101207757531432e-01),
			FLIT( 6.0942990391849616e-01),
			FLIT( 1.6562038680390530e+00),
			FLIT( 3.0664204964536554e+00),
			FLIT( 3.7457634749394795e+00),
			FLIT( 2.7428186078612251e+00),
			FLIT( 9.1727275091376992e-01),
			};

		 #elif FBITS <= 113
		  #define DPOLY(x)	FNAME(Poly)(x, c, sizeof (c) / sizeof (c[0]) - 1)
		  #define NPOLY(x)	FNAME(Poly)(x, s, sizeof (s) / sizeof (s[0]) - 1)

		/* extern const */ FTYPE FNAME(Erf_one) = FLIT(8.68);

		static const FTYPE s[] = {	/* 16/15, 1.523 <= x <= 8.68 */
			FLIT( 4.8855209310640277e-27),
			FLIT(-8.8227359218857487e-25),
			FLIT( 5.5461604037503264e-09),
			FLIT( 1.9014277865124507e-07),
			FLIT( 3.2520972668934794e-06),
			FLIT( 3.6388642487576878e-05),
			FLIT( 2.9557014465679733e-04),
			FLIT( 1.8351323952331701e-03),
			FLIT( 8.9534212346402253e-03),
			FLIT( 3.4801798915914534e-02),
			FLIT( 1.0819185350486094e-01),
			FLIT( 2.6770678673921655e-01),
			FLIT( 5.1957496897602196e-01),
			FLIT( 7.6893852075313784e-01),
			FLIT( 8.2392646495986810e-01),
			FLIT( 5.7636263867860460e-01),
			FLIT( 2.0108119985903089e-01),
			};

		static const FTYPE c[] = {
			FLIT( 9.8303133653668212e-09),
			FLIT( 3.3701930024228232e-07),
			FLIT( 5.7691074809070075e-06),
			FLIT( 6.4665699156461423e-05),
			FLIT( 5.2676162211479311e-04),
			FLIT( 3.2847675659616014e-03),
			FLIT( 1.6128598358289219e-02),
			FLIT( 6.3279098928549701e-02),
			FLIT( 1.9944504788391967e-01),
			FLIT( 5.0379293566266092e-01),
			FLIT( 1.0094988350207217e+00),
			FLIT( 1.5730897409993596e+00),
			FLIT( 1.8424900135760700e+00),
			FLIT( 1.5292253946412704e+00),
			FLIT( 8.0325847549410656e-01),
			FLIT( 2.0108119985903070e-01),
			};

		 #else /* FBITS */
		  #error _Erfc has insufficient precision
		 #endif /* FBITS */

#else


 #if   FBITS <= 24
  #define DPOLY(x)	((c[0] * x + c[1]) * x + c[2])
  #define NPOLY(x)	(((s[0] * x + s[1]) * x + s[2]) * x + s[3])

/* extern const */ FTYPE FNAME(Erf_one) = FLIT(3.82);

static const FTYPE s[] = {	/* 3/2, 1.523 <= x <= 3.82 */
	FLIT(-0.1904329681e-3),
	FLIT( 0.3365143039e-2),
	FLIT( 0.3904994244),
	FLIT( 0.8272613270),
	};

static const FTYPE c[] = {
	FLIT( 0.7372748054),
	FLIT( 1.2764107769),
	FLIT( 0.8419510227),
	};

 #elif FBITS <= 53
  #define DPOLY(x)	FNAME(Poly)(x, c, sizeof (c) / sizeof (c[0]) - 1)
  #define NPOLY(x)	FNAME(Poly)(x, s, sizeof (s) / sizeof (s[0]) - 1)

/* extern const */ FTYPE FNAME(Erf_one) = FLIT(5.84);

static const FTYPE s[] = {	/* 6/6, 1.523 <= x <= 5.84 */
	FLIT( 0.61792832735846070258e-9),
	FLIT( 0.11684287172270874217e-1),
	FLIT( 0.95637893500953094717e-1),
	FLIT( 0.38676415143622898851),
	FLIT( 0.91231706220035757904),
	FLIT( 1.25253625614956703876),
	FLIT( 0.83571382001120956678),
	};

static const FTYPE c[] = {
	FLIT( 0.20709916302643547030e-1),
	FLIT( 0.16951239053544544290),
	FLIT( 0.69589694980162046232),
	FLIT( 1.70158409934440707405),
	FLIT( 2.55410155085533580188),
	FLIT( 2.19550662597046521735),
	FLIT( 0.83571864525686785467),
	};

 #elif FBITS <= 67
  #define DPOLY(x)	FNAME(Poly)(x, c, sizeof (c) / sizeof (c[0]) - 1)
  #define NPOLY(x)	FNAME(Poly)(x, s, sizeof (s) / sizeof (s[0]) - 1)

/* extern const */ FTYPE FNAME(Erf_one) = FLIT(6.45);

static const FTYPE s[] = {	/* 8/8, 1.523 <= x <= 6.45 */
	FLIT( 0.3982366595670504399244521e-12),
	FLIT( 0.1030575181954501302353221e-2),
	FLIT( 0.1324015678034616536851924e-1),
	FLIT( 0.8468413085000757161966266e-1),
	FLIT( 0.3372142827713188129837938),
	FLIT( 0.8925819419479200421116839),
	FLIT( 1.5680950663872533819280129),
	FLIT( 1.7077875378129038467960200),
	FLIT( 0.9172727087211874336366180),
	};

static const FTYPE c[] = {
	FLIT( 0.1826647001857809893554410e-2),
	FLIT( 0.2346756505420102427184070e-1),
	FLIT( 0.1510120775753143340433125),
	FLIT( 0.6094299039184962013668769),
	FLIT( 1.6562038680390530271358464),
	FLIT( 3.0664204964536552860192478),
	FLIT( 3.7457634749394795507231292),
	FLIT( 2.7428186078612249378422898),
	FLIT( 0.9172727509137699498745190),
	};

 #elif FBITS <= 113
  #define DPOLY(x)	FNAME(Poly)(x, c, sizeof (c) / sizeof (c[0]) - 1)
  #define NPOLY(x)	FNAME(Poly)(x, s, sizeof (s) / sizeof (s[0]) - 1)

/* extern const */ FTYPE FNAME(Erf_one) = FLIT(8.68);

static const FTYPE s[] = {	/* 16/15, 1.523 <= x <= 8.68 */
	FLIT( 0.48855209310640276804305233185598921e-26),
	FLIT(-0.88227359218857478559335144433937656e-24),
	FLIT( 0.55461604037503267563215470701218812e-8),
	FLIT( 0.19014277865124507488158812474886923e-6),
	FLIT( 0.32520972668934791576950783450350765e-5),
	FLIT( 0.36388642487576878259051891057073040e-4),
	FLIT( 0.29557014465679734454153740538111773e-3),
	FLIT( 0.18351323952331700907225852099564597e-2),
	FLIT( 0.89534212346402258584503055479788071e-2),
	FLIT( 0.34801798915914533366900587811088718e-1),
	FLIT( 0.10819185350486092639853054900511446),
	FLIT( 0.26770678673921654105352596126503848),
	FLIT( 0.51957496897602199640258780829689114),
	FLIT( 0.76893852075313785542678534369981692),
	FLIT( 0.82392646495986814492858615912585115),
	FLIT( 0.57636263867860456048919433777939797),
	FLIT( 0.20108119985903088508219012350654573),
	};

static const FTYPE c[] = {
	FLIT( 0.98303133653668207579238433353825957e-8),
	FLIT( 0.33701930024228231587253433671219488e-6),
	FLIT( 0.57691074809070078550876764981535688e-5),
	FLIT( 0.64665699156461426447612497779078724e-4),
	FLIT( 0.52676162211479305928855854637498930e-3),
	FLIT( 0.32847675659616013862588770587625771e-2),
	FLIT( 0.16128598358289219076328461990453505e-1),
	FLIT( 0.63279098928549700456425105853399327e-1),
	FLIT( 0.19944504788391965783604607553960587),
	FLIT( 0.50379293566266091223169156435954456),
	FLIT( 1.00949883502072169922224925756156511),
	FLIT( 1.57308974099935961959954265933666554),
	FLIT( 1.84249001357607014096332750744848032),
	FLIT( 1.52922539464127030194091217994490513),
	FLIT( 0.80325847549410657269231276509661127),
	FLIT( 0.20108119985903069604991623646723121),
	};

 #else /* FBITS */
  #error _Erfc has insufficient precision
 #endif /* FBITS */

#endif														/* V10000K102 */


/* extern const */ FTYPE FNAME(Erf_small) = FLIT(1.523);

FTYPE (FNAME(Erfc))(FTYPE x)
	{	/* compute erfc(x), 1 - 2^(FBITS-1/2) < erfc(x) < 1/2 */
	FTYPE z = -x * x;

	FNAME(Exp)(&z, NPOLY(x) / DPOLY(x), 0);
	return (z);
	}
_STD_END

/*
 * Copyright (c) 1992-2007 by P.J. Plauger.  ALL RIGHTS RESERVED.
 * Consult your license regarding permissions and restrictions.
V5.03:0216 */
