/* xxxquad.h -- _[FL]Quad supplemental */

 #if 113 <= FBITS
  #define ACSHIFT	6
  #define FRAC_BITS	72057594037927936.0L		/* 2^56 */
  #define FULL_BITS	(FRAC_BITS_1 * FRAC_BITS_1 * 2)	/* 2^113 */
  #define FRAC_XTRA	7

static const FTYPE c[] = {	/* 2*pi * FRAC_BITS */
	(FTYPE)(FLIT(56593902016227522.0) * 8),
	(FTYPE)(FLIT(14853055124832476.0) * 8 / FRAC_BITS_1),
	(FTYPE)(FLIT(8111273410431114.0) * 8 / FRAC_BITS_2),
	(FTYPE)(FLIT(29216721223794342.0) * 8 / FRAC_BITS_3),
	(FTYPE)(FLIT(16628580642540040.0) * 8 / FRAC_BITS_4),
	(FTYPE)(FLIT(34214826253086613.0) * 8 / FRAC_BITS_5),
	};

static const FTYPE b[][ACSIZE]={	/* 2^N mod 2*Pi */
	{	/* 2^64 mod 2*Pi: 3.117992 */
	(FTYPE)(FLIT(56168749587851680.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(60503861654432048.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(19383957162966487.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(68337176116388606.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(54741230894245508.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(64538885340340224.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^128 mod 2*Pi: 1.346130 */
	(FTYPE)(FLIT(48499447582733368.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(19814507273381338.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(13129279075702268.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(11126851193220333.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(69279096418731623.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(62959861820357831.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^192 mod 2*Pi: 3.131272 */
	(FTYPE)(FLIT(56407974148896541.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(52586498126327436.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(36488013854957315.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(42394831819343127.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(11976807828538090.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(66289912679783363.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^256 mod 2*Pi: 2.694543 */
	(FTYPE)(FLIT(48540579472857568.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(21940522073322363.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(18439914774250907.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(16843761383249090.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(69365228817645250.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(58413190190094682.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^320 mod 2*Pi: .038570 */
	(FTYPE)(FLIT(1389617304469789.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(839869362169894.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(10850549354452451.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(46545672039841066.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(64715667372036548.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(10224409900482761.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^384 mod 2*Pi: 1.559242 */
	(FTYPE)(FLIT(56177598328739621.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1136993544505376.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(43371105579836755.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(28853994600746629.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(68500754214112014.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(57177044903663132.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^448 mod 2*Pi: -1.714938 */
	(FTYPE)(FLIT(-61787136243077602.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(39407815509631115.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(47454143518740262.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(22023334110481952.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(42130600836089580.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(24918185315092957.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^512 mod 2*Pi: 1.433420 */
	(FTYPE)(FLIT(51644386435457085.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3469259069167791.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(18223168542704401.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(16688515733776574.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(64504766911587624.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(37928904785818766.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^576 mod 2*Pi: 1.924039 */
	(FTYPE)(FLIT(69320826037280178.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(25058449446032873.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(12036771522046937.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(63513637271634701.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(27244777456050716.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(20673234342755435.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^640 mod 2*Pi: .960377 */
	(FTYPE)(FLIT(34601220524664661.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(15924618201592593.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(22738504219526962.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(22171104113944848.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(36580828554297892.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(15660679999575195.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^704 mod 2*Pi: -1.374624 */
	(FTYPE)(FLIT(-49526059965819944.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(24101085195900811.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(42252563147558213.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(36240284802649417.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(32201426016221947.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(30428513887836874.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^768 mod 2*Pi: -.103183 */
	(FTYPE)(FLIT(-3717542566730646.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(55793906219632905.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(24827831467224068.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(15534615154180771.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(69680926845653913.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(6967948550664815.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^832 mod 2*Pi: -.900675 */
	(FTYPE)(FLIT(-32450219974741413.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(45553170903685640.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(47910572287137496.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(46492533627438284.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(25967620228410639.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(27418135608371784.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^896 mod 2*Pi: -1.084375 */
	(FTYPE)(FLIT(-39068714889462316.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(67301480991747257.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(24966917441095228.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(49481736478941986.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(61780357329519940.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(45889228494887289.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^960 mod 2*Pi: 2.289652 */
	(FTYPE)(FLIT(41246696239884752.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(27679849855836777.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(26802125801892456.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(44930804441521661.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(47770761428538776.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(64814091414208301.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^1024 mod 2*Pi: -1.196332 */
	(FTYPE)(FLIT(-43102395882956400.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(9080651494622542.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(29030823238420432.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(70681517477772378.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(57946192890323353.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(59073460983954676.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^1088 mod 2*Pi: -2.479024 */
	(FTYPE)(FLIT(-44658123298931162.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(44791768512390799.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(34944466359405799.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(35534475460915993.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(17355189025257259.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(57630774231078436.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^1152 mod 2*Pi: .527766 */
	(FTYPE)(FLIT(19014767473639502.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(33521549496576386.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(9033927813028371.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(18975467535893065.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(17313313063985122.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(7710805617843575.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^1216 mod 2*Pi: -.093196 */
	(FTYPE)(FLIT(-3357728510099405.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(36423585111495836.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(16412661964425112.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(58375092540666690.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(10523510364673008.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(35165098906862398.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^1280 mod 2*Pi: 2.613222 */
	(FTYPE)(FLIT(47075618700774753.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(14922815664501604.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(6939725928255335.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(32760701827620034.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1564237591851796.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(6805001796213007.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^1344 mod 2*Pi: .623408 */
	(FTYPE)(FLIT(22460636626403298.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(44800913893927064.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(48607978251569417.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(30182819811831660.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(29513857495825453.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(39510827849262688.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^1408 mod 2*Pi: .871297 */
	(FTYPE)(FLIT(31391796784865357.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(16749011438837926.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(12906603914780008.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(8474009987602191.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(24920822761216266.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(32902010344762719.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^1472 mod 2*Pi: 1.607758 */
	(FTYPE)(FLIT(57925574903284247.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(44778666614520174.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(33507841308741747.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(24958458113639337.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(22646693022772801.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(52384414577986373.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^1536 mod 2*Pi: 2.165273 */
	(FTYPE)(FLIT(39006098008876331.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(26016135468869520.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(45564858131600952.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(18840412272021026.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(12063248630703307.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(69643783841985558.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^1600 mod 2*Pi: .158082 */
	(FTYPE)(FLIT(5695491512658906.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(35297104233942806.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(61839423668069793.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(39115846233273968.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(29845645825400183.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(765413466642745.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^1664 mod 2*Pi: -2.335635 */
	(FTYPE)(FLIT(-42075062085714801.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(7250128943705042.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1063672392844950.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(58100100098171887.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(21136713033802446.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(59476349793969375.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^1728 mod 2*Pi: -1.781353 */
	(FTYPE)(FLIT(-64179995395143845.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(4458713231458406.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(44274239437793741.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(26884667780707122.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(69956680185381203.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(54231688496267351.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^1792 mod 2*Pi: -2.123053 */
	(FTYPE)(FLIT(-38245517783126272.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(56361520398488870.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(30165773619697253.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(30928400489244393.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2024256899721933.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(33583677653998706.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^1856 mod 2*Pi: .311467 */
	(FTYPE)(FLIT(11221775956077033.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(70878192829431173.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(21436851645546707.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2608837202491530.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(6693042253713853.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(42469087127093017.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^1920 mod 2*Pi: -.372826 */
	(FTYPE)(FLIT(-13432457556980056.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(60494001424331067.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(68697896447070002.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(27736243078476002.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(57479635629976253.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(58337623406821268.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^1984 mod 2*Pi: .977005 */
	(FTYPE)(FLIT(35200310266208895.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(21967175370837536.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(49501490742702511.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(24078972115041591.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(26557170346753057.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(35145991596685362.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^2048 mod 2*Pi: 2.404925 */
	(FTYPE)(FLIT(43323286183789505.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(69440148784819719.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(37111730983922386.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(15105344684485000.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(62514158351854357.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(44967583435104006.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^2112 mod 2*Pi: -1.604955 */
	(FTYPE)(FLIT(-57824610534670756.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(45087471758618506.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(68654386750942845.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(40565018616592064.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(11853311431810757.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(39795301558238741.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^2176 mod 2*Pi: -1.437194 */
	(FTYPE)(FLIT(-51780379859392543.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(26853112282267132.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(65381603992572241.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(8034803512064885.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(47720055454389379.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(46667803971914505.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^2240 mod 2*Pi: -1.934799 */
	(FTYPE)(FLIT(-69708482609057035.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(50013851427747784.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(10049377571944267.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(15019196375096122.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(14989486343974797.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(40324897352872698.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^2304 mod 2*Pi: .432523 */
	(FTYPE)(FLIT(15583291999779331.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(26435199364741484.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(48228392838755907.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(38911195737283699.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(22205713419454515.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(4194538087339730.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^2368 mod 2*Pi: -2.190515 */
	(FTYPE)(FLIT(-39460816831601063.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(36212844335643060.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(13430066015630231.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(66953651354568286.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(65903421431701846.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(51168805227761811.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^2432 mod 2*Pi: -.541763 */
	(FTYPE)(FLIT(-19519064326307234.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(23970675587207460.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(53115020600616363.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(57145326017173201.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(58429422847100370.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(37147963530402769.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^2496 mod 2*Pi: -1.423135 */
	(FTYPE)(FLIT(-51273853663668861.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(31135499799729078.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(65044155576760778.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(50616355670343076.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(46628287506668917.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(32809763057573619.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^2560 mod 2*Pi: 2.188507 */
	(FTYPE)(FLIT(39424644767661166.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(55403986543709564.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(25857168202426438.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(8035159996814281.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(48289465672311903.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(20737841875568138.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^2624 mod 2*Pi: -.487928 */
	(FTYPE)(FLIT(-17579461240832868.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(41469489211878312.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(6973399118861807.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(54260380413747016.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(45699364178654466.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(416101977271753.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^2688 mod 2*Pi: 1.336630 */
	(FTYPE)(FLIT(48157175167378656.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(70346481995749140.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(65024791279946355.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(21533830952695593.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(61771995356048827.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(11971410695527710.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^2752 mod 2*Pi: -1.347038 */
	(FTYPE)(FLIT(-48532153238584555.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(49595804377426676.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(67101407568252534.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(33256564715415513.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(58704235956224590.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(59095367608613641.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^2816 mod 2*Pi: 1.761012 */
	(FTYPE)(FLIT(63447161060727241.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(6127324313154526.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(11877269692241942.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(46045814053629258.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(47615567463260972.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(15441528827191599.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^2880 mod 2*Pi: 3.136646 */
	(FTYPE)(FLIT(56504793007749631.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(35229456744135363.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(13258131119857430.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(4896315053504582.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(66384093065134967.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(19003107354778513.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^2944 mod 2*Pi: -.630275 */
	(FTYPE)(FLIT(-22708041435344004.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(33465016830858773.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(52177142666412143.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(4476796192665657.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(40165136601258864.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(59000935506252507.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^3008 mod 2*Pi: -.950240 */
	(FTYPE)(FLIT(-34236013065191938.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(36292718490660753.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(38323499969050316.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2373739311143874.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(67675181842648761.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(32594654075661193.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^3072 mod 2*Pi: -1.879008 */
	(FTYPE)(FLIT(-67698405438161967.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(50867283692325741.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(44148188890827756.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(67725421192086469.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(67760734236154306.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(57497325201965706.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^3136 mod 2*Pi: -.994981 */
	(FTYPE)(FLIT(-35847985185659878.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3322060318314154.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(14475442231492864.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(19673046728142516.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(64026594708406720.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(765990928640666.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^3200 mod 2*Pi: -2.185200 */
	(FTYPE)(FLIT(-39365060226058768.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(66810511607896375.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(22456144996327531.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(12166231332111914.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(14685239771136737.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(30792357119964755.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^3264 mod 2*Pi: .474596 */
	(FTYPE)(FLIT(17099140405077482.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(24303327760497350.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(31339911003093089.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(12935152200785738.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(25800217393024983.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(12777706473265032.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^3328 mod 2*Pi: -1.516832 */
	(FTYPE)(FLIT(-54649616419176628.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(64903353030274721.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(14427964273546802.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(57156118631205379.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(23159809104467539.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(42655094138160236.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^3392 mod 2*Pi: -1.387022 */
	(FTYPE)(FLIT(-49972720411615452.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(54392256510641474.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(16840171241151208.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(14097939676764875.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(50127717101580234.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(11100719748106974.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^3456 mod 2*Pi: -2.539828 */
	(FTYPE)(FLIT(-45753482511769168.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(55513772352167848.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(70657174340807565.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(8842807638635698.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(17055160653639334.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(49891691728629877.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^3520 mod 2*Pi: -1.635231 */
	(FTYPE)(FLIT(-58915403847277414.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(59635881464416745.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(6783484352185056.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(30767717135225340.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3281389201209322.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(51624839402282636.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^3584 mod 2*Pi: -1.114992 */
	(FTYPE)(FLIT(-40171838181103403.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(21646579584388443.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(45505263990470324.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(53919077658784557.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(37775699740531614.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(23217028704905671.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^3648 mod 2*Pi: -2.734328 */
	(FTYPE)(FLIT(-49257280666539420.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(1377577594534232.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(47570575121693852.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(48333515934728805.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(40922203979193990.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(67100789008954363.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^3712 mod 2*Pi: .065688 */
	(FTYPE)(FLIT(2366657993350416.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(65098401401421928.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(69076963038094496.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(69617476211083665.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(46575610872832047.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(8636175084387055.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^3776 mod 2*Pi: -.838404 */
	(FTYPE)(FLIT(-30206688908167249.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(52671753164701924.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(32987728122801797.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(58295451009921792.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(50077790087628930.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(40142035282469638.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^3840 mod 2*Pi: 2.309876 */
	(FTYPE)(FLIT(41611034523396586.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(29272051269874381.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(47887675831120239.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(19954079779863617.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4256473547102652.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(34057168778995942.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^3904 mod 2*Pi: -.887320 */
	(FTYPE)(FLIT(-31969087362475141.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(17710593033653288.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(6396208278744231.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(68830881657421118.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1851556687099905.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1480265033151351.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^3968 mod 2*Pi: -.775873 */
	(FTYPE)(FLIT(-27953769915305048.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(48006962951071653.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(54314609901926721.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(51186934010818215.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(36595835480316541.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(32895104074131653.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^4032 mod 2*Pi: 1.907356 */
	(FTYPE)(FLIT(68719753704602293.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(23547807506621467.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(69013103400133902.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(17838318665867221.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(48170220657204403.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(43005612199272163.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^4096 mod 2*Pi: 2.764036 */
	(FTYPE)(FLIT(49792454813210808.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(63325271416497399.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(60585040984814806.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(22319783082480837.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(21422669391507929.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(58867102168312171.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^4160 mod 2*Pi: -1.140832 */
	(FTYPE)(FLIT(-41102800612545145.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(10715351928151320.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(36592250075247111.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(54645245755775445.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(58121368463910630.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(61376564174175923.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^4224 mod 2*Pi: .893983 */
	(FTYPE)(FLIT(32209115443529681.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(36788674698928404.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2126440716982359.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(62510152664757075.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(7925109567771985.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2670641319615543.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^4288 mod 2*Pi: -.264485 */
	(FTYPE)(FLIT(-9529076159388368.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(11566236382125120.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(14821854029432214.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(50366402445740984.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(21026116707365213.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(41016625613939431.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^4352 mod 2*Pi: 1.165845 */
	(FTYPE)(FLIT(42003976749349570.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(71408323593804155.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(50163104474102901.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1797743540201753.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(10861163310780018.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(47439066725875781.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^4416 mod 2*Pi: 1.504789 */
	(FTYPE)(FLIT(54215738953590420.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(5700267714266634.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(8520788625020284.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(241526064026388.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(33113258199850728.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(12767700746441778.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^4480 mod 2*Pi: -.471484 */
	(FTYPE)(FLIT(-16987003216156091.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(50687308031644333.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(67537860046637854.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(10697706560876590.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3062289154133979.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(35555569247215019.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^4544 mod 2*Pi: -2.443591 */
	(FTYPE)(FLIT(-44019816017216657.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(68911701690492248.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(8172488774867074.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(38000374518906303.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(63046699501975687.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(46038734856513548.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^4608 mod 2*Pi: -.613148 */
	(FTYPE)(FLIT(-22090988609943967.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(36366952849614002.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(47721437753266032.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(39817399687667565.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(6621402518471777.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(37175324795760282.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^4672 mod 2*Pi: 1.857712 */
	(FTYPE)(FLIT(66931141774765711.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(49367333295662835.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(28377997079438219.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(19726187214314466.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(67966891206162472.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(23876722022818936.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^4736 mod 2*Pi: 2.092651 */
	(FTYPE)(FLIT(37697848326883206.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(6979708622356390.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(5346526521780685.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(63388573973649347.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(46736032474408466.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(51078265125465819.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^4800 mod 2*Pi: -.645538 */
	(FTYPE)(FLIT(-23257944741785488.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(5168038393801254.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4290887516755846.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(32982825857640359.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(19149761600525642.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(40905730196879339.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^4864 mod 2*Pi: 1.972936 */
	(FTYPE)(FLIT(71082509864420647.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(68953763370078819.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(34353947684800757.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(45802937296181559.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(71681288343867090.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(36024546719259499.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^4928 mod 2*Pi: 1.416693 */
	(FTYPE)(FLIT(51041757155795797.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(39964216788677024.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(15069657470015050.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(20089917286191268.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(65116766094911675.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(69350296272159752.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^4992 mod 2*Pi: .333626 */
	(FTYPE)(FLIT(12020134532972213.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(43391656503229536.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(35577223904121988.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(49020447555841935.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(41524282555240170.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(7087660864152258.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^5056 mod 2*Pi: -2.697202 */
	(FTYPE)(FLIT(-48588475319300757.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(49328769273253443.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(21711437581598204.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(43724991635794345.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(16390483882469324.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(65846003517625785.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^5120 mod 2*Pi: -2.567555 */
	(FTYPE)(FLIT(-46252959214371837.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(33631892972852535.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(28721193532466752.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(17735459442382810.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(53817768807300482.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(4519002844030143.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^5184 mod 2*Pi: .228217 */
	(FTYPE)(FLIT(8222377953701062.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(71538981648664524.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(17541558277176.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(5376249175216131.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(59330716304217306.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(34781000690889369.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^5248 mod 2*Pi: 1.865346 */
	(FTYPE)(FLIT(67206162854449456.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(23141973921561334.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(42441825571844360.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(69706161246640999.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(14621358742859091.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(36164591423532349.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^5312 mod 2*Pi: 1.461418 */
	(FTYPE)(FLIT(52653127667954994.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(40180275777289856.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(5793609706319846.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(41365345816579970.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(47772290119335850.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2650058956100974.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^5376 mod 2*Pi: .226040 */
	(FTYPE)(FLIT(8143957855296310.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(35136852337149762.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(21302117479532861.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(13950013943398940.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(9712753749962553.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(34786254354899413.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^5440 mod 2*Pi: .680682 */
	(FTYPE)(FLIT(24524158092718051.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2734386532012522.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(30345532978477908.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(50760203475531369.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(18476272827038444.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(64092794433587674.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^5504 mod 2*Pi: -2.247562 */
	(FTYPE)(FLIT(-40488475042863164.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(48734116619187890.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(6597390732809661.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(37096575641293836.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(23948703006394952.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(889995285156634.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^5568 mod 2*Pi: -1.254218 */
	(FTYPE)(FLIT(-45187965719655115.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(62789359826733269.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(60631310275674637.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(13630438462399159.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(29781435009448704.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(47693282744120004.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^5632 mod 2*Pi: -.476319 */
	(FTYPE)(FLIT(-17161204796996631.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(53103024781752623.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(53471481583124983.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(41285372075382602.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(66329743099447281.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(4568828068683042.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^5696 mod 2*Pi: -.726983 */
	(FTYPE)(FLIT(-26192329514867450.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(45062753004176885.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(63648615170205548.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(33959453677291016.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(58989852819569249.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3009495145746359.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^5760 mod 2*Pi: -1.467434 */
	(FTYPE)(FLIT(-52869887039152692.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(66720577152949822.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(7245753897281235.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(8786565664533210.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(41203013022807020.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(48708261208228029.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^5824 mod 2*Pi: .563461 */
	(FTYPE)(FLIT(20300819354689813.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(62288244093858072.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4671704640296208.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(39694600262071560.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(366954032022780.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(16977294574405981.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^5888 mod 2*Pi: 1.626293 */
	(FTYPE)(FLIT(58593387905288657.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(45859454568339463.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(38136712928340611.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(861693792048611.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(28863112918900011.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(38246145500450911.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^5952 mod 2*Pi: .963511 */
	(FTYPE)(FLIT(34714156463267109.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(6047897509433530.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(28503043639571211.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(27458632743911450.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(28057529243692097.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(27093353698263211.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^6016 mod 2*Pi: -.461597 */
	(FTYPE)(FLIT(-16630793312472681.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2446920439252170.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(58079799698914682.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(56448689567581184.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(20338346434277641.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(65621407036935612.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^6080 mod 2*Pi: 2.229107 */
	(FTYPE)(FLIT(40156025956688703.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(52583902317579684.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(44587247181860937.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(41353875174870648.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(12305028896520497.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(60392345219816782.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^6144 mod 2*Pi: -2.081306 */
	(FTYPE)(FLIT(-37493471000875256.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(47932938728970336.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(49212321550515300.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(23589794589887822.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(47192526955123045.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(44605174843183647.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^6208 mod 2*Pi: -2.254716 */
	(FTYPE)(FLIT(-40617346700126785.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(31258264161844740.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(65111259343414263.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(12682884502349886.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(15939080125482817.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(65906678358938644.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^6272 mod 2*Pi: -2.135192 */
	(FTYPE)(FLIT(-38464190997438297.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(50347946956653744.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(731497770994481.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(39059892363360284.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2582335207718282.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(6510138332275045.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^6336 mod 2*Pi: -1.325455 */
	(FTYPE)(FLIT(-47754556824279406.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(59666646010258982.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(51020464527461750.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(39316010101671527.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(38500617082656135.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(47666532694157778.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^6400 mod 2*Pi: -2.514245 */
	(FTYPE)(FLIT(-45292618722043827.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(4268102136721781.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(36147562744682466.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(64991185061230583.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(33250604278524254.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(13864207135526271.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^6464 mod 2*Pi: -1.180303 */
	(FTYPE)(FLIT(-42524881684310672.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(15454687162307076.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2321776900795745.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(31609383696074477.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(36852205505975263.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(31561765642872772.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^6528 mod 2*Pi: 2.934534 */
	(FTYPE)(FLIT(52863862409603818.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(38489461003629104.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(413853466721364.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(56020604760029244.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(49079333249043503.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(65001583578502535.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^6592 mod 2*Pi: 1.361593 */
	(FTYPE)(FLIT(49056553156993010.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(17714688898600481.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(51348349270021201.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(49192793331362514.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2728882330109079.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(10811641872905881.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^6656 mod 2*Pi: -1.232802 */
	(FTYPE)(FLIT(-44416379824350802.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(38997811993566751.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(29693853098863630.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(43476312762018454.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(56894283626952111.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1284524122601483.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^6720 mod 2*Pi: -2.245339 */
	(FTYPE)(FLIT(-40448428516759842.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(39354776785070885.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(69760358286546761.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(34973740322079660.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(34072959961731926.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(721332812610522.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^6784 mod 2*Pi: .664501 */
	(FTYPE)(FLIT(23941182061750454.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(48354269403985992.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(32918893515563062.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(27843013487092722.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(226569956917128.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(29905904981391028.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^6848 mod 2*Pi: -2.992195 */
	(FTYPE)(FLIT(-53902598178983847.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(16768658969046304.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(66759595132949271.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(53164456591900013.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(70043772276211669.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(31884343973124665.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^6912 mod 2*Pi: 2.709244 */
	(FTYPE)(FLIT(48805409873536298.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(29426485107252682.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(262870478560293.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(26395095876297039.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(61098674366655913.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(70853003939517456.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^6976 mod 2*Pi: -1.852103 */
	(FTYPE)(FLIT(-66729044516700199.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(62347325922830030.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(39436253635266137.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(46368579210128858.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3946782623111961.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(39773307519663596.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^7040 mod 2*Pi: -1.356910 */
	(FTYPE)(FLIT(-48887832270068191.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(55828515977535511.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(29496627917839975.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(40248652806139907.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(53634352503880018.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1917794589841687.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^7104 mod 2*Pi: 2.297985 */
	(FTYPE)(FLIT(41396808677972458.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(54042369969610119.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(67017381346959339.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(42597180352544850.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(12416290570477294.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3651894186364038.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^7168 mod 2*Pi: .089983 */
	(FTYPE)(FLIT(3241979993123059.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(10530811971586735.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(32114494142115444.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(51665344545036467.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(29192825390595850.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(48856602630589309.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^7232 mod 2*Pi: -1.683183 */
	(FTYPE)(FLIT(-60643047435064851.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(32518057308670776.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(70408754997803622.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(17881247084758721.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(13362733652930059.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(52744718258718278.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^7296 mod 2*Pi: 2.530929 */
	(FTYPE)(FLIT(45593159243299264.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(14304908328926580.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(50738444377586951.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(64742408816438383.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(40497244104475950.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(50933087472444174.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^7360 mod 2*Pi: -1.546470 */
	(FTYPE)(FLIT(-55717448133282477.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(38043993679974011.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(51696385299196784.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(53964548897722970.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(42634711630836141.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(7764642622510471.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^7424 mod 2*Pi: 1.874070 */
	(FTYPE)(FLIT(67520481992624977.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3275179572803798.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(57533863339124843.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(63133053506059664.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(27964495056739395.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(50608616108033431.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^7488 mod 2*Pi: .563063 */
	(FTYPE)(FLIT(20286487932135314.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(32507293457621601.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(16075465714437975.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(23245440832209255.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(43228556608456889.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2562112620883145.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^7552 mod 2*Pi: 2.789683 */
	(FTYPE)(FLIT(50254458510910114.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(18249766955699215.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(40010486957372746.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(46012885690261316.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(45378036046560611.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(690957666819511.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^7616 mod 2*Pi: -2.099095 */
	(FTYPE)(FLIT(-37813933607257274.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(60919364987236136.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(62510491387452528.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(31218300112181802.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(42095771057818875.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(44946316267815665.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^7680 mod 2*Pi: 2.935347 */
	(FTYPE)(FLIT(52878502897895049.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(16615866161908512.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(43793205515128626.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(57257004012012140.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(24627235690408663.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(66006578008300346.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^7744 mod 2*Pi: -.931321 */
	(FTYPE)(FLIT(-33554391756214409.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(14080190304427684.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(64526341573126628.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(69712659786260401.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(56043640577539777.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(53981090159571066.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^7808 mod 2*Pi: 1.705011 */
	(FTYPE)(FLIT(61429488562689026.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(19794224444293502.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(39382667515913954.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(4546215842034502.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(64093814353664658.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(583340922183283.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^7872 mod 2*Pi: .627719 */
	(FTYPE)(FLIT(22615966261999617.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(57207380046181257.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(37236889914515662.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(70964160373220989.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(18266334693502464.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(35623121581685879.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^7936 mod 2*Pi: 1.826955 */
	(FTYPE)(FLIT(65822999278642513.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(32548353490311505.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(37893649981564046.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(12271158719744351.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(36446118758078656.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(31952426535142240.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^8000 mod 2*Pi: 3.101205 */
	(FTYPE)(FLIT(55866336751842494.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(66000234844486322.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(51486264969136584.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(20022932452394350.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(53081732579349829.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(23493561294264264.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^8064 mod 2*Pi: .297608 */
	(FTYPE)(FLIT(10722471668998037.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(65190271143612244.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(57587077542392986.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(36584782300083909.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(51934590634066914.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(25329923694135380.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^8128 mod 2*Pi: -1.546106 */
	(FTYPE)(FLIT(-55704322984187588.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(63058170986589802.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(64779343103851444.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(61672182595226242.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(9488708522954697.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(63409775968813928.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^8192 mod 2*Pi: 1.099806 */
	(FTYPE)(FLIT(39624676980958955.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(39637801316348139.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(11253209364099546.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(59425385878115218.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(71981891379568255.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(46247448569784345.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^8256 mod 2*Pi: -1.710333 */
	(FTYPE)(FLIT(-61621250524220890.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(7682450392162730.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(39118391838392973.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(63251831965894135.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(44901562221717604.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(63138953552266212.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^8320 mod 2*Pi: -1.257225 */
	(FTYPE)(FLIT(-45296306558991076.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(42809227710146041.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(63087393341064607.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(11384375844405640.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(59068734967448240.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(22771935620330062.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^8384 mod 2*Pi: 2.760064 */
	(FTYPE)(FLIT(49720898157267392.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(37088945701960167.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(35399123063687982.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(34760538588279061.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(13951344161564201.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(48113360786449433.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^8448 mod 2*Pi: -.840786 */
	(FTYPE)(FLIT(-30292507132796885.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(17428490494908468.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(25758422299812133.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(69761915083752892.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(18046626712048040.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(8261437270361752.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^8512 mod 2*Pi: -.728170 */
	(FTYPE)(FLIT(-26235084042344424.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(54571900310282837.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(71478052161629277.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(28858496385315962.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(57785550562595293.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(22275040195461354.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^8576 mod 2*Pi: 1.447679 */
	(FTYPE)(FLIT(52158120826114632.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(68928143493257731.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(47856795889574602.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(61310494601505279.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(40305325333708395.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(18629809696103720.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^8640 mod 2*Pi: 1.143742 */
	(FTYPE)(FLIT(41207665676177782.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(332704599383532.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(67830578014152089.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(7087870374727162.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(10277030246116884.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(49561462026677437.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^8704 mod 2*Pi: -1.858084 */
	(FTYPE)(FLIT(-66944513468150983.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(52626064675127597.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(67718980272366588.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(24994957226329993.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(6534874103730333.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(71290833967073763.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^8768 mod 2*Pi: -.504587 */
	(FTYPE)(FLIT(-18179674732557750.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2375838187924159.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(13974106609753743.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(70535118338262489.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(54490868014822448.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(39261163227781578.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^8832 mod 2*Pi: -.070545 */
	(FTYPE)(FLIT(-2541635655071550.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(13018371961264986.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(62056167306880655.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(4701420483258130.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(18562225236963131.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(68215679399790180.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^8896 mod 2*Pi: 1.360554 */
	(FTYPE)(FLIT(49019113880267721.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(57002330457045575.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(23866713163085083.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(32201734783382978.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(69771298892874176.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(55552357829133167.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^8960 mod 2*Pi: -.346279 */
	(FTYPE)(FLIT(-12476017339208695.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(11390886980584271.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(57153357049409126.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(59974450814134680.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(9686513931319604.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(40328840148400253.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^9024 mod 2*Pi: -.621670 */
	(FTYPE)(FLIT(-22398008871004245.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(24592248919653147.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(10311142864008392.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(58422582189627322.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(68033192889713523.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(66913851357295016.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^9088 mod 2*Pi: -.449740 */
	(FTYPE)(FLIT(-16203582663775670.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(22520426832807433.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(61990205843080370.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(66849633559503713.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(7919706835432282.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(35406740850710530.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^9152 mod 2*Pi: -1.522618 */
	(FTYPE)(FLIT(-54858108174124637.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(59797777281248304.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(25887745183620135.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(65680485265160075.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(69538221642363337.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(63529965331786689.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^9216 mod 2*Pi: -1.312654 */
	(FTYPE)(FLIT(-47293346173127670.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(51650571124551265.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(45401174083440414.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(33959862648592883.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(63011498630655857.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(59013928530017389.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^9280 mod 2*Pi: 3.110886 */
	(FTYPE)(FLIT(56040733918485148.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(69053680837321840.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(35037621814335434.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(16208489869100096.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(6623267078737403.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(28402164504832458.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^9344 mod 2*Pi: .729527 */
	(FTYPE)(FLIT(26283994405374387.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(37324825042950751.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(58260207168809724.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(47172703386402064.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(60119913211383604.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(27130439638873668.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^9408 mod 2*Pi: -3.010089 */
	(FTYPE)(FLIT(-54224946255830332.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(1374252982187777.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(28024373464615786.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(68723653417644998.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(36814180458488818.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(62636308047937565.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^9472 mod 2*Pi: -2.894924 */
	(FTYPE)(FLIT(-52150308418289938.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(11193175209037914.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(39248627866967310.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(52080734929540660.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(14526644686034524.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(32509182076617887.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^9536 mod 2*Pi: -1.980041 */
	(FTYPE)(FLIT(-71338500246254387.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(24809315263890160.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(66725023328597989.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(49601451915320343.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(46745759268315319.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(11723113844950273.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^9600 mod 2*Pi: -1.218566 */
	(FTYPE)(FLIT(-43903466091294816.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(45177887453989297.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(57987642179042342.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(70040207392317055.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(19901922124323654.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(39638569290443718.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^9664 mod 2*Pi: -.760306 */
	(FTYPE)(FLIT(-27392920219226252.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(64953445327259246.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(29864182544138384.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(57239058665796472.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(18876108656029296.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(51223194445100720.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^9728 mod 2*Pi: 2.166887 */
	(FTYPE)(FLIT(39035166546486909.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(50135647863053194.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(50859037046839511.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(6255804026154940.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(32723104555481828.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(19970561501974679.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^9792 mod 2*Pi: 1.554995 */
	(FTYPE)(FLIT(56024602530812787.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(15032097900408994.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(54759917712834686.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(64800238963067860.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(61416211188577188.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(55573214937300828.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^9856 mod 2*Pi: .034535 */
	(FTYPE)(FLIT(1244265034770287.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(13057250190137936.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(56215910489466948.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(58227758597019006.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(20584903307870574.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(9900155879921050.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^9920 mod 2*Pi: -3.028785 */
	(FTYPE)(FLIT(-54561735236204942.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(67935315714124484.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(10181882792878234.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(6841855204512596.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(28061286923736802.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(9258601920858250.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^9984 mod 2*Pi: 1.376518 */
	(FTYPE)(FLIT(49594290899911659.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(49354567807188336.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(19007471928658114.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(56773277387171638.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(29360429246133950.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2944568438487864.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^10048 mod 2*Pi: 2.066076 */
	(FTYPE)(FLIT(37219122881796284.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(44786381863785552.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(67206700813224438.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(38552933658717311.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(60751351321410959.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(65029930825990489.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^10112 mod 2*Pi: -.895368 */
	(FTYPE)(FLIT(-32259032469324862.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(43353402773456262.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(47894598726585686.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(62135894219874499.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(69437483255116215.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(71555758408790769.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^10176 mod 2*Pi: 2.771570 */
	(FTYPE)(FLIT(49928174770928552.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(72056093876147786.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(39154520998411602.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(16626792556362479.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(31393165392557484.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(9551435181299795.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^10240 mod 2*Pi: -1.516611 */
	(FTYPE)(FLIT(-54641668890608837.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(26818911148364581.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(48082132164418939.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(27957066672588917.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(396325422161865.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(22334601535559912.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^10304 mod 2*Pi: .647711 */
	(FTYPE)(FLIT(23336235684902586.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(59635103627385786.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(37807264873641667.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(15700540783398041.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(13900467784582485.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(24493003486925896.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^10368 mod 2*Pi: .277664 */
	(FTYPE)(FLIT(10003892069661676.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(50629953758485408.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(38716934266307690.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(28831239015738270.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(17752114370573425.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(20754171236930928.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^10432 mod 2*Pi: 1.772218 */
	(FTYPE)(FLIT(63850898576624554.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(54143866697614566.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(10048645248161772.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(47056654928237821.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(53908882577999137.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(63822670142263434.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^10496 mod 2*Pi: -1.609414 */
	(FTYPE)(FLIT(-57985264085005924.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(51172776071370386.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(22992738017283100.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(62146182454330550.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(23855952814125928.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(35664336963051510.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^10560 mod 2*Pi: 2.760293 */
	(FTYPE)(FLIT(49725021110729602.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(43661403768199108.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(43889959826395404.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(71034017299397615.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(7384211242271787.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(69158982905308315.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^10624 mod 2*Pi: -1.899921 */
	(FTYPE)(FLIT(-68451873544656784.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(48436648301637642.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2370783332377337.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(25225692342027743.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(49345687395770657.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(42765889309970585.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^10688 mod 2*Pi: 1.571754 */
	(FTYPE)(FLIT(56628390490700047.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(7460177589491702.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(53074895573781034.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(21870223632479465.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(28157518406442680.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(37967459186593798.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^10752 mod 2*Pi: 2.184654 */
	(FTYPE)(FLIT(39355231708176476.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(8018069547016326.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(6067070772690103.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(29949790620581835.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(65874325108877617.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(19881632329001243.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^10816 mod 2*Pi: -2.312213 */
	(FTYPE)(FLIT(-41653118957091933.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(43049608282469835.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(9353522990735405.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(63582676034816582.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(49973546994934507.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(5098561618997090.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^10880 mod 2*Pi: .843593 */
	(FTYPE)(FLIT(30393657578826367.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(68026185281889527.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(14575107516244745.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(45665874454958677.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(32006187529392950.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(49583501829342001.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^10944 mod 2*Pi: 2.058085 */
	(FTYPE)(FLIT(37075158134596897.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(44121734124406304.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(18897712602449781.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(4740829410175701.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(32811686151153496.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(4138470604469060.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^11008 mod 2*Pi: .489267 */
	(FTYPE)(FLIT(17627709849116446.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(31340207741265004.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2853342649294268.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(45179577409123242.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(58429334215057733.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(47224886424137513.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^11072 mod 2*Pi: 2.797707 */
	(FTYPE)(FLIT(50399000979171514.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(7974060742792871.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(26624735032304360.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(65001840415603989.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(53966740535912084.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(65850584072050720.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^11136 mod 2*Pi: .585013 */
	(FTYPE)(FLIT(21077328110358611.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(29660361104777278.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(42403928076058103.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(61674528858816090.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(27584128850418448.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(26890747082327524.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^11200 mod 2*Pi: .785425 */
	(FTYPE)(FLIT(28297925201836344.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(23388323255905447.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(23062276753669825.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(4127633734881999.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1133717907757884.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(69085087528593502.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^11264 mod 2*Pi: -1.774577 */
	(FTYPE)(FLIT(-63935877467360461.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(54896907589980998.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(23658435918225801.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(41743575813870397.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(42825214459728739.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(27653680582533943.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^11328 mod 2*Pi: 2.227508 */
	(FTYPE)(FLIT(40127217514609853.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(44648305047971317.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(9480337962072580.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(35351194052974270.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(27964311624407721.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(114053862739126.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^11392 mod 2*Pi: 1.093928 */
	(FTYPE)(FLIT(39412911208543319.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(39760288396488592.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(13601917731189177.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(67227174150466441.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(46252126140302444.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(9021391600372418.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^11456 mod 2*Pi: -.867724 */
	(FTYPE)(FLIT(-31263061307308353.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(6847147470353520.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(22033293307843573.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(13657811512011177.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(24297734562974674.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(5452576536709131.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^11520 mod 2*Pi: .759992 */
	(FTYPE)(FLIT(27381606261458441.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(42856453973211199.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(63702738098042336.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(60834842470958302.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(51841842674340365.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(21625013840194040.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^11584 mod 2*Pi: 2.054211 */
	(FTYPE)(FLIT(37005375820523784.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(20532255714485982.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(24024397619536121.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(42317220452207708.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(9338841937806409.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(16151506877205829.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^11648 mod 2*Pi: -2.525008 */
	(FTYPE)(FLIT(-45486500180219718.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(36647405624264417.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(31694772347138017.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(14922544318716125.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(63105215906784835.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(43742951310306747.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^11712 mod 2*Pi: 2.770936 */
	(FTYPE)(FLIT(49916745523303641.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(55515790489599911.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(56153599170551556.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(26433022064208539.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(44952562532482987.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(37069594529022217.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^11776 mod 2*Pi: -.926048 */
	(FTYPE)(FLIT(-33364413322449777.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(57962134365803629.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(53901901149201578.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(879471497156603.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(64318008318233788.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(69351033217426073.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^11840 mod 2*Pi: -2.992644 */
	(FTYPE)(FLIT(-53910677451881243.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(64454419690873927.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(62834412991600002.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(41344780806990540.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(5428860598409128.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(40818999407653835.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^11904 mod 2*Pi: -1.923170 */
	(FTYPE)(FLIT(-69289506711086767.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(5725150403632970.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(47909169857203499.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1019864521895077.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(39570238884670085.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(70782815928014308.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^11968 mod 2*Pi: .087491 */
	(FTYPE)(FLIT(3152183125799198.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(56759772928363902.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(52486870638257113.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(64289169657634269.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(10883064860865985.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(29492841720129264.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^12032 mod 2*Pi: 3.124190 */
	(FTYPE)(FLIT(56280411253972177.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(52037558244202215.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(52531440648872111.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(24723910705713608.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(46390911741342186.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(57387333864654390.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^12096 mod 2*Pi: -2.812903 */
	(FTYPE)(FLIT(-50672752663301859.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(21053395664050966.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(35518236879063377.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(26855270467722443.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(47215068014368223.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(30758779702569973.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^12160 mod 2*Pi: -.000709 */
	(FTYPE)(FLIT(-25547607203669.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(58532844584784241.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(69591077170710491.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(68080296176894799.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(37767491686581866.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(9180989488639008.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^12224 mod 2*Pi: 1.623418 */
	(FTYPE)(FLIT(58489796482912542.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(42875695175054418.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(21718237857691693.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2056452332601535.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(27539295067196706.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1804781950004119.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^12288 mod 2*Pi: -.604801 */
	(FTYPE)(FLIT(-21790238915089715.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(4969991945005201.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(31445504372767880.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(14455898489216165.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(32626979126484785.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(26144675258520447.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^12352 mod 2*Pi: 2.789779 */
	(FTYPE)(FLIT(50256195166793234.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(13006564794284141.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(11924930637493839.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(67414412842372040.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(8849205226700640.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(70282100908288842.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^12416 mod 2*Pi: -1.903926 */
	(FTYPE)(FLIT(-68596171560321601.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(21388450997174660.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(19607716059411700.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1015077763751865.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(58887159780072355.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(27220229309383263.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^12480 mod 2*Pi: -2.916230 */
	(FTYPE)(FLIT(-52534136435521285.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(33674503284576565.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(11499544337026880.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(6017957478591691.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(46950589458000121.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(51724684508168329.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^12544 mod 2*Pi: .712824 */
	(FTYPE)(FLIT(25682179255647898.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(34964561624955317.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(13981640208916099.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(22724098881285711.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(29718766590714203.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3392249945558787.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^12608 mod 2*Pi: .628886 */
	(FTYPE)(FLIT(22658015442671167.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(17843697824500303.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(17090515863984468.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(86273926018071.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(9264763592778279.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(34743250352745672.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^12672 mod 2*Pi: -.398883 */
	(FTYPE)(FLIT(-14371279509589418.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(64785463129290675.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(71781116260034319.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(36447789539208062.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(38958720807563863.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(24295850575715801.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^12736 mod 2*Pi: -1.809622 */
	(FTYPE)(FLIT(-65198486626084681.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(16385817342421510.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(17847102929126762.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(30849346874626817.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(13235141207650344.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(40355414492850710.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^12800 mod 2*Pi: .931226 */
	(FTYPE)(FLIT(33550949830730259.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(21822645807235607.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(26401176440171715.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(26913652987744313.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(58332132374023959.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(67359164998722997.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^12864 mod 2*Pi: 1.906872 */
	(FTYPE)(FLIT(68702298826444378.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(6956039791073507.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(24957852940151133.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(32427069094378878.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(68467503319661651.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(59181203272364715.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^12928 mod 2*Pi: 1.104821 */
	(FTYPE)(FLIT(39805367991806441.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(15465302890518828.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(67975180119194012.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(52312922052284379.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(27479945668133866.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(63612634689785199.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^12992 mod 2*Pi: .536499 */
	(FTYPE)(FLIT(19329401700236529.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(48033472122159364.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(35008650362341079.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(48802143580137386.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(65459610482260123.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(61572674541912398.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^13056 mod 2*Pi: 2.706729 */
	(FTYPE)(FLIT(48760098441896536.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(64695631124527873.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(4675408131689452.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2295149725319367.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(18958152943716678.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(9624667853109957.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^13120 mod 2*Pi: -2.756267 */
	(FTYPE)(FLIT(-49652491300083692.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(58534013401271287.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(66392961597363080.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(47563411127998584.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(54699526579898384.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(48478177318275195.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^13184 mod 2*Pi: -.068228 */
	(FTYPE)(FLIT(-2458170944039261.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(35813455938862515.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(19425152699694888.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(50808698574621465.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(28075356562942078.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(45721841992557445.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^13248 mod 2*Pi: -2.326548 */
	(FTYPE)(FLIT(-41911355782061213.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(4745588201081742.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(22837275404101383.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(35745537977362566.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(30720068942282390.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(7335045958118022.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^13312 mod 2*Pi: -1.670284 */
	(FTYPE)(FLIT(-60178336991075255.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(49942920717336886.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(28420316831477851.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(12623871505315682.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(18642922262898505.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(14588171761220529.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^13376 mod 2*Pi: .203847 */
	(FTYPE)(FLIT(7344344241553946.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(34434479567211169.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1553638274101693.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(30393237449256952.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2218698842728620.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(54151143047354743.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^13440 mod 2*Pi: 2.223001 */
	(FTYPE)(FLIT(40046033566072356.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(18201990851451888.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(12918285561585969.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(39579751570692668.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(21596715658871914.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(45400080387350675.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^13504 mod 2*Pi: .512652 */
	(FTYPE)(FLIT(18470218934145624.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(43231755908915187.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(24476328459292448.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(7408033495407183.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(13877030975783571.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(23298674371859321.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^13568 mod 2*Pi: .522580 */
	(FTYPE)(FLIT(18827937810610603.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(67061749427558437.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(29977536173116107.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(28312676822449301.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(40456658637737277.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(39767563348030456.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^13632 mod 2*Pi: -.439100 */
	(FTYPE)(FLIT(-15820227817682941.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(26347014664894612.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(27957957336815683.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3541180561565874.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(32578334631299292.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(49068815146196528.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^13696 mod 2*Pi: -2.902715 */
	(FTYPE)(FLIT(-52290671656709696.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2592017531268716.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(33140018805411425.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(33704156058895716.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(48589905423507518.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(12340710605171468.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^13760 mod 2*Pi: 2.687270 */
	(FTYPE)(FLIT(48409547857180509.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(26061062100116397.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(22937857090079757.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(50325678033448657.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(15305103280661248.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(63885620981773576.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^13824 mod 2*Pi: 1.464861 */
	(FTYPE)(FLIT(52777169612762201.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(68417711009408634.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(35714207720090269.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(4259986289249901.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(43034049108380294.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(22422143205721918.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^13888 mod 2*Pi: -1.781825 */
	(FTYPE)(FLIT(-64197018251119271.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(67751248825631136.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(59943080572960966.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(24106891762199191.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3510950567563918.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(21049864452310339.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^13952 mod 2*Pi: .145958 */
	(FTYPE)(FLIT(5258706841101029.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(12057879798696879.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(27418117583651206.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(19791018166657611.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(33778426631852878.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(70853413126646862.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^14016 mod 2*Pi: 2.788857 */
	(FTYPE)(FLIT(50239573591547590.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(34174248098759496.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1268240657829830.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(15719996102593839.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(39424525166408250.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(41632497932541588.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^14080 mod 2*Pi: 2.932135 */
	(FTYPE)(FLIT(52820648534489159.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(39507938205005435.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(22320236969872581.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(34147804293406965.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(66220028091634282.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(63716680287728309.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^14144 mod 2*Pi: -2.870801 */
	(FTYPE)(FLIT(-51715750685217311.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(12105722996223198.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(61803752892943726.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(68668807759186125.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(14245614630086153.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(16167441401882433.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^14208 mod 2*Pi: 2.750922 */
	(FTYPE)(FLIT(49556201687599485.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(52533029596565018.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(16234612381250679.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(33239780872024392.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(51678672482576372.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(18705323720135168.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^14272 mod 2*Pi: -2.609721 */
	(FTYPE)(FLIT(-47012560210669049.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(28224276643965726.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(71738584079629236.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(27461063873295630.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(12533148495823137.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(33971845766373831.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^14336 mod 2*Pi: -2.078715 */
	(FTYPE)(FLIT(-37446801539509880.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(54821995026610499.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(685765185190574.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(68742063141665572.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(55834691635559497.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(49301435359249676.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^14400 mod 2*Pi: 1.915331 */
	(FTYPE)(FLIT(69007073728033997.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(561637499078451.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(21828641146299078.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(58299272319135568.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(10187561791445254.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(43413355432071446.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^14464 mod 2*Pi: 2.072053 */
	(FTYPE)(FLIT(37326794755105307.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(67144895795143041.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(61436408640748935.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(13216621706334737.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(11259505496950508.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(67776548096264012.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^14528 mod 2*Pi: .033219 */
	(FTYPE)(FLIT(1196834795092889.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(44571105863644033.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(34960674303388826.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(42998230999471905.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(46852335597415527.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(10493834687482745.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^14592 mod 2*Pi: -.642438 */
	(FTYPE)(FLIT(-23146253002811838.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(24653536132928164.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(37083368001623625.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(15793875550055180.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(58365438578138590.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(49314768099898296.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^14656 mod 2*Pi: -2.937321 */
	(FTYPE)(FLIT(-52914076588947826.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(29840163256452887.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(69188728711958087.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(160761076424016.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(10567826164465228.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(70207657316828687.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^14720 mod 2*Pi: .977154 */
	(FTYPE)(FLIT(35205673986768236.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(10511275268925719.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(8039797583732588.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(32821838877152218.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(66389111255302944.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(34688111369392794.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^14784 mod 2*Pi: 1.981410 */
	(FTYPE)(FLIT(71387803059140512.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(13773896240968837.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(57379014806290276.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(39268616149337912.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(20129194138593294.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(34792578464551708.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^14848 mod 2*Pi: .580717 */
	(FTYPE)(FLIT(20922545393111133.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(13696324589263759.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(65148011442140041.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(35171316093299222.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(12274857566240047.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(25263526611727948.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^14912 mod 2*Pi: -1.630115 */
	(FTYPE)(FLIT(-58731079330269300.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(69283752764130220.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(11889989692082830.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(8205958038659609.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(12358256904907851.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1095156265093059.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^14976 mod 2*Pi: 1.622529 */
	(FTYPE)(FLIT(58457754427622429.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(56748084762612709.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(18248766680457859.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(31092864591840728.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(56656194684898654.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(42259375632980979.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^15040 mod 2*Pi: -1.215515 */
	(FTYPE)(FLIT(-43793530959361722.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(31709197891010650.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(24165600376822747.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(28785052482302425.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(41501471901511770.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(42227485340422508.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^15104 mod 2*Pi: 1.541888 */
	(FTYPE)(FLIT(55552378955445181.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(22811945984477703.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(53821237220952138.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(39471463702420541.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(19900045361691802.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(44020637994061919.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^15168 mod 2*Pi: .848909 */
	(FTYPE)(FLIT(30585171759994599.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3194493768873973.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(67937269899233139.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(28678763298824.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(64902608790626046.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(70024513536879126.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^15232 mod 2*Pi: 2.870456 */
	(FTYPE)(FLIT(51709538847953897.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(64224231564840416.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(65707129311249595.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(459487180821424.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(39088772260826477.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2474071317780991.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^15296 mod 2*Pi: -1.931105 */
	(FTYPE)(FLIT(-69575384039073886.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(64759134657023602.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(45556577999672441.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(67801238021602559.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(16412023687330646.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(9915459662074723.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^15360 mod 2*Pi: 2.481817 */
	(FTYPE)(FLIT(44708445955310492.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(68711621909220517.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(28393907485393771.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(37718219095163022.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(57689242548357473.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(13634520352603892.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^15424 mod 2*Pi: .258336 */
	(FTYPE)(FLIT(9307539575287064.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(41370353354695720.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(48561607638199645.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(5104649182131507.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(57246024392646382.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(59758471090641846.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^15488 mod 2*Pi: .236438 */
	(FTYPE)(FLIT(8518563664085609.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(30140755638015651.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(61619295460231014.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(41130570820279625.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(44167472142645159.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(46810276348302458.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^15552 mod 2*Pi: .759989 */
	(FTYPE)(FLIT(27381494811557600.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(63582253384468779.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(48747151825345567.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(8958188479287556.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3889286006192492.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(65271495962629688.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^15616 mod 2*Pi: .236482 */
	(FTYPE)(FLIT(8520178549789766.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(48874783351744564.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(14870387721252459.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(49544225910470958.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(45571870909587964.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(32637680054829734.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^15680 mod 2*Pi: -.568203 */
	(FTYPE)(FLIT(-20471685464061296.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(52322827713300413.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(42619524506619973.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(41610248777574648.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(64416637319493984.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(50625043206720151.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^15744 mod 2*Pi: 2.922656 */
	(FTYPE)(FLIT(52649894499657570.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(27808442822266732.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(51631759463385654.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(15871634695050261.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2977255059791846.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(34920526790840411.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^15808 mod 2*Pi: 2.215681 */
	(FTYPE)(FLIT(39914167389848599.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(64862066064811362.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(11432885571076653.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(9814235874597257.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(60750177936061585.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(42488727447770971.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^15872 mod 2*Pi: 1.266510 */
	(FTYPE)(FLIT(45630825497711220.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(12905931060133912.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(21113370941871264.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(48268470751453999.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3105060309154128.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(61592070879494888.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^15936 mod 2*Pi: 1.243107 */
	(FTYPE)(FLIT(44787650505920914.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(10897114041389791.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(51494756731503822.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(65541562163069511.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(56476719821897969.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1798521542672346.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^16000 mod 2*Pi: .774342 */
	(FTYPE)(FLIT(27898613127270603.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(497936082589714.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(23283662038701941.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(48864790544117603.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(61686056247297473.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(29761937998322017.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^16064 mod 2*Pi: -1.042627 */
	(FTYPE)(FLIT(-37564586805999246.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(39052678092290858.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(47021052724655625.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(39468186280586247.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(11323458340108315.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(18201616936852934.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^16128 mod 2*Pi: 2.046293 */
	(FTYPE)(FLIT(36862734981765997.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(21769408789369618.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1653439258072433.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(28514139883358966.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(16074222042345758.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(56829304099891722.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^16192 mod 2*Pi: 2.686549 */
	(FTYPE)(FLIT(48396556950206086.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(31221575589381208.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(28294480081025935.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(38821190668853085.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(749332791067322.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(43270262808355127.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^16256 mod 2*Pi: -2.809711 */
	(FTYPE)(FLIT(-50615246253097630.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(37408790833999501.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(21927223880137623.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(5091178715894488.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(27469462733400825.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(282358277834617.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^16320 mod 2*Pi: -.896289 */
	(FTYPE)(FLIT(-32292231111065809.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(61761634347780445.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(16260419680495761.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(6505173078526295.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(46284199199692280.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(48200450436500596.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},
	};

 #elif 64 <= FBITS
  #define ACSHIFT	6
  #define FRAC_BITS	4294967296.0L		/* 2^32 */
  #define FULL_BITS	(FRAC_BITS_1 * FRAC_BITS_1)	/* 2^64 */
  #define FRAC_XTRA	5

static const FTYPE c[] = {
	(FTYPE)(FLIT(3373259426.0) * 8),
	(FTYPE)(FLIT(560513588.0) * 8 / FRAC_BITS_1),
	(FTYPE)(FLIT(3301335691.0) * 8 / FRAC_BITS_2),
	(FTYPE)(FLIT(2161908945.0) * 8 / FRAC_BITS_3),
	(FTYPE)(FLIT(688016904.0) * 8 / FRAC_BITS_4),
	(FTYPE)(FLIT(2322058356.0) * 8 / FRAC_BITS_5),
	(FTYPE)(FLIT(34324134.0) * 8 / FRAC_BITS_6),
	};

static const FTYPE b[][ACSIZE]={	/* 2^N mod 2*Pi */
	{	/* 2^64 mod 2*Pi: 3.117992 */
	(FTYPE)(FLIT(3347918366.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2842271958.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(4092661107.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2838512861.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2604206653.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3623012428.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3009340158.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^128 mod 2*Pi: 1.346130 */
	(FTYPE)(FLIT(2890792344.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(4172560454.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1697676141.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3856281253.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(41907925.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(4230449103.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3973524717.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^192 mod 2*Pi: 3.131272 */
	(FTYPE)(FLIT(3362177261.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2767658426.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3542365389.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(780960161.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2814403167.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(60202463.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(4209476887.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^256 mod 2*Pi: 2.694543 */
	(FTYPE)(FLIT(2893243996.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2883182669.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(4073316445.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(4084941187.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(20565701.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2604390223.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3454932162.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^320 mod 2*Pi: .038570 */
	(FTYPE)(FLIT(82827645.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3464568066.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4225454845.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1747330700.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2221138901.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3819265290.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3351526698.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^384 mod 2*Pi: 1.559242 */
	(FTYPE)(FLIT(3348445792.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3088524548.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(169275477.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(136354325.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3396180517.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1399227022.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(579292805.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^448 mod 2*Pi: -1.714938 */
	(FTYPE)(FLIT(-3682800308.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2330861196.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(20122835.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1619765399.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1254592015.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(642661915.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(242011680.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^512 mod 2*Pi: 1.433420 */
	(FTYPE)(FLIT(3078245308.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(551566604.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1397084787.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2561622205.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3759123331.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(289098269.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3693340862.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^576 mod 2*Pi: 1.924039 */
	(FTYPE)(FLIT(4131843211.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2099098201.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(109504986.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1441344195.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1631768683.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3655443793.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(200803085.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^640 mod 2*Pi: .960377 */
	(FTYPE)(FLIT(2062393458.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(719803704.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2472221462.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(4077998280.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2358426247.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(844022912.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1895655696.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^704 mod 2*Pi: -1.374624 */
	(FTYPE)(FLIT(-2951983212.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2631129173.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2681155021.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2542507548.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2071544461.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1166065752.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3594030409.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^768 mod 2*Pi: -.103183 */
	(FTYPE)(FLIT(-221582805.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3747900102.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(943921370.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1225349172.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3355125164.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(70725798.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1912390307.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^832 mod 2*Pi: -.900675 */
	(FTYPE)(FLIT(-1934183835.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2243058593.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3596491291.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1510517302.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1768040726.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3634703542.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2274510028.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^896 mod 2*Pi: -1.084375 */
	(FTYPE)(FLIT(-2328676873.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(784192751.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(441918302.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3971569843.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1198864006.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1018153824.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2377278242.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^960 mod 2*Pi: 2.289652 */
	(FTYPE)(FLIT(2458494677.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2305413218.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1454195223.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3798556472.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1681106346.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1755291732.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(506830333.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^1024 mod 2*Pi: -1.196332 */
	(FTYPE)(FLIT(-2569102996.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1838780448.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1120792234.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2236507939.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1631758791.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3506117751.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(896711770.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^1088 mod 2*Pi: -2.479024 */
	(FTYPE)(FLIT(-2661831576.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(1853761183.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(568347402.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3868163109.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3466082252.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3883810410.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3407917849.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^1152 mod 2*Pi: .527766 */
	(FTYPE)(FLIT(1133368460.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3233828471.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(397144592.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1770135576.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1329215706.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(323185174.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1374454345.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^1216 mod 2*Pi: -.093196 */
	(FTYPE)(FLIT(-200136216.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3879744385.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1729020932.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1419524687.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(983971143.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2563728342.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1587409730.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^1280 mod 2*Pi: 2.613222 */
	(FTYPE)(FLIT(2805925530.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(1036869941.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(70829755.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(862197927.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2765802191.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1735680943.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1258757314.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^1344 mod 2*Pi: .623408 */
	(FTYPE)(FLIT(1338758267.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2344608415.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(707894850.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2828577968.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3000823625.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(158022429.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1563701100.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^1408 mod 2*Pi: .871297 */
	(FTYPE)(FLIT(1871096896.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(958418235.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2166562086.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2695245274.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2095421661.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1746803473.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(857888527.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^1472 mod 2*Pi: 1.607758 */
	(FTYPE)(FLIT(3452633315.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2235701151.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(368428306.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(4184766219.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(876766672.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1935190933.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3724624809.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^1536 mod 2*Pi: 2.165273 */
	(FTYPE)(FLIT(2324944615.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(3836029788.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1837732108.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3885015520.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4282330326.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(943910721.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1357205026.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^1600 mod 2*Pi: .158082 */
	(FTYPE)(FLIT(339477748.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1860950653.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1720156022.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3474381746.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2698041765.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2710239143.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2815604336.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^1664 mod 2*Pi: -2.335635 */
	(FTYPE)(FLIT(-2507869130.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2054983449.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3254005827.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3956409287.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1736909318.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2530109883.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3015975919.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^1728 mod 2*Pi: -1.781353 */
	(FTYPE)(FLIT(-3825425828.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3376896783.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3610055249.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(6724939.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(799695849.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3445588854.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2163815218.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^1792 mod 2*Pi: -2.123053 */
	(FTYPE)(FLIT(-2279610502.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(1227817160.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1015091802.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1428581163.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2625436182.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1701699895.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1688332009.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^1856 mod 2*Pi: .311467 */
	(FTYPE)(FLIT(668869969.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2624186875.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3478602219.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2105887784.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3019337600.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3540599993.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1052457098.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^1920 mod 2*Pi: -.372826 */
	(FTYPE)(FLIT(-800636862.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3675171030.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3942205936.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1899754512.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1601342287.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(845318647.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1410904290.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^1984 mod 2*Pi: .977005 */
	(FTYPE)(FLIT(2098101989.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1721925454.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(185046194.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2384506845.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1475580465.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2941619122.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2474196279.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^2048 mod 2*Pi: 2.404925 */
	(FTYPE)(FLIT(2582269083.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2093203958.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3010627960.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(772244440.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3962981354.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3526732347.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(539027848.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^2112 mod 2*Pi: -1.604955 */
	(FTYPE)(FLIT(-3446615371.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3460193440.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(785453566.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(797635560.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3440283630.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2106596779.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1693644480.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^2176 mod 2*Pi: -1.437194 */
	(FTYPE)(FLIT(-3086351148.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(627564895.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1724082866.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3187468360.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(955306641.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1360825244.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2033007477.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^2240 mod 2*Pi: -1.934799 */
	(FTYPE)(FLIT(-4154949344.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1098053041.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2941597747.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(935863219.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3675022263.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1261788129.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(683662138.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^2304 mod 2*Pi: .432523 */
	(FTYPE)(FLIT(928836584.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(335151965.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3937172403.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3110906711.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2009021942.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1133133190.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3216301171.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^2368 mod 2*Pi: -2.190515 */
	(FTYPE)(FLIT(-2352047970.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(883317120.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2808339182.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3115593654.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2464820211.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2548948477.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3177678430.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^2432 mod 2*Pi: -.541763 */
	(FTYPE)(FLIT(-1163426896.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2072141397.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(691262310.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3508845747.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3564053285.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2882209119.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(164878033.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^2496 mod 2*Pi: -1.423135 */
	(FTYPE)(FLIT(-3056159834.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(479560558.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2643621239.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2478237461.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1352392249.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3400782670.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2878225828.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^2560 mod 2*Pi: 2.188507 */
	(FTYPE)(FLIT(2349891946.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(3317460676.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3584153876.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(226253788.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4112357992.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1176275951.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2035471305.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^2624 mod 2*Pi: -.487928 */
	(FTYPE)(FLIT(-1047817543.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1706859667.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1413995901.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2879920326.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1157716821.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(4022388103.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1274044232.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^2688 mod 2*Pi: 1.336630 */
	(FTYPE)(FLIT(2870391319.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1021632761.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3955273358.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(387245827.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3020019146.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1934393575.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3096885033.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^2752 mod 2*Pi: -1.347038 */
	(FTYPE)(FLIT(-2892741754.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(126031280.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(857673284.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(720694884.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1609173198.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1987454635.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1582295001.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^2816 mod 2*Pi: 1.761012 */
	(FTYPE)(FLIT(3781745497.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(135907605.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3301235995.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(4091423282.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1348003928.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(379819628.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2249157962.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^2880 mod 2*Pi: 3.136646 */
	(FTYPE)(FLIT(3367948115.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(1434058621.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(687937245.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(985870106.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(859031775.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(370238764.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(796457030.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^2944 mod 2*Pi: -.630275 */
	(FTYPE)(FLIT(-1353504744.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3012787318.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3829491867.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(370522462.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3585476288.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1863313311.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1456189497.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^3008 mod 2*Pi: -.950240 */
	(FTYPE)(FLIT(-2040625398.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3107847808.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4027122065.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2945550375.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(86652022.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3423104743.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1080957890.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^3072 mod 2*Pi: -1.879008 */
	(FTYPE)(FLIT(-4035139409.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(4286304692.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3079038763.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2339216600.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2335985803.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3975191529.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1751843781.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^3136 mod 2*Pi: -.994981 */
	(FTYPE)(FLIT(-2136706423.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(409213451.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3445977394.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(246035309.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1451764929.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(4580488.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(568422068.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^3200 mod 2*Pi: -2.185200 */
	(FTYPE)(FLIT(-2346340432.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2851467501.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1540254630.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2570538951.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3199305696.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1797994783.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2026784298.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^3264 mod 2*Pi: .474596 */
	(FTYPE)(FLIT(1019188189.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3475368534.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1472164358.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(986083159.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2074517944.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1630401651.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3490389834.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^3328 mod 2*Pi: -1.516832 */
	(FTYPE)(FLIT(-3257370974.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(960449766.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2504095257.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(4003541826.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(674585430.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(852168495.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3821062659.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^3392 mod 2*Pi: -1.387022 */
	(FTYPE)(FLIT(-2978606249.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1742677185.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1031280601.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1161968596.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(199805210.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3895596544.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1585421003.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^3456 mod 2*Pi: -2.539828 */
	(FTYPE)(FLIT(-2727120073.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2787225797.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(964385073.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1604909830.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1398893227.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2367646332.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2552116402.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^3520 mod 2*Pi: -1.635231 */
	(FTYPE)(FLIT(-3511631719.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3798244051.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3733236365.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3387496473.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2332501698.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3765260051.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1650790908.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^3584 mod 2*Pi: -1.114992 */
	(FTYPE)(FLIT(-2394428145.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1034474828.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3883077306.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3445334442.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3420950518.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3032452893.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2390225709.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^3648 mod 2*Pi: -2.734328 */
	(FTYPE)(FLIT(-2935962717.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(1156211716.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3840296748.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(962111745.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(799007676.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2628499219.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2684944997.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^3712 mod 2*Pi: .065688 */
	(FTYPE)(FLIT(141063808.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(4288483559.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1185329914.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1080620393.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(566496356.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2700563641.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3417868689.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^3776 mod 2*Pi: -.838404 */
	(FTYPE)(FLIT(-1800458963.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3384258491.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(548286740.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1088714034.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(704165102.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2244942695.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1635234560.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^3840 mod 2*Pi: 2.309876 */
	(FTYPE)(FLIT(2480210931.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2162813543.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(4274424265.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2999822881.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2523072625.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1866916897.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1025064001.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^3904 mod 2*Pi: -.887320 */
	(FTYPE)(FLIT(-1905506097.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(4149967678.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3954230920.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1277695673.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1363828012.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2817821010.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2059697470.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^3968 mod 2*Pi: -.775873 */
	(FTYPE)(FLIT(-1666174526.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(280209578.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2383680881.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2812657910.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3650441593.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1102436926.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3403361959.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^4032 mod 2*Pi: 1.907356 */
	(FTYPE)(FLIT(4096016508.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2642064723.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2828742059.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3827037487.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(222888741.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(239034331.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(930619349.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^4096 mod 2*Pi: 2.764036 */
	(FTYPE)(FLIT(2967861581.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2732112096.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(4194284565.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3841447741.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3323370036.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3595520953.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1981306053.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^4160 mod 2*Pi: -1.140832 */
	(FTYPE)(FLIT(-2449917830.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(925730598.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(294537554.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(488145408.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1965245554.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(130163599.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3186612693.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^4224 mod 2*Pi: .893983 */
	(FTYPE)(FLIT(1919812884.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2324156802.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3004878639.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3776186253.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4237267544.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1474172071.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(342897491.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^4288 mod 2*Pi: -.264485 */
	(FTYPE)(FLIT(-567977200.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2070229033.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(393102065.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3695195304.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1708152389.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2528309241.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3865349048.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^4352 mod 2*Pi: 1.165845 */
	(FTYPE)(FLIT(2503632113.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1283113725.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2977821136.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2575020599.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(333906556.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1963352841.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3374082329.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^4416 mod 2*Pi: 1.504789 */
	(FTYPE)(FLIT(3231509861.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2422641684.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1079836731.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3322551877.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2628989781.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2080431018.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2873103124.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^4480 mod 2*Pi: -.471484 */
	(FTYPE)(FLIT(-1012504293.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2158642612.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(332828120.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3534614513.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1399650379.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(505807233.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3883462702.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^4544 mod 2*Pi: -2.443591 */
	(FTYPE)(FLIT(-2623785497.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(926642164.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3537099809.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(626531592.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3587332952.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2189885731.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2827484607.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^4608 mod 2*Pi: -.613148 */
	(FTYPE)(FLIT(-1316725529.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(717644161.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(864881194.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(615688586.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1695642703.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1888318902.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3426967405.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^4672 mod 2*Pi: 1.857712 */
	(FTYPE)(FLIT(3989406929.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3849228207.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1666448536.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2800968913.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2740149091.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2336625884.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3719207906.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^4736 mod 2*Pi: 2.092651 */
	(FTYPE)(FLIT(2246966858.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(1376224792.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3422686482.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1067848446.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2738232553.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3454088082.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2055509955.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^4800 mod 2*Pi: -.645538 */
	(FTYPE)(FLIT(-1386281535.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1976594450.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1548596389.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3928362814.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2316973335.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2255826356.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2465130407.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^4864 mod 2*Pi: 1.972936 */
	(FTYPE)(FLIT(4236847750.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(910501876.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4178910105.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2455992844.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3149947528.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(4121082247.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1597331767.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^4928 mod 2*Pi: 1.416693 */
	(FTYPE)(FLIT(3042325803.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(4221785485.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4215165290.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1906324873.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3322700566.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1246191532.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1600721060.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^4992 mod 2*Pi: .333626 */
	(FTYPE)(FLIT(716455848.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(4252939674.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(679170071.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1012956773.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1274078804.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2226005974.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1531703183.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^5056 mod 2*Pi: -2.697202 */
	(FTYPE)(FLIT(-2896098812.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(1783458735.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1078008253.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1313033506.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1878826301.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(4238038949.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(4064422313.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^5120 mod 2*Pi: -2.567555 */
	(FTYPE)(FLIT(-2756891204.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(930874231.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2080852421.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1429693961.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3321497382.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1077871182.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1878906842.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^5184 mod 2*Pi: .228217 */
	(FTYPE)(FLIT(490091917.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(598525694.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(676537539.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(130809871.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4097202580.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(940775851.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2387611651.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^5248 mod 2*Pi: 1.865346 */
	(FTYPE)(FLIT(4005799463.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2819698770.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(931180286.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(4210464456.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2643514417.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(150447458.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1673730919.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^5312 mod 2*Pi: 1.461418 */
	(FTYPE)(FLIT(3138370970.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(4130681486.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3216996526.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3196064917.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1105232687.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3868390800.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(392728450.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^5376 mod 2*Pi: .226040 */
	(FTYPE)(FLIT(485417715.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(131806844.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3569873428.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3343010734.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(700011721.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1026658166.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3115663900.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^5440 mod 2*Pi: .680682 */
	(FTYPE)(FLIT(1461753731.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2284839689.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3068721643.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1374317519.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(435794875.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1421104674.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3638736489.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^5504 mod 2*Pi: -2.247562 */
	(FTYPE)(FLIT(-2413301173.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2460468397.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(594263431.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1991382896.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1253774037.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3179531043.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2507904012.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^5568 mod 2*Pi: -1.254218 */
	(FTYPE)(FLIT(-2693412645.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(676148703.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(311889957.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2295715687.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3674161026.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(221277391.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3266257591.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^5632 mod 2*Pi: -.476319 */
	(FTYPE)(FLIT(-1022887516.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(675539388.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2834002077.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2033171960.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(125395009.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(4153584851.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3237549898.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^5696 mod 2*Pi: -.726983 */
	(FTYPE)(FLIT(-1561184497.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1831143072.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(408275306.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1173742112.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(336177767.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1819846129.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1966310920.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^5760 mod 2*Pi: -1.467434 */
	(FTYPE)(FLIT(-3151290837.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3076377837.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(167963753.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(507386301.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4186647910.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3542038357.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3174755034.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^5824 mod 2*Pi: .563461 */
	(FTYPE)(FLIT(1210023126.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1226905053.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1255405285.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2971144344.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3825177749.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(277677575.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1411331336.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^5888 mod 2*Pi: 1.626293 */
	(FTYPE)(FLIT(3492438072.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1208603042.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3975041827.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2550630269.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(594214570.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2198015924.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3093386723.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^5952 mod 2*Pi: .963511 */
	(FTYPE)(FLIT(2069124964.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2879202581.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2089279152.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(280651075.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1577002867.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(190942587.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(582483994.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^6016 mod 2*Pi: -.461597 */
	(FTYPE)(FLIT(-991272528.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1190237960.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2977304467.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1154141783.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1160097277.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2059963336.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3115729920.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^6080 mod 2*Pi: 2.229107 */
	(FTYPE)(FLIT(2393485662.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(3177398202.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3502756491.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(228892263.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3715484048.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1234365217.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1608666744.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^6144 mod 2*Pi: -2.081306 */
	(FTYPE)(FLIT(-2234785021.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2561607850.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1254160891.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(408989398.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1484822332.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1683214027.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(249220430.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^6208 mod 2*Pi: -2.254716 */
	(FTYPE)(FLIT(-2420982522.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(945143663.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(221889449.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2114250578.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1483475683.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(4146925316.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(696084542.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^6272 mod 2*Pi: -2.135192 */
	(FTYPE)(FLIT(-2292644441.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(106997682.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3744523653.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2226127513.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1259916107.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(831177923.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3779622940.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^6336 mod 2*Pi: -1.325455 */
	(FTYPE)(FLIT(-2846393396.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(354849491.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4202666081.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1713812802.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3617091405.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1988865459.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(4028139111.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^6400 mod 2*Pi: -2.514245 */
	(FTYPE)(FLIT(-2699650450.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(538463503.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(701560761.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1903525996.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(72148119.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3806782755.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1931163639.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^6464 mod 2*Pi: -1.180303 */
	(FTYPE)(FLIT(-2534680467.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(391475254.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3891577452.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2449737791.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2765056877.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1634749585.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(650512109.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^6528 mod 2*Pi: 2.934534 */
	(FTYPE)(FLIT(3150931740.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(1630202504.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3187014327.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2989490552.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1707401084.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1422329457.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1993537596.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^6592 mod 2*Pi: 1.361593 */
	(FTYPE)(FLIT(2923998424.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3554669118.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4016728859.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2384574061.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(221645524.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1370408085.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3154537170.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^6656 mod 2*Pi: -1.232802 */
	(FTYPE)(FLIT(-2647422542.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1549381258.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2353900260.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3726600574.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1726871660.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(245003641.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3797084822.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^6720 mod 2*Pi: -2.245339 */
	(FTYPE)(FLIT(-2410914214.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2301025931.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3505783421.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(723908566.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2904494807.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1232879726.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2019378092.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^6784 mod 2*Pi: .664501 */
	(FTYPE)(FLIT(1427005652.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1260959403.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3388189490.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3091756275.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2401920224.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(912452370.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3227509746.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^6848 mod 2*Pi: -2.992195 */
	(FTYPE)(FLIT(-3212845217.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(305158459.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2466359605.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2904616237.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2139176851.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(398254282.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2782281069.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^6912 mod 2*Pi: 2.709244 */
	(FTYPE)(FLIT(2909029118.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2703567464.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2335930318.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1573519599.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(340623132.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(626902579.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(696574287.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^6976 mod 2*Pi: -1.852103 */
	(FTYPE)(FLIT(-3977360995.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1635768797.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2156922451.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1724812315.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(273757126.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1503968250.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(613363162.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^7040 mod 2*Pi: -1.356910 */
	(FTYPE)(FLIT(-2913941877.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3022397894.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1472024365.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2685888715.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(115154270.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1737424367.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3174215683.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^7104 mod 2*Pi: 2.297985 */
	(FTYPE)(FLIT(2467442076.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(366602943.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(4282370267.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3716673047.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4094228063.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3952563688.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3948462162.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^7168 mod 2*Pi: .089983 */
	(FTYPE)(FLIT(193237065.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3689476901.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1773648579.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1253011991.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4132928366.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1958186331.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1825446067.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^7232 mod 2*Pi: -1.683183 */
	(FTYPE)(FLIT(-3614607301.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2301226355.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2264938155.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1262025252.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1673443514.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1715439334.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1151387329.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^7296 mod 2*Pi: 2.530929 */
	(FTYPE)(FLIT(2717564060.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(3799629874.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3527213949.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2104800322.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1487508733.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(132514528.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3077057647.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^7360 mod 2*Pi: -1.546470 */
	(FTYPE)(FLIT(-3321018704.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(963990407.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(684689697.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3464214441.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2527718955.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1891612792.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2810401370.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^7424 mod 2*Pi: 1.874070 */
	(FTYPE)(FLIT(4024534344.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1003180299.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2730633987.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(953601126.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3194937960.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1809861421.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2077261200.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^7488 mod 2*Pi: .563063 */
	(FTYPE)(FLIT(1209168906.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(4016542323.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2100694822.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2724280604.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2366079503.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1465030042.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(4084433255.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^7552 mod 2*Pi: 2.789683 */
	(FTYPE)(FLIT(2995399147.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(3961692736.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3591437472.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3423571493.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1399743093.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1252227193.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3400048452.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^7616 mod 2*Pi: -2.099095 */
	(FTYPE)(FLIT(-2253886081.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(3346745048.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1842804225.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2938691092.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4126270044.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1886316768.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3903691306.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^7680 mod 2*Pi: 2.935347 */
	(FTYPE)(FLIT(3151804381.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2076608827.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(134926391.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1260428181.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2956611087.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(852191985.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(420086380.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^7744 mod 2*Pi: -.931321 */
	(FTYPE)(FLIT(-1999997602.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3077535538.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(98289015.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(514123070.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1571036969.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3841436491.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1927831473.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^7808 mod 2*Pi: 1.705011 */
	(FTYPE)(FLIT(3661482844.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2203320902.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1388184731.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1098812394.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1406375910.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3792709314.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1549153094.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^7872 mod 2*Pi: .627719 */
	(FTYPE)(FLIT(1348016635.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1282933195.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1036983854.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(4085875786.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3238782240.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3472629127.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(584345213.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^7936 mod 2*Pi: 1.826955 */
	(FTYPE)(FLIT(3923356490.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(233132403.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2727221200.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1498515104.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(317351140.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2385221773.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3363375455.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^8000 mod 2*Pi: 3.101205 */
	(FTYPE)(FLIT(3329893156.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(4277452522.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2061314303.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2058532586.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2083933193.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3360105152.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1076872558.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^8064 mod 2*Pi: .297608 */
	(FTYPE)(FLIT(639109114.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(4057961959.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2587150931.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2404699287.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(609521972.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2592209322.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1764652741.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^8128 mod 2*Pi: -1.546106 */
	(FTYPE)(FLIT(-3320236384.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(317275360.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(118655447.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1852499492.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2015788283.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3034258053.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(4162620034.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^8192 mod 2*Pi: 1.099806 */
	(FTYPE)(FLIT(2361814795.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3391548300.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3529427747.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1894459386.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3153771249.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3671269138.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3622294418.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^8256 mod 2*Pi: -1.710333 */
	(FTYPE)(FLIT(-3672912749.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3815908891.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1260773025.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(564824825.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4166628930.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2380314420.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3216524791.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^8320 mod 2*Pi: -1.257225 */
	(FTYPE)(FLIT(-2699870263.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3926203544.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(381946565.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2784616481.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2791695941.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2670227975.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2385641864.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^8384 mod 2*Pi: 2.760064 */
	(FTYPE)(FLIT(2963596472.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2479472771.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3291683240.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3118955971.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1352372811.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(779845254.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2462150933.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^8448 mod 2*Pi: -.840786 */
	(FTYPE)(FLIT(-1805574128.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(4267715389.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3944655083.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2553568131.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(638265249.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(636999703.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2540373436.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^8512 mod 2*Pi: -.728170 */
	(FTYPE)(FLIT(-1563732865.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(15210689.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3772427446.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1649802736.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3907277996.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1567000230.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1238135930.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^8576 mod 2*Pi: 1.447679 */
	(FTYPE)(FLIT(3108866263.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(4262611188.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3787981809.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1510189573.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2157385250.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3403272593.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3954829823.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^8640 mod 2*Pi: 1.143742 */
	(FTYPE)(FLIT(2456168274.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2798745089.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(781702006.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(502067451.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2367910245.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2568564321.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1810255354.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^8704 mod 2*Pi: -1.858084 */
	(FTYPE)(FLIT(-3990203945.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(298531258.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4146103011.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1093529750.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(230928291.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(4233678023.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(4205234057.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^8768 mod 2*Pi: -.504587 */
	(FTYPE)(FLIT(-1083593055.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1862945288.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1892675388.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(717173157.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1614579486.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2415564625.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(12453337.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^8832 mod 2*Pi: -.070545 */
	(FTYPE)(FLIT(-151493291.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2710094382.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1076096078.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(458939511.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3244323558.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2400236522.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3252168466.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^8896 mod 2*Pi: 1.360554 */
	(FTYPE)(FLIT(2921766870.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(162253258.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2203142722.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(4198978762.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2788166325.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(460482382.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2733258178.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^8960 mod 2*Pi: -.346279 */
	(FTYPE)(FLIT(-743628582.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1223428392.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2012449831.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2203044620.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2900928174.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1725239921.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(4234160536.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^9024 mod 2*Pi: -.621670 */
	(FTYPE)(FLIT(-1335025363.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2438441815.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1585784085.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2065376417.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3993477940.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3369045767.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1782978490.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^9088 mod 2*Pi: -.449740 */
	(FTYPE)(FLIT(-965808789.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1017793104.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(37058959.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1175051323.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3280393348.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3001909091.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(900588385.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^9152 mod 2*Pi: -1.522618 */
	(FTYPE)(FLIT(-3269798051.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(993633236.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1908603188.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3962592248.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3294606492.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(669603853.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2833758091.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^9216 mod 2*Pi: -1.312654 */
	(FTYPE)(FLIT(-2818903099.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(477366967.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2146154579.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(778150220.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(546677007.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(511223376.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2915719667.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^9280 mod 2*Pi: 3.110886 */
	(FTYPE)(FLIT(3340288038.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(702192885.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1408562365.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3832577146.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2282357911.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3392771465.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(553534528.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^9344 mod 2*Pi: .729527 */
	(FTYPE)(FLIT(1566648149.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3481908100.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2595949053.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(442486523.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1502140010.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(4238841682.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3832610064.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^9408 mod 2*Pi: -3.010089 */
	(FTYPE)(FLIT(-3232058660.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(1961018372.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3789567189.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3070321552.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(82405707.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1794385868.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1973433286.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^9472 mod 2*Pi: -2.894924 */
	(FTYPE)(FLIT(-3108400609.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(3439259175.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3290574910.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1348111216.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1800007325.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(247007015.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(152950324.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^9536 mod 2*Pi: -1.980041 */
	(FTYPE)(FLIT(-4252105966.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(55364952.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(602986348.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3270569230.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(237052279.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3853531201.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(4190215191.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^9600 mod 2*Pi: -1.218566 */
	(FTYPE)(FLIT(-2616850501.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(944742560.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2165087589.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3383873027.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1947038140.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(653841714.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2442993279.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^9664 mod 2*Pi: -.760306 */
	(FTYPE)(FLIT(-1632745280.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(4176442598.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3268443051.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1181641241.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1356336384.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2429246110.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3742200696.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^9728 mod 2*Pi: 2.166887 */
	(FTYPE)(FLIT(2326677235.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(3227942322.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(505096566.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(462075056.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(106220440.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3608557982.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3770904508.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^9792 mod 2*Pi: 1.554995 */
	(FTYPE)(FLIT(3339326532.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2282976053.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1738344341.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(815973003.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3672323072.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2129016697.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1489046484.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^9856 mod 2*Pi: .034535 */
	(FTYPE)(FLIT(74163975.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1734831918.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1669330771.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2588985272.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(312439592.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1154407894.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2201884030.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^9920 mod 2*Pi: -3.028785 */
	(FTYPE)(FLIT(-3252132848.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(3938874097.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1523534040.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(717497388.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1582498720.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2585284257.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2366755668.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^9984 mod 2*Pi: 1.376518 */
	(FTYPE)(FLIT(2956050091.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(4194560943.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1471662640.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3178251143.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(837575368.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3267998462.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3076892470.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^10048 mod 2*Pi: 2.066076 */
	(FTYPE)(FLIT(2218432598.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(949533855.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(486153668.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(340848324.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(594050953.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(4136171440.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1539763327.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^10112 mod 2*Pi: -.895368 */
	(FTYPE)(FLIT(-1922788172.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3728458394.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(95464477.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3313936935.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3795829261.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1457307716.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1053221059.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^10176 mod 2*Pi: 2.771570 */
	(FTYPE)(FLIT(2975951121.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2168170751.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(4272076643.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3595209498.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3562239485.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1379602938.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3490937583.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^10240 mod 2*Pi: -1.516611 */
	(FTYPE)(FLIT(-3256897265.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3610983263.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1202214978.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3542461138.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1908913181.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2070106829.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3556460661.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^10304 mod 2*Pi: .647711 */
	(FTYPE)(FLIT(1390948038.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1689696979.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3721367514.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2612692561.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2177939702.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3275212687.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(70061209.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^10368 mod 2*Pi: .277664 */
	(FTYPE)(FLIT(596278433.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(788262067.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3752638660.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3684731276.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3636051012.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1785097691.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(4025985950.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^10432 mod 2*Pi: 1.772218 */
	(FTYPE)(FLIT(3805810128.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1070312128.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1536120135.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(82191283.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(814382487.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3970379207.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1095816445.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^10496 mod 2*Pi: -1.609414 */
	(FTYPE)(FLIT(-3456191068.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(25795765.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3445515239.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2526171567.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3321753356.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(484231583.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2841003190.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^10560 mod 2*Pi: 2.760293 */
	(FTYPE)(FLIT(2963842219.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(3237708443.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(500219391.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2546244589.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2946017425.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(217865487.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(4162419695.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^10624 mod 2*Pi: -1.899921 */
	(FTYPE)(FLIT(-4080049607.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(690516140.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(350224417.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(805963884.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(922901922.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(4183400098.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(792888799.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^10688 mod 2*Pi: 1.571754 */
	(FTYPE)(FLIT(3375315099.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1719209754.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2164126510.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3623271567.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1444489866.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(709735130.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1053144297.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^10752 mod 2*Pi: 2.184654 */
	(FTYPE)(FLIT(2345754606.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(81812508.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2086947618.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1619400077.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4160633788.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3077203757.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(118063051.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^10816 mod 2*Pi: -2.312213 */
	(FTYPE)(FLIT(-2482719360.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(3330515864.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(4049863013.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1976246586.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4207362784.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(769778715.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1659669062.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^10880 mod 2*Pi: .843593 */
	(FTYPE)(FLIT(1811603163.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1764392945.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2910093606.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3841405895.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4222226851.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(161627358.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(4047426133.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^10944 mod 2*Pi: 2.058085 */
	(FTYPE)(FLIT(2209851630.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2594513308.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3229335900.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(102777635.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1586936967.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1964038082.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1559177941.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^11008 mod 2*Pi: .489267 */
	(FTYPE)(FLIT(1050693383.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3265207919.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1472249242.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3832285731.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(429590685.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3164635798.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(378713002.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^11072 mod 2*Pi: 2.797707 */
	(FTYPE)(FLIT(3004014550.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(1709750812.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1415426557.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3601292951.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(238147298.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3907448532.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1471675669.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^11136 mod 2*Pi: .585013 */
	(FTYPE)(FLIT(1256306654.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3574616937.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1609627535.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1614714534.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(635309565.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(4158332072.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1079098970.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^11200 mod 2*Pi: .785425 */
	(FTYPE)(FLIT(1686687779.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2302228563.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(395205519.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1822904815.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(79535422.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3238963727.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2659701455.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^11264 mod 2*Pi: -1.774577 */
	(FTYPE)(FLIT(-3810875265.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(666055619.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(141710379.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(323376141.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(953997537.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2308197775.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2685031229.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^11328 mod 2*Pi: 2.227508 */
	(FTYPE)(FLIT(2391768545.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(3363618206.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2674235957.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(636821934.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1362138234.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(75339705.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1139398334.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^11392 mod 2*Pi: 1.093928 */
	(FTYPE)(FLIT(2349192572.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(640964493.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1103464970.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(797978706.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3745685937.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3119437506.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(981330825.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^11456 mod 2*Pi: -.867724 */
	(FTYPE)(FLIT(-1863423664.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(801554200.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1399963825.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(4101000775.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(702339219.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(4113597877.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(194324905.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^11520 mod 2*Pi: .759992 */
	(FTYPE)(FLIT(1632070914.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2550532504.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1102562151.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(4164936273.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1300467125.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3772260599.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2272445662.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^11584 mod 2*Pi: 2.054211 */
	(FTYPE)(FLIT(2205692280.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2414413896.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(4059713612.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2799588698.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(267783712.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(4187379529.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2901380188.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^11648 mod 2*Pi: -2.525008 */
	(FTYPE)(FLIT(-2711206686.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2930293378.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(849283628.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2262921370.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(977206511.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3778348025.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2571311325.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^11712 mod 2*Pi: 2.770936 */
	(FTYPE)(FLIT(2975269885.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(1117051333.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(995179406.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3215443839.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1721985951.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(73263281.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2323262107.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^11776 mod 2*Pi: -.926048 */
	(FTYPE)(FLIT(-1988674005.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3333197773.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3963686220.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(342736767.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2119612260.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2852331487.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3928856571.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^11840 mod 2*Pi: -2.992644 */
	(FTYPE)(FLIT(-3213326780.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(3779388900.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(4243850720.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3829915451.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2429683925.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2190664411.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3981519564.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^11904 mod 2*Pi: -1.923170 */
	(FTYPE)(FLIT(-4129976435.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3537457428.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1459516440.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(524986933.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(584766093.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(721657743.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3062623397.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^11968 mod 2*Pi: .087491 */
	(FTYPE)(FLIT(187884755.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2062622409.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2796975853.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1300150904.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2279588835.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3655624360.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3227065821.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^12032 mod 2*Pi: 3.124190 */
	(FTYPE)(FLIT(3354573920.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2602357176.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3756142111.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3605510817.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(287533664.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2941769284.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(185766344.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^12096 mod 2*Pi: -2.812903 */
	(FTYPE)(FLIT(-3020331423.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(3060866378.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3421743583.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(454458927.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2784246153.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1365207225.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3901971659.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^12160 mod 2*Pi: -.000709 */
	(FTYPE)(FLIT(-1522757.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(4070616015.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4082098475.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1366423356.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3075099655.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3690061483.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(768852815.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^12224 mod 2*Pi: 1.623418 */
	(FTYPE)(FLIT(3486263542.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1498488472.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1396159592.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(877808936.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2672601016.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(755453525.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(516440255.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^12288 mod 2*Pi: -.604801 */
	(FTYPE)(FLIT(-1298799451.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3844787473.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2821614699.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(680619959.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2231757820.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2285067152.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(643554469.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^12352 mod 2*Pi: 2.789779 */
	(FTYPE)(FLIT(2995502660.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2918060590.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(895933007.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3094162013.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2839977590.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1341096205.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(573967304.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^12416 mod 2*Pi: -1.903926 */
	(FTYPE)(FLIT(-4088650439.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(838713163.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4239314939.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2172929449.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(489067508.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(4093877045.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(898047929.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^12480 mod 2*Pi: -2.916230 */
	(FTYPE)(FLIT(-3131278541.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(768146295.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2731034179.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3509922010.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3327084943.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1075142988.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3922259147.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^12544 mod 2*Pi: .712824 */
	(FTYPE)(FLIT(1530777171.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2537462396.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(940925793.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(4189401516.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(977930142.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2203106162.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2443767375.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^12608 mod 2*Pi: .628886 */
	(FTYPE)(FLIT(1350522961.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3331735359.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1690281551.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(172965047.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3150911961.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1409306231.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(917943319.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^12672 mod 2*Pi: -.398883 */
	(FTYPE)(FLIT(-856595011.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3706869478.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(705238126.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(934543108.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2340438695.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(260144402.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1280650110.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^12736 mod 2*Pi: -1.809622 */
	(FTYPE)(FLIT(-3886132636.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3260593978.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(919627276.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2852536167.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3631635525.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1785567569.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1241764609.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^12800 mod 2*Pi: .931226 */
	(FTYPE)(FLIT(1999792446.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2309100365.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2274667366.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1108827595.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3135725164.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3277823443.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(636571705.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^12864 mod 2*Pi: 1.906872 */
	(FTYPE)(FLIT(4094976116.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3448658456.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3061528778.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1491294379.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(150395561.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1567831103.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1585069438.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^12928 mod 2*Pi: 1.104821 */
	(FTYPE)(FLIT(2372584819.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1311369526.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4053560610.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(422375807.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(284199993.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2629425747.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1343672283.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^12992 mod 2*Pi: .536499 */
	(FTYPE)(FLIT(1152122122.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(272429482.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2788178731.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2164554848.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(781773254.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3618464074.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2153719722.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^13056 mod 2*Pi: 2.706729 */
	(FTYPE)(FLIT(2906328346.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(3617741029.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3629477810.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2063667356.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1112071819.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3959957357.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(806715591.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^13120 mod 2*Pi: -2.756267 */
	(FTYPE)(FLIT(-2959519107.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(3630699727.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(4099933199.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2348280800.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(201038035.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2292775595.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2694256760.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^13184 mod 2*Pi: -.068228 */
	(FTYPE)(FLIT(-146518406.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(357999487.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1009123178.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1035158787.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(315514751.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(682918461.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(4262087449.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^13248 mod 2*Pi: -2.326548 */
	(FTYPE)(FLIT(-2498111474.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2384683792.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3692452601.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3415101730.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1636309351.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(125763168.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2641504390.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^13312 mod 2*Pi: -1.670284 */
	(FTYPE)(FLIT(-3586908400.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2032421297.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1859280999.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(20342008.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(547955952.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1529665880.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(549697378.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^13376 mod 2*Pi: .203847 */
	(FTYPE)(FLIT(437757029.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2688686714.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1442450081.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(178324869.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(110718961.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3177970301.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(163360760.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^13440 mod 2*Pi: 2.223001 */
	(FTYPE)(FLIT(2386929605.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(1585325120.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2862431975.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3689950693.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(482214241.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(831298963.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(145447484.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^13504 mod 2*Pi: .512652 */
	(FTYPE)(FLIT(1100910838.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2119325849.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2534247927.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2683524853.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(391067855.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(538595729.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(888822351.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^13568 mod 2*Pi: .522580 */
	(FTYPE)(FLIT(1122232545.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(234466286.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1078872229.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1478847104.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1762318090.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3412366906.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3299114133.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^13632 mod 2*Pi: -.439100 */
	(FTYPE)(FLIT(-942959060.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2840068957.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2591580670.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(949248851.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2637411544.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1124897967.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1500850354.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^13696 mod 2*Pi: -2.902715 */
	(FTYPE)(FLIT(-3116766910.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(3587293193.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(896343091.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(4000085436.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2884157198.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1635237312.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1498957156.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^13760 mod 2*Pi: 2.687270 */
	(FTYPE)(FLIT(2885433903.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(3283574108.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2523258098.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1672302973.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3691496268.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(229821168.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(37990097.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^13824 mod 2*Pi: 1.464861 */
	(FTYPE)(FLIT(3145764447.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(82598387.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(294367503.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2793045729.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3791165226.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2635014767.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1501875821.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^13888 mod 2*Pi: -1.781825 */
	(FTYPE)(FLIT(-3826440469.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2159368688.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3009863511.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1101059317.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3926412096.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3327501591.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(538962583.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^13952 mod 2*Pi: .145958 */
	(FTYPE)(FLIT(313443353.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1038279978.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3600017957.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1269784936.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2717318081.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2252754899.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2140217931.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^14016 mod 2*Pi: 2.788857 */
	(FTYPE)(FLIT(2994511937.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2539570809.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1766600292.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2202535041.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1967777359.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3325548864.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3482373423.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^14080 mod 2*Pi: 2.932135 */
	(FTYPE)(FLIT(3148355992.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(3023587212.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1547873924.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1987792716.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(589554764.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3313062207.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1086628085.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^14144 mod 2*Pi: -2.870801 */
	(FTYPE)(FLIT(-3082498949.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(493740331.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(35079920.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1826544530.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(798029901.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1861481962.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3047344333.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^14208 mod 2*Pi: 2.750922 */
	(FTYPE)(FLIT(2953779798.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(29982138.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2726500372.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(236599725.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1262488820.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2004227943.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2471096648.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^14272 mod 2*Pi: -2.609721 */
	(FTYPE)(FLIT(-2802166952.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2840725348.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1171554151.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3944677085.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3702833531.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3026292657.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(760378638.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^14336 mod 2*Pi: -2.078715 */
	(FTYPE)(FLIT(-2232003304.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(1129416898.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3293602672.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2034434671.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3005629242.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2935240842.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3467623204.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^14400 mod 2*Pi: 1.915331 */
	(FTYPE)(FLIT(4113142116.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2356464897.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4274940832.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(120802701.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(143750242.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3335462625.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(423554896.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^14464 mod 2*Pi: 2.072053 */
	(FTYPE)(FLIT(2224850341.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(4217510894.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2347585113.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2709641796.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(378621629.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2268001394.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2314195473.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^14528 mod 2*Pi: .033219 */
	(FTYPE)(FLIT(71336912.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3506149790.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1496269887.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3011607604.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2353853996.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2593702569.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3434190625.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^14592 mod 2*Pi: -.642438 */
	(FTYPE)(FLIT(-1379624189.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3805692503.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2520952745.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(312771519.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(544264150.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1228414066.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(902408972.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^14656 mod 2*Pi: -2.937321 */
	(FTYPE)(FLIT(-3153924739.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(1279692394.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(58223344.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3340236238.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3359462990.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1191219766.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(450534736.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^14720 mod 2*Pi: .977154 */
	(FTYPE)(FLIT(2098421692.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(255683621.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1475542154.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1763122320.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(658443103.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1819581257.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3743798234.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^14784 mod 2*Pi: 1.981410 */
	(FTYPE)(FLIT(4255044642.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2729943088.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4014547101.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3028667353.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3908245311.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1686864537.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(744949560.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^14848 mod 2*Pi: .580717 */
	(FTYPE)(FLIT(1247080885.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(4094713136.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2830897631.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(462415731.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3312440563.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2306667552.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(705047062.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^14912 mod 2*Pi: -1.630115 */
	(FTYPE)(FLIT(-3500645121.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1048022262.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(624214070.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1135356477.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3790863050.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2384275270.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2112856601.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^14976 mod 2*Pi: 1.622529 */
	(FTYPE)(FLIT(3484353687.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(109321673.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2618628597.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2481275093.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(672633826.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2205054667.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2903229912.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^15040 mod 2*Pi: -1.215515 */
	(FTYPE)(FLIT(-2610297857.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3037283952.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2807624808.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(5920218.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2085240475.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3680912346.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1275883993.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^15104 mod 2*Pi: 1.541888 */
	(FTYPE)(FLIT(3311179814.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(288603473.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(190320906.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1242021686.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(558755144.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1250704150.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1287609405.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^15168 mod 2*Pi: .848909 */
	(FTYPE)(FLIT(1823018298.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(639035147.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1499466324.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3086348636.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2521258631.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1929386517.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1266663432.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^15232 mod 2*Pi: 2.870456 */
	(FTYPE)(FLIT(3082128694.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2283006436.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(731458661.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(232843632.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1228263108.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3137446374.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2989560752.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^15296 mod 2*Pi: -1.931105 */
	(FTYPE)(FLIT(-4147016051.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1029153510.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(303497521.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2389877209.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2002836052.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2045829341.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3818650879.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^15360 mod 2*Pi: 2.481817 */
	(FTYPE)(FLIT(2664831039.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(2688785652.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(484124631.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(212165856.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(465662915.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1803944069.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(985284750.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^15424 mod 2*Pi: .258336 */
	(FTYPE)(FLIT(554772590.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(506271890.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4196270064.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1680387206.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2254241581.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1561469606.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3241424179.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^15488 mod 2*Pi: .236438 */
	(FTYPE)(FLIT(507745961.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(834824555.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(349931792.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3601062634.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1815689095.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1720852489.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1193729353.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^15552 mod 2*Pi: .759989 */
	(FTYPE)(FLIT(1632064271.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2843664609.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3820550912.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(153857327.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1186749596.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(522179436.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3391328516.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^15616 mod 2*Pi: .236482 */
	(FTYPE)(FLIT(507842215.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3792979629.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2740667431.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2821993684.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2314325038.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1806697526.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(34650414.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^15680 mod 2*Pi: -.568203 */
	(FTYPE)(FLIT(-1220207541.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(4127887545.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3814041470.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3351091050.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(995276432.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1167316045.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(23537912.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^15744 mod 2*Pi: 2.922656 */
	(FTYPE)(FLIT(3138178259.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(489120354.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3416368173.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2406266734.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3486118282.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(909665066.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3959477269.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^15808 mod 2*Pi: 2.215681 */
	(FTYPE)(FLIT(2379069768.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(3338934246.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1874106160.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3848415390.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(639318210.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(757259774.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3675003273.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^15872 mod 2*Pi: 1.266510 */
	(FTYPE)(FLIT(2719809144.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2572317741.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3655351381.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3222817538.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2143223892.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2695592939.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(486400815.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^15936 mod 2*Pi: 1.243107 */
	(FTYPE)(FLIT(2669551998.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3134296614.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3068007299.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2464134898.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(895141572.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(3471366580.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(448856647.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^16000 mod 2*Pi: .774342 */
	(FTYPE)(FLIT(1662886925.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(760269569.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3302934354.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3625079480.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1577378583.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1974311492.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2724720483.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^16064 mod 2*Pi: -1.042627 */
	(FTYPE)(FLIT(-2239023853.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1263104650.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3191090487.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(4213876493.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1710792246.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(160184347.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(925821959.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^16128 mod 2*Pi: 2.046293 */
	(FTYPE)(FLIT(2197190224.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(161181005.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1462334940.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1393690079.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3411255957.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1902464373.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2329070326.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^16192 mod 2*Pi: 2.686549 */
	(FTYPE)(FLIT(2884659585.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(1584825966.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3957033557.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1146643589.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2919388539.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2408180650.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3482525533.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^16256 mod 2*Pi: -2.809711 */
	(FTYPE)(FLIT(-3016903774.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(3715981956.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3877165347.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(781012454.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2980464955.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2534544998.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1792627416.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},

	{	/* 2^16320 mod 2*Pi: -.896289 */
	(FTYPE)(FLIT(-1924766965.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2663329755.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1809912844.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(157104580.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3288003688.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2434210923.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2),
	(FTYPE)(FLIT(2727102807.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2  / FRAC_BITS)},
	};

 #elif 53 <= FBITS
  #define ACSHIFT	5
  #define FRAC_BITS	67108864.0L		/* 2^26 */
  #define FULL_BITS	(FRAC_BITS_1 * FRAC_BITS_1 * 2)	/* 2^53 */
  #define FRAC_XTRA	5

static const FTYPE c[] = {
	(FTYPE)(FLIT(52707178.0) * 8),
	(FTYPE)(FLIT(35788428.0) * 8 / FRAC_BITS_1),
	(FTYPE)(FLIT(9253169.0) * 8 / FRAC_BITS_2),
	(FTYPE)(FLIT(40012672.0) * 8 / FRAC_BITS_3),
	(FTYPE)(FLIT(57701188.0) * 8 / FRAC_BITS_4),
	(FTYPE)(FLIT(43001056.0) * 8 / FRAC_BITS_5),
	};

static const FTYPE b[][ACSIZE]={	/* 2^N mod 2*Pi */
	{	/* 2^32 mod 2*Pi: -2.661359 */
	(FTYPE)(FLIT(-44650192.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(24373128.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(52217969.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(32495948.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(52430789.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(10049912.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^64 mod 2*Pi: 3.117992 */
	(FTYPE)(FLIT(52311224.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(32151194.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3521788.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(17658793.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(12653430.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(28545187.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^96 mod 2*Pi: 3.075365 */
	(FTYPE)(FLIT(51596056.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(34529797.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(57427415.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(47345698.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(19105487.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(33321368.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^128 mod 2*Pi: 1.346130 */
	(FTYPE)(FLIT(45168630.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(26184515.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(34707788.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(8089061.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(57195156.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(2619245.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^160 mod 2*Pi: 1.940571 */
	(FTYPE)(FLIT(65114761.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(20027062.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(47489540.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(14214764.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(59230352.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(31139624.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^192 mod 2*Pi: 3.131272 */
	(FTYPE)(FLIT(52534019.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(47861617.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(57586889.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3460398.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(36832902.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(41682469.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^224 mod 2*Pi: -.204121 */
	(FTYPE)(FLIT(-6849158.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(17949024.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(45979062.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(9676238.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(39833771.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(34623173.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^256 mod 2*Pi: 2.694543 */
	(FTYPE)(FLIT(45206937.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(30064030.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1277106.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(31481331.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(32310796.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(1285356.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^288 mod 2*Pi: -2.734756 */
	(FTYPE)(FLIT(-45881600.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(65668541.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(35499664.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(66210623.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(58493317.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(65982999.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^320 mod 2*Pi: .038570 */
	(FTYPE)(FLIT(1294181.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(64808977.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(54574838.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(55770472.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(10000946.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(4603453.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^352 mod 2*Pi: -3.081346 */
	(FTYPE)(FLIT(-51696412.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(16119248.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(25386904.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(11185286.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(56753234.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(29265903.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^384 mod 2*Pi: 1.559242 */
	(FTYPE)(FLIT(52319465.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(34308466.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(21037701.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(49304840.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(8546391.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(10934690.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^416 mod 2*Pi: 1.087057 */
	(FTYPE)(FLIT(36475572.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(15585858.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(7042195.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(63308505.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(34738113.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(43227007.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^448 mod 2*Pi: -1.714938 */
	(FTYPE)(FLIT(-57543755.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(13151969.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(61014092.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(51172192.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(36610653.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(11303136.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^480 mod 2*Pi: 1.857537 */
	(FTYPE)(FLIT(62328609.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(17373473.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(20271818.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2732297.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(44166545.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(13628803.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^512 mod 2*Pi: 1.433420 */
	(FTYPE)(FLIT(48097582.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(63049219.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(54727889.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(30569368.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(45941495.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(33618616.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^544 mod 2*Pi: -2.034838 */
	(FTYPE)(FLIT(-34138911.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(472447.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(24191272.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(66788033.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(42935532.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(43807839.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^576 mod 2*Pi: 1.924039 */
	(FTYPE)(FLIT(64560050.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(12046811.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(9847201.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(48880213.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(61123341.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(34876678.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^608 mod 2*Pi: 2.376597 */
	(FTYPE)(FLIT(39872682.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(22873682.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(31384146.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(15814545.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(47398232.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(41988367.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^640 mod 2*Pi: .960377 */
	(FTYPE)(FLIT(32224897.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(52604533.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(21898454.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(52106995.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(4539170.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(13183912.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^672 mod 2*Pi: -.405135 */
	(FTYPE)(FLIT(-13594073.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(12725775.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(28801379.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(18128404.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(44774589.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(60130533.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^704 mod 2*Pi: -1.374624 */
	(FTYPE)(FLIT(-46124738.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(21613885.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(34957299.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(53333399.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(36591729.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(62362664.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^736 mod 2*Pi: -.208487 */
	(FTYPE)(FLIT(-6995674.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(54175033.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(22625417.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(23179700.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(52525623.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(17345860.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^768 mod 2*Pi: -.103183 */
	(FTYPE)(FLIT(-3462232.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(46003782.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(45190672.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(51960393.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2449619.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(8368730.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^800 mod 2*Pi: -1.018313 */
	(FTYPE)(FLIT(-34168926.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(14513990.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(63122172.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(36035659.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1080650.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(47601380.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^832 mod 2*Pi: -.900675 */
	(FTYPE)(FLIT(-30221623.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(39344933.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(48788887.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(35265370.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2271449.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(43393681.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^864 mod 2*Pi: -1.326629 */
	(FTYPE)(FLIT(-44514277.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(34044011.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(63424890.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(19238758.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(52815139.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(23109538.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^896 mod 2*Pi: -1.084375 */
	(FTYPE)(FLIT(-36385577.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(57863133.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(20694677.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(52649708.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(48587469.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(7820136.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^928 mod 2*Pi: -2.169818 */
	(FTYPE)(FLIT(-36403504.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(64031972.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(61650298.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(32999103.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(37147537.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(10436430.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^960 mod 2*Pi: 2.289652 */
	(FTYPE)(FLIT(38413979.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(22582941.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1611179.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(21108706.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(27622625.0) * 4 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(37960282.0) * 4 / FRAC_BITS_4 / FRAC_BITS_2)},

	{	/* 2^992 mod 2*Pi: -.123343 */
	(FTYPE)(FLIT(-4138705.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(41933462.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(51111950.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(51269386.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(59561043.0) * 2 / FRAC_BITS_4  / FRAC_BITS),
	(FTYPE)(FLIT(6069291.0) * 2 / FRAC_BITS_4 / FRAC_BITS_2)},
	};

 #elif 24 <= FBITS
  #define ACSHIFT	3
  #define FRAC_BITS	4096.0L		/* 2^12 */
  #define FULL_BITS	(FRAC_BITS_1 * FRAC_BITS_1)	/* 2^24 */
  #define FRAC_XTRA	4

static const FTYPE c[] = {
	(FTYPE)(FLIT(3216.0) * 8),
	(FTYPE)(FLIT(4058.0) * 8 / FRAC_BITS_1),
	(FTYPE)(FLIT(2594.0) * 8 / FRAC_BITS_2),
	(FTYPE)(FLIT(360.0) * 8 / FRAC_BITS_3),
	(FTYPE)(FLIT(3107.0) * 8 / FRAC_BITS_4),
	};

static const FTYPE b[][ACSIZE] = {	/* 2^N mod 2*Pi */
	{	/* 2^8 mod 2*Pi: -1.610598 */
	(FTYPE)(FLIT(-3299.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2032.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(553.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2275.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2403.0) * 2 / FRAC_BITS_4  / FRAC_BITS)},

	{	/* 2^16 mod 2*Pi: 2.377246 */
	(FTYPE)(FLIT(2434.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(1228.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(3674.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3023.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(962.0) * 4 / FRAC_BITS_4  / FRAC_BITS)},

	{	/* 2^24 mod 2*Pi: -.893969 */
	(FTYPE)(FLIT(-1831.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(621.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2511.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2994.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(61.0) * 2 / FRAC_BITS_4  / FRAC_BITS)},

	{	/* 2^32 mod 2*Pi: -2.661359 */
	(FTYPE)(FLIT(-2726.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(3148.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(371.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3704.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2247.0) * 4 / FRAC_BITS_4  / FRAC_BITS)},

	{	/* 2^40 mod 2*Pi: -2.723843 */
	(FTYPE)(FLIT(-2790.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(3216.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(170.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2288.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1274.0) * 4 / FRAC_BITS_4  / FRAC_BITS)},

	{	/* 2^48 mod 2*Pi: .129861 */
	(FTYPE)(FLIT(265.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(3910.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2109.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(592.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(561.0) * 2 / FRAC_BITS_4  / FRAC_BITS)},

	{	/* 2^56 mod 2*Pi: 1.828413 */
	(FTYPE)(FLIT(3744.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2415.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(635.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1011.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3900.0) * 2 / FRAC_BITS_4  / FRAC_BITS)},

	{	/* 2^64 mod 2*Pi: 3.117992 */
	(FTYPE)(FLIT(3192.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(3374.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(490.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2409.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2573.0) * 4 / FRAC_BITS_4  / FRAC_BITS)},

	{	/* 2^72 mod 2*Pi: .241406 */
	(FTYPE)(FLIT(494.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1635.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2440.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(1888.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1235.0) * 2 / FRAC_BITS_4  / FRAC_BITS)},

	{	/* 2^80 mod 2*Pi: -1.031939 */
	(FTYPE)(FLIT(-2114.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2415.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(802.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2030.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3474.0) * 2 / FRAC_BITS_4  / FRAC_BITS)},

	{	/* 2^88 mod 2*Pi: -.282511 */
	(FTYPE)(FLIT(-579.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1708.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2269.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2968.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(2501.0) * 2 / FRAC_BITS_4  / FRAC_BITS)},

	{	/* 2^96 mod 2*Pi: 3.075365 */
	(FTYPE)(FLIT(3149.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(710.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(526.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3616.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1499.0) * 4 / FRAC_BITS_4  / FRAC_BITS)},

	{	/* 2^104 mod 2*Pi: 1.895179 */
	(FTYPE)(FLIT(3881.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(1341.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(816.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(32.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(305.0) * 2 / FRAC_BITS_4  / FRAC_BITS)},

	{	/* 2^112 mod 2*Pi: 1.360661 */
	(FTYPE)(FLIT(2786.0) * 2  / FRAC_BITS),
	(FTYPE)(FLIT(2599.0) * 2 / FRAC_BITS_2),
	(FTYPE)(FLIT(3838.0) * 2 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(3593.0) * 2 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(1902.0) * 2 / FRAC_BITS_4  / FRAC_BITS)},

	{	/* 2^120 mod 2*Pi: 2.754152 */
	(FTYPE)(FLIT(2820.0) * 4  / FRAC_BITS),
	(FTYPE)(FLIT(1030.0) * 4 / FRAC_BITS_2),
	(FTYPE)(FLIT(1226.0) * 4 / FRAC_BITS_2  / FRAC_BITS),
	(FTYPE)(FLIT(2488.0) * 4 / FRAC_BITS_2 / FRAC_BITS_2),
	(FTYPE)(FLIT(64.0) * 4 / FRAC_BITS_4  / FRAC_BITS)},
	};

 #else /* FBITS */
  #error Quad has insufficient precision
 #endif /* FBITS */

/*
 * Copyright (c) 1994-2005 by P.J. Plauger.  ALL RIGHTS RESERVED. 
 * Consult your license regarding permissions and restrictions.
V5.00:1521 */
