/* xxxtgamma.h -- common _[FL]Tgamma functionality */
#include "xmath.h"
_STD_BEGIN

 #if 16384 == FMAXEXP
  #define BIG_ARG	FLIT(130.0)	/* cutover for Stirling's Formula */

 #elif 1024 == FMAXEXP
  #define BIG_ARG	FLIT(54.0)

 #elif 128 == FMAXEXP
  #define BIG_ARG	FLIT(31.0)

 #else /* FMAXEXP */
  #error _Tgamma has unknnown exponent range
 #endif /* FMAXEXP */

FTYPE FNAME(Pow)(FTYPE, FTYPE, short *);
FTYPE FNAME(Gamma_big) = BIG_ARG;

	/* coefficients */

 #if   FBITS <= 26
  #define DPOLY(x)	(((c[0] * x + c[1]) * x + c[2]) * x + c[3])
  #define NPOLY(x)	(((s[0] * x + s[1]) * x + s[2]) * x + s[3])

static const FTYPE s[] = {	/* 4/3, (gamma(x+2)-1)/x, |x| < 1/2 */
	FLIT( 0.0132447635),
	FLIT( 0.0094383842),
	FLIT( 0.4292531118),
	FLIT( 0.4329603874),
	};

static const FTYPE c[] = {
	FLIT( 0.0356189406),
	FLIT(-0.1925531275),
	FLIT( 0.0177401307),
	FLIT( 1.0240691409),
	};

 #elif FBITS <= 57
  #define DPOLY(x)	FNAME(Poly)(x, c, sizeof (c) / sizeof (c[0]) - 1)
  #define NPOLY(x)	FNAME(Poly)(x, s, sizeof (s) / sizeof (s[0]) - 1)

#if defined(_BUILD_FOR_RENESAS) && defined(_R_FLT)		/* V10000K102 */
static const FTYPE s[] = {	/* 7/6, (gamma(x+2)-1)/x, |x| < 1/2 */
	FLIT( 1.1922927408269750e-05),
	FLIT( 1.1794182945081213e-04),
	FLIT( 1.0195946014535590e-03),
	FLIT( 7.5606068049843831e-03),
	FLIT( 1.9265272117452482e-02),
	FLIT( 1.2554212337999338e-01),
	FLIT( 5.4544333054825789e-01),
	FLIT( 4.3251944860403391e-01),
	};

static const FTYPE c[] = {
	FLIT( 2.6706305208419249e-05),
	FLIT(-1.4256270073394934e-03),
	FLIT( 1.1843095408138172e-02),
	FLIT(-9.1362668889262699e-03),
	FLIT(-1.8643116397504167e-01),
	FLIT( 2.9357730424461009e-01),
	FLIT( 1.0230261925463711e+00),
	};
#else
static const FTYPE s[] = {	/* 7/6, (gamma(x+2)-1)/x, |x| < 1/2 */
	FLIT( 0.00001192292740826975),
	FLIT( 0.00011794182945081212),
	FLIT( 0.00101959460145355905),
	FLIT( 0.00756060680498438352),
	FLIT( 0.01926527211745248008),
	FLIT( 0.12554212337999338034),
	FLIT( 0.54544333054825790736),
	FLIT( 0.43251944860403390826),
	};

static const FTYPE c[] = {
	FLIT( 0.00002670630520841925),
	FLIT(-0.00142562700733949340),
	FLIT( 0.01184309540813817347),
	FLIT(-0.00913626688892627011),
	FLIT(-0.18643116397504167435),
	FLIT( 0.29357730424461011830),
	FLIT( 1.02302619254637107038),
	};
#endif													/* V10000K102 */

 #elif FBITS <= 67
  #define DPOLY(x)	FNAME(Poly)(x, c, sizeof (c) / sizeof (c[0]) - 1)
  #define NPOLY(x)	FNAME(Poly)(x, s, sizeof (s) / sizeof (s[0]) - 1)

static const FTYPE s[] = {	/* 8/7, (gamma(x+2)-1)/x, |x| < 1/2 */
	FLIT( 0.0000012252274233843080429),
	FLIT( 0.0000189902736198147386676),
	FLIT( 0.0001488810124060112759143),
	FLIT( 0.0021081558679903176502243),
	FLIT( 0.0082237284021852496451284),
	FLIT( 0.0274355999439532197115759),
	FLIT( 0.2106616549602068357701475),
	FLIT( 0.6205985834021645903460609),
	FLIT( 0.4311258398802884098685604),
	};

static const FTYPE c[] = {
	FLIT( 0.0000502947339888362866946),
	FLIT(-0.0005968825777416810441688),
	FLIT( 0.0008416628541196812057007),
	FLIT( 0.0156647378005578993812638),
	FLIT(-0.0491646970580070110266764),
	FLIT(-0.1607532521144927558711585),
	FLIT( 0.4745508666467367057422347),
	FLIT( 1.0197299286878226480191199),
	};

 #elif FBITS <= 117
  #define DPOLY(x)	FNAME(Poly)(x, c, sizeof (c) / sizeof (c[0]) - 1)
  #define NPOLY(x)	FNAME(Poly)(x, s, sizeof (s) / sizeof (s[0]) - 1)

static const FTYPE s[] = {	/* 13/11, (gamma(x+2)-1)/x, |x| < 1/2 */
	FLIT( 0.00000000000531035009341276167986284),
	FLIT( 0.00000000016294654964411099307242608),
	FLIT( 0.00000000327242878788474131984189565),
	FLIT( 0.00000005236906526935516683513375497),
	FLIT( 0.00000043197996749153122182692067538),
	FLIT( 0.00000776343149366655960896567547298),
	FLIT( 0.00003976590749611874301475773220307),
	FLIT( 0.00029802749260661569256458097765892),
	FLIT( 0.00294113962293592843283121484732478),
	FLIT( 0.01021953978946398840123869237891331),
	FLIT( 0.03515349429739150060092309358658018),
	FLIT( 0.23241405547975625308620390257748281),
	FLIT( 0.63505917043490637037026710564298434),
	FLIT( 0.43025456679510420491836522563856427),
	};

static const FTYPE c[] = {
	FLIT(-0.00000000405267401443659457210378442),
	FLIT( 0.00000014669240569061373288732127492),
	FLIT(-0.00000199955504453415316664202895746),
	FLIT( 0.00000909879874354614872628723656270),
	FLIT( 0.00005574346734983244407441706816705),
	FLIT(-0.00074965006027880299742115829456059),
	FLIT( 0.00127752057256789968449288102476137),
	FLIT( 0.01522545954111876548830316472043297),
	FLIT(-0.05368036363632279725552453725613803),
	FLIT(-0.14417861450285788570291128750769483),
	FLIT( 0.51076154302413771672360131760965778),
	FLIT( 1.01766913075172767875655842962379213),
	};

 #else /* FBITS */
  #error _Tgamma has insufficient precision
 #endif /* FBITS */

/*
 * Stirling approximation coefficients
 */
#define ASIZE(x)	(sizeof (x) / sizeof ((x)[0]))
#define PSIZE(x)	(ASIZE(x) - 1)
#define POLY(x)		x, PSIZE(x)

struct Approx {	/* description of one interval approximation */
	FTYPE to, mid;
	const FTYPE *num;
	int nsize;
	const FTYPE *den;
	int dsize;
	};

 #if FBITS <= 24
static const FTYPE s10[] = {	/* 7/1, GAMMA(1/x)/(((1/x)^(1/x - 1/2))*exp(-1/x)), 30 <= x < 67 */
	FLIT(-0.1481641075e-2),
	FLIT( 0.3563276104e-3),
	FLIT( 0.1898581880e-2),
	FLIT(-0.1818622339e-2),
	FLIT(-0.4966273005e-2),
	FLIT( 0.5404322946e-1),
	FLIT( 0.7592609766),
	FLIT( 2.5116735242),
	};

static const FTYPE c10[] = {
	FLIT( 0.2189643786),
	FLIT( 1.0),
	};

static const struct Approx approx0[] = {	/* table of tail approximations */
	{FLIT(67.0), FLIT(97.0) / FLIT(4020.0), POLY(s10), POLY(c10)},
	};

 #elif FBITS <= 53
#if defined(_BUILD_FOR_RENESAS) && defined(_R_FLT)		/* V10000K102 */
static const FTYPE s10[] = {	/* 13/1, GAMMA(1/x)/(((1/x)^(1/x - 1/2))*exp(-1/x)), 30 <= x < 38 */
	FLIT( 1.6614314518760217e-02),
	FLIT(-1.3965707272626177e-03),
	FLIT(-4.9824254383538848e-03),
	FLIT( 1.0583487432607030e-03),
	FLIT( 2.1489456425337538e-03),
	FLIT(-9.5896447695592948e-04),
	FLIT(-1.4455262959800640e-03),
	FLIT( 1.4401123536802326e-03),
	FLIT( 1.6474099822547440e-03),
	FLIT(-5.1877751839995417e-03),
	FLIT(-8.0784377037000112e-04),
	FLIT( 1.5488179113127576e-01),
	FLIT( 1.9659470092827178e+00),
	FLIT( 2.5089636430553437e+00),
	};

static const FTYPE c10[] = {
	FLIT( 7.0023705660120272e-01),
	FLIT( 1.0),
	};
#else
static const FTYPE s10[] = {	/* 13/1, GAMMA(1/x)/(((1/x)^(1/x - 1/2))*exp(-1/x)), 30 <= x < 38 */
	FLIT( 0.16614314518760217485e-1),
	FLIT(-0.13965707272626176936e-2),
	FLIT(-0.49824254383538848853e-2),
	FLIT( 0.10583487432607028510e-2),
	FLIT( 0.21489456425337538895e-2),
	FLIT(-0.95896447695592953043e-3),
	FLIT(-0.14455262959800639857e-2),
	FLIT( 0.14401123536802324852e-2),
	FLIT( 0.16474099822547439696e-2),
	FLIT(-0.51877751839995419056e-2),
	FLIT(-0.80784377037000113812e-3),
	FLIT( 0.15488179113127575577),
	FLIT( 1.96594700928271786568),
	FLIT( 2.50896364305534390989),
	};

static const FTYPE c10[] = {
	FLIT( 7.0023705660120272e-01),
	FLIT( 1.0),
	};
#endif													/* V10000K102 */

static const struct Approx approx0[] = {	/* table of tail approximations */
	{FLIT(174.0), FLIT(35.0) / FLIT(3132.0), POLY(s10), POLY(c10)},
	};

 #elif FBITS <= 64
static const FTYPE s10[] = {	/* 17/1, GAMMA(1/x)/(((1/x)^(1/x - 1/2))*exp(-1/x)), 154 <= x < 1000 */
	FLIT( 0.4546220494140817043363865),
	FLIT(-0.1224903749847175016039538e-1),
	FLIT(-0.7484768892852057231978545e-1),
	FLIT( 0.4734077145599577484114983e-2),
	FLIT( 0.1618895833987363743071835e-1),
	FLIT(-0.1883846717278683780199795e-2),
	FLIT(-0.4807666725790491874221959e-2),
	FLIT( 0.9742315104975633726799432e-3),
	FLIT( 0.2079795300739290027706013e-2),
	FLIT(-0.7583360852686586970764657e-3),
	FLIT(-0.1423261873101868630482683e-2),
	FLIT( 0.1062150935520615378012921e-2),
	FLIT( 0.1715485372904218056920799e-2),
	FLIT(-0.3704639161490968123219714e-2),
	FLIT(-0.2669856489920408955993153e-2),
	FLIT( 0.1069420473981335034682702),
	FLIT( 1.3887211374154465871745720),
	FLIT( 2.5074110395950202124949870),
	};

static const FTYPE c10[] = {
	FLIT( 0.4705134069148969307515689),
	FLIT( 1.),
	};

static const FTYPE s11[] = {	/* 17/1, GAMMA(1/x)/(((1/x)^(1/x - 1/2))*exp(-1/x)), 1000 <= x < 2321 */
	FLIT( 0.3151460521622963255843048e-3),
	FLIT( 0.2359698914441546497633878e-1),
	FLIT(-0.5017014879258214825063233e-3),
	FLIT(-0.1313786780552261030922185e-1),
	FLIT( 0.4584803728292781718733545e-3),
	FLIT( 0.8002434854057141126144849e-2),
	FLIT(-0.4963439826404186776514985e-3),
	FLIT(-0.6926082339829834038821802e-2),
	FLIT( 0.8543247901482949653124380e-3),
	FLIT( 0.1047212923020167331186581e-1),
	FLIT(-0.3224543722361497268181487e-2),
	FLIT(-0.3892072550086160725350508e-1),
	FLIT( 0.5204243162146607220010858e-1),
	FLIT( 1.2634854182504211010427808),
	FLIT( 15.254493930066741604036385),
	FLIT( 0.2881130790198211822767118),
	FLIT( 2.5067771039391622794713656),
	};

static const FTYPE c11[] = {
	FLIT( 6.0792001667043917610360325),
	FLIT( 0.3160032780464379173800391e-1),
	FLIT( 0.9999997538432151781934066),
	};

static const struct Approx approx0[] = {	/* table of tail approximations */
	{FLIT(1000.0), FLIT(577.0) / FLIT(154000.0), POLY(s10), POLY(c10)},
	{FLIT(2321.0), FLIT(3321.0) / FLIT(4642000.0), POLY(s11), POLY(c11)},
	};

 #elif FBITS <= 113
static const FTYPE s10[] = {	/* 30/1, GAMMA(1/x)/(((1/x)^(1/x - 1/2))*exp(-1/x)), 30 <= x < 38 */
	FLIT(-15836257.0882011360972091240098903001),
	FLIT( 152307.084530599622445599674077464446),
	FLIT( 812645.270930855470082886308909193196),
	FLIT(-15698.8750179128888515456109204599179),
	FLIT(-48406.8246075798375690108805901964641),
	FLIT( 1414.43996465841068613423945017613725),
	FLIT( 3395.68611200030747430874171335031236),
	FLIT(-133.735075355214854825693648612430192),
	FLIT(-284.805507971742371332362102493487166),
	FLIT( 14.2155414211561753609709260845215104),
	FLIT( 29.0767548318187840105113164230770446),
	FLIT(-1.77290685497823651801257818248876672),
	FLIT(-3.69225198413643054956550960269840399),
	FLIT( 0.26900448053782904027672907528746684),
	FLIT( 0.59889307545611591235092304871789165),
	FLIT(-0.51574304551337409338972205345517512e-1),
	FLIT(-0.12835546434092314709113653384978839),
	FLIT( 0.13077220977411688707071457680850311e-1),
	FLIT( 0.38007105701239568439799735209102476e-1),
	FLIT(-0.46637585419517434518765695088575056e-2),
	FLIT(-0.16541063080373772699577404371277554e-1),
	FLIT( 0.25668970938684036872808031139298409e-2),
	FLIT( 0.11602135828115409077882206206742382e-1),
	FLIT(-0.25520447625886275530527735385396737e-2),
	FLIT(-0.15301309302000801597180837986635353e-1),
	FLIT( 0.61899506926938202000120404231987147e-2),
	FLIT( 0.52226697178255473207433568153557812e-1),
	FLIT(-0.74380815990758777697488594303851729e-1),
	FLIT(-1.62973983609088662356771598241110436),
	FLIT(-19.4514907200798513678525421400858126),
	FLIT( 2.50741103959502021249498700433396431),
	};

static const FTYPE c10[] = {
	FLIT(-7.84093275344868895140619461428486446),
	FLIT( 1.),
	};

static const FTYPE s11[] = {	/* 30/1, GAMMA(1/x)/(((1/x)^(1/x - 1/2))*exp(-1/x)), 30 <= x < 38 */
	FLIT(-94288528.1460326384368400079307627093),
	FLIT( 189761.967246715816996309730816514113),
	FLIT( 4921048.09944687955517827046180700132),
	FLIT(-20486.8834776295027030919618501172904),
	FLIT(-298707.365627488615528916604643879634),
	FLIT( 1942.89256335143927301647958068134038),
	FLIT( 21350.2154198918642173784574707400382),
	FLIT(-194.527190165612936897070933658950014),
	FLIT(-1823.28255409038875584130234700675955),
	FLIT( 22.0612626252047494768466003720030988),
	FLIT( 189.306089484781962263143789186571037),
	FLIT(-2.96393036937924292005157466176576137),
	FLIT(-24.4082698802270259536400252423525133),
	FLIT( 0.49062704594017394813943768718641060),
	FLIT( 4.01249235410265569914322138803207396),
	FLIT(-0.10437248799699121716480712240571645),
	FLIT(-0.86979480101350433722915445090123977),
	FLIT( 0.30044032224827247180291710364690977e-1),
	FLIT( 0.25995471466161057787208701308964689),
	FLIT(-0.12541571258465635861938964263901135e-1),
	FLIT(-0.11395765795382210285721405354016328),
	FLIT( 0.83963676230910616622076424423679778e-2),
	FLIT( 0.80362107529727756797522438423416962e-1),
	FLIT(-0.10553998818560570712451721493160870e-1),
	FLIT(-0.10637659365915814440780278737965368),
	FLIT( 0.32756544231428853729033870816098076e-1),
	FLIT( 0.36375285643170554763108182435274946),
	FLIT(-0.47760870345228570199347815418139510),
	FLIT(-11.3120127301338717675911886948516542),
	FLIT(-135.639531302150718535126550962269226),
	FLIT( 2.50677772099950634364557211544833396),
	};

static const FTYPE c11[] = {
	FLIT(-54.1924512480147507160294167471708686),
	FLIT( 1.),
	};

static const struct Approx approx0[] = {	/* table of tail approximations */
	{FLIT(1000.0), FLIT(577.0) / FLIT(154000.0), POLY(s10), POLY(c10)},
	{FLIT(2321.0), FLIT(3321.0) / FLIT(4642000.0), POLY(s11), POLY(c11)},
	};

 #else /* FBITS */
	#error _Tgamma has insufficient precision
 #endif /* FBITS */

static FTYPE stirling(FTYPE *px, short *pex)
	{	/* compute Stirling's approximation for [BIG_ARG and beyond) */
	int i;
	FTYPE x = *px;
	FTYPE rootxx = FNAME(Pow)(x, x - FLIT(0.5), pex);

	*pex = -*pex;
	for (i = 0; i < sizeof (approx0) / sizeof (approx0[0]) - 1; ++i)
		if (x < approx0[i].to)
			break;

	 {	/* found interval (or last one), approximate Stirling's series */
	FTYPE y = FLIT(1.0) / x - approx0[i].mid;

	*px = FNAME(Poly)(y, approx0[i].den, approx0[i].dsize)
		/ FNAME(Poly)(y, approx0[i].num, approx0[i].nsize);
	*px /= rootxx * FFUN(exp)(-x);
	return (FLIT(0.0));
	 }
	}

/* compute gamma(x) as (1+approx(f))/(y*2^yexp)
	approx(f) = (gamma(f+2)-1)/f, |f| < 1/2
	get x from *pex
	return approx(f), yexp in *pex, y in *px
 */
FTYPE FNAME(Tgamma)(FTYPE *px, short *pex)
	{	/* compute gamma(x), -BIG_ARG <= x <= big enough for zeta(-x) */
	FTYPE x = *px;
	FTYPE y;

	if (BIG_ARG <= x)
		return (stirling(px, pex));
	else
		{	/* compute gamma(x) |x| < BIG_ARG */
		if (x < -FLIT(0.5))
			{	/* increase x to [1.5, 2.5] by recurrence relation */
			for (y = FLIT(1.0); ; x += FLIT(1.0))
				{	/* scale up */
				y *= x;
				if (FLIT(0.5) < x)
					break;
				}
			x -= FLIT(1.0);
			FNAME(Dunscale)(pex, &y);
			}
		else if (x < FLIT(0.5))
			{	/* x in [-0.5, 0.5) */
			y = x * (FLIT(1.0) + x);
			FNAME(Dunscale)(pex, &y);
			}
		else if (x < FLIT(1.5))
			{	/* x in [0.5, 1.5) */
			y = x;
			x -= FLIT(1.0);
			*pex = 0;
			}
		else if (x < FLIT(2.5))
			{	/* x in [1.5, 2.5) */
			y = FLIT(1.0);
			x -= FLIT(2.0);
			*pex = 0;
			}
		else
			{	/* decrease x to (1.5, 2.5] by recurrence relation */
			for (y = FLIT(1.0); FLIT(2.5) < x; y /= x)
				x -= FLIT(1.0);
			x -= FLIT(2.0);
			FNAME(Dunscale)(pex, &y);
			}
		*px = y;
		return ((NPOLY(x) / DPOLY(x)) * x);
		}
	}
_STD_END

/*
 * Copyright (c) 1992-2007 by P.J. Plauger.  ALL RIGHTS RESERVED.
 * Consult your license regarding permissions and restrictions.
V5.03:0216 */
