#include "robot.h"

void _INITSCT(void)  /*f[^ZNVvO*/
{
  char *p, *q ;

  /* f[^̈[ŏ */
  for (p=_B_BGN; p<_B_END ; p++)
    *p=0;

  /*f[^ROM ォRAM փRs[ */
  for (p=_D_BGN, q=_D_ROM; p<_D_END; p++, q++)
    *p=*q;
}

float sfabs(float x)  /*  float ^l̐ΒlƂ֐  */
{
  if(x<0.0f) x=-x;
  return x;
}


/***********************************************************************************
  ʒuƎpp̌vZ͈ȉURLQƉ
       http://kamuy.elec.muroran-it.ac.jp/study/kinematics/estimation.html
************************************************************************************/
void current_status(void) /*̈ʒuƎppobNOEhŌvZbvO[`*/
{
  float cosfai_1,sinfai_1,fai_1,romega_1,lomega_1,omega_1,theta_r,theta_l;
  long count_r,count_l;
  count_r=RCOUNT;    /*RCOUNT̒lς\̂Ńb`*/
  count_l=LCOUNT;    /*LCOUNT̒lς\̂Ńb`*/
  theta_r=K_K*(float)count_r;
  theta_l=K_K*(float)count_l;
/*---------------ԗւ̈ړx̌vZ-------------*/
  R_SPEED=K_K*(float)RCOUNT_1;
  L_SPEED=K_K*(float)LCOUNT_1;
  R_SPEED=R_R*(theta_r-R_SPEED)/T_T;
  L_SPEED=R_R*(theta_l-L_SPEED)/T_T;
/*--------------܂łړx̌vZ----------*/
  romega_1=K_K*(float)(count_r-RCOUNT_2);
  lomega_1=K_K*(float)(count_l-LCOUNT_2);
  omega_1=0.5f*(romega_1+lomega_1)/T_T;
  fai_1=K_K*(float)(RCOUNT_1-LCOUNT_1);
  fai_1=R_R*fai_1/L_L;
  cosfai_1=cos(fai_1+FAI0);
  sinfai_1=sin(fai_1+FAI0);
  POSITION_X_1=0.25f*R_R*T_T*(omega_1*cosfai_1+OMEGA_2*COSFAI_2);
  POSITION_X_1+=POSITION_X_2;
  POSITION_Y_1=0.25f*R_R*T_T*(omega_1*sinfai_1+OMEGA_2*SINFAI_2);
  POSITION_Y_1+=POSITION_Y_2;
  POSITION_X=2.0f*POSITION_X_1-POSITION_X_2;                /*_̂wWl𐄒*/
  POSITION_Y=2.0f*POSITION_Y_1-POSITION_Y_2;                /*_̂xWl𐄒*/
  ATTITUDE_ANGLE=0.572958e+2f*R_R*(theta_r-theta_l)/L_L+ATTITUDE_ANGLE0;/*_̎pp*/
  RCOUNT_2=RCOUNT_1;
  LCOUNT_2=LCOUNT_1;
  RCOUNT_1=count_r;
  LCOUNT_1=count_l;
  OMEGA_2=omega_1;
  POSITION_X_2=POSITION_X_1;
  POSITION_Y_2=POSITION_Y_1;
  COSFAI_2=cosfai_1;
  SINFAI_2=sinfai_1;
}

void wait(float sec) /* w肵Ԃ҂֐B sec̒Pʂ͕b*/
{
  unsigned int i;
  i=(unsigned int)(sec/T_T);
  while(i)
  {
    if(CFLAG)
    {
      CFLAG=0;
      i--;
    }
  }
}

unsigned char input0(void)  /*[U[J͒[q P76 ̓dx荞ފ֐*/
{
  return (unsigned char)IO.PDR7.BIT.B6;
}

unsigned char input1(void)  /*[U[J͒[q P87 ̓dx荞ފ֐*/
{
  return (unsigned char)IO.PDR8.BIT.B7;
}

void output0(unsigned char revel)  /*[U[Jo͒[q P85 ɓdo͂֐*/
{
  if(revel==1) IO.PDR8.BIT.B5=1;
  else IO.PDR8.BIT.B5=0;
}

void output1(unsigned char revel)  /*[U[Jo͒[q P86 ɓdo͂֐*/
{
  if(revel==1) IO.PDR8.BIT.B6=1;
  else IO.PDR8.BIT.B6=0;
}

void pwm(unsigned int duty)  /*[U[JPWMo͒[q P84 PWMMo͂֐*/
{
  if(duty>799) duty=799;
  TW.GRD=duty;
}

void linesensor_on(char on)  /*CZT̓dIɂ֐*/
{
	if(on!=0) on=1;               /*0ȊO̒lݒ肳ꂽƂɂ1Ƃ݂Ȃ*/
	if(on==1) IO.PDR7.BIT.B4=0;   /*PœdI*/
	else IO.PDR7.BIT.B4=1;        /*OœdIt*/
}

void rangesensor_on(char on) /*ԊOZT̓dIɂ֐*/
{
	if(on!=0) on=1;               /*0ȊO̒lݒ肳ꂽƂɂ1Ƃ݂Ȃ*/
	if(on==1) IO.PDR7.BIT.B5=0;   /*PœdI*/
	else IO.PDR7.BIT.B5=1;        /*OœdIt*/
}

void stop(void)  /*{bg~֐*/
{
  IO.PDR5.BIT.B4=0;  /*Eԗ։]Xgbv*/
  IO.PDR5.BIT.B5=0;
  IO.PDR5.BIT.B6=0;  /*ԗ։]Xgbv*/
  IO.PDR5.BIT.B7=0;
  TW.GRB=1;
  TW.GRC=1;
  SUM_R=0.0f;        /*EϕNA*/
  SUM_L=0.0f;        /*ϕNA*/
}

/*************************************************************************************
@f[eB^ĐȂŃ{bg𓮂֐
@̃f[eBi0`799)^邱
**************************************************************************************/
void move_forward(unsigned int lduty, unsigned int rduty) /*Oi֐*/
{
    
    if(lduty>799) lduty=799;
    if(rduty>799) rduty=799;
    TW.GRC=lduty;/*f[eB̕ύX*/
    TW.GRB=rduty;/*Ef[eB̕ύX*/
    IO.PDR5.BIT.B6=1;      /*ԗւ̉]]ɂȂ悤*/
    IO.PDR5.BIT.B7=0;      /*|[gɏo͂o              */
    IO.PDR5.BIT.B4=1;      /*Eԗւ̉]]ɂȂ悤*/
    IO.PDR5.BIT.B5=0;      /*|[gɏo͂o              */
}

void move_backward(unsigned int lduty, unsigned int rduty) /*ނ֐*/
{
    if(lduty>799) lduty=799;
    if(rduty>799) rduty=799;
    TW.GRC=lduty; /*f[eB̕ύX*/
    TW.GRB=rduty; /*Ef[eB̕ύX*/
    IO.PDR5.BIT.B6=0;      /*ԗւ̉]t]ɂȂ悤*/
    IO.PDR5.BIT.B7=1;      /*|[gɏo͂o              */
    IO.PDR5.BIT.B4=0;      /*Eԗւ̉]t]ɂȂ悤*/
    IO.PDR5.BIT.B5=1;      /*|[gɏo͂o              */
}

/*************************************************************************************
@[^PI䂷֐
  ڕW̉Eԗւƍԗւ̉]x[cm/sec]PIvZă[^̃f[eBݒ
  TvOƂɌĂяo
**************************************************************************************/
void PI_control(float lspd, float rspd)
{
  float error_r, error_l;
  float u_r,u_l;

  error_r=rspd-R_SPEED; /*E΍̌vZ*/
  error_l=lspd-L_SPEED; /*΍̌vZ*/
  SUM_R+=error_r;               /*E̐ϕ̌vZ*/
  SUM_L+=error_l;               /*̐ϕ̌vZ*/
  u_r=KP*error_r+KI*SUM_R;      /*EPI*/
  u_l=KP*error_l+KI*SUM_L;      /*PI*/

  /*E[^ւ̑ʂ̏o*/
  if(u_r>=0.0f)            /*Oiw߂̏ꍇ*/
  {
    IO.PDR5.BIT.B4=1;      /*ԗւ̉]]ɂȂ悤*/
    IO.PDR5.BIT.B5=0;      /*|[gɏo͂o              */
  }
  else                     /*ގw߂̏ꍇ*/
  {
    u_r=-u_r;
    IO.PDR5.BIT.B4=0;      /*ԗւ̉]t]ɂȂ悤*/
    IO.PDR5.BIT.B5=1;      /*|[gɏo͂o              */
  }
  if(u_r>=799.0f) u_r=799.0f;
  TW.GRB=(unsigned int)u_r;/*f[eB̕ύX*/

  /*[^ւ̑ʂ̏o*/
  if(u_l>=0.0f)            /*Oiw߂̏ꍇ*/
  {
    IO.PDR5.BIT.B6=1;      /*ԗւ̉]]ɂȂ悤*/
    IO.PDR5.BIT.B7=0;      /*|[gɏo͂o              */
  }
  else                     /*ގw߂̏ꍇ*/
  {
    u_l=-u_l;
    IO.PDR5.BIT.B6=0;      /*ԗւ̉]t]ɂȂ悤*/
    IO.PDR5.BIT.B7=1;      /*|[gɏo͂o              */
  }
  if(u_l>=799.0f) u_l=799.0f;
    TW.GRC=(unsigned int)u_l;/*f[eB̕ύX*/

  return;
}

	
/***************************************************************************************
  Eԗւƍԗւ̉]x[cm/sec]^Ďw肵[cm]{bgړ֐
  ̏񂳂悤Ȏԗւ̉]x̗^͋֎~Bړdistance͂Q̎ԗւ̒
  ʒüړŁA̒lŗ^܂Blspeed,rspeed͐łłnjB
****************************************************************************************/
void move_s(float lspeed, float rspeed, float distance)
{
  float error_r,error_l,u_r,u_l,x0,y0,s,dx,dy;
  s=0.0f;
  x0=POSITION_X_1;
  y0=POSITION_Y_1;

  while(s<distance)
  {
    if(CFLAG)  //10msɎs
    {
      CFLAG=0;

      PI_control(lspeed,rspeed);
      
      dx=POSITION_X_1-x0;
      dy=POSITION_Y_1-y0;
      s+=sqrt(dx*dx+dy*dy);
      x0=POSITION_X_1;
      y0=POSITION_Y_1;
    }
  }
  stop();
}

/***************************************************************************************
  Eԗւƍԗւ̉]x[cm/sec]^Ďw肵[sec]{bgړ֐
  ̏񂳂悤Ȏԗւ̉]x̗^njłB
****************************************************************************************/
void move_t(float lspeed, float rspeed, float sec)
{
  float error_r,error_l,u_r,u_l;
  unsigned int i;
  int fg;
  i=(unsigned int)(sec/T_T);
  fg=1;
  while(i)
  {
    if(CFLAG)                  /*10.24msecCFLAGPɃZbĝ*/
    {                          /*ȍ~̏10.24msecɌJԂ*/
      CFLAG=0;
      i--;
 
      PI_control(lspeed,rspeed);

    }
  }
  stop();
}

/**************************************************************************************
  ԑ̂̉]x[deg/sec]^Ďw肵px[deg]{bg̏񂳂֐
  speedɂ͐̒l^Aangleɐ̒l^ĉ]w܂BȂ甽
  v܂AȂ玞v܂łB
***************************************************************************************/
void rotate(float speed, float angle)
{
  float rspeed,lspeed,error_r, error_l,u_r,u_l,angle0;
  int fg;
  angle0=ATTITUDE_ANGLE;
  speed=sfabs(speed);         /*speed͐̒lŗ^邱ƂɂȂĂ̂ŔÔ*/
  if(angle>0.0f)              /*angleȂ甽v܂̐*/
  {
    rspeed=8.7266462599716478e-3f*speed*L_L;  /*Eԗւɐ]ڕWlݒ*/
    lspeed=-rspeed;                          /*ԗւɋt]ڕWlݒ*/
  }
  else                        /*angleȂ玞v܂̐*/
  {
    lspeed=8.7266462599716478e-3f*speed*L_L;    /*ԗւɐ]ڕWlݒ*/
    rspeed=-lspeed;           /*Eԗւɋt]ڕWlݒ*/
  }
  angle=sfabs(angle);         /*̒lmŐpxrߐlɕϊ*/
  fg=1;
  while(sfabs(ATTITUDE_ANGLE-angle0)<angle)
  {
    if(CFLAG)
    {
      CFLAG=0;

      PI_control(lspeed,rspeed);

    }
  }
  stop();
}

/***********************************************************************************************
  ԑ̂̈ړx[cm/sec]^Ďw肵[sec]FCg[X֐
  speedɂ͐̒l^܂Bsec 0.01secPʂŐݒ\B
  CoZTFCoƎw肵Ԃo߂ĂȂĂ֐甲o܂B
************************************************************************************************/
unsigned char linetrace(float speed, float sec)
{
  unsigned int i;
  int fg;
  float adjust, error_r, error_l,u_r,u_l,deviation,shift,kp,ki;
  unsigned char flash, result;
/******C̃gbLOx𒲐߂Ƃ͎skp̒lςĉ***/
  kp=0.05f;          /* ĈȂ߂̔QC*/
/***************************************************************************/
  ki=0.0001f;        /* ĈȂ߂̐ϕQC*/
  shift=0.0f;        /* Ĉ𔽉fώZϐ*/
  LINESENSE=1;       /* Cg[XZTECl[u*/
  wait(0.1f);        /* ZTH̃EH[Abv҂*/
  LINEDETECT_R=0;    /* ECotÕNA*/
  LINEDETECT_L=0;    /* CotÕNA*/
  flash=AUTOFLASH;   /*AUTOFLASH̒lꎞIɃZ[u*/
  AUTOFLASH=5;       /*\pLEDvO琧ł悤ɐݒ*/
  i=(unsigned int)(sec/T_T);
  fg=1;
  while(i)          /*w肵Ԃo߂while[v𔲂܂B*/
  {
    if(CFLAG)
    {
      CFLAG=0;
      i--;
      deviation=(float)TRACER-(float)GNDV;
      if(deviation>=0)   /*Ĉɉĕ\pLED_*/
      {
        IO.PDR5.BIT.B2=1;   /*ꂪȂELED_*/
        IO.PDR5.BIT.B3=0;
      }
      else
      {
        IO.PDR5.BIT.B2=0;   /*ꂪ񐳂Ȃ獶LED_*/
        IO.PDR5.BIT.B3=1;
      }
      shift+=deviation;
      adjust=kp*deviation+ki*shift; /*CgbLȌC*/

      PI_control(speed+adjust,speed-adjust);

    }
    if((LINEDETECT_R==1)||(LINEDETECT_L==1)) break; /*Cowhile[v𔲂*/
  }
  stop();
  if(LINEDETECT_R==1)
  {
    result=1;
    IO.PDR5.BIT.B2=1;   /*ELED_*/
    IO.PDR5.BIT.B3=0;
  }
  else if(LINEDETECT_L==1)
  {
    result=2;
    IO.PDR5.BIT.B2=0;   /*LED_*/
    IO.PDR5.BIT.B3=1;
  }
  else
  {
    result=0;           /*w肵Ԃo߂ďIꍇ*/
    AUTOFLASH=flash;    /* AUTOFLASH̒l𕜌*/
  }
  LINESENSE=0;          /*Cg[XZTfBXG[u*/
  return result;
}


/********************************************************************************************
  ̏񂵂Ȃ|[╗DȂǂ̏Q𔭌֐
  speed[deg/sec]͐Xs[hŐ̒l^Aangleɂ͐̒l^ĉ]w
  ܂BȂ甽v܂AȂ玞v܂łBQoƁAw肵px܂Ő
  ȂĂQقڐʂɂ݂Ē~A֐甲܂B֐̖߂l͏Q܂ł̋[cm]B
  덷l邽߁AAϑlT_̈ړϒlŒŽƋ߂ĂB
  Aꍇ̓obNOEhmCYłȂ̂ŁADISTANCE̒lTHRESHOLD
  Ƃ̓mCY𑪂ĂƌȂB
  Q͂邪AŒZoOɒTIꍇɂ͍ł߂𕉂̒lŕԂB
  QȂꍇ100.0fԂB
*********************************************************************************************/
float find_obstacle(float speed, float angle)
{
  float rspeed,lspeed,error_r, error_l,u_r,u_l,angle0,ang[5],av[3],d,v;
  unsigned int i,dis[5];
  int fg;
  angle0=ATTITUDE_ANGLE;      /*݂̃{bǧangle0ɕۑ*/
  speed=sfabs(speed);         /*speed͐̒lŗ^邱ƂɂȂĂ̂ŔÔ*/
  if(angle>0.0f)              /*angleȂ甽v܂̐*/
  {
    rspeed=8.7266462599716478e-3f*speed*L_L;  /*Eԗւɐ]ڕWlݒ*/
    lspeed=-rspeed;                          /*ԗւɋt]ڕWlݒ*/
  }
  else                        /*angleȂ玞v܂̐*/
  {
    lspeed=8.7266462599716478e-3f*speed*L_L;    /*ԗւɐ]ڕWlݒ*/
    rspeed=-lspeed;           /*Eԗւɋt]ڕWlݒ*/
  }
  angle=sfabs(angle);         /*̒lmŐpxrߐlɕϊ*/
  for(i=0;i<5;i++)            /*pxz0.0ɏ*/
  {
    dis[i]=THRESHOLD;
    ang[i]=0.0f;
  }
  av[0]=(float)THRESHOLD;     /*obNOEhmCYlŏ*/
  av[1]=(float)THRESHOLD;     /*obNOEhmCYlŏ*/
  d=1.0f;                    /*dcmPʂɊZl\AƂ肠1ƂĂ*/
  fg=1;                      /*fg͍E̎ԗւ݂̑ɐ䂷邽߂̃tO*/
 /*w肵Xs[hŐJnBAw肳ꂽpx񂷂ƃ[v𔲂B*/
  while(sfabs(ATTITUDE_ANGLE-angle0)<angle)
  {
    if(CFLAG)
    {
      CFLAG=0;
	  
	  PI_control(lspeed,rspeed);


      /*擪ɐVϑf[^tĐVȃf[^Zbg쐬*/
      dis[4]=dis[3];
      dis[3]=dis[2];
      dis[2]=dis[1];
      dis[1]=dis[0];
      dis[0]=DISTANCE;
      if(dis[0]<=THRESHOLD) dis[0]=THRESHOLD; /*mCYɖ鋗THRESHOLDƂ*/
     /*ϑsƂ̃{bǧΉċLĂ*/
      ang[4]=ang[3];
      ang[3]=ang[2];
      ang[2]=ang[1];
      ang[1]=ang[0];
      ang[0]=ATTITUDE_ANGLE;
     /*ړς̌vZFav[0]=(dis[0]+dis[1]+dis[2])/3, av[1]=(dis[1]+dis[2]+dis[3])/3, */
     /*            av[2]=(dis[2]+dis[3]+dis[4])/3  Aav[2],av[1]͉ߋɌvZς */
      av[2]=av[1];
      av[1]=av[0];
      av[0]=(float)dis[0];
      av[0]+=(float)dis[1];
      av[0]+=(float)dis[2];
      av[0]*=3.3333333333333333e-1f;
      /*ŒZiɑlj߂ǂ̔*/
      if(av[0]-av[1]<0.0f)
      {
        d=-1.0f;        /*ŒZiɑljƂ*/
        v=4.8875855327468230e-3f*(float)dis[1];/*ŒZA/DϊldlɊZ*/
      }
    }
    if(d<0.0f) break;  /*ŒZiɑljĂȂT[v𔲂*/
  }
  stop();

  if(sfabs(ATTITUDE_ANGLE-angle0)-angle >= 0.0f) /*ŒZiɑlj*/
  {                                              /*Ȃꍇ*/
    if((dis[0]==THRESHOLD)&&(dis[3]==THRESHOLD))  /*Qꍇ*/
    {
      d=100.0f;            /*̂Ƃ͋100cmƂ*/
    }
    else /*ɑlɂ܂Ȃꍇ*/
    {
      v=4.8875855327468230e-3f*(float)dis[0];
      d=0.5508f;
      d*=v;
      d-=8.5941f;
      d*=v;
      d+=50.26f;
      d*=v;
      d-=136.51f;
      d*=v;
      d+=166.2f; /*ŒŽvZ*/
      d=-d;      /*ɑlł͂Ȃ̂ŕ̋o*/
    }
  }                                                      
  else
  {
/* o͓dvƋdƂ̊֌WƁATˎ̎ŋߎłB*/
/*  d=0.5508*v^4-8.5941*v^3+50.26*v^2-136.51*v+166.2 @@@@@@*/
/* ̎găZTQ܂ł̋vZB@@@@@*/
  d=0.5508f;
  d*=v;
  d-=8.5941f;
  d*=v;
  d+=50.26f;
  d*=v;
  d-=136.51f;
  d*=v;
  d+=166.2f; /*ŒŽvZBPʂcm*/
  }
  return d;
}

/********************************************************************************************
  FC𔭌֐ 
  lspeed, rspeed ɂ͍ԗւƉEԗւ̉]x[cm/sec]^܂Bsec̒Pʂ͕bŁA0.01secP
  Őݒ\BFCƁAw肵Ԃo߂ȂĂ~Ă̊֐甲܂B
  ^[l͉ECoZTFCꍇ"-1"ACoZT
  ꍇ"1"łBw莞ԓɃCoȂꍇ"0"o͂܂B
*********************************************************************************************/
unsigned char find_line(float lspeed, float rspeed, float sec)
{
  float error_r,error_l,u_r,u_l;
  unsigned int i;
  int fg;
  unsigned char result;
  LINEDETECT_R=0;                /*ECotÕNA*/
  LINEDETECT_L=0;                /*CotÕNA*/
  i=(unsigned int)(sec/T_T);     /*w莞ԂɌJԂ񐔂̌vZ*/
  fg=1;
  while(i)
  {
    if(CFLAG)
    {
      CFLAG=0;
      i--;

	  PI_control(lspeed,rspeed);

    }
    if((LINEDETECT_R==1)||(LINEDETECT_L==1)) break; /*Cowhile[v𔲂*/
  }
  stop();
  if(LINEDETECT_R==1)
  {
    result=1;
    AUTOFLASH=4;
    IO.PDR5.BIT.B2=1;   /*ELED_*/
    IO.PDR5.BIT.B3=0;
  }
  else if(LINEDETECT_L==1)
  {
    result=2;
    AUTOFLASH=4;
    IO.PDR5.BIT.B2=0;   /*LED_*/
    IO.PDR5.BIT.B3=1;
  }
  else
  {
    result=0;           /*w肵Ԃo߂ďIꍇ*/
  }
   return result;
}

/*********************************************************************/
void INITIALVALUES(void)      /*lݒ肵Ă֐łB*/
{
  AUTOFLASH=3;                /*p[Iŕ\pLEDQƂ_*/
/*obNOEhœĂʒuEppVXeɗ^鏉l  */
  POSITION_X_2=0.0f;          /*{bg̏wW                  */
  POSITION_Y_2=0.0f;          /*{bg̏xW                  */
  ATTITUDE_ANGLE0=90.0f;       /*{bg̏pp[Pʂ͓x(degree)]*/

/*ȉ11s͌ďȂŉB*/
  ATTITUDE_ANGLE=ATTITUDE_ANGLE0;
  POSITION_X=POSITION_X_2;
  POSITION_X_1=POSITION_X_2;
  POSITION_Y=POSITION_Y_2;
  POSITION_Y_1=POSITION_Y_2;
  FAI0=PI*ATTITUDE_ANGLE0/180.0f;
  SINFAI_2=sin(FAI0);
  COSFAI_2=cos(FAI0);
  OMEGA_2=0.0f;
  SUM_R=0.0f;
  SUM_L=0.0f;
}
